/*
 * Decompiled with CFR 0.152.
 */
package croissantnova.sanitydim.client;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import croissantnova.sanitydim.config.ConfigProxy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostPass;
import org.joml.Matrix4f;

public class PostProcessor {
    private float m_time;
    private final RenderTarget m_swapBuffer;
    private final Matrix4f m_orthoMat = new Matrix4f();
    public final List<PostPassEntry> passEntries = new ArrayList<PostPassEntry>();

    public PostProcessor() {
        Minecraft mc = Minecraft.m_91087_();
        this.m_swapBuffer = new TextureTarget(mc.m_91385_().f_83915_, mc.m_91385_().f_83916_, false, Minecraft.f_91002_);
        this.m_swapBuffer.m_83931_(0.0f, 0.0f, 0.0f, 1.0f);
        this.updateOrthoMatrix();
    }

    public float getTime() {
        return this.m_time;
    }

    public PostPassEntry addPassEntry(String in, String out, Function<PostPass, Boolean> inProcessor, Function<PostPass, Boolean> outProcessor) {
        PostPass outPass;
        PostPass inPass;
        Minecraft mc = Minecraft.m_91087_();
        try {
            inPass = new PostPass(mc.m_91098_(), in, mc.m_91385_(), this.m_swapBuffer);
            inPass.m_253214_(this.m_orthoMat);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        try {
            outPass = new PostPass(mc.m_91098_(), out, this.m_swapBuffer, mc.m_91385_());
            outPass.m_253214_(this.m_orthoMat);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        PostPassEntry entry = new PostPassEntry(inPass, outPass, inProcessor, outProcessor);
        this.passEntries.add(entry);
        return entry;
    }

    public PostPassEntry addSinglePassEntry(String in, Function<PostPass, Boolean> inProcessor) {
        return this.addPassEntry(in, "blit", inProcessor, null);
    }

    public void render(float partialTicks) {
        this.m_time += partialTicks;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91074_.m_7500_() || mc.f_91074_.m_5833_() || !ConfigProxy.getRenderPost(mc.f_91074_.m_9236_().m_46472_().m_135782_())) {
            return;
        }
        for (PostPassEntry entry : this.passEntries) {
            if (entry.getInPass() == null || entry.getOutPass() == null || entry.getInProcessor() != null && !entry.getInProcessor().apply(entry.getInPass()).booleanValue() || entry.getOutProcessor() != null && !entry.getOutProcessor().apply(entry.getOutPass()).booleanValue()) continue;
            entry.getInPass().m_110065_(partialTicks);
            entry.getOutPass().m_110065_(partialTicks);
        }
    }

    public void updateOrthoMatrix() {
        Minecraft mc = Minecraft.m_91087_();
        this.m_orthoMat.setOrtho(0.0f, (float)mc.m_91385_().f_83915_, 0.0f, (float)mc.m_91385_().f_83916_, 0.1f, 1000.0f);
        for (PostPassEntry entry : this.passEntries) {
            entry.getInPass().m_253214_(this.m_orthoMat);
            entry.getOutPass().m_253214_(this.m_orthoMat);
        }
    }

    public void resize(int w, int h) {
        if (this.m_swapBuffer != null) {
            this.m_swapBuffer.m_83941_(w, h, false);
        }
        this.updateOrthoMatrix();
    }

    public class PostPassEntry {
        private PostPass m_in;
        private PostPass m_out;
        private Function<PostPass, Boolean> m_inProcessor;
        private Function<PostPass, Boolean> m_outProcessor;

        public PostPassEntry(PostPass in, PostPass out, Function<PostPass, Boolean> inProcessor, Function<PostPass, Boolean> outProcessor) {
            this.m_in = in;
            this.m_out = out;
            this.m_inProcessor = inProcessor;
            this.m_outProcessor = outProcessor;
        }

        public PostPass getInPass() {
            return this.m_in;
        }

        public PostPass getOutPass() {
            return this.m_out;
        }

        public Function<PostPass, Boolean> getInProcessor() {
            return this.m_inProcessor;
        }

        public Function<PostPass, Boolean> getOutProcessor() {
            return this.m_outProcessor;
        }
    }
}

