/*
 * Decompiled with CFR 0.152.
 */
package croissantnova.sanitydim.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import croissantnova.sanitydim.capability.IPassiveSanity;
import croissantnova.sanitydim.capability.ISanity;
import croissantnova.sanitydim.capability.SanityProvider;
import croissantnova.sanitydim.client.PostProcessor;
import croissantnova.sanitydim.config.ConfigProxy;
import croissantnova.sanitydim.config.SanityIndicatorLocation;
import croissantnova.sanitydim.sound.SwishSoundInstance;
import croissantnova.sanitydim.util.MathHelper;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class GuiHandler {
    private static final float PASSIVE_THRESHOLD = 2.0E-4f;
    private static final float BT_DELAY = 100.0f;
    public static final ResourceLocation SANITY_INDICATOR;
    public static final ResourceLocation BLOOD_TENDRILS_OVERLAY;
    public static final MutableComponent[] HINTS0;
    public static final MutableComponent[] HINTS1;
    private final Minecraft m_mc;
    private ISanity m_cap;
    private PostProcessor m_post;
    private final Random m_random = new Random();
    private int m_indicatorOffset;
    private int m_hintOffsetX;
    private int m_hintOffsetY;
    private float m_dt;
    private float m_prevSanity;
    private float m_sanityGain;
    private float m_flashTimer;
    private float m_flashSanityGain;
    private float m_arrowTimer;
    private float m_hintTimer;
    private float m_showingHintTimer;
    private float m_maxShowingHintTimer;
    private float m_btGainedAlpha;
    private float m_btDelay;
    private float m_btAlpha;
    private double m_btTimer;
    private MutableComponent m_hint;

    public GuiHandler() {
        this.m_mc = Minecraft.m_91087_();
    }

    private void initSanityPostProcess() {
        Minecraft mc = Minecraft.m_91087_();
        this.m_post.addSinglePassEntry("insanity", pass -> this.processPlayer(mc.f_91074_, cap -> {
            if (cap.getSanity() < 0.4f) {
                return false;
            }
            pass.m_110074_().m_108960_("DesaturateFactor").m_5985_(MathHelper.clampNorm(Mth.m_184655_((float)cap.getSanity(), (float)0.4f, (float)0.8f)) * 0.69f);
            pass.m_110074_().m_108960_("SpreadFactor").m_5985_(MathHelper.clampNorm(Mth.m_184655_((float)cap.getSanity(), (float)0.4f, (float)0.8f)) * 1.43f);
            return true;
        }));
        this.m_post.addSinglePassEntry("chromatical", pass -> this.processPlayer(mc.f_91074_, cap -> {
            if (cap.getSanity() < 0.4f) {
                return false;
            }
            pass.m_110074_().m_108960_("Factor").m_5985_(MathHelper.clampNorm(Mth.m_184655_((float)cap.getSanity(), (float)0.4f, (float)0.8f)) * 0.1f);
            pass.m_110074_().m_108960_("TimeTotal").m_5985_(this.m_post.getTime() / 20.0f);
            return true;
        }));
    }

    private boolean processPlayer(LocalPlayer player, Function<ISanity, Boolean> action) {
        ISanity cap;
        return player != null && !player.m_7500_() && !player.m_5833_() && (cap = (ISanity)player.getCapability(SanityProvider.CAP).orElse(null)) != null && cap.getSanity() > 0.0f && action.apply(cap) != false;
    }

    private void renderSanityIndicator(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int scw, int sch) {
        float p;
        if (this.m_mc.f_91074_ == null || this.m_mc.f_91074_.m_7500_() || this.m_mc.f_91074_.m_5833_() || this.m_cap == null || !ConfigProxy.getRenderIndicator(this.m_mc.f_91074_.m_9236_().m_46472_().m_135782_())) {
            return;
        }
        ResourceLocation dim = this.m_mc.f_91074_.m_9236_().m_46472_().m_135782_();
        float scale = ConfigProxy.getIndicatorScale(dim);
        if (scale <= 0.0f) {
            return;
        }
        SanityIndicatorLocation loc = ConfigProxy.getIndicatorLocation(dim);
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        if (loc == SanityIndicatorLocation.HOTBAR_LEFT) {
            poseStack.m_252880_((float)scw / 2.0f - 97.0f - (!this.m_mc.f_91074_.m_21206_().m_41619_() ? 29.0f : 0.0f), (float)sch - 5.0f, 0.0f);
        } else if (loc == SanityIndicatorLocation.HOTBAR_RIGHT) {
            poseStack.m_252880_(97.0f, 0.0f, 0.0f);
        } else if (loc == SanityIndicatorLocation.TOP_LEFT) {
            poseStack.m_252880_(5.0f, 5.0f, 0.0f);
        } else if (loc == SanityIndicatorLocation.TOP_RIGHT) {
            poseStack.m_252880_((float)scw - 5.0f, 5.0f, 0.0f);
        } else if (loc == SanityIndicatorLocation.BOTTOM_LEFT) {
            poseStack.m_252880_(5.0f, (float)sch - 5.0f, 0.0f);
        } else if (loc == SanityIndicatorLocation.BOTTOM_RIGHT) {
            poseStack.m_252880_((float)scw - 5.0f, (float)sch - 5.0f, 0.0f);
        }
        poseStack.m_85841_(scale, scale, 1.0f);
        int texw = 256;
        int texh = 128;
        int spritew = 33;
        int spriteh = 24;
        int x = 0;
        int y = 0;
        if (loc == SanityIndicatorLocation.HOTBAR_LEFT || loc == SanityIndicatorLocation.BOTTOM_RIGHT) {
            x = -spritew;
            y = -spriteh;
        } else if (loc == SanityIndicatorLocation.HOTBAR_RIGHT || loc == SanityIndicatorLocation.BOTTOM_LEFT) {
            y = -spriteh;
        } else if (loc == SanityIndicatorLocation.TOP_RIGHT) {
            x = -spritew;
        }
        if (ConfigProxy.getTwitchIndicator(this.m_mc.f_91074_.m_9236_().m_46472_().m_135782_())) {
            y += this.m_indicatorOffset;
        }
        int vOffset = Math.round(this.m_cap.getSanity() * (float)(spriteh - 2)) + 1;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SANITY_INDICATOR);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280398_(SANITY_INDICATOR, x, y, 0, 0.0f, 0.0f, spritew, spriteh, texw, texh);
        if (this.m_flashTimer > 0.0f && (int)this.m_flashTimer / 3 % 2 == 0) {
            guiGraphics.m_280398_(SANITY_INDICATOR, x, y, 0, (float)spritew, 0.0f, spritew, spriteh, texw, texh);
            if (this.m_flashSanityGain > 0.0f) {
                int flashOffset = Math.round((this.m_cap.getSanity() - this.m_flashSanityGain) * (float)(spriteh - 2)) + 1;
                guiGraphics.m_280398_(SANITY_INDICATOR, x, y + flashOffset, 0, (float)(spritew * 3), (float)flashOffset, spritew, spriteh - flashOffset, texw, texh);
            }
        }
        guiGraphics.m_280398_(SANITY_INDICATOR, x, y + vOffset, 0, (float)(spritew * 2), (float)vOffset, spritew, spriteh - vOffset, texw, texh);
        if (this.m_cap instanceof IPassiveSanity && (p = ((IPassiveSanity)((Object)this.m_cap)).getPassiveIncrease()) != 0.0f) {
            int os;
            float f;
            float absp = Math.abs(p);
            if (f >= 2.0E-4f) {
                float maxArrowTimer = 23.99f;
                this.m_arrowTimer = Mth.m_14036_((float)this.m_arrowTimer, (float)0.0f, (float)maxArrowTimer);
                os = this.m_arrowTimer >= 12.0f && this.m_arrowTimer <= 15.0f || this.m_arrowTimer >= 0.0f && this.m_arrowTimer <= 3.0f ? 0 : ((int)this.m_arrowTimer / 3 % 2 == 0 ? 2 : 1);
                os *= this.m_arrowTimer > 12.0f ? 1 : -1;
            } else {
                float maxArrowTimerSmall = 15.99f;
                this.m_arrowTimer = Mth.m_14036_((float)this.m_arrowTimer, (float)0.0f, (float)maxArrowTimerSmall);
                os = (int)this.m_arrowTimer / 4 % 2;
                os *= this.m_arrowTimer > 8.0f ? 1 : -1;
            }
            if (p > 0.0f) {
                if (absp < 2.0E-4f) {
                    guiGraphics.m_280398_(SANITY_INDICATOR, x, y + os, 0, 0.0f, (float)spriteh, spritew, spriteh, texw, texh);
                    guiGraphics.m_280398_(SANITY_INDICATOR, x, y + vOffset, 0, (float)spritew, (float)(spriteh + vOffset - os), spritew, spriteh - vOffset + os, texw, texh);
                } else {
                    guiGraphics.m_280398_(SANITY_INDICATOR, x, y + os, 0, (float)(spritew * 2), (float)spriteh, spritew, spriteh, texw, texh);
                    guiGraphics.m_280398_(SANITY_INDICATOR, x, y + vOffset, 0, (float)(spritew * 3), (float)(spriteh + vOffset - os), spritew, spriteh - vOffset + os, texw, texh);
                }
            } else if (absp < 2.0E-4f) {
                guiGraphics.m_280398_(SANITY_INDICATOR, x, y + os, 0, 0.0f, (float)(spriteh * 2), spritew, spriteh, texw, texh);
                guiGraphics.m_280398_(SANITY_INDICATOR, x, y + vOffset, 0, (float)spritew, (float)(spriteh * 2 + vOffset - os), spritew, spriteh - vOffset + os, texw, texh);
            } else {
                guiGraphics.m_280398_(SANITY_INDICATOR, x, y + os, 0, (float)(spritew * 2), (float)(spriteh * 2), spritew, spriteh, texw, texh);
                guiGraphics.m_280398_(SANITY_INDICATOR, x, y + vOffset, 0, (float)(spritew * 3), (float)(spriteh * 2 + vOffset - os), spritew, spriteh - vOffset + os, texw, texh);
            }
        }
        poseStack.m_85849_();
    }

    private void renderHint(ForgeGui gui, GuiGraphics guiGraphics, float partialTicks, int scw, int sch) {
        if (this.m_mc.f_91074_ == null || this.m_mc.f_91074_.m_7500_() || this.m_mc.f_91074_.m_5833_() || this.m_hint == null || this.m_cap == null || this.m_cap.getSanity() < 0.5f || !ConfigProxy.getRenderHint(this.m_mc.f_91074_.m_9236_().m_46472_().m_135782_())) {
            return;
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        poseStack.m_85836_();
        poseStack.m_85837_((double)scw / 2.0, (double)sch / 2.0, 0.0);
        poseStack.m_85841_(2.0f, 2.0f, 1.0f);
        float o = (float)((int)this.m_showingHintTimer % 10) / 10.0f;
        o = (int)this.m_showingHintTimer / 10 % 2 == 0 ? o : 1.0f - o;
        int opacity = Mth.m_14045_((int)((int)(Mth.m_14179_((float)o, (float)(this.m_showingHintTimer >= this.m_maxShowingHintTimer - 9.0f || this.m_showingHintTimer < 10.0f ? 0.0f : 0.5f), (float)1.0f) * 255.0f)), (int)16, (int)239) << 24;
        float pX = (float)(-gui.m_93082_().m_92852_((FormattedText)this.m_hint)) / 2.0f;
        Objects.requireNonNull(gui.m_93082_());
        float pY = (float)(-9) / 2.0f;
        if (ConfigProxy.getTwitchHint(this.m_mc.f_91074_.m_9236_().m_46472_().m_135782_())) {
            pX += (float)this.m_hintOffsetX;
            pY += (float)this.m_hintOffsetY;
        }
        gui.m_93082_().m_272077_((Component)this.m_hint, pX, pY, 0xFFFFFF | opacity, true, poseStack.m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        poseStack.m_85849_();
        RenderSystem.disableBlend();
    }

    private void renderBloodTendrilsOverlay(ForgeGui gui, GuiGraphics guiGraphics, float partialTicks, int scw, int sch) {
        if (this.m_mc.f_91074_ == null || this.m_mc.f_91074_.m_7500_() || this.m_mc.f_91074_.m_5833_()) {
            return;
        }
        ResourceLocation dim = this.m_mc.f_91074_.m_9236_().m_46472_().m_135782_();
        if (!ConfigProxy.getRenderBtOverlay(dim) || !ConfigProxy.getFlashBtOnShortBurst(dim) && !ConfigProxy.getRenderBtPassive(dim)) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BLOOD_TENDRILS_OVERLAY);
        if (this.m_btAlpha > 0.0f) {
            GuiHandler.renderFullscreen(guiGraphics.m_280168_(), scw, sch, 100, 58, 0, 0, 100, 58, this.m_btAlpha);
        }
    }

    public void tick(float dt) {
        if (this.m_mc.f_91074_ == null || this.m_mc.m_91104_() || this.m_mc.f_91074_.m_7500_() || this.m_mc.f_91074_.m_5833_()) {
            return;
        }
        this.m_cap = (ISanity)this.m_mc.f_91074_.getCapability(SanityProvider.CAP).orElse(null);
        if (this.m_cap == null) {
            return;
        }
        this.m_dt = dt;
        if (this.m_flashTimer > 0.0f) {
            this.m_flashTimer -= dt;
        }
        this.m_sanityGain = this.m_cap.getSanity() - this.m_prevSanity;
        if (Math.abs(this.m_sanityGain) >= 0.01f) {
            this.m_flashTimer = 20.0f;
        }
        float f = this.m_flashSanityGain = this.m_flashTimer <= 0.0f ? 0.0f : this.m_flashSanityGain + this.m_sanityGain;
        if (this.m_cap instanceof IPassiveSanity) {
            float p;
            if (this.m_arrowTimer <= 0.0f) {
                this.m_arrowTimer = 23.99f;
            }
            if ((p = ((IPassiveSanity)((Object)this.m_cap)).getPassiveIncrease()) != 0.0f) {
                this.m_arrowTimer -= dt;
            }
        }
        if (this.m_cap.getSanity() >= 0.7f) {
            this.m_indicatorOffset = this.m_random.nextInt(3) - 1;
            this.m_hintOffsetX = this.m_random.nextInt(3) - 1;
            this.m_hintOffsetY = this.m_random.nextInt(3) - 1;
        } else {
            this.m_indicatorOffset = 0;
            this.m_hintOffsetX = 0;
            this.m_hintOffsetY = 0;
        }
        this.tickHint(dt);
        this.tickBt(dt);
        this.m_prevSanity = this.m_cap.getSanity();
    }

    private void tickHint(float dt) {
        if (this.m_cap.getSanity() <= 0.4f || !ConfigProxy.getRenderHint(this.m_mc.f_91074_.m_9236_().m_46472_().m_135782_())) {
            return;
        }
        if (this.m_hintTimer <= 0.0f && this.m_showingHintTimer <= 0.0f) {
            if (this.m_cap.getSanity() <= 0.7f) {
                int id = this.m_random.nextInt(HINTS0.length);
                this.m_hint = HINTS0[id];
                this.m_hintTimer = 2000.0f;
                if (ConfigProxy.getPlaySounds(this.m_mc.f_91074_.m_9236_().m_46472_().m_135782_()) && id == 2) {
                    this.m_mc.m_91106_().m_120367_((SoundInstance)new SwishSoundInstance());
                }
            } else {
                int id = this.m_random.nextInt(HINTS1.length);
                this.m_hint = HINTS1[id];
                this.m_hintTimer = 600.0f;
                if (ConfigProxy.getPlaySounds(this.m_mc.f_91074_.m_9236_().m_46472_().m_135782_()) && id == 0) {
                    this.m_mc.m_91106_().m_120367_((SoundInstance)new SwishSoundInstance());
                }
            }
            this.m_maxShowingHintTimer = 199.0f;
            this.m_showingHintTimer = 199.0f;
        }
        if (this.m_showingHintTimer > 0.0f) {
            this.m_showingHintTimer -= dt;
        } else {
            this.m_hintTimer = MathHelper.clamp(this.m_hintTimer - dt, 0.0f, Float.MAX_VALUE);
        }
    }

    private void tickBt(float dt) {
        ResourceLocation dim = this.m_mc.f_91074_.m_9236_().m_46472_().m_135782_();
        boolean flash = ConfigProxy.getFlashBtOnShortBurst(dim);
        boolean passive = ConfigProxy.getRenderBtPassive(dim);
        if (!ConfigProxy.getRenderBtOverlay(dim) || !flash && !passive) {
            return;
        }
        if (this.m_sanityGain >= 0.002f && flash) {
            this.m_btGainedAlpha = Mth.m_14179_((float)MathHelper.clampNorm(Mth.m_184655_((float)this.m_sanityGain, (float)0.002f, (float)0.02f)), (float)0.4f, (float)0.75f);
        }
        if (passive) {
            IPassiveSanity ps;
            ISanity iSanity = this.m_cap;
            this.m_btDelay = Mth.m_14036_((float)(this.m_btDelay + (iSanity instanceof IPassiveSanity && (ps = (IPassiveSanity)((Object)iSanity)).getPassiveIncrease() > 0.0f ? dt : -dt)), (float)0.0f, (float)100.0f);
        }
        if (this.m_btGainedAlpha > 0.0f && flash) {
            if (this.m_btAlpha < this.m_btGainedAlpha) {
                this.m_btAlpha = Mth.m_14036_((float)(this.m_btAlpha + 0.5f), (float)0.0f, (float)this.m_btGainedAlpha);
            } else {
                this.m_btGainedAlpha = 0.0f;
            }
        } else if (this.m_btDelay >= 100.0f && passive) {
            if (this.m_btAlpha < 0.15f) {
                this.m_btTimer = 0.0;
                this.m_btAlpha = Mth.m_14036_((float)(this.m_btAlpha + 0.1f), (float)this.m_btAlpha, (float)0.15f);
            } else if (this.m_btAlpha > 0.3f) {
                this.m_btTimer = 15.707963943481445;
                this.m_btAlpha = Mth.m_14036_((float)(this.m_btAlpha - 0.1f), (float)0.3f, (float)this.m_btAlpha);
            } else {
                this.m_btAlpha = Mth.m_14179_((float)((-Mth.m_14089_((float)((float)this.m_btTimer * 0.2f)) + 1.0f) * 0.5f), (float)0.15f, (float)0.3f);
                this.m_btTimer += (double)this.m_dt;
            }
        } else {
            this.m_btAlpha = Mth.m_14036_((float)(this.m_btAlpha - 0.1f), (float)0.0f, (float)this.m_btAlpha);
        }
    }

    public void initOverlays(RegisterGuiOverlaysEvent event) {
        event.registerBelow(VanillaGuiOverlay.HOTBAR.id(), "sanitydim".concat(".sanity_indicator"), this::renderSanityIndicator);
        event.registerAbove(VanillaGuiOverlay.HOTBAR.id(), "sanitydim".concat(".hint"), this::renderHint);
        event.registerAbove(VanillaGuiOverlay.VIGNETTE.id(), "sanitydim".concat(".blood_tendrils_overlay"), this::renderBloodTendrilsOverlay);
    }

    public void initPostProcessor() {
        if (this.m_post != null) {
            return;
        }
        this.m_post = new PostProcessor();
        this.initSanityPostProcess();
    }

    public PostProcessor getPostProcessor() {
        return this.m_post;
    }

    public void renderPostProcess(float partialTicks) {
        if (this.m_post == null) {
            return;
        }
        this.m_post.render(partialTicks);
    }

    public void resize(int w, int h) {
        if (this.m_post == null) {
            return;
        }
        this.m_post.resize(w, h);
    }

    private static void renderFullscreen(PoseStack poseStack, int scw, int sch, int texw, int texh, int uoffset, int voffset, int spritew, int spriteh, float alpha) {
        Matrix4f mat = poseStack.m_85850_().m_252922_();
        RenderSystem.setShader(GameRenderer::m_172814_);
        RenderSystem.enableBlend();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        bufferbuilder.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_((float)uoffset / (float)texw, (float)voffset / (float)texh).m_5752_();
        bufferbuilder.m_252986_(mat, 0.0f, (float)sch, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_((float)uoffset / (float)texw, (float)(voffset + spriteh) / (float)texh).m_5752_();
        bufferbuilder.m_252986_(mat, (float)scw, (float)sch, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_((float)(uoffset + spritew) / (float)texw, (float)(voffset + spriteh) / (float)texh).m_5752_();
        bufferbuilder.m_252986_(mat, (float)scw, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_((float)(uoffset + spritew) / (float)texw, (float)voffset / (float)texh).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    static {
        int i;
        SANITY_INDICATOR = new ResourceLocation("sanitydim", "textures/sanity_indicator.png");
        BLOOD_TENDRILS_OVERLAY = new ResourceLocation("sanitydim", "textures/overlay/blood_tendrils.png");
        HINTS0 = new MutableComponent[12];
        for (i = 0; i < HINTS0.length; ++i) {
            GuiHandler.HINTS0[i] = Component.m_237115_((String)("gui.sanitydim.hint0" + i));
        }
        HINTS1 = new MutableComponent[9];
        for (i = 0; i < HINTS1.length; ++i) {
            GuiHandler.HINTS1[i] = Component.m_237115_((String)("gui.sanitydim.hint1" + i));
        }
    }
}

