/*
 * Decompiled with CFR 0.152.
 */
package croissantnova.sanitydim.capability;

import croissantnova.sanitydim.capability.IPassiveSanity;
import croissantnova.sanitydim.capability.IPersistentSanity;
import croissantnova.sanitydim.capability.ISanity;
import croissantnova.sanitydim.util.MathHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;

public class Sanity
implements ISanity,
IPassiveSanity,
IPersistentSanity {
    private boolean m_dirty = true;
    private int m_emAngerTimer;
    private float m_sanityVal;
    private float m_passive;
    private Vec3 m_stuckMultiplier;
    private final int[] m_cds = new int[8];
    private final Map<Integer, Integer> m_itemCds = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> m_brokenBlocksCds = new HashMap<Integer, Integer>();

    @Override
    public void serializeNBT(CompoundTag tag) {
        tag.m_128350_("sanity.sanity", this.m_sanityVal);
        tag.m_128405_("sanity.ender_man_anger_timer", this.m_emAngerTimer);
        tag.m_128405_("sanity.sleeping", this.m_cds[0]);
        tag.m_128405_("sanity.baby_chicken_spawn", this.m_cds[1]);
        tag.m_128405_("sanity.animal_breeding", this.m_cds[2]);
        tag.m_128405_("sanity.villager_trade", this.m_cds[3]);
        tag.m_128405_("sanity.shearing", this.m_cds[4]);
        tag.m_128405_("sanity.eating", this.m_cds[5]);
        tag.m_128405_("sanity.fishing", this.m_cds[6]);
        tag.m_128405_("sanity.potting_flower", this.m_cds[7]);
        this.serializeItemCds(tag);
        this.serializeBrokenBlocksCds(tag);
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        this.setSanity(tag.m_128457_("sanity.sanity"));
        this.setEnderManAngerTimer(tag.m_128451_("sanity.ender_man_anger_timer"));
        this.m_cds[0] = tag.m_128451_("sanity.sleeping");
        this.m_cds[1] = tag.m_128451_("sanity.baby_chicken_spawn");
        this.m_cds[2] = tag.m_128451_("sanity.animal_breeding");
        this.m_cds[3] = tag.m_128451_("sanity.villager_trade");
        this.m_cds[4] = tag.m_128451_("sanity.shearing");
        this.m_cds[5] = tag.m_128451_("sanity.eating");
        this.m_cds[6] = tag.m_128451_("sanity.fishing");
        this.m_cds[7] = tag.m_128451_("sanity.potting_flower");
        this.deserializeItemCds(tag);
        this.deserializeBrokenBlocksCooldowns(tag);
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.writeFloat(this.m_sanityVal);
        buf.writeFloat(this.m_passive);
    }

    public void deserialize(FriendlyByteBuf buf) {
        this.m_sanityVal = buf.readFloat();
        this.m_passive = buf.readFloat();
    }

    @Override
    public float getSanity() {
        return this.m_sanityVal;
    }

    @Override
    public void setSanity(float value) {
        this.m_sanityVal = MathHelper.clampNorm(value);
        this.m_dirty = true;
    }

    @Override
    public float getPassiveIncrease() {
        return this.m_passive;
    }

    @Override
    public void setPassiveIncrease(float value) {
        this.m_passive = value;
        this.m_dirty = true;
    }

    public boolean getDirty() {
        return this.m_dirty;
    }

    public void setDirty(boolean value) {
        this.m_dirty = value;
    }

    @Override
    public int[] getActiveSourcesCooldowns() {
        return this.m_cds;
    }

    @Override
    public Map<Integer, Integer> getItemCooldowns() {
        return this.m_itemCds;
    }

    @Override
    public Map<Integer, Integer> getBrokenBlocksCooldowns() {
        return this.m_brokenBlocksCds;
    }

    @Override
    public void setEnderManAngerTimer(int value) {
        this.m_emAngerTimer = value;
    }

    @Override
    public int getEnderManAngerTimer() {
        return this.m_emAngerTimer;
    }

    @Override
    public void setStuckMotionMultiplier(Vec3 multiplier) {
        this.m_stuckMultiplier = multiplier;
    }

    @Override
    public Vec3 getStuckMotionMultiplier() {
        return this.m_stuckMultiplier;
    }

    private void serializeItemCds(CompoundTag tag) {
        long[] itemCds = new long[this.m_itemCds.size()];
        int i = 0;
        for (Map.Entry<Integer, Integer> entry : this.m_itemCds.entrySet()) {
            long val = entry.getKey().intValue();
            val <<= 32;
            itemCds[i] = val |= (long)entry.getValue().intValue();
            ++i;
        }
        tag.m_128388_("sanity.item_cooldowns", itemCds);
    }

    private void deserializeItemCds(CompoundTag tag) {
        long[] itemCds = tag.m_128467_("sanity.item_cooldowns");
        this.m_itemCds.clear();
        for (long itemCd : itemCds) {
            this.m_itemCds.put((int)(itemCd >> 32), (int)itemCd);
        }
    }

    private void serializeBrokenBlocksCds(CompoundTag tag) {
        long[] brokenBlocksCds = new long[this.m_brokenBlocksCds.size()];
        int i = 0;
        for (Map.Entry<Integer, Integer> entry : this.m_brokenBlocksCds.entrySet()) {
            long val = entry.getKey().intValue();
            val <<= 32;
            brokenBlocksCds[i] = val |= (long)entry.getValue().intValue();
            ++i;
        }
        tag.m_128388_("sanity.broken_blocks_cooldowns", brokenBlocksCds);
    }

    private void deserializeBrokenBlocksCooldowns(CompoundTag tag) {
        long[] brokenBlocksCds = tag.m_128467_("sanity.broken_blocks_cooldowns");
        this.m_brokenBlocksCds.clear();
        for (long blockCd : brokenBlocksCds) {
            this.m_itemCds.put((int)(blockCd >> 32), (int)blockCd);
        }
    }
}

