/*
 * Decompiled with CFR 0.152.
 */
package croissantnova.sanitydim;

import croissantnova.sanitydim.SanityMod;
import croissantnova.sanitydim.capability.IPassiveSanity;
import croissantnova.sanitydim.capability.IPersistentSanity;
import croissantnova.sanitydim.capability.ISanity;
import croissantnova.sanitydim.capability.InnerEntityCapImpl;
import croissantnova.sanitydim.capability.InnerEntityCapImplProvider;
import croissantnova.sanitydim.capability.Sanity;
import croissantnova.sanitydim.capability.SanityLevelChunkProvider;
import croissantnova.sanitydim.capability.SanityProvider;
import croissantnova.sanitydim.config.ConfigBrokenBlock;
import croissantnova.sanitydim.config.ConfigBrokenBlockCategory;
import croissantnova.sanitydim.config.ConfigItem;
import croissantnova.sanitydim.config.ConfigItemCategory;
import croissantnova.sanitydim.config.ConfigProxy;
import croissantnova.sanitydim.entity.InnerEntity;
import croissantnova.sanitydim.entity.InnerEntitySpawner;
import croissantnova.sanitydim.item.ItemRegistry;
import croissantnova.sanitydim.net.InnerEntityCapImplPacket;
import croissantnova.sanitydim.net.PacketHandler;
import croissantnova.sanitydim.net.SanityPacket;
import croissantnova.sanitydim.passive.BlockStuck;
import croissantnova.sanitydim.passive.Darkness;
import croissantnova.sanitydim.passive.DirtPath;
import croissantnova.sanitydim.passive.EnderManAnger;
import croissantnova.sanitydim.passive.Hungry;
import croissantnova.sanitydim.passive.IPassiveSanitySource;
import croissantnova.sanitydim.passive.InWaterOrRain;
import croissantnova.sanitydim.passive.Jukebox;
import croissantnova.sanitydim.passive.Lightness;
import croissantnova.sanitydim.passive.Monster;
import croissantnova.sanitydim.passive.Passive;
import croissantnova.sanitydim.passive.PassiveBlocks;
import croissantnova.sanitydim.passive.Pet;
import croissantnova.sanitydim.passive.PlayerCompany;
import croissantnova.sanitydim.util.MathHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public final class SanityProcessor {
    private static int garlandTimer;
    private static final RandomSource RAND;
    public static final int MAX_GARLAND_TIMER = 60;
    public static final float SANITY_TARGET_THRESHOLD = 0.87f;
    public static final List<IPassiveSanitySource> PASSIVE_SANITY_SOURCES;

    private SanityProcessor() {
    }

    private static float calcPassive(ServerPlayer player, ISanity sanity) {
        ResourceLocation dim = player.m_9236_().m_46472_().m_135782_();
        float passive = 0.0f;
        for (IPassiveSanitySource pss : PASSIVE_SANITY_SOURCES) {
            float val = pss.get(player, sanity, dim);
            val *= SanityProcessor.getSanityMultiplier(player, val);
            passive += val;
        }
        --garlandTimer;
        ItemStack headItem = player.m_6844_(EquipmentSlot.HEAD);
        if (headItem.m_150930_((Item)ItemRegistry.GARLAND.get())) {
            passive = (float)((double)passive - 5.0E-5 * (double)ConfigProxy.getPosMul(dim));
            if (garlandTimer <= 0) {
                headItem.m_41622_(player.m_20070_() ? 2 : 1, (LivingEntity)player, ent -> {});
            }
        }
        if (garlandTimer <= 0) {
            garlandTimer = 60;
        }
        return passive;
    }

    private static void shareSanity(ServerPlayer player, Sanity cap) {
        if (cap.getDirty()) {
            SanityPacket packet = new SanityPacket(cap);
            PacketHandler.CHANNEL_INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
            cap.setDirty(false);
        }
    }

    private static void handlePlayerAte(ServerPlayer player, ItemStack itemStack) {
        SanityProcessor.handleActiveSourceForPlayer(player, 5, ConfigProxy::getEatingCooldown, dim -> Float.valueOf((float)itemStack.getFoodProperties((LivingEntity)player).m_38744_() * ConfigProxy.getEating(dim)));
    }

    public static float getGarlandMultiplier(ServerPlayer player) {
        return player.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ItemRegistry.GARLAND.get()) ? 0.92f : 1.0f;
    }

    public static float getSanityMultiplier(ServerPlayer player, float value) {
        ResourceLocation dim = player.m_9236_().m_46472_().m_135782_();
        return value >= 0.0f ? ConfigProxy.getNegMul(dim) * SanityProcessor.getGarlandMultiplier(player) : ConfigProxy.getPosMul(dim);
    }

    public static void addSanity(@NotNull ISanity sanity, float value, @NotNull ServerPlayer player) {
        if (value == 0.0f) {
            return;
        }
        sanity.setSanity(sanity.getSanity() + value * SanityProcessor.getSanityMultiplier(player, value));
    }

    public static void tickPlayer(ServerPlayer player) {
        if (player == null || player.m_7500_() || player.m_5833_()) {
            return;
        }
        player.getCapability(SanityProvider.CAP).ifPresent(s -> {
            Object ps;
            ResourceLocation dim = player.m_9236_().m_46472_().m_135782_();
            float passive = SanityProcessor.calcPassive(player, s);
            float snapshot = s.getSanity();
            s.setSanity(s.getSanity() + passive);
            if (s instanceof IPassiveSanity) {
                ps = (IPassiveSanity)((Object)s);
                ps.setPassiveIncrease(snapshot != s.getSanity() ? passive : 0.0f);
            }
            if (s instanceof IPersistentSanity) {
                ps = (IPersistentSanity)((Object)s);
                int[] cds = ps.getActiveSourcesCooldowns();
                for (int i = 0; i < cds.length; ++i) {
                    cds[i] = Mth.m_14045_((int)(cds[i] - 1), (int)0, (int)Integer.MAX_VALUE);
                }
                Map<Integer, Integer> itemCds = ps.getItemCooldowns();
                Iterator<Map.Entry<Integer, Integer>> it = itemCds.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Integer, Integer> entry = it.next();
                    itemCds.put(entry.getKey(), itemCds.get(entry.getKey()) - 1);
                    if (itemCds.get(entry.getKey()) > 0) continue;
                    it.remove();
                }
                Map<Integer, Integer> brokenBlocksCds = ps.getBrokenBlocksCooldowns();
                Iterator<Map.Entry<Integer, Integer>> it2 = brokenBlocksCds.entrySet().iterator();
                while (it2.hasNext()) {
                    Map.Entry<Integer, Integer> entry = it2.next();
                    brokenBlocksCds.put(entry.getKey(), brokenBlocksCds.get(entry.getKey()) - 1);
                    if (brokenBlocksCds.get(entry.getKey()) > 0) continue;
                    it2.remove();
                }
            }
            if (s instanceof Sanity) {
                SanityProcessor.shareSanity(player, (Sanity)s);
            }
        });
        InnerEntitySpawner.trySpawnForPlayer(player);
    }

    public static void tickLevel(ServerLevel level) {
        for (Entity ent : level.m_142646_().m_142273_()) {
            if (!(ent instanceof InnerEntity)) continue;
            InnerEntity ie = (InnerEntity)ent;
            ie.getCapability(InnerEntityCapImplProvider.CAP).ifPresent(iec -> {
                if (iec instanceof InnerEntityCapImpl) {
                    InnerEntityCapImpl ieci = (InnerEntityCapImpl)iec;
                    if (ieci.hasTarget() && ie.m_5448_() == null || !ieci.hasTarget() && ie.m_5448_() != null) {
                        UUID uUID;
                        ieci.setHasTarget(ie.m_5448_() != null);
                        LivingEntity patt7383$temp = ie.m_5448_();
                        if (patt7383$temp instanceof ServerPlayer) {
                            ServerPlayer sp = (ServerPlayer)patt7383$temp;
                            uUID = sp.m_20148_();
                        } else {
                            uUID = null;
                        }
                        ieci.setPlayerTargetUUID(uUID);
                    }
                    if (ieci.getDirty()) {
                        InnerEntityCapImplPacket packet = new InnerEntityCapImplPacket(ieci);
                        packet.m_id = ent.m_19879_();
                        PacketHandler.CHANNEL_INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> ent), (Object)packet);
                    }
                }
            });
        }
    }

    public static List<Player> getInsanePlayersInArea(Level levelIn, BlockPos center, int blockRadius) {
        if (levelIn == null || center == null) {
            return null;
        }
        ArrayList<Player> list = new ArrayList<Player>();
        for (Player player : levelIn.m_45976_(Player.class, new AABB(center.m_7918_(blockRadius, blockRadius, blockRadius), center.m_7918_(-blockRadius, -blockRadius, -blockRadius)))) {
            player.getCapability(SanityProvider.CAP).ifPresent(s -> {
                if (s.getSanity() >= 0.87f) {
                    list.add(player);
                }
            });
        }
        return list;
    }

    public static Player getMostInsanePlayer(Level levelIn) {
        return SanityProcessor.getMostInsanePlayer(levelIn, 0.87f);
    }

    public static Player getMostInsanePlayer(Level levelIn, float sanityThreshold) {
        if (levelIn == null) {
            return null;
        }
        Player toReturn = null;
        float maxSanity = Float.MIN_VALUE;
        for (Player player : levelIn.m_6907_()) {
            float sanity;
            ISanity s;
            if (player.m_7500_() || player.m_5833_() || (s = (ISanity)player.getCapability(SanityProvider.CAP).orElse(null)) == null || !((sanity = s.getSanity()) >= sanityThreshold) || !(sanity > maxSanity)) continue;
            maxSanity = s.getSanity();
            toReturn = player;
        }
        return toReturn;
    }

    public static void handleActiveSourceForPlayer(ServerPlayer player, int id, Function<ResourceLocation, Integer> cdSupplier, Function<ResourceLocation, Float> sanitySupplier) {
        if (player == null || player.m_7500_() || player.m_5833_()) {
            return;
        }
        player.getCapability(SanityProvider.CAP).ifPresent(s -> {
            ResourceLocation dimLoc = player.m_9236_().m_46472_().m_135782_();
            int cd = (Integer)cdSupplier.apply(dimLoc);
            if (s instanceof IPersistentSanity) {
                IPersistentSanity ps = (IPersistentSanity)((Object)s);
                if ((float)cd > 0.0f) {
                    int timePassed = cd - ps.getActiveSourcesCooldowns()[id];
                    SanityProcessor.addSanity(s, ((Float)sanitySupplier.apply(dimLoc)).floatValue() * MathHelper.clampNorm((float)timePassed / (float)cd), player);
                    ps.getActiveSourcesCooldowns()[id] = cd;
                    return;
                }
            }
            SanityProcessor.addSanity(s, ((Float)sanitySupplier.apply(dimLoc)).floatValue(), player);
        });
    }

    public static void handlePlayerSlept(ServerLevel level) {
        for (ServerPlayer player : level.m_6907_()) {
            if (player.m_7500_() || player.m_5833_()) continue;
            SanityProcessor.handleActiveSourceForPlayer(player, 0, ConfigProxy::getSleepingCooldown, ConfigProxy::getSleeping);
        }
    }

    public static void handlePlayerHurt(ServerPlayer player, float amount) {
        if (player == null || player.m_7500_() || player.m_5833_() || amount <= 0.0f) {
            return;
        }
        player.getCapability(SanityProvider.CAP).ifPresent(s -> {
            ResourceLocation dimLoc = player.m_9236_().m_46472_().m_135782_();
            SanityProcessor.addSanity(s, amount * ConfigProxy.getHurtRatio(dimLoc), player);
        });
    }

    public static void handlePlayerHurtAnimal(ServerPlayer player, Animal animal, float amount) {
        if (player == null || player.m_7500_() || player.m_5833_() || amount <= 0.0f) {
            return;
        }
        player.getCapability(SanityProvider.CAP).ifPresent(s -> {
            ResourceLocation dimLoc = player.m_9236_().m_46472_().m_135782_();
            SanityProcessor.addSanity(s, amount * ConfigProxy.getAnimalHurtRatio(player.m_9236_().m_46472_().m_135782_()) * (animal.m_6162_() ? 2.0f : 1.0f), player);
        });
    }

    public static void handlePlayerPetDeath(ServerPlayer player, TamableAnimal pet) {
        if (player == null || player.m_7500_() || player.m_5833_() || pet.m_21830_((LivingEntity)player)) {
            return;
        }
        player.getCapability(SanityProvider.CAP).ifPresent(s -> {
            ResourceLocation dimLoc = player.m_9236_().m_46472_().m_135782_();
            SanityProcessor.addSanity(s, ConfigProxy.getPetDeath(player.m_9236_().m_46472_().m_135782_()), player);
        });
    }

    public static void handlePlayerEnderManAngered(ServerPlayer player) {
        if (player == null || player.m_7500_() || player.m_5833_()) {
            return;
        }
        player.getCapability(SanityProvider.CAP).ifPresent(s -> {
            IPersistentSanity ps;
            if (s instanceof IPersistentSanity && (ps = (IPersistentSanity)((Object)s)).getEnderManAngerTimer() <= 0) {
                ps.setEnderManAngerTimer(100);
            }
        });
    }

    public static void handlePlayerGotAdvancement(ServerPlayer player, Advancement adv) {
        if (player == null || player.m_7500_() || player.m_5833_()) {
            return;
        }
        if (adv.m_138320_() == null || !adv.m_138320_().m_14996_()) {
            return;
        }
        player.getCapability(SanityProvider.CAP).ifPresent(s -> {
            ResourceLocation dimLoc = player.m_9236_().m_46472_().m_135782_();
            SanityProcessor.addSanity(s, ConfigProxy.getAdvancement(dimLoc), player);
        });
    }

    public static void handlePlayerBredAnimals(ServerPlayer player) {
        if (player == null || player.m_7500_() || player.m_5833_()) {
            return;
        }
        SanityProcessor.handleActiveSourceForPlayer(player, 2, ConfigProxy::getAnimalBreedingCooldown, ConfigProxy::getAnimalBreeding);
    }

    public static void handlePlayerTradedWithVillager(ServerPlayer player) {
        if (player == null || player.m_7500_() || player.m_5833_()) {
            return;
        }
        SanityProcessor.handleActiveSourceForPlayer(player, 3, ConfigProxy::getVillagerTradeCooldown, ConfigProxy::getVillagerTrade);
    }

    public static void handlePlayerUsedShears(ServerPlayer player) {
        if (player == null || player.m_7500_() || player.m_5833_()) {
            return;
        }
        SanityProcessor.handleActiveSourceForPlayer(player, 4, ConfigProxy::getShearingCooldown, ConfigProxy::getShearing);
    }

    public static void handlePlayerSpawnedChicken(ServerPlayer player) {
        if (player == null || player.m_7500_() || player.m_5833_()) {
            return;
        }
        SanityProcessor.handleActiveSourceForPlayer(player, 1, ConfigProxy::getBabyChickenSpawningCooldown, ConfigProxy::getBabyChickenSpawning);
    }

    public static void handlePlayerUsedItem(ServerPlayer player, ItemStack itemStack) {
        if (player == null || player.m_7500_() || player.m_5833_()) {
            return;
        }
        player.getCapability(SanityProvider.CAP).ifPresent(s -> {
            if (s instanceof IPersistentSanity) {
                IPersistentSanity ps = (IPersistentSanity)((Object)s);
                ResourceLocation dim = player.m_9236_().m_46472_().m_135782_();
                for (ConfigItem citem : ConfigProxy.getItems(dim)) {
                    if (!itemStack.m_150930_((Item)ForgeRegistries.ITEMS.getValue(citem.m_name))) continue;
                    if (!ConfigProxy.getIdToItemCat(dim).containsKey(citem.m_cat)) {
                        SanityMod.LOGGER.warn("player " + player.m_5446_().getString() + " used " + citem.m_name + " from category " + citem.m_cat + ", but no such category is present");
                        return;
                    }
                    ConfigItemCategory cat = ConfigProxy.getIdToItemCat(dim).get(citem.m_cat);
                    if (cat.m_cd <= 0) {
                        SanityProcessor.addSanity(s, citem.m_sanity, player);
                        return;
                    }
                    Map<Integer, Integer> itemCds = ps.getItemCooldowns();
                    if (!itemCds.containsKey(citem.m_cat) || itemCds.get(citem.m_cat) <= 0) {
                        SanityProcessor.addSanity(s, citem.m_sanity, player);
                    } else {
                        int timePassed = cat.m_cd - itemCds.get(citem.m_cat);
                        SanityProcessor.addSanity(s, citem.m_sanity * MathHelper.clampNorm((float)timePassed / (float)cat.m_cd), player);
                    }
                    itemCds.put(citem.m_cat, cat.m_cd);
                    return;
                }
            }
            if (itemStack.m_41614_()) {
                SanityProcessor.handlePlayerAte(player, itemStack);
            }
        });
    }

    public static void handlePlayerFishedItem(ServerPlayer player) {
        if (player == null || player.m_7500_() || player.m_5833_()) {
            return;
        }
        SanityProcessor.handleActiveSourceForPlayer(player, 6, ConfigProxy::getFishingCooldown, ConfigProxy::getFishing);
    }

    public static void handlePlayerMinedBlock(ServerPlayer player, BlockPos blockPos, BlockState blockState, Block block, boolean correctTool) {
        if (player == null) {
            return;
        }
        ServerLevel level = player.m_284548_();
        LevelChunk levelChunk = level.m_46745_(blockPos);
        if (player.m_7500_() || player.m_5833_()) {
            levelChunk.getCapability(SanityLevelChunkProvider.CAP).ifPresent(sl -> {
                sl.getArtificiallyPlacedBlocks().remove(blockPos);
                levelChunk.m_8092_(true);
            });
            return;
        }
        player.getCapability(SanityProvider.CAP).ifPresent(s -> {
            if (s instanceof IPersistentSanity) {
                IPersistentSanity ps = (IPersistentSanity)((Object)s);
                ResourceLocation dim = level.m_46472_().m_135782_();
                for (ConfigBrokenBlock cbblock : ConfigProxy.getBrokenBlocks(dim)) {
                    if ((!cbblock.m_isTag || !blockState.m_204343_().anyMatch(tag -> tag.f_203868_().equals((Object)cbblock.m_name))) && !block.equals(ForgeRegistries.BLOCKS.getValue(cbblock.m_name))) continue;
                    if (cbblock.m_toolRequired && !correctTool) {
                        return;
                    }
                    if (!ConfigProxy.getIdToBrokenBlockCat(dim).containsKey(cbblock.m_cat)) {
                        SanityMod.LOGGER.warn("player " + player.m_5446_().getString() + " mined " + cbblock.m_name + " from category " + cbblock.m_cat + ", but no such category is present");
                        return;
                    }
                    if (cbblock.m_naturallyGend) {
                        AtomicBoolean flag = new AtomicBoolean(false);
                        levelChunk.getCapability(SanityLevelChunkProvider.CAP).ifPresent(sl -> {
                            if (sl.getArtificiallyPlacedBlocks().remove(blockPos)) {
                                flag.set(true);
                                levelChunk.m_8092_(true);
                            }
                        });
                        if (flag.get()) {
                            return;
                        }
                    }
                    ConfigBrokenBlockCategory cat = ConfigProxy.getIdToBrokenBlockCat(dim).get(cbblock.m_cat);
                    if (cat.m_cd <= 0) {
                        SanityProcessor.addSanity(s, cbblock.m_sanity, player);
                        return;
                    }
                    Map<Integer, Integer> brokenBlockCds = ps.getBrokenBlocksCooldowns();
                    if (!brokenBlockCds.containsKey(cbblock.m_cat) || brokenBlockCds.get(cbblock.m_cat) <= 0) {
                        SanityProcessor.addSanity(s, cbblock.m_sanity, player);
                    } else {
                        int timePassed = cat.m_cd - brokenBlockCds.get(cbblock.m_cat);
                        SanityProcessor.addSanity(s, cbblock.m_sanity * MathHelper.clampNorm((float)timePassed / (float)cat.m_cd), player);
                    }
                    brokenBlockCds.put(cbblock.m_cat, cat.m_cd);
                    return;
                }
            }
        });
    }

    public static void handlePlayerTrampledFarmland(ServerPlayer player) {
        if (player == null || player.m_7500_() || player.m_5833_()) {
            return;
        }
        player.getCapability(SanityProvider.CAP).ifPresent(s -> SanityProcessor.addSanity(s, ConfigProxy.getFarmlandTrample(player.m_9236_().m_46472_().m_135782_()), player));
    }

    public static void handlePlayerPottedFlower(ServerPlayer player) {
        if (player == null || player.m_7500_() || player.m_5833_()) {
            return;
        }
        player.getCapability(SanityProvider.CAP).ifPresent(s -> SanityProcessor.handleActiveSourceForPlayer(player, 7, ConfigProxy::getPottingFlowerCooldown, ConfigProxy::getPottingFlower));
    }

    public static void handlePlayerChangedDimensions(ServerPlayer player) {
        if (player == null || player.m_7500_() || player.m_5833_()) {
            return;
        }
        player.getCapability(SanityProvider.CAP).ifPresent(s -> SanityProcessor.addSanity(s, ConfigProxy.getChangedDimension(player.m_9236_().m_46472_().m_135782_()), player));
    }

    public static void handlePlayerStruckByLightning(ServerPlayer player) {
        if (player == null || player.m_7500_() || player.m_5833_()) {
            return;
        }
        player.getCapability(SanityProvider.CAP).ifPresent(s -> SanityProcessor.addSanity(s, ConfigProxy.getStruckByLightning(player.m_9236_().m_46472_().m_135782_()), player));
    }

    static {
        RAND = RandomSource.m_216327_();
        PASSIVE_SANITY_SOURCES = Arrays.asList(new Passive(), new InWaterOrRain(), new Hungry(), new EnderManAnger(), new Pet(), new Monster(), new Darkness(), new Lightness(), new PassiveBlocks(), new PlayerCompany(), new Jukebox(), new BlockStuck(), new DirtPath());
    }
}

