/*
 * Decompiled with CFR 0.152.
 */
package croissantnova.sanitydim;

import com.mojang.logging.LogUtils;
import croissantnova.sanitydim.client.GuiHandler;
import croissantnova.sanitydim.config.ConfigManager;
import croissantnova.sanitydim.entity.EntityRegistry;
import croissantnova.sanitydim.event.EventHandler;
import croissantnova.sanitydim.event.ModEventHandler;
import croissantnova.sanitydim.item.ItemRegistry;
import croissantnova.sanitydim.net.PacketHandler;
import croissantnova.sanitydim.sound.SoundRegistry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="sanitydim")
public class SanityMod {
    @OnlyIn(value=Dist.CLIENT)
    private GuiHandler m_gui;
    private static SanityMod m_inst;
    public static final String MODID = "sanitydim";
    public static final Logger LOGGER;

    public SanityMod() {
        m_inst = this;
        ConfigManager.register();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(ModEventHandler::addEntityAttributes);
        modEventBus.addListener(ModEventHandler::onConfigLoading);
        modEventBus.addListener(ModEventHandler::registerOverlaysEvent);
        modEventBus.addListener(ModEventHandler::registerEntityRenderersEvent);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        EntityRegistry.register(modEventBus);
        ItemRegistry.register(modEventBus);
        SoundRegistry.register(modEventBus);
    }

    private void setup(FMLCommonSetupEvent event) {
        PacketHandler.init();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        this.initGui();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initGui() {
        if (this.m_gui == null) {
            this.m_gui = new GuiHandler();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public GuiHandler getGui() {
        return this.m_gui;
    }

    public static SanityMod getInstance() {
        return m_inst;
    }

    static {
        LOGGER = LogUtils.getLogger();
        ConfigManager.init();
    }
}

