/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.client.gui;

import com.legacy.structure_gel.core.client.widget.MultiWidget;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;

public interface LayerWidgetHolder
extends ContainerEventHandler {
    public List<LayerAwareWidget> getLayerAwareWidgets();

    @Nullable
    default public LayerAwareWidget getLayerAwareWidget(@Nullable GuiEventListener widget) {
        if (widget != null) {
            for (LayerAwareWidget v : this.getLayerAwareWidgets()) {
                if (v.widget != widget) continue;
                return v;
            }
        }
        return null;
    }

    default public void forLayerAware(@Nullable GuiEventListener widget, Consumer<LayerAwareWidget> action) {
        LayerAwareWidget layerAware = this.getLayerAwareWidget(widget);
        if (layerAware != null) {
            action.accept(layerAware);
        }
    }

    default public <T extends GuiEventListener & NarratableEntry> T addLayerAwareWidget(int layer, T widget) {
        if (!(widget instanceof MultiWidget)) {
            this.getLayerAwareWidgets().add(new LayerAwareWidget(layer, widget));
        }
        return widget;
    }

    default public void changeWidgetLayer(GuiEventListener widget, int newLayer) {
        this.forLayerAware(widget, l -> {
            l.layer = newLayer;
        });
    }

    @Nullable
    default public GuiEventListener getTopWidget(double mouseX, double mouseY) {
        LayerAwareWidget top = null;
        for (LayerAwareWidget layerAware : this.getLayerAwareWidgets()) {
            if (!layerAware.widget.m_5953_(mouseX, mouseY) || top != null && layerAware.layer <= top.layer) continue;
            top = layerAware;
        }
        return top == null ? null : top.widget;
    }

    default public Optional<GuiEventListener> m_94729_(double mouseX, double mouseY) {
        GuiEventListener top = this.getTopWidget(mouseX, mouseY);
        if (top != null) {
            return Optional.of(top);
        }
        return super.m_94729_(mouseX, mouseY);
    }

    default public boolean m_6375_(double mouseX, double mouseY, int click) {
        GuiEventListener top = this.getTopWidget(mouseX, mouseY);
        if (top != null && top.m_6375_(mouseX, mouseY, click)) {
            this.m_7522_(top);
            if (click == 0) {
                this.m_7897_(true);
            }
            return true;
        }
        return super.m_6375_(mouseX, mouseY, click);
    }

    default public boolean m_6348_(double mouseX, double mouseY, int click) {
        return super.m_6348_(mouseX, mouseY, click);
    }

    default public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return super.m_6050_(mouseX, mouseY, delta);
    }

    default public void m_94757_(double mouseX, double mouseY) {
        GuiEventListener top = this.getTopWidget(mouseX, mouseY);
        if (top != null) {
            top.m_94757_(mouseX, mouseY);
        }
    }

    public static class LayerAwareWidget {
        @Nullable
        public static GuiEventListener topHovered = null;
        protected int layer;
        public final GuiEventListener widget;

        public LayerAwareWidget(int layer, GuiEventListener widget) {
            this.layer = layer;
            this.widget = widget;
        }

        public static boolean isTop(GuiEventListener widget) {
            return topHovered == widget;
        }
    }
}

