/*
 * Decompiled with CFR 0.152.
 */
package com.plr.longnbtkiller.mixin;

import com.google.common.collect.Lists;
import com.plr.longnbtkiller.LongNbtKiller;
import com.plr.longnbtkiller.api.IListTag;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagTypes;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@Mixin(value={ListTag.class})
public abstract class MixinListTag
implements IListTag {
    @Mutable
    @Shadow
    @Final
    public static TagType<ListTag> f_128714_;
    @Mutable
    @Shadow
    @Final
    private List<Tag> f_128716_;
    @Shadow
    private byte f_128717_;

    @Inject(method={"<clinit>"}, at={@At(value="TAIL")})
    private static void inject$clinit(CallbackInfo ci) {
        f_128714_ = new TagType.VariableSize<ListTag>(){

            public ListTag load(DataInput input, int depth, NbtAccounter accounter) throws IOException {
                if (depth > LongNbtKiller.getMaxDepthForListTag()) {
                    LongNbtKiller.LOGGER.warn("Tried to read NBT tag with too high complexity, depth: {}", (Object)depth);
                    return new ListTag();
                }
                accounter.m_128926_(296L);
                byte b0 = input.readByte();
                int i = input.readInt();
                if (b0 == 0 && i > 0) {
                    throw new RuntimeException("Missing type on ListTag");
                }
                accounter.m_128926_(32L * (long)i);
                TagType tagtype = TagTypes.m_129397_((int)b0);
                ArrayList list = Lists.newArrayListWithCapacity((int)i);
                for (int j = 0; j < i; ++j) {
                    list.add(tagtype.m_7300_(input, depth + 1, accounter));
                }
                ListTag tag = new ListTag();
                ((IListTag)tag).longnbtkiller$setListAndType(list, b0);
                return tag;
            }

            public StreamTagVisitor.ValueResult m_196511_(DataInput input, StreamTagVisitor visitor) throws IOException {
                TagType tagtype = TagTypes.m_129397_((int)input.readByte());
                int i = input.readInt();
                switch (visitor.m_196339_(tagtype, i)) {
                    case HALT: {
                        return StreamTagVisitor.ValueResult.HALT;
                    }
                    case BREAK: {
                        tagtype.m_196189_(input, i);
                        return visitor.m_196527_();
                    }
                }
                int j = 0;
                while (true) {
                    block16: {
                        int k;
                        block15: {
                            if (j >= i) break block15;
                            block4 : switch (visitor.m_196338_(tagtype, j)) {
                                case HALT: {
                                    return StreamTagVisitor.ValueResult.HALT;
                                }
                                case BREAK: {
                                    tagtype.m_196159_(input);
                                    break;
                                }
                                case SKIP: {
                                    tagtype.m_196159_(input);
                                    break block16;
                                }
                                default: {
                                    switch (tagtype.m_196511_(input, visitor)) {
                                        case HALT: {
                                            return StreamTagVisitor.ValueResult.HALT;
                                        }
                                        case BREAK: {
                                            break block4;
                                        }
                                    }
                                    break block16;
                                }
                            }
                        }
                        if ((k = i - 1 - j) > 0) {
                            tagtype.m_196189_(input, k);
                        }
                        return visitor.m_196527_();
                    }
                    ++j;
                }
            }

            public void m_196159_(DataInput input) throws IOException {
                TagType tagtype = TagTypes.m_129397_((int)input.readByte());
                int i = input.readInt();
                tagtype.m_196189_(input, i);
            }

            public String m_5987_() {
                return "LIST";
            }

            public String m_5986_() {
                return "TAG_List";
            }
        };
    }

    @Override
    public void longnbtkiller$setListAndType(List<Tag> list, byte type) {
        this.f_128716_ = list;
        this.f_128717_ = type;
    }
}

