/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.widgets;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetElement;
import com.tiviacz.travelersbackpack.inventory.upgrades.FilterSettingsBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.FilterUpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.ButtonStates;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.FilterButton;
import com.tiviacz.travelersbackpack.network.ServerboundFilterSettingsPacket;
import com.tiviacz.travelersbackpack.network.ServerboundFilterTagsPacket;
import com.tiviacz.travelersbackpack.util.PacketDistributorHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class FilterUpgradeWidgetBase<W extends FilterUpgradeWidgetBase<W, U>, U extends FilterUpgradeBase<U, ?>>
extends UpgradeWidgetBase<U> {
    private final WidgetElement tagIconElement;
    private final List<FilterButton<W>> buttons = new ArrayList<FilterButton<W>>();
    private int selectedTagIndex = 0;
    private List<String> addableTags;
    private List<String> tags;

    public FilterUpgradeWidgetBase(BackpackScreen screen, U upgrade, Point pos, Point tabUv, String upgradeIconTooltip) {
        super(screen, upgrade, pos, tabUv, upgradeIconTooltip);
        this.tagIconElement = new WidgetElement(new Point(pos.x() + 6 + 36, pos.y() + 22), new Point(18, 18));
        this.tags = ((FilterSettingsBase)((FilterUpgradeBase)upgrade).getFilterSettings()).getFilterTags();
        this.addableTags = new ArrayList<String>();
        ((FilterUpgradeBase)upgrade).addChangeListener(this::updateAddableTags);
    }

    public void addFilterButton(FilterButton<W> button) {
        if (((FilterUpgradeBase)this.upgrade).isTagSelector() && button.getButtonState() == ButtonStates.IGNORE_MODE) {
            button.setHidden(true);
        }
        if (!this.buttons.contains(button)) {
            this.buttons.add(button);
        }
    }

    public void hideButton(ButtonStates.ButtonState state, boolean hidden) {
        if (this.hasButton(state)) {
            this.getFilterButton(state).setHidden(hidden);
        }
    }

    public boolean hasButton(ButtonStates.ButtonState buttonState) {
        return this.buttons.stream().anyMatch(button -> button.getButtonState() == buttonState);
    }

    public FilterButton<W> getFilterButton(ButtonStates.ButtonState buttonState) {
        return this.buttons.stream().filter(button -> button.getButtonState() == buttonState).findFirst().orElseThrow(() -> new IllegalArgumentException("No filter button found for state: " + String.valueOf(buttonState)));
    }

    @Override
    public void renderBg(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        if (((FilterUpgradeBase)this.getUpgrade()).isTagSelector() && this.isTabOpened()) {
            guiGraphics.m_280218_(BackpackScreen.TABS, this.pos.x(), this.pos.y(), 66, 149, 87, 103);
            guiGraphics.m_280480_(((BackpackScreen)this.screen).getWrapper().getUpgrades().getStackInSlot(this.dataHolderSlot), this.pos.x() + 4, this.pos.y() + 4);
            int j = 0;
            for (String tag : this.getTags()) {
                if (++j >= 5) {
                    return;
                }
                guiGraphics.m_280218_(BackpackScreen.TABS, this.pos.x() + 7, this.calculateTagBoxY(this.getTags().indexOf(tag)), 153, 149, 73, 13);
                guiGraphics.m_280056_(((BackpackScreen)this.screen).getFont(), this.getTrimmedText(tag), this.pos.x() + 9, this.calculateTagBoxY(this.getTags().indexOf(tag)) + 3, 0xFFFFFF, false);
            }
        } else {
            super.renderBg(guiGraphics, x, y, mouseX, mouseY);
        }
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.m_280218_(BackpackScreen.ICONS, this.tagIconElement.pos().x(), this.tagIconElement.pos().y(), 0, 186, this.tagIconElement.size().x(), this.tagIconElement.size().y());
        if (this.isTabOpened()) {
            if (((FilterUpgradeBase)this.upgrade).isTagSelector()) {
                if (!((FilterUpgradeBase)this.upgrade).getFirstFilterStack().m_41619_()) {
                    guiGraphics.m_280218_(BackpackScreen.ICONS, this.tagIconElement.pos().x(), this.tagIconElement.pos().y(), 186, 36, this.tagIconElement.size().x(), this.tagIconElement.size().y());
                } else {
                    guiGraphics.m_280218_(BackpackScreen.ICONS, this.tagIconElement.pos().x(), this.tagIconElement.pos().y(), 186, 0, this.tagIconElement.size().x(), this.tagIconElement.size().y());
                }
            }
            this.buttons.forEach(button -> button.renderButton(guiGraphics, mouseX, mouseY));
        }
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.isTabOpened() && ((FilterUpgradeBase)this.getUpgrade()).isTagSelector() && this.isMouseOverTags(mouseX, mouseY)) {
            guiGraphics.m_280677_(((BackpackScreen)this.screen).getFont(), this.getTooltip(), Optional.empty(), mouseX, mouseY);
        }
    }

    public void updateAddableTags() {
        this.selectedTagIndex = 0;
        this.addableTags = ((FilterSettingsBase)((FilterUpgradeBase)this.upgrade).getFilterSettings()).getAddableTags();
    }

    public boolean isAdding() {
        return !((FilterUpgradeBase)this.upgrade).getFirstFilterStack().m_41619_();
    }

    public int getSelectedTagIndex() {
        return this.selectedTagIndex;
    }

    public void setNextSelectedTagIndex(double mouse) {
        if (mouse < 0.0 && this.selectedTagIndex + 1 < this.getTags().size()) {
            ++this.selectedTagIndex;
        } else if (mouse > 0.0 && this.selectedTagIndex - 1 >= 0) {
            --this.selectedTagIndex;
        }
    }

    public List<String> getTags() {
        if (this.isAdding()) {
            return this.addableTags;
        }
        return this.tags;
    }

    public boolean addTag() {
        ArrayList<String> itemTags = new ArrayList<String>(this.addableTags);
        if (itemTags.isEmpty()) {
            return false;
        }
        int selected = this.getSelectedTagIndex();
        String tag = (String)itemTags.get(selected);
        itemTags.remove(tag);
        this.selectedTagIndex = Math.min(selected, itemTags.size() - 1);
        this.addableTags = itemTags;
        this.tags.add(tag);
        return true;
    }

    public boolean removeTag() {
        ArrayList<String> storedTags = new ArrayList<String>(this.tags);
        if (storedTags.isEmpty()) {
            return false;
        }
        int selected = this.getSelectedTagIndex();
        storedTags.remove(selected);
        this.selectedTagIndex = Math.max(0, Math.min(selected, storedTags.size() - 1));
        this.tags = storedTags;
        return true;
    }

    public List<Component> getTooltip() {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        boolean isAdding = this.isAdding();
        ArrayList<String> displayedTags = isAdding ? new ArrayList<String>(this.addableTags) : new ArrayList<String>(this.tags);
        displayedTags.forEach(t -> tooltip.add((Component)Component.m_237113_((String)t).m_130940_(ChatFormatting.GRAY)));
        if (tooltip.isEmpty()) {
            return List.of(Component.m_237115_((String)"screen.travelersbackpack.filter_tag_empty").m_130940_(ChatFormatting.DARK_GRAY));
        }
        ChatFormatting cursorColor = isAdding ? ChatFormatting.GREEN : ChatFormatting.RED;
        String selectedTagString = (String)displayedTags.get(this.getSelectedTagIndex());
        MutableComponent selectedTag = Component.m_237113_((String)("> " + selectedTagString)).m_130940_(cursorColor);
        tooltip.set(this.getSelectedTagIndex(), (Component)selectedTag);
        tooltip.add((Component)Component.m_237115_((String)(isAdding ? "screen.travelersbackpack.filter_tag_add" : "screen.travelersbackpack.filter_tag_remove")).m_130940_(ChatFormatting.BLUE));
        return tooltip;
    }

    public int calculateTagBoxY(int index) {
        return this.pos.y() + 44 + 13 * index;
    }

    public String getTrimmedText(String tag) {
        Font font = ((BackpackScreen)this.screen).getFont();
        int maxWidth = 70;
        Object displayText = tag;
        if (font.m_92895_(tag) > maxWidth) {
            int i;
            String ellipsis = "...";
            int ellipsisWidth = font.m_92895_(ellipsis);
            int availableWidth = maxWidth - ellipsisWidth;
            for (i = tag.length(); i > 0 && font.m_92895_(tag.substring(0, i)) > availableWidth; --i) {
            }
            displayText = tag.substring(0, i) + ellipsis;
        }
        return displayText;
    }

    public boolean isMouseOverTags(double mouseX, double mouseY) {
        return this.isWithinBounds(mouseX, mouseY, new Point(9, this.calculateTagBoxY(0) - this.pos.y()), new Point(73, 52));
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.isTabOpened() && ((FilterUpgradeBase)this.upgrade).isTagSelector() && this.isMouseOverTags(pMouseX, pMouseY)) {
            this.setNextSelectedTagIndex(pDelta);
            return true;
        }
        return false;
    }

    @Override
    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.isTabOpened() && this.isBackpackOwner()) {
            for (FilterButton<W> button : this.buttons) {
                if (!button.mouseClicked(pMouseX, pMouseY, pButton)) continue;
                if (this.hasButton(ButtonStates.OBJECT_TYPE) && this.getFilterButton(ButtonStates.OBJECT_TYPE).getCurrentState() == 2) {
                    if (this.hasButton(ButtonStates.ALLOW) && this.getFilterButton(ButtonStates.ALLOW).getCurrentState() == 2) {
                        this.getFilterButton(ButtonStates.ALLOW).nextState();
                    }
                    this.hideButton(ButtonStates.IGNORE_MODE, true);
                } else {
                    this.hideButton(ButtonStates.IGNORE_MODE, false);
                }
                PacketDistributorHelper.sendToServer(new ServerboundFilterSettingsPacket(this.dataHolderSlot, List.of(Integer.valueOf(this.buttons.get(0).getCurrentState()), Integer.valueOf(this.buttons.get(1).getCurrentState()), Integer.valueOf(this.buttons.get(2).getCurrentState()))));
                ((BackpackScreen)this.screen).playUIClickSound();
                return true;
            }
            if (this.isMouseOverTags(pMouseX, pMouseY) && ((FilterUpgradeBase)this.getUpgrade()).isTagSelector()) {
                if (this.isAdding() ? !this.addTag() : !this.removeTag()) {
                    return false;
                }
                PacketDistributorHelper.sendToServer(new ServerboundFilterTagsPacket(this.dataHolderSlot, this.tags));
                ((FilterSettingsBase)((FilterUpgradeBase)this.getUpgrade()).getFilterSettings()).updateFilterTags(this.tags);
                return true;
            }
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }
}

