/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.IEBlockEntityRenderer;
import blusunrize.immersiveengineering.client.utils.RenderUtils;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.CrusherLogic;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CrusherRenderer
extends IEBlockEntityRenderer<MultiblockBlockEntityMaster<CrusherLogic.State>> {
    public static String NAME_LEFT = "crusher_barrel_left";
    public static String NAME_RIGHT = "crusher_barrel_right";
    public static DynamicModel BARREL_LEFT;
    public static DynamicModel BARREL_RIGHT;

    public void render(MultiblockBlockEntityMaster<CrusherLogic.State> te, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        IMultiblockContext ctx = te.getHelper().getContext();
        CrusherLogic.State state = (CrusherLogic.State)ctx.getState();
        MultiblockOrientation orientation = ctx.getLevel().getOrientation();
        Direction dir = orientation.front();
        boolean active = state.shouldRenderActive();
        float angle = state.getBarrelAngle() + (active ? 18.0f * partialTicks : 0.0f);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 1.5, 0.5);
        matrixStack.m_85837_((double)dir.m_122429_() * 0.5, 0.0, (double)dir.m_122431_() * 0.5);
        matrixStack.m_85836_();
        matrixStack.m_252781_(new Quaternionf().rotateAxis(angle * ((float)Math.PI / 180), (Vector3fc)new Vector3f((float)(-dir.m_122431_()), 0.0f, (float)dir.m_122429_())));
        this.renderBarrel(BARREL_LEFT, matrixStack, bufferIn, dir, combinedLightIn, combinedOverlayIn);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_252880_((float)(dir.m_122429_() * -1), 0.0f, (float)(dir.m_122431_() * -1));
        matrixStack.m_252781_(new Quaternionf().rotateAxis(-angle * ((float)Math.PI / 180), (Vector3fc)new Vector3f((float)(-dir.m_122431_()), 0.0f, (float)dir.m_122429_())));
        this.renderBarrel(BARREL_RIGHT, matrixStack, bufferIn, dir, combinedLightIn, combinedOverlayIn);
        matrixStack.m_85849_();
        matrixStack.m_85849_();
    }

    private void renderBarrel(DynamicModel barrel, PoseStack matrix, MultiBufferSource buffer, Direction facing, int light, int overlay) {
        matrix.m_85836_();
        matrix.m_85837_(-0.5, -0.5, -0.5);
        List quads = barrel.get().getQuads(null, null, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, null);
        CrusherRenderer.rotateForFacing(matrix, facing);
        RenderUtils.renderModelTESRFast(quads, buffer.m_6299_(RenderType.m_110451_()), matrix, light, overlay);
        matrix.m_85849_();
    }
}

