/*
 * Decompiled with CFR 0.152.
 */
package com.diontryban.ash.api.modloader.forge;

import com.diontryban.ash.api.modloader.CommonModInitializer;
import com.diontryban.ash.api.modloader.forge.ForgeClientModInitializer;
import com.diontryban.ash.api.modloader.forge.ForgeModLoader;
import java.util.function.Supplier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.Nullable;

public abstract class ForgeModInitializer {
    protected CommonModInitializer commonModInitializer;

    protected ForgeModInitializer(String modId, @Nullable Supplier<CommonModInitializer> commonModInitializer, @Nullable Supplier<ForgeClientModInitializer> forgeClientModInitializer) {
        ForgeModLoader.registerMod(modId, ModLoadingContext.get(), FMLJavaModLoadingContext.get());
        if (commonModInitializer != null) {
            this.commonModInitializer = commonModInitializer.get();
        }
        if (forgeClientModInitializer != null) {
            DistExecutor.safeCallWhenOn((Dist)Dist.CLIENT, () -> ((Supplier)forgeClientModInitializer)::get);
        }
        ForgeModLoader.getEventBusOrThrow(modId).addListener(this::onInitialize);
    }

    protected void onInitialize(FMLCommonSetupEvent event) {
        if (this.commonModInitializer != null) {
            this.commonModInitializer.onInitialize();
        }
    }
}

