/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.scuba_gear;

import com.legacy.scuba_gear.ScubaConfig;
import com.legacy.scuba_gear.ScubaRegistry;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidType;

public class ScubaEvents {
    private static final List<Item> SCUBA_GEAR = List.of((Item)ScubaRegistry.SCUBA_HELMET.get(), (Item)ScubaRegistry.SCUBA_CHESTPLATE.get(), (Item)ScubaRegistry.SCUBA_LEGGINGS.get(), (Item)ScubaRegistry.SCUBA_BOOTS.get());
    private static final AttributeModifier HELMET_SPEED_MODIFIER = new AttributeModifier("scuba helmet land speed reduction", (double)-0.003f, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier CHESTPLATE_SPEED_MODIFIER = new AttributeModifier("scuba chestplate land speed reduction", (double)-0.005f, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier LEGGINGS_SPEED_MODIFIER = new AttributeModifier("scuba leggings land speed reduction", (double)-0.002f, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier BOOTS_SPEED_MODIFIER = new AttributeModifier("scuba boots land speed reduction", (double)-0.001f, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier SWIM_SPEED_MODIFIER = new AttributeModifier("scuba swim speed addition", (double)0.3f, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier UNDERWATER_WALK_SPEED_MODIFIER = new AttributeModifier("scuba underwater walk speed addition", (double)0.8f, AttributeModifier.Operation.ADDITION);

    public static void onDrownedSpawn(Drowned drowned) {
        if (ScubaEvents.isRuinOrWreckNearby((Entity)drowned)) {
            float chance = drowned.m_9236_().f_46441_.m_188501_();
            if (chance < 0.5f) {
                drowned.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ScubaRegistry.SCUBA_HELMET.get()));
            }
            if (chance < 0.4f) {
                drowned.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)ScubaRegistry.SCUBA_BOOTS.get()));
            }
            if (chance < 0.3f) {
                drowned.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)ScubaRegistry.SCUBA_LEGGINGS.get()));
            }
            if (chance < 0.2f) {
                drowned.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)ScubaRegistry.SCUBA_CHESTPLATE.get()));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        if (event.getSource().m_276093_(DamageTypes.f_268546_) && ScubaEvents.isWearingFullScuba(event.getEntity())) {
            event.getEntity().m_7311_(0);
            event.setCanceled(true);
            event.getEntity().m_6168_().forEach(armor -> {
                if (event.getEntity() instanceof ServerPlayer && event.getEntity().f_19797_ % 10 == 0 && !event.getEntity().m_9236_().f_46443_) {
                    armor.m_41622_(1, event.getEntity(), living -> {});
                }
            });
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity living = event.getEntity();
        if (living instanceof Player || living instanceof Drowned) {
            ScubaEvents.checkAddAndRemoveModifier(living, ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.HEAD) && !living.m_20072_(), Attributes.f_22279_, HELMET_SPEED_MODIFIER);
            ScubaEvents.checkAddAndRemoveModifier(living, ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.CHEST) && !living.m_20072_(), Attributes.f_22279_, CHESTPLATE_SPEED_MODIFIER);
            ScubaEvents.checkAddAndRemoveModifier(living, ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.LEGS) && !living.m_20072_(), Attributes.f_22279_, LEGGINGS_SPEED_MODIFIER);
            ScubaEvents.checkAddAndRemoveModifier(living, ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.FEET) && !living.m_20072_(), Attributes.f_22279_, BOOTS_SPEED_MODIFIER);
            ScubaEvents.checkAddAndRemoveModifier(living, living.m_6067_() && ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.LEGS), (Attribute)ForgeMod.SWIM_SPEED.get(), SWIM_SPEED_MODIFIER);
            ScubaEvents.checkAddAndRemoveModifier(living, !living.m_6069_() && ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.FEET), (Attribute)ForgeMod.SWIM_SPEED.get(), UNDERWATER_WALK_SPEED_MODIFIER);
            if (ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.HEAD) && living.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) && !living.m_9236_().f_46443_) {
                living.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 5, 0, false, false, false));
            }
            if (living instanceof Player && living.m_20072_() && !living.m_9236_().f_46443_ && living.f_19797_ % 80 == 0) {
                if (ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.HEAD)) {
                    living.m_6844_(EquipmentSlot.HEAD).m_41622_(1, living, entity -> entity.m_21166_(EquipmentSlot.HEAD));
                }
                if (ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.CHEST)) {
                    living.m_6844_(EquipmentSlot.CHEST).m_41622_(1, living, entity -> entity.m_21166_(EquipmentSlot.CHEST));
                }
                if (ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.LEGS)) {
                    living.m_6844_(EquipmentSlot.LEGS).m_41622_(1, living, entity -> entity.m_21166_(EquipmentSlot.LEGS));
                }
                if (ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.FEET)) {
                    living.m_6844_(EquipmentSlot.FEET).m_41622_(1, living, entity -> entity.m_21166_(EquipmentSlot.FEET));
                }
            }
        }
    }

    @SubscribeEvent
    public static void breakSpeed(PlayerEvent.BreakSpeed event) {
        if (ScubaEvents.isWearingScubaOnSlot((LivingEntity)event.getEntity(), EquipmentSlot.CHEST) && event.getEntity().isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) && !event.getEntity().m_21023_(MobEffects.f_19599_)) {
            event.setNewSpeed(event.getOriginalSpeed() + 0.7f);
        }
    }

    public static boolean isWearingScuba(LivingEntity living) {
        return ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.HEAD) || ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.CHEST) || ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.LEGS) || ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.FEET);
    }

    public static boolean isWearingFullScuba(LivingEntity living) {
        return ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.HEAD) && ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.CHEST) && ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.LEGS) && ScubaEvents.isWearingScubaOnSlot(living, EquipmentSlot.FEET);
    }

    public static boolean isWearingScubaOnSlot(LivingEntity living, EquipmentSlot pieceValue) {
        return SCUBA_GEAR.contains(living.m_6844_(pieceValue).m_41720_());
    }

    private static void checkAddAndRemoveModifier(LivingEntity living, boolean condition, Attribute attribute, AttributeModifier modifier) {
        if (condition) {
            if (!living.m_21051_(attribute).m_22109_(modifier)) {
                living.m_21051_(attribute).m_22118_(modifier);
            }
        } else {
            ScubaEvents.removeModifier(living, attribute, modifier);
        }
    }

    private static void removeModifier(LivingEntity living, Attribute attribute, AttributeModifier modifier) {
        if (living.m_21051_(attribute).m_22109_(modifier)) {
            living.m_21051_(attribute).m_22130_(modifier);
        }
    }

    private static boolean isRuinOrWreckNearby(Entity entity) {
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            BlockPos pos = entity.m_20183_();
            if (world.m_215010_().m_220488_(pos, BuiltinStructures.f_209857_).m_73603_() || world.m_215010_().m_220488_(pos, BuiltinStructures.f_209858_).m_73603_()) {
                return true;
            }
            int radius = ScubaConfig.COMMON.getMaxDistanceFromRuin();
            BlockPos min = pos.m_7918_(-radius, -5, -radius);
            BlockPos max = pos.m_7918_(radius, 5, radius);
            for (BlockPos posAround : BlockPos.MutableBlockPos.m_121990_((BlockPos)min, (BlockPos)max).map(BlockPos::m_7949_).collect(Collectors.toList())) {
                if (!world.m_215010_().m_220488_(posAround, BuiltinStructures.f_209857_).m_73603_() && !world.m_215010_().m_220488_(posAround, BuiltinStructures.f_209858_).m_73603_()) continue;
                return true;
            }
        }
        return false;
    }
}

