/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.utils;

import com.hypherionmc.craterlib.core.platform.LoaderType;
import com.hypherionmc.craterlib.core.platform.ModloaderEnvironment;
import com.hypherionmc.craterlib.nojang.resources.ResourceIdentifier;
import com.hypherionmc.craterlib.utils.DiscordMarkdownStripper;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import shadow.hypherionmc.mcdiscordformatter.discord.DiscordSerializer;
import shadow.hypherionmc.mcdiscordformatter.minecraft.MinecraftSerializer;
import shadow.kyori.adventure.text.format.NamedTextColor;
import shadow.kyori.adventure.text.minimessage.MiniMessage;
import shadow.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import shadow.kyori.adventure.text.serializer.json.JSONOptions;

public class ChatUtils {
    private static final GsonComponentSerializer adventureSerializer = ModloaderEnvironment.INSTANCE.getLoaderType() == LoaderType.PAPER ? GsonComponentSerializer.builder().build() : GsonComponentSerializer.builder().options(JSONOptions.byDataVersion().at(SharedConstants.m_183709_().m_183476_().m_193006_())).build();
    private static final MiniMessage miniMessage = MiniMessage.miniMessage();

    public static Component adventureToMojang(shadow.kyori.adventure.text.Component inComponent) {
        String serialised = (String)adventureSerializer.serialize(inComponent);
        return Component.Serializer.m_130701_((String)serialised);
    }

    public static shadow.kyori.adventure.text.Component mojangToAdventure(Component inComponent) {
        try {
            String serialised = Component.Serializer.m_130703_((Component)inComponent);
            return adventureSerializer.deserialize(serialised);
        }
        catch (Exception e) {
            return shadow.kyori.adventure.text.Component.text(inComponent.getString());
        }
    }

    public static Component safeCopy(Component inComponent) {
        String value = inComponent.getString();
        Style style = inComponent.m_7383_();
        return Component.m_237113_((String)value).m_130948_(style);
    }

    public static String strip(String inString, String ... toStrip) {
        String finalString = inString;
        for (String strip : toStrip) {
            if (finalString.startsWith(strip)) {
                finalString = finalString.replaceFirst(strip, "");
            }
            if (!finalString.startsWith(" ")) continue;
            finalString = finalString.replaceFirst(" ", "");
        }
        return finalString;
    }

    public static String resolve(shadow.kyori.adventure.text.Component component, boolean formatted) {
        Component c = ChatUtils.adventureToMojang(component);
        String returnVal = ChatFormatting.m_126649_((String)DiscordMarkdownStripper.stripMarkdown(c.getString()));
        if (formatted) {
            returnVal = DiscordSerializer.INSTANCE.serialize(ChatUtils.safeCopy(c).m_6881_());
        }
        return returnVal;
    }

    public static shadow.kyori.adventure.text.Component resolve(String component, boolean formatted) {
        MutableComponent returnVal = Component.m_237113_((String)component);
        if (formatted) {
            returnVal = MinecraftSerializer.INSTANCE.serialize(component);
        }
        return ChatUtils.mojangToAdventure((Component)returnVal);
    }

    public static shadow.kyori.adventure.text.Component getTooltipTitle(String key) {
        return shadow.kyori.adventure.text.Component.text(NamedTextColor.YELLOW + shadow.kyori.adventure.text.Component.translatable(key).key());
    }

    public static String resolveTranslation(String key) {
        return shadow.kyori.adventure.text.Component.translatable(key).key();
    }

    public static shadow.kyori.adventure.text.Component getTranslation(String key) {
        return shadow.kyori.adventure.text.Component.translatable(key);
    }

    public static shadow.kyori.adventure.text.Component makeComponent(String text) {
        return shadow.kyori.adventure.text.Component.translatable(text);
    }

    public static shadow.kyori.adventure.text.Component getBiomeName(ResourceIdentifier identifier) {
        if (identifier == null) {
            return shadow.kyori.adventure.text.Component.text("Unknown");
        }
        return ChatUtils.mojangToAdventure((Component)Component.m_237115_((String)Util.m_137492_((String)"biome", (ResourceLocation)identifier.toMojang())));
    }

    public static shadow.kyori.adventure.text.Component format(String value) {
        value = ChatUtils.convertFormattingCodes(value);
        try {
            return miniMessage.deserializeOr(value, shadow.kyori.adventure.text.Component.translatable(value));
        }
        catch (Exception exception) {
            return shadow.kyori.adventure.text.Component.translatable(value);
        }
    }

    private static String convertFormattingCodes(String input) {
        return input.replaceAll("\u00a7([0-9a-fklmnor])", "\u00a7$1");
    }

    public static GsonComponentSerializer getAdventureSerializer() {
        return adventureSerializer;
    }
}

