/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.common.light;

import ca.spottedleaf.starlight.common.blockstate.ExtendedAbstractBlockState;
import ca.spottedleaf.starlight.common.chunk.ExtendedChunk;
import ca.spottedleaf.starlight.common.light.SWMRNibbleArray;
import ca.spottedleaf.starlight.common.light.StarLightEngine;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class BlockStarLightEngine
extends StarLightEngine {
    protected final BlockPos.MutableBlockPos recalcCenterPos = new BlockPos.MutableBlockPos();
    protected final BlockPos.MutableBlockPos recalcNeighbourPos = new BlockPos.MutableBlockPos();

    public BlockStarLightEngine(Level world) {
        super(false, world);
    }

    @Override
    protected boolean[] getEmptinessMap(ChunkAccess chunk) {
        return ((ExtendedChunk)chunk).getBlockEmptinessMap();
    }

    @Override
    protected void setEmptinessMap(ChunkAccess chunk, boolean[] to) {
        ((ExtendedChunk)chunk).setBlockEmptinessMap(to);
    }

    @Override
    protected SWMRNibbleArray[] getNibblesOnChunk(ChunkAccess chunk) {
        return ((ExtendedChunk)chunk).getBlockNibbles();
    }

    @Override
    protected void setNibbles(ChunkAccess chunk, SWMRNibbleArray[] to) {
        ((ExtendedChunk)chunk).setBlockNibbles(to);
    }

    @Override
    protected boolean canUseChunk(ChunkAccess chunk) {
        return chunk.m_6415_().m_62427_(ChunkStatus.f_62323_) && (this.isClientSide || chunk.m_6332_());
    }

    @Override
    protected void setNibbleNull(int chunkX, int chunkY, int chunkZ) {
        SWMRNibbleArray nibble = this.getNibbleFromCache(chunkX, chunkY, chunkZ);
        if (nibble != null) {
            nibble.setHidden();
        }
    }

    @Override
    protected void initNibble(int chunkX, int chunkY, int chunkZ, boolean extrude, boolean initRemovedNibbles) {
        if (chunkY < this.minLightSection || chunkY > this.maxLightSection || this.getChunkInCache(chunkX, chunkZ) == null) {
            return;
        }
        SWMRNibbleArray nibble = this.getNibbleFromCache(chunkX, chunkY, chunkZ);
        if (nibble == null) {
            if (!initRemovedNibbles) {
                throw new IllegalStateException();
            }
            this.setNibbleInCache(chunkX, chunkY, chunkZ, new SWMRNibbleArray());
        } else {
            nibble.setNonNull();
        }
    }

    @Override
    protected final void checkBlock(LightChunkGetter lightAccess, int worldX, int worldY, int worldZ) {
        int encodeOffset = this.coordinateOffset;
        int emittedMask = this.emittedLightMask;
        int currentLevel = this.getLightLevel(worldX, worldY, worldZ);
        BlockState blockState = this.getBlockState(worldX, worldY, worldZ);
        this.checkBlockPos.m_122178_(worldX, worldY, worldZ);
        int emittedLevel = blockState.getLightEmission(lightAccess.m_7653_(), (BlockPos)this.checkBlockPos) & emittedMask;
        this.setLightLevel(worldX, worldY, worldZ, emittedLevel);
        if (emittedLevel != 0) {
            this.appendToIncreaseQueue((long)(worldX + (worldZ << 6) + (worldY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)emittedLevel & 0xFL) << 28 | 0x3F00000000L | (((ExtendedAbstractBlockState)blockState).isConditionallyFullOpaque() ? Long.MIN_VALUE : 0L));
        }
        this.appendToDecreaseQueue((long)(worldX + (worldZ << 6) + (worldY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)currentLevel & 0xFL) << 28 | 0x3F00000000L);
    }

    @Override
    protected int calculateLightValue(LightChunkGetter lightAccess, int worldX, int worldY, int worldZ, int expect) {
        Object conditionallyOpaqueState;
        BlockState centerState = this.getBlockState(worldX, worldY, worldZ);
        this.recalcCenterPos.m_122178_(worldX, worldY, worldZ);
        int level = centerState.getLightEmission(lightAccess.m_7653_(), (BlockPos)this.recalcCenterPos) & 0xF;
        if (level >= 14 || level > expect) {
            return level;
        }
        int sectionOffset = this.chunkSectionIndexOffset;
        int opacity = ((ExtendedAbstractBlockState)centerState).getOpacityIfCached();
        if (opacity == -1) {
            opacity = centerState.m_60739_(lightAccess.m_7653_(), (BlockPos)this.recalcCenterPos);
            conditionallyOpaqueState = ((ExtendedAbstractBlockState)centerState).isConditionallyFullOpaque() ? centerState : null;
        } else {
            if (opacity >= 15) {
                return level;
            }
            conditionallyOpaqueState = null;
        }
        opacity = Math.max(1, opacity);
        for (StarLightEngine.AxisDirection direction : AXIS_DIRECTIONS) {
            int calculated;
            int offX = worldX + direction.x;
            int offZ = worldZ + direction.z;
            int offY = worldY + direction.y;
            int sectionIndex = (offX >> 4) + 5 * (offZ >> 4) + 25 * (offY >> 4) + sectionOffset;
            int neighbourLevel = this.getLightLevel(sectionIndex, offX & 0xF | (offZ & 0xF) << 4 | (offY & 0xF) << 8);
            if (neighbourLevel - 1 <= level) continue;
            BlockState neighbourState = this.getBlockState(offX, offY, offZ);
            if (((ExtendedAbstractBlockState)neighbourState).isConditionallyFullOpaque()) {
                VoxelShape thisFace;
                this.recalcNeighbourPos.m_122178_(offX, offY, offZ);
                VoxelShape neighbourFace = neighbourState.m_60655_(lightAccess.m_7653_(), (BlockPos)this.recalcNeighbourPos, direction.opposite.nms);
                VoxelShape voxelShape = thisFace = conditionallyOpaqueState == null ? Shapes.m_83040_() : conditionallyOpaqueState.m_60655_(lightAccess.m_7653_(), (BlockPos)this.recalcCenterPos, direction.nms);
                if (Shapes.m_83145_((VoxelShape)thisFace, (VoxelShape)neighbourFace)) continue;
            }
            if ((level = Math.max(calculated = neighbourLevel - opacity, level)) <= expect) continue;
            return level;
        }
        return level;
    }

    @Override
    protected void propagateBlockChanges(LightChunkGetter lightAccess, ChunkAccess atChunk, Set<BlockPos> positions) {
        for (BlockPos pos : positions) {
            this.checkBlock(lightAccess, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        }
        this.performLightDecrease(lightAccess);
    }

    protected List<BlockPos> getSources(LightChunkGetter lightAccess, ChunkAccess chunk) {
        ArrayList<BlockPos> sources = new ArrayList<BlockPos>();
        int offX = chunk.m_7697_().f_45578_ << 4;
        int offZ = chunk.m_7697_().f_45579_ << 4;
        LevelChunkSection[] sections = chunk.m_7103_();
        for (int sectionY = this.minSection; sectionY <= this.maxSection; ++sectionY) {
            LevelChunkSection section = sections[sectionY - this.minSection];
            if (section == null || section.m_188008_()) continue;
            PalettedContainer states = section.f_62972_;
            int offY = sectionY << 4;
            for (int index = 0; index < 4096; ++index) {
                BlockState state = (BlockState)states.m_63085_(index);
                this.mutablePos1.m_122178_(offX | index & 0xF, offY | index >>> 8, offZ | index >>> 4 & 0xF);
                if (state.getLightEmission(lightAccess.m_7653_(), (BlockPos)this.mutablePos1) <= 0) continue;
                sources.add(new BlockPos(offX | index & 0xF, offY | index >>> 8, offZ | index >>> 4 & 0xF));
            }
        }
        return sources;
    }

    @Override
    public void lightChunk(LightChunkGetter lightAccess, ChunkAccess chunk, boolean needsEdgeChecks) {
        int emittedMask = this.emittedLightMask;
        List<BlockPos> positions = this.getSources(lightAccess, chunk);
        int len = positions.size();
        for (int i = 0; i < len; ++i) {
            BlockPos pos = positions.get(i);
            BlockState blockState = this.getBlockState(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            int emittedLight = blockState.getLightEmission(lightAccess.m_7653_(), pos) & emittedMask;
            if (emittedLight <= this.getLightLevel(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())) continue;
            this.appendToIncreaseQueue((long)(pos.m_123341_() + (pos.m_123343_() << 6) + (pos.m_123342_() << 12) + this.coordinateOffset) & 0xFFFFFFFL | ((long)emittedLight & 0xFL) << 28 | 0x3F00000000L | (((ExtendedAbstractBlockState)blockState).isConditionallyFullOpaque() ? Long.MIN_VALUE : 0L));
            this.setLightLevel(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), emittedLight);
        }
        if (needsEdgeChecks) {
            this.performLightIncrease(lightAccess);
            this.checkChunkEdges(lightAccess, chunk, this.minLightSection, this.maxLightSection);
        } else {
            this.propagateNeighbourLevels(lightAccess, chunk, this.minLightSection, this.maxLightSection);
            this.performLightIncrease(lightAccess);
        }
    }
}

