/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.world.structure.structures;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.connected.ConnectedPillarBlock;
import net.joefoxe.hexerei.world.structure.ModStructures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class DarkCovenStructure
extends Structure {
    public static final Codec<DarkCovenStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DarkCovenStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, DarkCovenStructure::new)).codec();
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    static final Logger LOGGER = LogUtils.getLogger();

    public DarkCovenStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    private boolean canBeReplaced(BlockState currBlock) {
        return currBlock.m_247087_() || currBlock.m_60795_() || currBlock.m_204336_(BlockTags.f_13035_) || currBlock.m_60713_((Block)ModBlocks.WILLOW_FENCE.get()) || currBlock.m_60713_((Block)ModBlocks.WILLOW_SLAB.get()) || currBlock.m_60713_((Block)ModBlocks.WILLOW_STAIRS.get()) || currBlock.m_60713_((Block)ModBlocks.MAHOGANY_SLAB.get()) || currBlock.m_60713_((Block)ModBlocks.MAHOGANY_STAIRS.get()) || currBlock.m_60713_(Blocks.f_50403_) || currBlock.m_60713_(Blocks.f_50373_) || currBlock.m_60713_(Blocks.f_49990_) || currBlock.m_60713_(Blocks.f_49991_);
    }

    public void m_214110_(WorldGenLevel pLevel, StructureManager pStructureManager, ChunkGenerator pChunkGenerator, RandomSource pRandom, BoundingBox pBoundingBox, ChunkPos pChunkPos, PiecesContainer pPieces) {
        super.m_214110_(pLevel, pStructureManager, pChunkGenerator, pRandom, pBoundingBox, pChunkPos, pPieces);
        try {
            for (BlockPos blockPos : BlockPos.m_121976_((int)pBoundingBox.m_162395_(), (int)pBoundingBox.m_162396_(), (int)pBoundingBox.m_162398_(), (int)pBoundingBox.m_162399_(), (int)pBoundingBox.m_162400_(), (int)pBoundingBox.m_162401_())) {
                BlockState currBlock;
                BlockPos.MutableBlockPos mutable;
                if (!pPieces.m_192751_(blockPos) || !pLevel.isAreaLoaded(blockPos, 1) || !pLevel.m_8055_(blockPos).m_60713_(Blocks.f_50307_)) continue;
                if (pLevel instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)pLevel;
                    serverLevel.m_46597_(blockPos, ((ConnectedPillarBlock)((Object)ModBlocks.POLISHED_WITCH_HAZEL_PILLAR.get())).m_49966_());
                    mutable = blockPos.m_7495_().m_122032_();
                    currBlock = pLevel.m_8055_((BlockPos)mutable);
                    while (mutable.m_123342_() > 0 && this.canBeReplaced(currBlock)) {
                        serverLevel.m_46597_((BlockPos)mutable, Blocks.f_50004_.m_49966_());
                        mutable.m_122173_(Direction.DOWN);
                        currBlock = serverLevel.m_8055_((BlockPos)mutable);
                    }
                    continue;
                }
                if (!(pLevel instanceof WorldGenRegion)) continue;
                WorldGenRegion worldGenRegion = (WorldGenRegion)pLevel;
                worldGenRegion.m_7731_(blockPos, ((ConnectedPillarBlock)((Object)ModBlocks.POLISHED_WITCH_HAZEL_PILLAR.get())).m_49966_(), 3);
                mutable = blockPos.m_7495_().m_122032_();
                currBlock = pLevel.m_8055_((BlockPos)mutable);
                while (mutable.m_123342_() > 0 && (currBlock.m_247087_() || currBlock.m_60795_() || currBlock.m_204336_(BlockTags.f_13035_) || currBlock.m_60713_(Blocks.f_49990_) || currBlock.m_60713_(Blocks.f_49991_))) {
                    worldGenRegion.m_7731_((BlockPos)mutable, Blocks.f_50004_.m_49966_(), 3);
                    mutable.m_122173_(Direction.DOWN);
                    currBlock = worldGenRegion.m_8055_((BlockPos)mutable);
                }
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public static Optional<Structure.GenerationStub> addPieces(Structure.GenerationContext pContext, Holder<StructureTemplatePool> pStartPool, Optional<ResourceLocation> pStartJigsawName, int pMaxDepth, BlockPos pPos, boolean pUseExpansionHack, Optional<Heightmap.Types> pProjectStartToHeightmap, int pMaxDistanceFromCenter) {
        BlockPos blockpos;
        RegistryAccess registryaccess = pContext.f_226621_();
        ChunkGenerator chunkgenerator = pContext.f_226622_();
        StructureTemplateManager structuretemplatemanager = pContext.f_226625_();
        LevelHeightAccessor levelheightaccessor = pContext.f_226629_();
        WorldgenRandom worldgenrandom = pContext.f_226626_();
        Registry registry = registryaccess.m_175515_(Registries.f_256948_);
        Rotation rotation = Rotation.m_221990_((RandomSource)worldgenrandom);
        StructureTemplatePool structuretemplatepool = (StructureTemplatePool)pStartPool.m_203334_();
        StructurePoolElement structurepoolelement = structuretemplatepool.m_227355_((RandomSource)worldgenrandom);
        if (structurepoolelement == EmptyPoolElement.f_210175_) {
            return Optional.empty();
        }
        if (pStartJigsawName.isPresent()) {
            ResourceLocation resourcelocation = pStartJigsawName.get();
            Optional<BlockPos> optional = DarkCovenStructure.getRandomNamedJigsaw(structurepoolelement, resourcelocation, pPos, rotation, structuretemplatemanager, worldgenrandom);
            if (optional.isEmpty()) {
                LOGGER.error("No starting jigsaw {} found in start pool {}", (Object)resourcelocation, (Object)pStartPool.m_203543_().map(p_248484_ -> p_248484_.m_135782_().toString()).orElse("<unregistered>"));
                return Optional.empty();
            }
            blockpos = optional.get();
        } else {
            blockpos = pPos;
        }
        BlockPos vec3i = blockpos.m_121996_((Vec3i)pPos);
        BlockPos blockpos1 = pPos.m_121996_((Vec3i)vec3i);
        PoolElementStructurePiece poolelementstructurepiece = new PoolElementStructurePiece(structuretemplatemanager, structurepoolelement, blockpos1, structurepoolelement.m_210540_(), rotation, structurepoolelement.m_214015_(structuretemplatemanager, blockpos1, rotation));
        BoundingBox boundingbox = poolelementstructurepiece.m_73547_();
        int i = (boundingbox.m_162399_() + boundingbox.m_162395_()) / 2;
        int j = (boundingbox.m_162401_() + boundingbox.m_162398_()) / 2;
        int k = pProjectStartToHeightmap.isPresent() ? pPos.m_123342_() + chunkgenerator.m_223221_(i, j, pProjectStartToHeightmap.get(), levelheightaccessor, pContext.f_226624_()) : blockpos1.m_123342_();
        int l = boundingbox.m_162396_() + poolelementstructurepiece.m_72647_();
        poolelementstructurepiece.m_6324_(0, k - l, 0);
        int i1 = k + vec3i.m_123342_();
        Consumer<StructurePiecesBuilder> pGenerator = structurePiecesBuilder -> {
            ArrayList list = Lists.newArrayList();
            list.add(poolelementstructurepiece);
            if (pMaxDepth > 0) {
                AABB aabb = new AABB((double)(i - pMaxDistanceFromCenter), (double)(i1 - pMaxDistanceFromCenter), (double)(j - pMaxDistanceFromCenter), (double)(i + pMaxDistanceFromCenter + 1), (double)(i1 + pMaxDistanceFromCenter + 1), (double)(j + pMaxDistanceFromCenter + 1));
                VoxelShape voxelshape = Shapes.m_83113_((VoxelShape)Shapes.m_83064_((AABB)aabb), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingbox)), (BooleanOp)BooleanOp.f_82685_);
                DarkCovenStructure.addPieces(pContext.f_226624_(), pMaxDepth, pUseExpansionHack, chunkgenerator, structuretemplatemanager, levelheightaccessor, (RandomSource)worldgenrandom, (Registry<StructureTemplatePool>)registry, poolelementstructurepiece, list, voxelshape, pProjectStartToHeightmap.orElse(null));
                list.forEach(arg_0 -> ((StructurePiecesBuilder)structurePiecesBuilder).m_142679_(arg_0));
            }
        };
        return Optional.of(new Structure.GenerationStub(new BlockPos(i, i1, j), pGenerator));
    }

    private static void addPieces(RandomState pRandomState, int pMaxDepth, boolean pUseExpansionHack, ChunkGenerator pChunkGenerator, StructureTemplateManager pStructureTemplateManager, LevelHeightAccessor pLevel, RandomSource pRandom, Registry<StructureTemplatePool> pPools, PoolElementStructurePiece p_227219_, List<PoolElementStructurePiece> pPieces, VoxelShape p_227221_, Heightmap.Types pType) {
        Placer jigsawplacement$placer = new Placer(pPools, pMaxDepth, pChunkGenerator, pStructureTemplateManager, pPieces, pRandom);
        jigsawplacement$placer.placing.addLast(new PieceState(p_227219_, (MutableObject<VoxelShape>)new MutableObject((Object)p_227221_), 0));
        while (!jigsawplacement$placer.placing.isEmpty()) {
            PieceState jigsawplacement$piecestate = jigsawplacement$placer.placing.removeFirst();
            jigsawplacement$placer.tryPlacingChildren(jigsawplacement$piecestate.piece, jigsawplacement$piecestate.free, jigsawplacement$piecestate.depth, pUseExpansionHack, pLevel, pRandomState, pChunkGenerator, pType);
        }
    }

    private static Optional<BlockPos> getRandomNamedJigsaw(StructurePoolElement pElement, ResourceLocation pStartJigsawName, BlockPos pPos, Rotation pRotation, StructureTemplateManager pStructureTemplateManager, WorldgenRandom pRandom) {
        List list = pElement.m_213638_(pStructureTemplateManager, pPos, pRotation, (RandomSource)pRandom);
        Optional<BlockPos> optional = Optional.empty();
        for (StructureTemplate.StructureBlockInfo usingStructureBlockInf : list) {
            ResourceLocation resourcelocation = ResourceLocation.m_135820_((String)usingStructureBlockInf.f_74677_().m_128461_("name"));
            if (!pStartJigsawName.equals((Object)resourcelocation)) continue;
            optional = Optional.of(usingStructureBlockInf.f_74675_());
            break;
        }
        return optional;
    }

    private static boolean extraSpawningChecks(Structure.GenerationContext context) {
        ChunkPos chunkpos = context.f_226628_();
        return context.f_226622_().m_223235_(chunkpos.m_45604_(), chunkpos.m_45605_(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, context.f_226629_(), context.f_226624_()) < 150;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        if (!DarkCovenStructure.extraSpawningChecks(context)) {
            return Optional.empty();
        }
        int startY = this.startHeight.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
        ChunkPos chunkPos = context.f_226628_();
        BlockPos blockPos = new BlockPos(chunkPos.m_45604_(), startY, chunkPos.m_45605_());
        Optional<Structure.GenerationStub> structurePiecesGenerator = DarkCovenStructure.addPieces(context, this.startPool, this.startJigsawName, this.size, blockPos, false, this.projectStartToHeightmap, this.maxDistanceFromCenter);
        return structurePiecesGenerator;
    }

    public StructureType<?> m_213658_() {
        return (StructureType)ModStructures.DARK_COVEN.get();
    }

    static final class Placer {
        private final Registry<StructureTemplatePool> pools;
        private final int maxDepth;
        private final ChunkGenerator chunkGenerator;
        private final StructureTemplateManager structureTemplateManager;
        private final List<? super PoolElementStructurePiece> pieces;
        private final RandomSource random;
        final Deque<PieceState> placing = Queues.newArrayDeque();

        Placer(Registry<StructureTemplatePool> pPools, int pMaxDepth, ChunkGenerator pChunkGenerator, StructureTemplateManager pStructureTemplateManager, List<? super PoolElementStructurePiece> pPieces, RandomSource pRandom) {
            this.pools = pPools;
            this.maxDepth = pMaxDepth;
            this.chunkGenerator = pChunkGenerator;
            this.structureTemplateManager = pStructureTemplateManager;
            this.pieces = pPieces;
            this.random = pRandom;
        }

        void tryPlacingChildren(PoolElementStructurePiece pPiece, MutableObject<VoxelShape> pFree, int pDepth, boolean pUseExpansionHack, LevelHeightAccessor pLevel, RandomState pRandomState, ChunkGenerator chunkGenerator, Heightmap.Types pType) {
            StructurePoolElement structurepoolelement = pPiece.m_209918_();
            BlockPos blockpos = pPiece.m_72646_();
            Rotation rotation = pPiece.m_6830_();
            StructureTemplatePool.Projection structuretemplatepool$projection = structurepoolelement.m_210539_();
            boolean flag = structuretemplatepool$projection == StructureTemplatePool.Projection.RIGID;
            MutableObject<VoxelShape> mutableobject = new MutableObject<VoxelShape>();
            BoundingBox boundingbox = pPiece.m_73547_();
            int i = boundingbox.m_162396_();
            block0: for (StructureTemplate.StructureBlockInfo structuretemplate$structureblockinfo : structurepoolelement.m_213638_(this.structureTemplateManager, blockpos, rotation, this.random)) {
                StructurePoolElement structurepoolelement1;
                MutableObject<VoxelShape> mutableobject1;
                CompoundTag tag;
                Direction direction = JigsawBlock.m_54250_((BlockState)structuretemplate$structureblockinfo.f_74676_());
                BlockPos blockpos1 = structuretemplate$structureblockinfo.f_74675_();
                BlockPos blockpos2 = blockpos1.m_121945_(direction);
                int j = blockpos1.m_123342_() - i;
                int k = -1;
                BlockPos forwards = blockpos1.m_5484_(direction, 15);
                BlockPos left = blockpos1.m_5484_(direction, 10).m_5484_(direction.m_122428_(), 6);
                BlockPos right = blockpos1.m_5484_(direction, 10).m_5484_(direction.m_122427_(), 6);
                StructureTemplate.StructureBlockInfo usingStructureBlockInf = structuretemplate$structureblockinfo;
                int groundLevel = chunkGenerator.m_223221_(blockpos2.m_123341_(), blockpos2.m_123343_(), pType, pLevel, pRandomState);
                int distToGround = blockpos2.m_123342_() - groundLevel;
                boolean stairsFlag = false;
                CompoundTag compoundTag = tag = usingStructureBlockInf.f_74677_() != null ? usingStructureBlockInf.f_74677_().m_6426_() : new CompoundTag();
                if (distToGround < 3 && distToGround > -5 && tag.m_128441_("name") && tag.m_128461_("name").equals("minecraft:street")) {
                    tag.m_128359_("pool", "hexerei:coven/dark_coven/stairs");
                    tag.m_128359_("target", "minecraft:stairs_up");
                    stairsFlag = true;
                } else if (distToGround > 8 && distToGround <= 15 && tag.m_128441_("name") && tag.m_128461_("name").equals("minecraft:street")) {
                    tag.m_128359_("pool", "hexerei:coven/dark_coven/stairs");
                    tag.m_128359_("target", "minecraft:stairs_down");
                    stairsFlag = true;
                } else if (distToGround > 15 && tag.m_128441_("name") && tag.m_128461_("name").equals("minecraft:street")) {
                    int groundLevelRight = chunkGenerator.m_223221_(right.m_123341_(), right.m_123343_(), pType, pLevel, pRandomState);
                    int distToGroundRight = right.m_123342_() - groundLevelRight;
                    int groundLevelLeft = chunkGenerator.m_223221_(left.m_123341_(), left.m_123343_(), pType, pLevel, pRandomState);
                    int distToGroundLeft = left.m_123342_() - groundLevelLeft;
                    int groundLevelForwards = chunkGenerator.m_223221_(forwards.m_123341_(), forwards.m_123343_(), pType, pLevel, pRandomState);
                    int distToGroundForwards = forwards.m_123342_() - groundLevelForwards;
                    if (this.random.m_188501_() > 0.4f) {
                        if (distToGroundForwards < 8) {
                            tag.m_128359_("pool", "hexerei:coven/dark_coven/streets");
                            tag.m_128359_("target", "minecraft:street");
                            tag.m_128359_("name", "minecraft:street");
                        } else if (distToGroundLeft >= distToGroundRight) {
                            tag.m_128359_("pool", "hexerei:coven/dark_coven/stairs");
                            tag.m_128359_("target", "minecraft:stairs_down_turn_right");
                        } else {
                            tag.m_128359_("pool", "hexerei:coven/dark_coven/stairs");
                            tag.m_128359_("target", "minecraft:stairs_down_turn_left");
                        }
                        stairsFlag = true;
                    }
                } else if (tag.m_128441_("name") && tag.m_128461_("name").equals("minecraft:street") && tag.m_128441_("target") && tag.m_128461_("target").equals("minecraft:stairs_up")) {
                    tag.m_128359_("pool", "hexerei:coven/dark_coven/streets");
                    tag.m_128359_("target", "minecraft:street");
                    tag.m_128359_("name", "minecraft:street");
                } else if (tag.m_128441_("name") && tag.m_128461_("name").equals("minecraft:street") && tag.m_128441_("target") && tag.m_128461_("target").equals("minecraft:stairs_down")) {
                    tag.m_128359_("pool", "hexerei:coven/dark_coven/streets");
                    tag.m_128359_("target", "minecraft:street");
                    tag.m_128359_("name", "minecraft:street");
                } else if (tag.m_128441_("name") && tag.m_128461_("name").equals("minecraft:street") && tag.m_128441_("target") && tag.m_128461_("target").equals("minecraft:stairs_down_turn")) {
                    tag.m_128359_("pool", "hexerei:coven/dark_coven/streets");
                    tag.m_128359_("target", "minecraft:street");
                    tag.m_128359_("name", "minecraft:street");
                }
                usingStructureBlockInf = new StructureTemplate.StructureBlockInfo(structuretemplate$structureblockinfo.f_74675_(), structuretemplate$structureblockinfo.f_74676_(), tag);
                ResourceKey<StructureTemplatePool> resourcekey = Placer.readPoolName(usingStructureBlockInf);
                Optional optional = this.pools.m_203636_(resourcekey);
                if (optional.isEmpty()) {
                    LOGGER.warn("Empty or non-existent pool: {}", (Object)resourcekey.m_135782_());
                    continue;
                }
                Holder holder = (Holder)optional.get();
                if (((StructureTemplatePool)holder.m_203334_()).m_210590_() == 0 && !holder.m_203565_(Pools.f_127186_)) {
                    LOGGER.warn("Empty or non-existent pool: {}", (Object)resourcekey.m_135782_());
                    continue;
                }
                Holder holder1 = ((StructureTemplatePool)holder.m_203334_()).m_254935_();
                if (((StructureTemplatePool)holder1.m_203334_()).m_210590_() == 0 && !holder1.m_203565_(Pools.f_127186_)) {
                    LOGGER.warn("Empty or non-existent fallback pool: {}", (Object)holder1.m_203543_().map(p_255599_ -> p_255599_.m_135782_().toString()).orElse("<unregistered>"));
                    continue;
                }
                boolean flag1 = boundingbox.m_71051_((Vec3i)blockpos2);
                if (flag1) {
                    mutableobject1 = mutableobject;
                    if (mutableobject.getValue() == null) {
                        mutableobject.setValue((Object)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingbox)));
                    }
                } else {
                    mutableobject1 = pFree;
                }
                ArrayList list = Lists.newArrayList();
                if (pDepth != this.maxDepth) {
                    list.addAll(((StructureTemplatePool)holder.m_203334_()).m_227362_(this.random));
                }
                list.addAll(((StructureTemplatePool)holder1.m_203334_()).m_227362_(this.random));
                Iterator iterator = list.iterator();
                while (iterator.hasNext() && (structurepoolelement1 = (StructurePoolElement)iterator.next()) != EmptyPoolElement.f_210175_) {
                    for (Rotation rotation1 : Rotation.m_221992_((RandomSource)this.random)) {
                        List list1 = structurepoolelement1.m_213638_(this.structureTemplateManager, BlockPos.f_121853_, rotation1, this.random);
                        BoundingBox boundingbox1 = structurepoolelement1.m_214015_(this.structureTemplateManager, BlockPos.f_121853_, rotation1);
                        int l = pUseExpansionHack && boundingbox1.m_71057_() <= 16 ? list1.stream().mapToInt(p_255598_ -> {
                            if (!boundingbox1.m_71051_((Vec3i)p_255598_.f_74675_().m_121945_(JigsawBlock.m_54250_((BlockState)p_255598_.f_74676_())))) {
                                return 0;
                            }
                            ResourceKey<StructureTemplatePool> resourcekey1 = Placer.readPoolName(p_255598_);
                            Optional optional1 = this.pools.m_203636_(resourcekey1);
                            Optional<Holder> optional2 = optional1.map(p_255600_ -> ((StructureTemplatePool)p_255600_.m_203334_()).m_254935_());
                            int j3 = optional1.map(p_255596_ -> ((StructureTemplatePool)p_255596_.m_203334_()).m_227357_(this.structureTemplateManager)).orElse(0);
                            int k3 = optional2.map(p_255601_ -> ((StructureTemplatePool)p_255601_.m_203334_()).m_227357_(this.structureTemplateManager)).orElse(0);
                            return Math.max(j3, k3);
                        }).max().orElse(0) : 0;
                        ArrayList<StructureTemplate.StructureBlockInfo> list2 = new ArrayList<StructureTemplate.StructureBlockInfo>();
                        for (StructureTemplate.StructureBlockInfo usingStructureBlockInf1 : list1) {
                            CompoundTag tag2 = usingStructureBlockInf1.f_74677_();
                            if (stairsFlag && tag2 != null && tag2.m_128441_("name") && tag2.m_128461_("name").equals("minecraft:stairs_street")) {
                                tag2.m_128359_("pool", "hexerei:coven/dark_coven/streets");
                                tag2.m_128359_("target", "minecraft:street");
                                tag2.m_128359_("name", "minecraft:street");
                            }
                            list2.add(new StructureTemplate.StructureBlockInfo(usingStructureBlockInf1.f_74675_(), usingStructureBlockInf1.f_74676_(), tag2));
                        }
                        for (StructureTemplate.StructureBlockInfo usingStructureBlockInf1 : list2) {
                            int l2;
                            int l1;
                            if (!JigsawBlock.m_54245_((StructureTemplate.StructureBlockInfo)usingStructureBlockInf, (StructureTemplate.StructureBlockInfo)usingStructureBlockInf1)) continue;
                            BlockPos blockpos3 = usingStructureBlockInf1.f_74675_();
                            BlockPos blockpos4 = blockpos2.m_121996_((Vec3i)blockpos3);
                            BoundingBox boundingbox2 = structurepoolelement1.m_214015_(this.structureTemplateManager, blockpos4, rotation1);
                            int i1 = boundingbox2.m_162396_();
                            StructureTemplatePool.Projection structuretemplatepool$projection1 = structurepoolelement1.m_210539_();
                            boolean flag2 = structuretemplatepool$projection1 == StructureTemplatePool.Projection.RIGID;
                            int j1 = blockpos3.m_123342_();
                            int k1 = j - j1 + JigsawBlock.m_54250_((BlockState)usingStructureBlockInf.f_74676_()).m_122430_();
                            if (flag && flag2) {
                                l1 = i + k1;
                            } else {
                                if (k == -1) {
                                    k = this.chunkGenerator.m_223221_(blockpos1.m_123341_(), blockpos1.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, pLevel, pRandomState);
                                }
                                l1 = k - j1;
                            }
                            int i2 = l1 - i1;
                            BoundingBox boundingbox3 = boundingbox2.m_71045_(0, i2, 0);
                            BlockPos blockpos5 = blockpos4.m_7918_(0, i2, 0);
                            if (l > 0) {
                                int j2 = Math.max(l + 1, boundingbox3.m_162400_() - boundingbox3.m_162396_());
                                boundingbox3.m_162371_(new BlockPos(boundingbox3.m_162395_(), boundingbox3.m_162396_() + j2, boundingbox3.m_162398_()));
                            }
                            if (Shapes.m_83157_((VoxelShape)((VoxelShape)mutableobject1.getValue()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingbox3).m_82406_(0.25)), (BooleanOp)BooleanOp.f_82683_)) continue;
                            mutableobject1.setValue((Object)Shapes.m_83148_((VoxelShape)((VoxelShape)mutableobject1.getValue()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingbox3)), (BooleanOp)BooleanOp.f_82685_));
                            int i3 = pPiece.m_72647_();
                            int k2 = flag2 ? i3 - k1 : structurepoolelement1.m_210540_();
                            PoolElementStructurePiece poolelementstructurepiece = new PoolElementStructurePiece(this.structureTemplateManager, structurepoolelement1, blockpos5, k2, rotation1, boundingbox3);
                            if (flag) {
                                l2 = i + j;
                            } else if (flag2) {
                                l2 = l1 + j1;
                            } else {
                                if (k == -1) {
                                    k = this.chunkGenerator.m_223221_(blockpos1.m_123341_(), blockpos1.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, pLevel, pRandomState);
                                }
                                l2 = k + k1 / 2;
                            }
                            pPiece.m_209916_(new JigsawJunction(blockpos2.m_123341_(), l2 - j + i3, blockpos2.m_123343_(), k1, structuretemplatepool$projection1));
                            poolelementstructurepiece.m_209916_(new JigsawJunction(blockpos1.m_123341_(), l2 - j1 + k2, blockpos1.m_123343_(), -k1, structuretemplatepool$projection));
                            this.pieces.add((PoolElementStructurePiece)poolelementstructurepiece);
                            if (pDepth + 1 > this.maxDepth) continue block0;
                            this.placing.addLast(new PieceState(poolelementstructurepiece, mutableobject1, pDepth + 1));
                            continue block0;
                        }
                    }
                }
            }
        }

        private static ResourceKey<StructureTemplatePool> readPoolName(StructureTemplate.StructureBlockInfo pStructureBlockInfo) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)new ResourceLocation(pStructureBlockInfo.f_74677_().m_128461_("pool")));
        }
    }

    static final class PieceState {
        final PoolElementStructurePiece piece;
        final MutableObject<VoxelShape> free;
        final int depth;

        PieceState(PoolElementStructurePiece pPiece, MutableObject<VoxelShape> pFree, int pDepth) {
            this.piece = pPiece;
            this.free = pFree;
            this.depth = pDepth;
        }
    }
}

