/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.particle.ModParticleTypes;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.joefoxe.hexerei.util.TreeCutter;
import net.joefoxe.hexerei.util.message.TESyncPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;

public class CuttingCrystalTile
extends BlockEntity {
    public List<BlockPos> boundPos = new ArrayList<BlockPos>();
    public boolean isParent;
    public static final AtomicInteger NEXT_BREAKER_ID = new AtomicInteger();
    protected int ticksUntilNextProgress;
    protected float destroyProgress;
    protected int breakerId = -NEXT_BREAKER_ID.incrementAndGet();
    protected BlockPos breakingPos;

    public CuttingCrystalTile(BlockEntityType<?> tileEntityTypeIn, BlockPos blockPos, BlockState blockState) {
        super(tileEntityTypeIn, blockPos, blockState);
    }

    public void cutTree(Level level, BlockPos breakingPos) {
        TreeCutter.findTree((BlockGetter)level, breakingPos).destroyBlocks(level, null, this::dropItemFromCutTree);
    }

    public void dropItemFromCutTree(BlockPos pos, ItemStack stack) {
        float distance = (float)Math.sqrt(pos.m_123331_((Vec3i)this.breakingPos));
        Vec3 dropPos = new Vec3((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f));
        ItemEntity entity = new ItemEntity(this.f_58857_, dropPos.f_82479_, dropPos.f_82480_, dropPos.f_82481_, stack);
        this.f_58857_.m_7967_((Entity)entity);
    }

    protected boolean shouldRun() {
        if (this.isParent) {
            return true;
        }
        return !this.boundPos.isEmpty() && this.boundPos.get(0) != null;
    }

    protected BlockPos getBreakingPos() {
        return this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_));
    }

    public void destroyNextTick() {
        this.ticksUntilNextProgress = 1;
    }

    private boolean posEquals(BlockPos pos, BlockPos pos2) {
        return pos.m_123341_() == pos2.m_123341_() && pos.m_123342_() == pos2.m_123342_() && pos.m_123343_() == pos2.m_123343_();
    }

    public void tick() {
        float blockHardness;
        if (this.shouldRun() && this.ticksUntilNextProgress < 0) {
            this.destroyNextTick();
        }
        if (!this.shouldRun()) {
            return;
        }
        BlockPos lastPos = this.breakingPos;
        this.breakingPos = null;
        if (this.ticksUntilNextProgress < 0) {
            return;
        }
        if (this.ticksUntilNextProgress-- > 0) {
            return;
        }
        BlockPos thisPos = this.m_58899_();
        for (BlockPos pos : this.boundPos) {
            if (this.posEquals(thisPos, pos)) continue;
            Vec3 vec3_1 = HexereiUtil.getCenterOf((Vec3i)thisPos);
            Vec3 vec3_2 = HexereiUtil.getCenterOf((Vec3i)pos);
            Vec3 vec3_3 = vec3_2.m_82546_(vec3_1).m_82541_();
            Vec3 vec3_4 = vec3_1.m_82546_(vec3_2).m_82541_();
            BlockHitResult result = this.f_58857_.m_45547_(new ClipContext(vec3_1.m_82549_(vec3_3), HexereiUtil.getCenterOf((Vec3i)pos).m_82546_(vec3_4), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, null));
            if (result.m_6662_() == HitResult.Type.BLOCK && !this.posEquals(result.m_82425_(), pos) && !this.posEquals(result.m_82425_(), thisPos)) {
                this.breakingPos = result.m_82425_();
                this.f_58857_.m_7106_((ParticleOptions)ModParticleTypes.EXTINGUISH.get(), (double)((float)thisPos.m_123341_() + 0.5f), (double)((float)thisPos.m_123342_() + 0.5f), (double)((float)thisPos.m_123343_() + 0.5f), (double)((float)(pos.m_123341_() - thisPos.m_123341_()) / 50.0f), (double)((float)(pos.m_123342_() - thisPos.m_123342_()) / 50.0f), (double)((float)(pos.m_123343_() - thisPos.m_123343_()) / 50.0f));
            }
            if (this.posEquals(pos, thisPos)) continue;
            this.f_58857_.m_7106_((ParticleOptions)ModParticleTypes.EXTINGUISH.get(), (double)((float)thisPos.m_123341_() + 0.5f), (double)((float)thisPos.m_123342_() + 0.5f), (double)((float)thisPos.m_123343_() + 0.5f), (double)((float)(pos.m_123341_() - thisPos.m_123341_()) / 50.0f), (double)((float)(pos.m_123342_() - thisPos.m_123342_()) / 50.0f), (double)((float)(pos.m_123343_() - thisPos.m_123343_()) / 50.0f));
        }
        if (this.breakingPos == null) {
            this.destroyProgress = 0.0f;
            return;
        }
        BlockState stateToBreak = this.f_58857_.m_8055_(this.breakingPos);
        if (!this.canBreak(stateToBreak, blockHardness = stateToBreak.m_60800_((BlockGetter)this.f_58857_, this.breakingPos))) {
            if (this.destroyProgress != 0.0f) {
                this.destroyProgress = 0.0f;
                if (!this.f_58857_.f_46443_) {
                    this.f_58857_.m_6801_(this.breakerId, this.breakingPos, -1);
                }
            }
            return;
        }
        float breakSpeed = this.getBreakSpeed();
        this.destroyProgress += Mth.m_14036_((float)(breakSpeed / blockHardness), (float)0.0f, (float)(10.0f - this.destroyProgress));
        if (!this.f_58857_.f_46443_) {
            this.f_58857_.m_5594_(null, this.f_58858_, stateToBreak.m_60827_().m_56778_(), SoundSource.NEUTRAL, 0.25f, 1.0f);
        }
        if (this.destroyProgress >= 10.0f) {
            if (!this.f_58857_.f_46443_) {
                this.onBlockBroken(stateToBreak);
            }
            this.destroyProgress = 0.0f;
            this.ticksUntilNextProgress = -1;
            if (!this.f_58857_.f_46443_) {
                this.f_58857_.m_6801_(this.breakerId, this.breakingPos, -1);
            }
            return;
        }
        this.ticksUntilNextProgress = (int)(blockHardness / breakSpeed);
        if (!this.f_58857_.f_46443_) {
            this.f_58857_.m_6801_(this.breakerId, this.breakingPos, (int)this.destroyProgress);
        }
    }

    public boolean canBreak(BlockState stateToBreak, float blockHardness) {
        return CuttingCrystalTile.isBreakable(stateToBreak, blockHardness);
    }

    public static boolean isBreakable(BlockState stateToBreak, float blockHardness) {
        return !(stateToBreak.m_60734_() instanceof AirBlock) && blockHardness != -1.0f && (stateToBreak.m_204336_(BlockTags.f_13106_) || stateToBreak.m_204336_(BlockTags.f_13035_));
    }

    public void onBlockBroken(BlockState stateToBreak) {
        BlockPos pos = this.m_58899_();
        Vec3 vec = HexereiUtil.offsetRandomly(HexereiUtil.getCenterOf((Vec3i)this.breakingPos), this.f_58857_.f_46441_, 0.125f);
        HexereiUtil.destroyBlock(this.f_58857_, this.breakingPos, 1.0f, stack -> {
            if (stack.m_41619_()) {
                return;
            }
            if (!this.f_58857_.m_46469_().m_46207_(GameRules.f_46136_)) {
                return;
            }
            if (this.f_58857_.restoringBlockSnapshots) {
                return;
            }
            ItemEntity itementity = new ItemEntity(this.f_58857_, vec.f_82479_, vec.f_82480_, vec.f_82481_, stack);
            itementity.m_32060_();
            itementity.m_20256_(Vec3.f_82478_);
            this.f_58857_.m_7967_((Entity)itementity);
        });
        if (stateToBreak.m_204336_(BlockTags.f_13106_)) {
            TreeCutter.findTree((BlockGetter)this.f_58857_, this.breakingPos).destroyBlocks(this.f_58857_, null, this::dropItemFromCutTree);
        }
    }

    protected float getBreakSpeed() {
        return Math.abs(1.0f);
    }

    public void m_6596_() {
        super.m_6596_();
    }

    public void sync() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            if (!this.f_58857_.f_46443_) {
                HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new TESyncPacket(this.f_58858_, this.save(new CompoundTag())));
            }
            if (this.f_58857_ != null) {
                this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 2);
            }
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        return super.getCapability(cap);
    }

    public CuttingCrystalTile(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)ModTileEntities.CUTTING_CRYSTAL_TILE.get(), blockPos, blockState);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("boundPos")) {
            int size = pTag.m_128451_("size");
            ArrayList<BlockPos> newList = new ArrayList<BlockPos>();
            CompoundTag boundList = pTag.m_128469_("boundPos");
            for (int i = 0; i < size; ++i) {
                newList.add(NbtUtils.m_129239_((CompoundTag)boundList.m_128469_("boundPos" + i)));
            }
            this.boundPos = newList;
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        int size = this.boundPos.size();
        compound.m_128405_("size", size);
        CompoundTag boundList = new CompoundTag();
        for (int i = 0; i < size; ++i) {
            boundList.m_128365_("boundPos" + i, (Tag)NbtUtils.m_129224_((BlockPos)this.boundPos.get(i)));
        }
        if (!boundList.m_128456_()) {
            compound.m_128365_("boundPos", (Tag)boundList);
        }
    }

    public CompoundTag save(CompoundTag compound) {
        super.m_183515_(compound);
        int size = this.boundPos.size();
        compound.m_128405_("size", size);
        CompoundTag boundList = new CompoundTag();
        for (int i = 0; i < size; ++i) {
            boundList.m_128365_("boundPos" + i, (Tag)NbtUtils.m_129224_((BlockPos)this.boundPos.get(i)));
        }
        if (!boundList.m_128456_()) {
            compound.m_128365_("boundPos", (Tag)boundList);
        }
        return compound;
    }

    public CompoundTag m_5995_() {
        return this.save(new CompoundTag());
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, tag -> this.m_5995_());
    }

    public static double getDistanceToEntity(Entity entity, BlockPos pos) {
        double deltaX = entity.m_20182_().m_7096_() - (double)pos.m_123341_() - 0.5;
        double deltaY = entity.m_20182_().m_7098_() - (double)pos.m_123342_() - 0.5;
        double deltaZ = entity.m_20182_().m_7094_() - (double)pos.m_123343_() - 0.5;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public static double getDistance(float x1, float y1, float x2, float y2) {
        double deltaX = x2 - x1;
        double deltaY = y2 - y1;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY);
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82377_(5.0, 5.0, 5.0);
    }

    public float getAngle(Vec3 pos) {
        float angle = (float)Math.toDegrees(Math.atan2(pos.m_7094_() - (double)this.m_58899_().m_123343_() - 0.5, pos.m_7096_() - (double)this.m_58899_().m_123341_() - 0.5));
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public Vec3 rotateAroundVec(Vec3 vector3dCenter, float rotation, Vec3 vector3d) {
        Vec3 newVec = vector3d.m_82546_(vector3dCenter);
        newVec = newVec.m_82524_(rotation / 180.0f * (float)Math.PI);
        newVec = newVec.m_82549_(vector3dCenter);
        return newVec;
    }
}

