/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.item.custom;

import java.util.List;
import net.joefoxe.hexerei.container.PackageContainer;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CourierPackageItem
extends BlockItem {
    public CourierPackageItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public InteractionResult m_40576_(BlockPlaceContext context) {
        return super.m_40576_(context);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        if (this.isSealed(pContext.m_43722_())) {
            return super.m_6225_(pContext);
        }
        if (!pContext.m_7078_() && pContext.m_43723_() != null && !pContext.m_43725_().f_46443_) {
            this.openMenu(pContext.m_43723_(), pContext.m_43724_(), pContext.m_43722_());
        }
        return pContext.m_7078_() ? super.m_6225_(pContext) : InteractionResult.CONSUME;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        if (!level.f_46443_) {
            this.openMenu(playerIn, handIn, itemstack);
        }
        return itemstack.m_41613_() == 1 ? (this.isSealed(itemstack) ? InteractionResultHolder.m_19100_((Object)itemstack) : InteractionResultHolder.m_19096_((Object)itemstack)) : InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public void m_7373_(ItemStack stack, @javax.annotation.Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, world, tooltip, flagIn);
        PackageInvWrapper wrapper = new PackageInvWrapper(stack);
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237110_((String)"<%s>", (Object[])new Object[]{Component.m_237115_((String)"tooltip.hexerei.shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAA6600)))}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            if (wrapper.isEmpty()) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.courier_package_use").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.courier_package_menu").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.courier_package_send").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.courier_package_must_be_sealed").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            } else if (wrapper.getSealed()) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.courier_package_send").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.courier_package_open").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.courier_package_must_be_sealed").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            }
        } else {
            tooltip.add((Component)Component.m_237110_((String)"[%s]", (Object[])new Object[]{Component.m_237115_((String)"tooltip.hexerei.shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAAAA00)))}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
        }
    }

    private boolean openMenu(Player player, InteractionHand hand, ItemStack stack) {
        if (!player.m_20161_() && stack.m_41613_() == 1) {
            CompoundTag tag = BlockItem.m_186336_((ItemStack)stack);
            if (!this.isSealed(stack)) {
                MenuProvider containerProvider = this.createContainerProvider(stack, hand, stack.m_41783_());
                int slotIndex = hand == InteractionHand.OFF_HAND ? -1 : player.m_150109_().f_35977_;
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerProvider, b -> b.writeByte(hand == InteractionHand.MAIN_HAND ? 0 : 1).writeByte(slotIndex));
                return true;
            }
        }
        return false;
    }

    private boolean isSealed(ItemStack stack) {
        CompoundTag tag = BlockItem.m_186336_((ItemStack)stack);
        return tag != null && tag.m_128441_("Sealed") && tag.m_128471_("Sealed");
    }

    private MenuProvider createContainerProvider(final ItemStack itemStack, final InteractionHand hand, CompoundTag list) {
        return new MenuProvider(){

            @javax.annotation.Nullable
            public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
                return new PackageContainer(i, itemStack, playerInventory, hand, hand == InteractionHand.OFF_HAND ? -1 : playerEntity.m_150109_().f_35977_);
            }

            public Component m_5446_() {
                return Component.m_237115_((String)"screen.hexerei.package");
            }
        };
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new PackageInvWrapper(stack);
    }

    public static class PackageInvWrapper
    implements IItemHandlerModifiable,
    ICapabilityProvider {
        private final ItemStack stack;
        private final LazyOptional<IItemHandler> holder = LazyOptional.of(() -> this);
        private CompoundTag cachedTag;
        private NonNullList<ItemStack> itemStacksCache;
        private boolean sealed;

        public PackageInvWrapper(ItemStack stack) {
            this.stack = stack;
            this.sealed = this.getSealed();
        }

        public int getSlots() {
            return 5;
        }

        public boolean isEmpty() {
            NonNullList<ItemStack> list = this.getItemList();
            for (ItemStack stack1 : list) {
                if (stack1.m_41619_()) continue;
                return false;
            }
            return true;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            if (!this.validateSlotIndex(slot)) {
                return ItemStack.f_41583_;
            }
            return (ItemStack)this.getItemList().get(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            boolean reachedLimit;
            if (stack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            this.validateSlotIndex(slot);
            NonNullList<ItemStack> itemStacks = this.getItemList();
            ItemStack existing = (ItemStack)itemStacks.get(slot);
            int limit = Math.min(this.getSlotLimit(slot), stack.m_41741_());
            if (!existing.m_41619_()) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                    return stack;
                }
                limit -= existing.m_41613_();
            }
            if (limit <= 0) {
                return stack;
            }
            boolean bl = reachedLimit = stack.m_41613_() > limit;
            if (!simulate) {
                if (existing.m_41619_()) {
                    itemStacks.set(slot, (Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack));
                } else {
                    existing.m_41769_(reachedLimit ? limit : stack.m_41613_());
                }
                this.setItemList(itemStacks);
            }
            return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - limit)) : ItemStack.f_41583_;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            NonNullList<ItemStack> itemStacks = this.getItemList();
            if (amount == 0) {
                return ItemStack.f_41583_;
            }
            this.validateSlotIndex(slot);
            ItemStack existing = (ItemStack)itemStacks.get(slot);
            if (existing.m_41619_()) {
                return ItemStack.f_41583_;
            }
            int toExtract = Math.min(amount, existing.m_41741_());
            if (existing.m_41613_() <= toExtract) {
                if (!simulate) {
                    itemStacks.set(slot, (Object)ItemStack.f_41583_);
                    this.setItemList(itemStacks);
                    return existing;
                }
                return existing.m_41777_();
            }
            if (!simulate) {
                itemStacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.m_41613_() - toExtract)));
                this.setItemList(itemStacks);
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
        }

        private boolean validateSlotIndex(int slot) {
            if (slot < 0 || slot >= this.getSlots()) {
                System.out.println("invalid slot - " + slot);
                return false;
            }
            return true;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            PackageInvWrapper wrapper;
            if (stack.m_41720_() instanceof CourierPackageItem && !(wrapper = new PackageInvWrapper(stack)).isEmpty()) {
                return false;
            }
            return stack.m_41720_().m_142095_();
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            this.validateSlotIndex(slot);
            if (!this.isItemValid(slot, stack)) {
                throw new RuntimeException("Invalid stack " + stack + " for slot " + slot + ")");
            }
            NonNullList<ItemStack> itemStacks = this.getItemList();
            itemStacks.set(slot, (Object)stack);
            this.setItemList(itemStacks);
        }

        private NonNullList<ItemStack> getItemList() {
            CompoundTag rootTag = BlockItem.m_186336_((ItemStack)this.stack);
            if (this.cachedTag == null || !this.cachedTag.equals((Object)rootTag)) {
                this.itemStacksCache = this.refreshItemList(rootTag);
            }
            return this.itemStacksCache;
        }

        private NonNullList<ItemStack> refreshItemList(CompoundTag rootTag) {
            NonNullList itemStacks = NonNullList.m_122780_((int)this.getSlots(), (Object)ItemStack.f_41583_);
            if (rootTag != null && rootTag.m_128425_("Items", 9)) {
                ContainerHelper.m_18980_((CompoundTag)rootTag, (NonNullList)itemStacks);
            }
            this.cachedTag = rootTag;
            return itemStacks;
        }

        private void setItemList(NonNullList<ItemStack> itemStacks) {
            boolean isEmpty = true;
            for (ItemStack itemStack : itemStacks) {
                if (itemStack.m_41619_()) continue;
                isEmpty = false;
            }
            CompoundTag existing = BlockItem.m_186336_((ItemStack)this.stack);
            CompoundTag rootTag = ContainerHelper.m_18973_((CompoundTag)(existing == null ? new CompoundTag() : existing), itemStacks);
            if (!isEmpty) {
                BlockItem.m_186338_((ItemStack)this.stack, (BlockEntityType)((BlockEntityType)ModTileEntities.COURIER_PACKAGE_TILE.get()), (CompoundTag)rootTag);
                this.cachedTag = rootTag;
            } else {
                this.stack.m_41749_("BlockEntityTag");
                this.cachedTag = null;
            }
        }

        public void setSealed(int sealed) {
            this.sealed = sealed == 1;
            CompoundTag existing = BlockItem.m_186336_((ItemStack)this.stack);
            if (existing != null) {
                if (this.isEmpty()) {
                    this.sealed = false;
                    existing.m_128379_("Sealed", false);
                    return;
                }
                existing.m_128379_("Sealed", this.sealed);
                this.cachedTag = existing;
            } else {
                this.sealed = false;
            }
        }

        public boolean getSealed() {
            CompoundTag existing = BlockItem.m_186336_((ItemStack)this.stack);
            if (existing != null) {
                return existing.m_128471_("Sealed");
            }
            this.sealed = false;
            return false;
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, this.holder);
        }
    }
}

