/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.integration.jei;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.MixingCauldron;
import net.joefoxe.hexerei.integration.jei.BloodSigilRecipeJEI;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.tileentity.renderer.MixingCauldronRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class BloodSigilRecipeCategory
implements IRecipeCategory<BloodSigilRecipeJEI> {
    public static final ResourceLocation UID = new ResourceLocation("hexerei", "blood_sigil");
    public static final ResourceLocation TEXTURE = new ResourceLocation("hexerei", "textures/gui/blood_sigil_gui_jei.png");
    private IDrawable background;
    private final IDrawable icon;
    private final IDrawable cauldronFG;

    public BloodSigilRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 126, 59);
        this.icon = helper.createDrawableItemStack(new ItemStack((ItemLike)ModItems.BLOOD_SIGIL.get()));
        this.cauldronFG = helper.createDrawable(TEXTURE, 232, 48, 24, 16);
    }

    public List<Component> getTooltipStrings(BloodSigilRecipeJEI recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (this.isHovering(mouseX, mouseY, 33.0, 25.0, 24.0, 15.0)) {
            ArrayList<Component> tooltip = new ArrayList<Component>();
            tooltip.add((Component)Component.m_237115_((String)"gui.jei.category.blood_sigil_tooltip1"));
            return tooltip;
        }
        if (this.isHovering(mouseX, mouseY, 58.0, 18.0, 24.0, 21.0)) {
            ArrayList<Component> tooltip = new ArrayList<Component>();
            tooltip.add((Component)Component.m_237115_((String)"gui.jei.category.blood_sigil_tooltip2"));
            return tooltip;
        }
        return super.getTooltipStrings((Object)recipe, recipeSlotsView, mouseX, mouseY);
    }

    public boolean isHovering(double mouseX, double mouseY, double x, double y, double width, double height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public RecipeType<BloodSigilRecipeJEI> getRecipeType() {
        return new RecipeType(UID, BloodSigilRecipeJEI.class);
    }

    public Component getTitle() {
        return Component.m_237115_((String)"gui.jei.category.blood_sigil");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, final BloodSigilRecipeJEI recipe, IFocusGroup focuses) {
        builder.moveRecipeTransferButton(160, 90);
        builder.addSlot(RecipeIngredientRole.INPUT, 14, 24).addItemStack(recipe.getInput());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 96, 24).setFluidRenderer(500L, false, 16, 16).addFluidStack(recipe.getOutputFluid().getFluid(), 250L, recipe.getOutputFluid().hasTag() ? recipe.getOutputFluid().getTag() : new CompoundTag())).setOverlay(new IDrawable(){

            public int getWidth() {
                return 16;
            }

            public int getHeight() {
                return 16;
            }

            public void draw(GuiGraphics guiGraphics, int xOffset, int yOffset) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_((float)xOffset, (float)yOffset, 0.0f);
                double val = Math.sin(Hexerei.getClientTicks() / 5.0f);
                if (Minecraft.m_91087_().f_91074_ != null) {
                    BloodSigilRecipeCategory.renderEntityInInventoryFollowsAngle(guiGraphics, 9.0, Math.min(val, 0.25) * 10.0 + 10.0, 9.0, 16, (float)Math.toRadians(-20.0), (float)Math.toRadians(-30.0), (LivingEntity)Minecraft.m_91087_().f_91074_);
                }
                guiGraphics.m_280168_().m_85849_();
                Lighting.m_84931_();
                RenderSystem.enableDepthTest();
                MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_((float)xOffset, (float)yOffset, 0.0f);
                guiGraphics.m_280168_().m_252931_(new Matrix4f().scale(1.0f, -1.0f, 1.0f));
                guiGraphics.m_280168_().m_252880_(-3.0f, -15.0f, 0.0f);
                guiGraphics.m_280168_().m_85841_(17.0f, 17.0f, 17.0f);
                guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(0.0f));
                guiGraphics.m_280168_().m_252781_(Axis.f_252529_.m_252977_(20.0f));
                guiGraphics.m_280168_().m_252781_(Axis.f_252436_.m_252977_(30.0f));
                BlockState blockState = (BlockState)((MixingCauldron)ModBlocks.MIXING_CAULDRON.get()).m_49966_().m_61124_((Property)MixingCauldron.GUI_RENDER, (Comparable)Boolean.valueOf(true));
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                BloodSigilRecipeCategory.this.renderBlock(guiGraphics.m_280168_(), (MultiBufferSource)buffer, 0xF000F0, blockState, -12566464);
                MixingCauldronRenderer.renderFluidGUI(guiGraphics.m_280168_(), (MultiBufferSource)buffer, recipe.getOutputFluid(), 1.0f, 1.0f, OverlayTexture.f_118083_);
                guiGraphics.m_280168_().m_85849_();
                BloodSigilRecipeCategory.this.cauldronFG.draw(guiGraphics, -4, 0);
            }
        }, -34, 0);
    }

    public void draw(BloodSigilRecipeJEI recipe, IRecipeSlotsView view, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        Component outputName = recipe.getOutputFluid().getDisplayName();
        int width = minecraft.f_91062_.m_92852_((FormattedText)outputName);
        Objects.requireNonNull(minecraft.f_91062_);
        float lineHeight = 9.0f / 2.0f;
        if (width > 80) {
            float percent = (float)width / 80.0f;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85841_(1.0f / percent, 1.0f / percent, 1.0f / percent);
            minecraft.f_91062_.m_272077_(outputName, 7.0f * percent, (5.0f + lineHeight) * percent - 4.5f, -12566464, false, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            guiGraphics.m_280168_().m_85849_();
        } else {
            minecraft.f_91062_.m_272077_(outputName, 7.0f, 5.0f + lineHeight - 4.5f, -12566464, false, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderBlock(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, BlockState state, int color) {
        this.renderSingleBlock(state, matrixStack, bufferIn, combinedLightIn, OverlayTexture.f_118083_, ModelData.EMPTY, color);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderSingleBlock(BlockState p_110913_, PoseStack poseStack, MultiBufferSource p_110915_, int p_110916_, int p_110917_, ModelData modelData, int color) {
        RenderShape rendershape = p_110913_.m_60799_();
        if (rendershape != RenderShape.INVISIBLE) {
            switch (rendershape) {
                case MODEL: {
                    BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
                    BakedModel bakedmodel = dispatcher.m_110910_(p_110913_);
                    int i = color;
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    dispatcher.m_110937_().renderModel(poseStack.m_85850_(), p_110915_.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)p_110913_, (boolean)false)), p_110913_, bakedmodel, f, f1, f2, p_110916_, p_110917_, modelData, null);
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack((ItemLike)p_110913_.m_60734_());
                    poseStack.m_85837_(0.2, -0.1, -0.1);
                    IClientItemExtensions.of((Item)stack.m_41720_()).getCustomRenderer().m_108829_(stack, ItemDisplayContext.NONE, poseStack, p_110915_, p_110916_, p_110917_);
                }
            }
        }
    }

    public static void renderEntityInInventoryFollowsAngle(GuiGraphics pGuiGraphics, double pX, double pY, double pZ, int pScale, float angleXComponent, float angleYComponent, LivingEntity pEntity) {
        float f = angleXComponent;
        float f1 = angleYComponent;
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf1 = new Quaternionf().rotateX(f1 * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf1);
        float f2 = pEntity.f_20883_;
        float f3 = pEntity.m_146908_();
        float f4 = pEntity.m_146909_();
        float f5 = pEntity.f_20886_;
        float f6 = pEntity.f_20885_;
        pEntity.f_20883_ = 180.0f + f * 20.0f;
        pEntity.m_146922_(180.0f + f * 40.0f);
        pEntity.m_146926_(-f1 * 20.0f);
        pEntity.f_20885_ = pEntity.m_146908_();
        pEntity.f_20886_ = pEntity.m_146908_();
        BloodSigilRecipeCategory.renderEntityInInventory(pGuiGraphics, pX, pY, pZ, pScale, quaternionf, quaternionf1, pEntity);
        pEntity.f_20883_ = f2;
        pEntity.m_146922_(f3);
        pEntity.m_146926_(f4);
        pEntity.f_20886_ = f5;
        pEntity.f_20885_ = f6;
    }

    public static void renderEntityInInventory(GuiGraphics pGuiGraphics, double pX, double pY, double pZ, int pScale, Quaternionf pPose, @Nullable Quaternionf pCameraOrientation, LivingEntity pEntity) {
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_85837_(pX, pY, pZ);
        pGuiGraphics.m_280168_().m_252931_(new Matrix4f().scaling((float)pScale, (float)pScale, (float)(-pScale)));
        pGuiGraphics.m_280168_().m_252781_(pPose);
        Lighting.m_166384_();
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.m_91087_().m_91290_();
        if (pCameraOrientation != null) {
            pCameraOrientation.conjugate();
            entityrenderdispatcher.m_252923_(pCameraOrientation);
        }
        entityrenderdispatcher.m_114468_(false);
        RenderSystem.runAsFancy(() -> entityrenderdispatcher.m_114384_((Entity)pEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, pGuiGraphics.m_280168_(), (MultiBufferSource)pGuiGraphics.m_280091_(), 0xF000F0));
        pGuiGraphics.m_280262_();
        entityrenderdispatcher.m_114468_(true);
        pGuiGraphics.m_280168_().m_85849_();
        Lighting.m_84931_();
    }
}

