/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.data.recipes.AddToCandleRecipe;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class AddToCandleRecipeBuilder
implements RecipeBuilder {
    private final Item result;
    private final Ingredient ingredient;
    private final int count;
    private final CompoundTag nbt;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();

    public AddToCandleRecipeBuilder(ItemLike ingredient, ItemLike result, int count, CompoundTag nbt) {
        this.ingredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient});
        this.result = result.m_5456_();
        this.count = count;
        this.nbt = nbt;
    }

    public RecipeBuilder m_126132_(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        this.advancement.m_138386_(pCriterionName, pCriterionTrigger);
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String pGroupName) {
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ResourceLocation pRecipeId) {
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)pRecipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)pRecipeId)).m_138360_(RequirementsStrategy.f_15979_);
        String path = "recipes/add_to_candle/" + pRecipeId.m_135815_();
        pFinishedRecipeConsumer.accept(new Result(pRecipeId, this.result, this.count, this.ingredient, this.advancement, new ResourceLocation(pRecipeId.m_135827_(), path.trim()), this.nbt));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final Ingredient ingredient;
        private final int count;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        public final CompoundTag nbt;

        public Result(ResourceLocation pId, Item pResult, int pCount, Ingredient ingredient, Advancement.Builder pAdvancement, ResourceLocation pAdvancementId, CompoundTag nbt) {
            this.nbt = nbt;
            this.id = pId;
            this.result = pResult;
            this.count = pCount;
            this.ingredient = ingredient;
            this.advancement = pAdvancement;
            this.advancementId = pAdvancementId;
        }

        public void m_7917_(JsonObject pJson) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.ingredient.m_43908_()[0].m_41720_()).toString());
            pJson.add("input", (JsonElement)jsonobject);
            jsonobject = new JsonObject();
            jsonobject.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.result).toString());
            if (this.nbt != null && !this.nbt.m_128456_()) {
                jsonobject.addProperty("nbt", this.nbt.toString());
            }
            if (this.count > 1) {
                jsonobject.addProperty("count", (Number)this.count);
            }
            pJson.add("output", (JsonElement)jsonobject);
        }

        public ResourceLocation m_6445_() {
            return new ResourceLocation("hexerei", ForgeRegistries.ITEMS.getKey((Object)this.ingredient.m_43908_()[0].m_41720_()).m_135815_() + "_add_to_candle");
        }

        public RecipeSerializer<?> m_6637_() {
            return AddToCandleRecipe.Serializer.INSTANCE;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

