/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collections;
import java.util.Map;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.client.renderer.entity.custom.OwlEntity;
import net.minecraft.client.model.ColorableAgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Vector3f;

public class OwlModel<T extends OwlEntity>
extends ColorableAgeableListModel<T> {
    public final ModelPart owl;
    public final ModelPart head;
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("hexerei", "owl"), "main");

    public OwlModel(ModelPart root) {
        this.owl = root.m_171324_("owl");
        this.head = this.owl.m_171324_("head");
    }

    public static LayerDefinition createBodyLayerNone() {
        return OwlModel.createBodyLayer(CubeDeformation.f_171458_);
    }

    public static LayerDefinition createBodyLayerEnlarge() {
        return OwlModel.createBodyLayer(new CubeDeformation(0.1f));
    }

    public static LayerDefinition createBodyLayer(CubeDeformation cube) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition owl = partdefinition.m_171599_("owl", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)18.2166f, (float)-0.3823f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition body = owl.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.5f, -2.0f, -2.5f, 7.0f, 4.0f, 6.0f, cube), PartPose.m_171419_((float)0.0f, (float)-0.9668f, (float)-0.6345f));
        PartDefinition chest_r1 = body.m_171599_("chest_r1", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171488_(-3.0f, -3.25f, -1.75f, 6.0f, 7.0f, 5.0f, cube), PartPose.m_171423_((float)0.0f, (float)1.75f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition tailMid = body.m_171599_("tailMid", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)4.2502f, (float)3.0167f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition tailMid_r1 = tailMid.m_171599_("tailMid_r1", CubeListBuilder.m_171558_().m_171514_(13, 39).m_171488_(-1.0f, -1.9983f, 2.6101f, 2.0f, 0.0f, 7.0f, cube).m_171514_(0, 24).m_171488_(-1.0f, -2.0959f, 2.5885f, 2.0f, 0.0f, 7.0f, cube), PartPose.m_171423_((float)0.0f, (float)1.6f, (float)-3.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition leftTail = body.m_171599_("leftTail", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.75f, (float)4.7502f, (float)3.5167f, (float)-0.2618f, (float)0.2618f, (float)0.0f));
        PartDefinition leftTail_r1 = leftTail.m_171599_("leftTail_r1", CubeListBuilder.m_171558_().m_171514_(9, 40).m_171488_(-0.0531f, -1.8441f, 2.0488f, 2.0f, 0.0f, 6.0f, cube), PartPose.m_171423_((float)-0.75f, (float)1.5f, (float)-2.5f, (float)-0.1688f, (float)0.008f, (float)-0.0444f));
        PartDefinition leftTail_r2 = leftTail.m_171599_("leftTail_r2", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-0.0531f, -1.8441f, 2.0488f, 2.0f, 0.0f, 6.0f, cube), PartPose.m_171423_((float)-0.75f, (float)1.4f, (float)-2.5f, (float)-0.1688f, (float)0.008f, (float)-0.0444f));
        PartDefinition rightTail = body.m_171599_("rightTail", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-0.75f, (float)4.7502f, (float)3.5167f, (float)-0.2618f, (float)-0.2618f, (float)0.0f));
        PartDefinition rightTail_r1 = rightTail.m_171599_("rightTail_r1", CubeListBuilder.m_171558_().m_171514_(19, 40).m_171488_(-1.9481f, -1.7465f, 2.0706f, 2.0f, 0.0f, 6.0f, cube).m_171514_(-5, 32).m_171488_(-1.9469f, -1.8441f, 2.0488f, 2.0f, 0.0f, 6.0f, cube), PartPose.m_171423_((float)0.75f, (float)1.4f, (float)-2.5f, (float)-0.1688f, (float)-0.008f, (float)0.0444f));
        PartDefinition leftWingBase = body.m_171599_("leftWingBase", CubeListBuilder.m_171558_().m_171514_(14, 30).m_171480_().m_171488_(-0.5f, 0.0f, -1.5f, 4.0f, 0.0f, 5.0f, cube).m_171555_(false).m_171514_(-4, 41).m_171480_().m_171488_(-0.5f, 0.1f, -1.5f, 4.0f, 0.0f, 5.0f, cube).m_171555_(false), PartPose.m_171423_((float)3.5f, (float)-0.7498f, (float)-0.4833f, (float)0.0f, (float)0.0f, (float)1.4835f));
        PartDefinition leftWing_r1 = leftWingBase.m_171599_("leftWing_r1", CubeListBuilder.m_171558_().m_171514_(46, 33).m_171480_().m_171488_(-2.0f, 0.0f, -0.5f, 4.0f, 0.0f, 1.0f, cube).m_171555_(false), PartPose.m_171423_((float)1.5f, (float)-0.1f, (float)-1.5f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition leftWingCloseMiddle = leftWingBase.m_171599_("leftWingCloseMiddle", CubeListBuilder.m_171558_().m_171514_(21, 5).m_171480_().m_171488_(-0.25f, 0.0f, 0.5f, 4.0f, 0.0f, 6.0f, cube).m_171555_(false).m_171514_(-5, 47).m_171480_().m_171488_(-0.25f, 0.1f, 0.5f, 4.0f, 0.0f, 6.0f, cube).m_171555_(false), PartPose.m_171423_((float)3.5f, (float)0.0f, (float)-2.0f, (float)-0.0873f, (float)-0.5236f, (float)0.1745f));
        PartDefinition leftWing_r2 = leftWingCloseMiddle.m_171599_("leftWing_r2", CubeListBuilder.m_171558_().m_171514_(54, 9).m_171480_().m_171488_(-2.0f, 0.0f, -0.5f, 4.0f, 0.0f, 1.0f, cube).m_171555_(false), PartPose.m_171423_((float)1.75f, (float)-0.1f, (float)0.5f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition leftWingFarMiddle = leftWingCloseMiddle.m_171599_("leftWingFarMiddle", CubeListBuilder.m_171558_().m_171514_(20, 0).m_171480_().m_171488_(-0.25f, 0.0f, 0.5f, 4.0f, 0.0f, 5.0f, cube).m_171555_(false).m_171514_(-4, 55).m_171480_().m_171488_(-0.25f, 0.1f, 0.5f, 4.0f, 0.0f, 5.0f, cube).m_171555_(false), PartPose.m_171423_((float)3.75f, (float)0.0f, (float)0.0f, (float)-0.1745f, (float)-1.0472f, (float)0.1745f));
        PartDefinition leftWing_r3 = leftWingFarMiddle.m_171599_("leftWing_r3", CubeListBuilder.m_171558_().m_171514_(53, 3).m_171480_().m_171488_(-1.5f, 0.0f, -0.5f, 3.0f, 0.0f, 1.0f, cube).m_171555_(false), PartPose.m_171423_((float)1.25f, (float)-0.1f, (float)0.5f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition leftWingTip = leftWingFarMiddle.m_171599_("leftWingTip", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)3.75f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.6109f));
        PartDefinition rightWingBase = body.m_171599_("rightWingBase", CubeListBuilder.m_171558_().m_171514_(14, 30).m_171488_(-3.5f, 0.0f, -1.5f, 4.0f, 0.0f, 5.0f, cube).m_171514_(-4, 41).m_171488_(-3.5f, 0.1f, -1.5f, 4.0f, 0.0f, 5.0f, cube), PartPose.m_171423_((float)-3.5f, (float)-0.7498f, (float)-0.4833f, (float)0.0f, (float)0.0f, (float)-1.4835f));
        PartDefinition rightWing_r1 = rightWingBase.m_171599_("rightWing_r1", CubeListBuilder.m_171558_().m_171514_(46, 33).m_171488_(-2.0f, 0.0f, -0.5f, 4.0f, 0.0f, 1.0f, cube), PartPose.m_171423_((float)-1.5f, (float)-0.1f, (float)-1.5f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition rightWingCloseMiddle = rightWingBase.m_171599_("rightWingCloseMiddle", CubeListBuilder.m_171558_().m_171514_(21, 5).m_171488_(-3.75f, 0.0f, 0.5f, 4.0f, 0.0f, 6.0f, cube).m_171514_(-5, 47).m_171488_(-3.75f, 0.1f, 0.5f, 4.0f, 0.0f, 6.0f, cube), PartPose.m_171423_((float)-3.5f, (float)0.0f, (float)-2.0f, (float)-0.0873f, (float)0.5236f, (float)-0.1745f));
        PartDefinition rightWing_r2 = rightWingCloseMiddle.m_171599_("rightWing_r2", CubeListBuilder.m_171558_().m_171514_(54, 9).m_171488_(-2.0f, 0.0f, -0.5f, 4.0f, 0.0f, 1.0f, cube), PartPose.m_171423_((float)-1.75f, (float)-0.1f, (float)0.5f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition rightWingFarMiddle = rightWingCloseMiddle.m_171599_("rightWingFarMiddle", CubeListBuilder.m_171558_().m_171514_(20, 0).m_171488_(-3.75f, 0.0f, 0.5f, 4.0f, 0.0f, 5.0f, cube).m_171514_(-4, 55).m_171488_(-3.75f, 0.1f, 0.5f, 4.0f, 0.0f, 5.0f, cube), PartPose.m_171423_((float)-3.75f, (float)0.0f, (float)0.0f, (float)-0.1745f, (float)1.0472f, (float)-0.1745f));
        PartDefinition rightWing_r3 = rightWingFarMiddle.m_171599_("rightWing_r3", CubeListBuilder.m_171558_().m_171514_(53, 3).m_171488_(-1.5f, 0.0f, -0.5f, 3.0f, 0.0f, 1.0f, cube), PartPose.m_171423_((float)-1.25f, (float)-0.2f, (float)0.5f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition rightWingTip = rightWingFarMiddle.m_171599_("rightWingTip", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-3.75f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6109f));
        PartDefinition rightLeg = owl.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171488_(-1.0f, 0.0f, 0.25f, 1.0f, 2.0f, 1.0f, cube).m_171514_(12, 29).m_171488_(-1.5f, 2.0f, -0.75f, 2.0f, 0.0f, 1.0f, cube), PartPose.m_171423_((float)-1.0f, (float)3.567f, (float)-1.094f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = owl.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(12, 24).m_171488_(0.0f, 0.0f, 0.25f, 1.0f, 2.0f, 1.0f, cube).m_171514_(37, 15).m_171488_(-0.5f, 2.0f, -0.75f, 2.0f, 0.0f, 1.0f, cube), PartPose.m_171423_((float)1.0f, (float)3.567f, (float)-1.094f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition head = owl.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(18, 19).m_171488_(-3.0f, -3.5126f, -2.7186f, 6.0f, 5.0f, 5.0f, cube).m_171514_(10, 50).m_171488_(-3.0f, -3.5126f, -2.7186f, 6.0f, 5.0f, 5.0f, new CubeDeformation(0.2f)), PartPose.m_171423_((float)0.0f, (float)-3.9001f, (float)0.3282f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition beak = head.m_171599_("beak", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.6835f, (float)-2.9962f));
        PartDefinition beak_r1 = beak.m_171599_("beak_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.5f, 0.0f, -0.75f, 1.0f, 2.0f, 1.0f, cube), PartPose.m_171423_((float)0.0f, (float)-0.6961f, (float)0.0276f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition rightBrow = head.m_171599_("rightBrow", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.85f, (float)-3.2626f, (float)-2.8186f));
        PartDefinition rightBrow_r1 = rightBrow.m_171599_("rightBrow_r1", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171488_(-1.2462f, -1.4566f, 0.0f, 3.0f, 2.0f, 0.0f, cube), PartPose.m_171423_((float)-1.15f, (float)1.0f, (float)-0.15f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition rightBrow_r2 = rightBrow.m_171599_("rightBrow_r2", CubeListBuilder.m_171558_().m_171514_(11, 32).m_171488_(-1.0f, -0.5f, -0.5f, 2.0f, 1.0f, 1.0f, cube), PartPose.m_171423_((float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0451f, (float)0.0834f, (float)0.1725f));
        PartDefinition rightBrow_r3 = rightBrow.m_171599_("rightBrow_r3", CubeListBuilder.m_171558_().m_171514_(36, 20).m_171488_(-1.6f, -0.5f, -0.6f, 3.0f, 1.0f, 1.0f, cube), PartPose.m_171423_((float)-2.2437f, (float)-0.5276f, (float)1.2532f, (float)0.3589f, (float)1.0414f, (float)0.6033f));
        PartDefinition rightBrow_r4 = rightBrow.m_171599_("rightBrow_r4", CubeListBuilder.m_171558_().m_171514_(11, 36).m_171488_(-2.1f, 0.0f, 0.4f, 4.0f, 0.0f, 1.0f, cube), PartPose.m_171423_((float)-2.2437f, (float)-0.7776f, (float)1.2532f, (float)0.3589f, (float)1.0414f, (float)0.6033f));
        PartDefinition leftBrow = head.m_171599_("leftBrow", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.85f, (float)-3.2626f, (float)-2.8186f));
        PartDefinition leftBrow_r1 = leftBrow.m_171599_("leftBrow_r1", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171488_(-1.7538f, -1.4566f, 0.0f, 3.0f, 2.0f, 0.0f, cube), PartPose.m_171423_((float)1.15f, (float)1.0f, (float)-0.15f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition leftBrow_r2 = leftBrow.m_171599_("leftBrow_r2", CubeListBuilder.m_171558_().m_171514_(21, 37).m_171488_(-1.0f, -0.5f, -0.5f, 2.0f, 1.0f, 1.0f, cube), PartPose.m_171423_((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0451f, (float)-0.0834f, (float)-0.1725f));
        PartDefinition leftBrow_r3 = leftBrow.m_171599_("leftBrow_r3", CubeListBuilder.m_171558_().m_171514_(37, 12).m_171488_(-1.4f, -0.5f, -0.6f, 3.0f, 1.0f, 1.0f, cube), PartPose.m_171423_((float)2.2437f, (float)-0.5276f, (float)1.2532f, (float)0.3589f, (float)-1.0414f, (float)-0.6033f));
        PartDefinition leftBrow_r4 = leftBrow.m_171599_("leftBrow_r4", CubeListBuilder.m_171558_().m_171514_(36, 18).m_171488_(-1.9f, 0.0f, 0.4f, 4.0f, 0.0f, 1.0f, cube), PartPose.m_171423_((float)2.2437f, (float)-0.7776f, (float)1.2532f, (float)0.3589f, (float)-1.0414f, (float)-0.6033f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(OwlEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setupInitialAnimationValues(entity, netHeadYaw, headPitch);
        ModelPart body = this.owl.m_171324_("body");
        ModelPart leftWingBase = body.m_171324_("leftWingBase");
        ModelPart leftWingCloseMiddle = leftWingBase.m_171324_("leftWingCloseMiddle");
        ModelPart leftWingFarMiddle = leftWingCloseMiddle.m_171324_("leftWingFarMiddle");
        ModelPart rightWingBase = body.m_171324_("rightWingBase");
        ModelPart rightWingCloseMiddle = rightWingBase.m_171324_("rightWingCloseMiddle");
        ModelPart rightWingFarMiddle = rightWingCloseMiddle.m_171324_("rightWingFarMiddle");
        ModelPart rightLeg = this.owl.m_171324_("rightLeg");
        ModelPart leftLeg = this.owl.m_171324_("leftLeg");
        ModelPart head = this.owl.m_171324_("head");
        ModelPart rightTail = body.m_171324_("rightTail");
        ModelPart leftTail = body.m_171324_("leftTail");
        ModelPart tailMid = body.m_171324_("tailMid");
        ModelPart beak = head.m_171324_("beak");
        ModelPart rightBrow = head.m_171324_("rightBrow");
        ModelPart leftBrow = head.m_171324_("leftBrow");
        if (!entity.m_20096_() || !entity.m_21825_()) {
            this.owl.f_104201_ = 18.5f;
        }
        float ticks = (float)entity.f_19797_ + (float)entity.m_19879_() * 235.0f + Hexerei.getPartial();
        rightWingBase.f_104205_ = Mth.m_14179_((float)Hexerei.getPartial(), (float)entity.rightWingAngleLast, (float)entity.rightWingAngle);
        leftWingBase.f_104205_ = Mth.m_14179_((float)Hexerei.getPartial(), (float)entity.leftWingAngleLast, (float)entity.leftWingAngle);
        rightWingCloseMiddle.f_104205_ = Mth.m_14179_((float)Hexerei.getPartial(), (float)entity.rightWingMiddleAngleLast, (float)entity.rightWingMiddleAngle);
        leftWingCloseMiddle.f_104205_ = Mth.m_14179_((float)Hexerei.getPartial(), (float)entity.leftWingMiddleAngleLast, (float)entity.leftWingMiddleAngle);
        rightWingBase.f_104203_ = 0.0f;
        leftWingBase.f_104203_ = 0.0f;
        rightWingBase.f_104204_ = entity.rightWingFoldAngle;
        leftWingBase.f_104204_ = entity.leftWingFoldAngle;
        rightWingCloseMiddle.f_104204_ = entity.rightWingMiddleFoldAngle;
        leftWingCloseMiddle.f_104204_ = entity.leftWingMiddleFoldAngle;
        rightWingFarMiddle.f_104204_ = entity.rightWingTipAngle;
        leftWingFarMiddle.f_104204_ = entity.leftWingTipAngle;
        this.owl.f_104203_ = Mth.m_14031_((float)(entity.peckAnimation.getPeckRot() / 100.0f));
        this.owl.f_104205_ = 0.0f;
        this.owl.f_104204_ = 0.0f;
        body.f_104204_ = 0.0f;
        head.f_104204_ = 0.0f;
        head.f_104205_ = 0.0f;
        leftBrow.f_104205_ = 0.0f;
        rightBrow.f_104205_ = 0.0f;
        leftBrow.f_104204_ = 0.0f;
        rightBrow.f_104204_ = 0.0f;
        leftBrow.f_104202_ = -2.81f;
        rightBrow.f_104202_ = -2.81f;
        leftBrow.f_104201_ = -3.26f;
        rightBrow.f_104201_ = -3.26f;
        leftBrow.f_104200_ = 0.85f;
        rightBrow.f_104200_ = -0.85f;
        if (entity.browAnimation.getBrowAnim() == OwlEntity.BrowAnim.BOTH) {
            leftBrow.f_104205_ += Mth.m_14031_((float)(entity.browAnimation.getBrowRot() / 100.0f)) * 0.2f;
            rightBrow.f_104205_ -= Mth.m_14031_((float)(entity.browAnimation.getBrowRot() / 100.0f)) * 0.2f;
            leftBrow.f_104201_ += Mth.m_14031_((float)(entity.browAnimation.getBrowRot() / 50.0f)) * 0.3f;
            rightBrow.f_104201_ += Mth.m_14031_((float)(entity.browAnimation.getBrowRot() / 50.0f)) * 0.3f;
        }
        if (entity.browAnimation.getBrowAnim() == OwlEntity.BrowAnim.RIGHT) {
            rightBrow.f_104205_ -= Mth.m_14031_((float)(entity.browAnimation.getBrowRot() / 100.0f)) * 0.2f;
            rightBrow.f_104201_ += Mth.m_14031_((float)(entity.browAnimation.getBrowRot() / 50.0f)) * 0.3f;
        }
        if (entity.browAnimation.getBrowAnim() == OwlEntity.BrowAnim.LEFT) {
            leftBrow.f_104205_ += Mth.m_14031_((float)(entity.browAnimation.getBrowRot() / 100.0f)) * 0.2f;
            leftBrow.f_104201_ += Mth.m_14031_((float)(entity.browAnimation.getBrowRot() / 50.0f)) * 0.3f;
        }
        if (entity.emotionState != null) {
            leftBrow.f_104205_ = (float)((double)leftBrow.f_104205_ + Math.toRadians(entity.emotionState.getzRot()));
            rightBrow.f_104205_ = (float)((double)rightBrow.f_104205_ - Math.toRadians(entity.emotionState.getzRot()));
            leftBrow.f_104201_ += entity.emotionState.getyOffset();
            rightBrow.f_104201_ += entity.emotionState.getyOffset();
            leftBrow.f_104200_ += entity.emotionState.getxOffset();
            rightBrow.f_104200_ -= entity.emotionState.getxOffset();
        }
        rightLeg.f_104202_ = 0.0f;
        leftLeg.f_104202_ = 0.0f;
        if (entity.m_20096_() || !entity.m_29443_()) {
            rightTail.f_104203_ = Mth.m_14031_((float)(ticks / 15.0f)) * 0.1f;
            leftTail.f_104203_ = Mth.m_14031_((float)(ticks / 15.0f)) * 0.1f;
            tailMid.f_104203_ = Mth.m_14031_((float)(ticks / 15.0f)) * 0.1f;
            if (entity.m_21824_() && entity.m_21825_()) {
                rightLeg.f_104203_ = -0.7853982f;
                leftLeg.f_104203_ = -0.7853982f;
                rightLeg.f_104201_ = 2.25f;
                rightLeg.f_104202_ = -2.0f;
                leftLeg.f_104201_ = 2.25f;
                leftLeg.f_104202_ = -2.0f;
                this.owl.f_104201_ = 20.0f;
                rightTail.f_104203_ += 0.3926991f;
                leftTail.f_104203_ += 0.3926991f;
                tailMid.f_104203_ += 0.3926991f;
            } else {
                rightLeg.f_104201_ = 3.5f;
                leftLeg.f_104201_ = 3.5f;
                rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 2.0f + (float)Math.PI)) * 2.0f * limbSwingAmount;
                leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 2.0f)) * 2.0f * limbSwingAmount;
                if (entity.m_20096_()) {
                    this.owl.f_104205_ = Mth.m_14089_((float)(limbSwing * 2.0f)) * 0.1f * (float)Math.max(0.08, (double)limbSwingAmount);
                    this.owl.f_104203_ += Mth.m_14089_((float)(limbSwing * 4.0f)) * 0.1f * (float)Math.max(0.08, (double)limbSwingAmount);
                }
            }
            head.f_104203_ = (float)Math.toRadians(headPitch);
            head.f_104203_ += Mth.m_14031_((float)(ticks / 15.0f)) * 0.1f;
            leftBrow.f_104205_ += -Mth.m_14031_((float)(ticks / 15.0f)) * 0.05f;
            rightBrow.f_104205_ -= -Mth.m_14031_((float)(ticks / 15.0f)) * 0.05f;
            leftBrow.f_104201_ += -Mth.m_14031_((float)(ticks / 15.0f)) * 0.15f;
            rightBrow.f_104201_ += -Mth.m_14031_((float)(ticks / 15.0f)) * 0.15f;
            rightTail.f_104204_ = -Mth.m_14031_((float)0.05f);
            leftTail.f_104204_ = Mth.m_14031_((float)0.05f);
            rightTail.f_104204_ += Mth.m_14031_((float)(entity.tailWagAnimation.getWagRot() / 100.0f)) * 0.2f;
            leftTail.f_104204_ += Mth.m_14031_((float)(entity.tailWagAnimation.getWagRot() / 100.0f)) * 0.2f;
            tailMid.f_104204_ = Mth.m_14031_((float)(entity.tailWagAnimation.getWagRot() / 100.0f)) * 0.2f;
            if (entity.tailWagAnimation.isActive()) {
                rightTail.f_104204_ += Mth.m_14031_((float)0.15f) * 0.5f;
                leftTail.f_104204_ -= Mth.m_14031_((float)0.15f) * 0.5f;
            }
            rightTail.f_104204_ -= Mth.m_14031_((float)(entity.tailFanAnimation.getFanRot() / 100.0f)) * 0.5f;
            leftTail.f_104204_ += Mth.m_14031_((float)(entity.tailFanAnimation.getFanRot() / 100.0f)) * 0.5f;
        } else if (entity.m_20159_()) {
            rightLeg.f_104203_ = -0.5235988f;
            leftLeg.f_104203_ = -0.5235988f;
            rightLeg.f_104201_ = 2.5f;
            rightLeg.f_104202_ = 1.5f;
            leftLeg.f_104201_ = 2.5f;
            leftLeg.f_104202_ = 1.5f;
            this.owl.f_104201_ = 20.0f;
            head.f_104203_ = (float)Math.toRadians(headPitch);
            head.f_104203_ += Mth.m_14031_((float)(ticks / 15.0f)) * 0.1f;
            leftBrow.f_104205_ += -Mth.m_14031_((float)(ticks / 15.0f)) * 0.05f;
            rightBrow.f_104205_ -= -Mth.m_14031_((float)(ticks / 15.0f)) * 0.05f;
            leftBrow.f_104201_ += -Mth.m_14031_((float)(ticks / 15.0f)) * 0.15f;
            rightBrow.f_104201_ += -Mth.m_14031_((float)(ticks / 15.0f)) * 0.15f;
            rightTail.f_104203_ = Mth.m_14031_((float)(ticks / 15.0f)) * 0.1f;
            leftTail.f_104203_ = Mth.m_14031_((float)(ticks / 15.0f)) * 0.1f;
            tailMid.f_104203_ = Mth.m_14031_((float)(ticks / 15.0f)) * 0.1f;
            rightTail.f_104204_ = -Mth.m_14031_((float)0.05f);
            leftTail.f_104204_ = Mth.m_14031_((float)0.05f);
            rightTail.f_104204_ += Mth.m_14031_((float)(entity.tailWagAnimation.getWagRot() / 100.0f)) * 0.2f;
            leftTail.f_104204_ += Mth.m_14031_((float)(entity.tailWagAnimation.getWagRot() / 100.0f)) * 0.2f;
            tailMid.f_104204_ = Mth.m_14031_((float)(entity.tailWagAnimation.getWagRot() / 100.0f)) * 0.2f;
            if (entity.tailWagAnimation.isActive()) {
                rightTail.f_104204_ += Mth.m_14031_((float)0.15f) * 0.5f;
                leftTail.f_104204_ -= Mth.m_14031_((float)0.15f) * 0.5f;
            }
            rightTail.f_104204_ -= Mth.m_14031_((float)(entity.tailFanAnimation.getFanRot() / 100.0f)) * 0.5f;
            leftTail.f_104204_ += Mth.m_14031_((float)(entity.tailFanAnimation.getFanRot() / 100.0f)) * 0.5f;
        } else {
            rightLeg.f_104203_ = Mth.m_14031_((float)20.0f);
            leftLeg.f_104203_ = Mth.m_14031_((float)20.0f);
            head.f_104203_ = (float)Math.toRadians(headPitch);
            rightTail.f_104204_ = -Mth.m_14031_((float)0.15f);
            leftTail.f_104204_ = Mth.m_14031_((float)0.15f);
            this.owl.f_104201_ = 18.5f + Mth.m_14179_((float)Hexerei.getPartial(), (float)entity.bodyYOffsetLast, (float)entity.bodyYOffset);
            this.owl.f_104203_ += Mth.m_14179_((float)Hexerei.getPartial(), (float)entity.bodyXRotLast, (float)entity.bodyXRot);
            head.f_104203_ -= this.owl.f_104203_ / 1.5f;
            head.f_104205_ = (float)((double)head.f_104205_ - Math.toRadians(netHeadYaw) / 2.0);
            leftLeg.f_104202_ = -1.0f;
            rightLeg.f_104202_ = -1.0f;
            leftLeg.f_104201_ = 4.5f;
            rightLeg.f_104201_ = 4.5f;
            rightWingBase.f_104203_ = -this.owl.f_104203_ / 1.15f;
            leftWingBase.f_104203_ = -this.owl.f_104203_ / 1.15f;
            tailMid.f_104203_ = -this.owl.f_104203_ / 1.15f;
            leftTail.f_104203_ = -this.owl.f_104203_ / 1.15f;
            rightTail.f_104203_ = -this.owl.f_104203_ / 1.15f;
            rightWingBase.f_104204_ += Mth.m_14179_((float)Hexerei.getPartial(), (float)entity.rightWingAngleLast, (float)entity.rightWingAngle) / 2.0f;
            leftWingBase.f_104204_ += Mth.m_14179_((float)Hexerei.getPartial(), (float)entity.leftWingAngleLast, (float)entity.leftWingAngle) / 2.0f;
        }
        if (entity.emotions.isHappy()) {
            leftBrow.f_104204_ = (float)((double)leftBrow.f_104204_ - Math.toRadians(10.0));
            rightBrow.f_104204_ = (float)((double)rightBrow.f_104204_ + Math.toRadians(10.0));
            if (entity.browHappyAnimation.getBrowAnim() == OwlEntity.BrowAnim.BOTH) {
                leftBrow.f_104204_ += Mth.m_14031_((float)(entity.browHappyAnimation.getBrowRot() / 100.0f)) * 0.2f;
                rightBrow.f_104204_ -= Mth.m_14031_((float)(entity.browHappyAnimation.getBrowRot() / 100.0f)) * 0.2f;
            }
            if (entity.browHappyAnimation.getBrowAnim() == OwlEntity.BrowAnim.RIGHT) {
                rightBrow.f_104204_ -= Mth.m_14031_((float)(entity.browHappyAnimation.getBrowRot() / 100.0f)) * 0.2f;
                body.f_104204_ += Mth.m_14031_((float)(Mth.m_14179_((float)Hexerei.getPartial(), (float)entity.browHappyAnimation.getBrowRotLast(), (float)entity.browHappyAnimation.getBrowRot()) / 90.0f)) * 0.2f;
            }
            if (entity.browHappyAnimation.getBrowAnim() == OwlEntity.BrowAnim.LEFT) {
                leftBrow.f_104204_ += Mth.m_14031_((float)(entity.browHappyAnimation.getBrowRot() / 100.0f)) * 0.2f;
                body.f_104204_ += Mth.m_14031_((float)(Mth.m_14179_((float)Hexerei.getPartial(), (float)entity.browHappyAnimation.getBrowRotLast(), (float)entity.browHappyAnimation.getBrowRot()) / 90.0f)) * 0.2f;
            }
            if (entity.m_21825_() || entity.m_29443_()) {
                rightLeg.f_104203_ += Mth.m_14031_((float)(entity.browHappyAnimation.getBrowRot() / 100.0f));
                leftLeg.f_104203_ -= Mth.m_14031_((float)(entity.browHappyAnimation.getBrowRot() / 100.0f));
            }
            leftBrow.f_104201_ = (float)((double)leftBrow.f_104201_ - 0.25);
            rightBrow.f_104201_ = (float)((double)rightBrow.f_104201_ - 0.25);
            leftBrow.f_104202_ = (float)((double)leftBrow.f_104202_ - 0.25);
            rightBrow.f_104202_ = (float)((double)rightBrow.f_104202_ - 0.25);
        }
        head.f_104204_ += (float)Math.toRadians(netHeadYaw);
        head.f_104205_ += Mth.m_14031_((float)(entity.headTiltAnimation.getzTilt() / 100.0f)) / 2.0f;
        head.f_104203_ += Mth.m_14031_((float)(entity.headTiltAnimation.getxTilt() / 100.0f)) / 2.0f;
        if ((entity.m_20096_() || entity.m_20159_()) && entity.dance) {
            head.f_104205_ = 0.0f;
            head.f_104203_ = (float)Math.toRadians(headPitch) + Mth.m_14031_((float)((float)entity.animationCounter / 1.5f)) / 12.0f;
            head.f_104204_ = (float)Math.toRadians(netHeadYaw) + Mth.m_14031_((float)((float)entity.animationCounter / 3.0f)) / 4.0f;
            rightTail.f_104203_ = Mth.m_14031_((float)((float)entity.animationCounter / 3.0f)) * 0.1f;
            leftTail.f_104203_ = Mth.m_14031_((float)((float)entity.animationCounter / 3.0f)) * 0.1f;
            tailMid.f_104203_ = Mth.m_14031_((float)((float)entity.animationCounter / 3.0f)) * 0.1f;
            this.owl.f_104204_ += Mth.m_14031_((float)((float)entity.animationCounter / 3.0f)) * 0.2f;
            rightTail.f_104204_ = Mth.m_14031_((float)0.1f);
            leftTail.f_104204_ = -Mth.m_14031_((float)0.1f);
            this.owl.f_104201_ = 18.5f + Mth.m_14154_((float)Mth.m_14031_((float)((float)entity.animationCounter / 6.0f)));
            rightTail.f_104204_ += Mth.m_14031_((float)((float)entity.animationCounter / 3.0f)) * 0.4f;
            leftTail.f_104204_ += Mth.m_14031_((float)((float)entity.animationCounter / 3.0f)) * 0.4f;
            tailMid.f_104204_ = Mth.m_14031_((float)((float)entity.animationCounter / 3.0f)) * 0.4f;
            rightLeg.f_104201_ = 3.5f - Mth.m_14154_((float)Mth.m_14031_((float)((float)entity.animationCounter / 6.0f)));
            rightLeg.f_104202_ = 0.5f;
            leftLeg.f_104201_ = 3.5f - Mth.m_14154_((float)Mth.m_14031_((float)((float)entity.animationCounter / 6.0f)));
            leftLeg.f_104202_ = 0.5f;
            rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 2.0f + (float)Math.PI)) * 2.0f * limbSwingAmount;
            leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 2.0f)) * 2.0f * limbSwingAmount;
        }
        beak.f_104203_ = Mth.m_14031_((float)(-entity.hootAnimation.getHootRot() / 100.0f));
        if (entity.peckAnimation.getPeckRot() > 0.0f) {
            beak.f_104203_ = Mth.m_14031_((float)(-entity.peckAnimation.getPeckRot() / 100.0f));
        }
        head.f_104207_ = true;
        this.saveAnimationValues(entity);
    }

    private Vector3f getRotationVector(ModelPart pModelPart) {
        return new Vector3f(pModelPart.f_104203_, pModelPart.f_104204_, pModelPart.f_104205_);
    }

    private void setRotationFromVector(ModelPart pModelPart, Vector3f pRotationVector) {
        pModelPart.m_171327_(pRotationVector.x(), pRotationVector.y(), pRotationVector.z());
    }

    private void saveAnimationValues(OwlEntity crow) {
        Map<String, Vector3f> map = crow.getModelRotationValues();
        map.put("owl", this.getRotationVector(this.owl));
    }

    private void setupInitialAnimationValues(OwlEntity crow, float pNetHeadYaw, float pHeadPitch) {
        this.owl.f_104200_ = 0.0f;
        this.owl.f_104201_ = 19.0f;
        Map<String, Vector3f> map = crow.getModelRotationValues();
        if (map.isEmpty()) {
            this.owl.m_171327_(pHeadPitch * ((float)Math.PI / 180), pNetHeadYaw * ((float)Math.PI / 180), 0.0f);
        } else {
            this.setRotationFromVector(this.owl, map.get("owl"));
        }
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.owl.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    protected Iterable<ModelPart> m_5607_() {
        return Collections.singleton(this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return Collections.singleton(this.owl);
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.f_104203_ = x;
        modelRenderer.f_104204_ = y;
        modelRenderer.f_104205_ = z;
    }
}

