/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.mediumcore.client;

import com.github.alexmodguy.mediumcore.CommonProxy;
import com.github.alexmodguy.mediumcore.Mediumcore;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientProxy
extends CommonProxy {
    private static final ResourceLocation MEDIUMCORE_HEARTS_TEXTURE = new ResourceLocation("mediumcore:textures/gui/mediumcore_hearts.png");
    private static final RandomSource random = RandomSource.m_216327_();
    private boolean mediumcoreMode;

    @Override
    public void clientInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPostRenderGuiOverlay(RenderGuiOverlayEvent.Post event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (((Boolean)Mediumcore.CONFIG.mediumcoreHeartTexture.get()).booleanValue() && event.getOverlay().id().equals((Object)VanillaGuiOverlay.PLAYER_HEALTH.id()) && Minecraft.m_91087_().f_91072_.m_105205_() && this.mediumcoreMode && Minecraft.m_91087_().m_91288_() instanceof Player && Gui.HeartType.m_168732_((Player)player) == Gui.HeartType.NORMAL) {
            int n;
            int leftHeight = 39;
            int width = event.getWindow().m_85445_();
            int height = event.getWindow().m_85446_();
            AttributeInstance attrMaxHealth = player.m_21051_(Attributes.f_22276_);
            float healthMax = (float)attrMaxHealth.m_22135_();
            float absorb = Mth.m_14167_((float)player.m_6103_());
            int health = Mth.m_14167_((float)player.m_21223_());
            Gui gui = Minecraft.m_91087_().f_91065_;
            if (gui instanceof ForgeGui) {
                ForgeGui forgeGui = (ForgeGui)gui;
                n = forgeGui.m_93079_();
            } else {
                n = 0;
            }
            int forgeGuiTick = n;
            int healthRows = Mth.m_14167_((float)((healthMax + absorb) / 2.0f / 10.0f));
            int rowHeight = Math.max(10 - (healthRows - 2), 3);
            random.m_188584_((long)(forgeGuiTick * 312871));
            int left = width / 2 - 91;
            int top = height - leftHeight;
            int regen = -1;
            if (player.m_21023_(MobEffects.f_19605_)) {
                regen = forgeGuiTick % Mth.m_14167_((float)(healthMax + 5.0f));
            }
            int heartV = player.m_9236_().m_6106_().m_5466_() ? 9 : 0;
            int heartU = 0;
            event.getGuiGraphics().m_280168_().m_85836_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)MEDIUMCORE_HEARTS_TEXTURE);
            for (int i = Mth.m_14167_((float)((healthMax + absorb) / 2.0f)) - 1; i >= 0; --i) {
                int row = Mth.m_14167_((float)((float)(i + 1) / 10.0f)) - 1;
                int x = left + i % 10 * 8;
                int y = top - row * rowHeight;
                if (health <= 4) {
                    y += random.m_188503_(2);
                }
                if (i == regen) {
                    y -= 2;
                }
                event.getGuiGraphics().m_280398_(MEDIUMCORE_HEARTS_TEXTURE, x, y, 50, (float)heartU, (float)(heartV + 18), 9, 9, 64, 32);
                if (i * 2 + 1 < health) {
                    event.getGuiGraphics().m_280398_(MEDIUMCORE_HEARTS_TEXTURE, x, y, 50, (float)heartU, (float)heartV, 9, 9, 64, 32);
                    continue;
                }
                if (i * 2 + 1 != health) continue;
                event.getGuiGraphics().m_280398_(MEDIUMCORE_HEARTS_TEXTURE, x, y, 50, (float)(heartU + 9), (float)heartV, 9, 9, 64, 32);
            }
            event.getGuiGraphics().m_280168_().m_85849_();
        }
    }

    @Override
    public void setGameRuleLocalValue(boolean mediumcoreMode) {
        this.mediumcoreMode = mediumcoreMode;
    }

    @Override
    public boolean isMediumcoreModeLocally() {
        return this.mediumcoreMode;
    }
}

