/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.util;

import com.hypherionmc.simplerpc.jodd.util.Base64;
import java.security.SecureRandom;

public class RandomString {
    protected static final char[] ALPHA_RANGE = new char[]{'A', 'Z', 'a', 'z'};
    protected static final char[] ALPHA_NUMERIC_RANGE = new char[]{'0', '9', 'A', 'Z', 'a', 'z'};
    protected static final RandomString INSTANCE = new RandomString();
    protected final SecureRandom rnd = new SecureRandom();

    public static RandomString get() {
        return INSTANCE;
    }

    public String random(int count, char[] chars) {
        if (count == 0) {
            return "";
        }
        char[] result = new char[count];
        while (count-- > 0) {
            result[count] = chars[this.rnd.nextInt(chars.length)];
        }
        return new String(result);
    }

    public String random(int count, String chars) {
        return this.random(count, chars.toCharArray());
    }

    public String random(int count, char start, char end) {
        if (count == 0) {
            return "";
        }
        char[] result = new char[count];
        int len = end - start + 1;
        while (count-- > 0) {
            result[count] = (char)(this.rnd.nextInt(len) + start);
        }
        return new String(result);
    }

    public String randomAscii(int count) {
        return this.random(count, ' ', '~');
    }

    public String randomNumeric(int count) {
        return this.random(count, '0', '9');
    }

    public String randomRanges(int count, char ... ranges) {
        int i;
        if (count == 0) {
            return "";
        }
        int len = 0;
        int[] lens = new int[ranges.length];
        for (i = 0; i < ranges.length; i += 2) {
            int gap = ranges[i + 1] - ranges[i] + 1;
            lens[i] = len += gap;
        }
        char[] result = new char[count];
        while (count-- > 0) {
            char c = '\u0000';
            int r = this.rnd.nextInt(len);
            for (i = 0; i < ranges.length; i += 2) {
                if (r >= lens[i]) continue;
                r += ranges[i];
                if (i != 0) {
                    r -= lens[i - 2];
                }
                c = (char)r;
                break;
            }
            result[count] = c;
        }
        return new String(result);
    }

    public String randomAlpha(int count) {
        return this.randomRanges(count, ALPHA_RANGE);
    }

    public String randomAlphaNumeric(int count) {
        return this.randomRanges(count, ALPHA_NUMERIC_RANGE);
    }

    public String randomBase64(int count) {
        return this.random(count, Base64.CHARS);
    }
}

