/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.typeconverter.impl;

import com.hypherionmc.simplerpc.jodd.time.JulianDate;
import com.hypherionmc.simplerpc.jodd.time.TimeUtil;
import com.hypherionmc.simplerpc.jodd.typeconverter.TypeConversionException;
import com.hypherionmc.simplerpc.jodd.typeconverter.TypeConverter;
import com.hypherionmc.simplerpc.jodd.util.StringUtil;
import java.sql.Time;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;

public class SqlTimeConverter
implements TypeConverter<Time> {
    @Override
    public Time convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Time) {
            return (Time)value;
        }
        if (value instanceof Calendar) {
            return new Time(((Calendar)value).getTimeInMillis());
        }
        if (value instanceof Date) {
            return new Time(((Date)value).getTime());
        }
        if (value instanceof JulianDate) {
            return new Time(((JulianDate)value).toMilliseconds());
        }
        if (value instanceof LocalDateTime) {
            return new Time(TimeUtil.toMilliseconds((LocalDateTime)value));
        }
        if (value instanceof LocalDate) {
            return new Time(TimeUtil.toMilliseconds((LocalDate)value));
        }
        if (value instanceof Number) {
            return new Time(((Number)value).longValue());
        }
        String stringValue = value.toString().trim();
        if (!StringUtil.containsOnlyDigits(stringValue)) {
            try {
                return Time.valueOf(stringValue);
            }
            catch (IllegalArgumentException iaex) {
                throw new TypeConversionException(value, (Throwable)iaex);
            }
        }
        try {
            long milliseconds = Long.parseLong(stringValue);
            return new Time(milliseconds);
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException(value, (Throwable)nfex);
        }
    }
}

