/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.server.config;

import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.vivecraft.client.gui.settings.GuiListValueEditScreen;
import org.vivecraft.server.config.ConfigBuilder;

public class WidgetBuilder {
    public static Supplier<AbstractWidget> getBaseWidget(ConfigBuilder.ConfigValue<?> value, int width, int height) {
        return () -> Button.m_253074_((Component)Component.m_237113_((String)("" + value.get())), button -> {}).m_252987_(0, 0, width, height).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)value.getComment()))).m_253136_();
    }

    public static Supplier<AbstractWidget> getOnOffWidget(ConfigBuilder.BooleanValue booleanValue, int width, int height) {
        return () -> CycleButton.m_168916_((boolean)((Boolean)booleanValue.get())).m_168929_().m_232498_(bool -> booleanValue.getComment() != null ? Tooltip.m_257550_((Component)Component.m_237113_((String)booleanValue.getComment())) : null).m_168936_(0, 0, width, height, (Component)Component.m_237119_(), (button, bool) -> booleanValue.set(bool));
    }

    public static Supplier<AbstractWidget> getEditBoxWidget(final ConfigBuilder.StringValue stringValue, int width, int height) {
        return () -> {
            EditBox box = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, width - 1, height, (Component)Component.m_237113_((String)((String)stringValue.get()))){

                public boolean m_5534_(char character, int modifiers) {
                    boolean ret = super.m_5534_(character, modifiers);
                    stringValue.set(this.m_94155_());
                    return ret;
                }

                public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
                    boolean ret = super.m_7933_(keyCode, scanCode, modifiers);
                    stringValue.set(this.m_94155_());
                    return ret;
                }
            };
            box.m_94199_(1000);
            box.m_94144_((String)stringValue.get());
            box.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)stringValue.getComment())));
            return box;
        };
    }

    public static <T> Supplier<AbstractWidget> getCycleWidget(ConfigBuilder.ConfigValue<T> configValue, Collection<? extends T> values, int width, int height) {
        return () -> CycleButton.m_168894_(newValue -> Component.m_237113_((String)("" + newValue))).m_168961_(values.toArray()).m_168948_(configValue.get()).m_168929_().m_232498_(bool -> configValue.getComment() != null ? Tooltip.m_257550_((Component)Component.m_237113_((String)configValue.getComment())) : null).m_168936_(0, 0, width, height, (Component)Component.m_237119_(), (button, newValue) -> configValue.set(newValue));
    }

    public static <E extends Number> Supplier<AbstractWidget> getSliderWidget(final ConfigBuilder.NumberValue<E> numberValue, int width, int height) {
        return () -> {
            AbstractSliderButton widget = new AbstractSliderButton(0, 0, width, height, (Component)Component.m_237113_((String)("" + numberValue.get())), numberValue.normalize()){

                protected void m_5695_() {
                    this.m_93666_((Component)Component.m_237113_((String)("" + numberValue.get())));
                }

                protected void m_5697_() {
                    numberValue.fromNormalized(this.f_93577_);
                }
            };
            widget.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)numberValue.getComment())));
            return widget;
        };
    }

    public static <T> Supplier<AbstractWidget> getEditListWidget(ConfigBuilder.ListValue<T> listValue, int width, int height) {
        return () -> Button.m_253074_((Component)Component.m_237115_((String)"vivecraft.options.editlist"), button -> Minecraft.m_91087_().m_91152_((Screen)new GuiListValueEditScreen((Component)Component.m_237113_((String)listValue.getPath().substring(listValue.getPath().lastIndexOf("."))), Minecraft.m_91087_().f_91080_, listValue))).m_253046_(width, height).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)listValue.getComment()))).m_253136_();
    }
}

