/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.server;

import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.common.network.BodyPart;
import org.vivecraft.common.network.VrPlayerState;
import org.vivecraft.common.utils.MathUtils;

public class ServerVivePlayer {
    @Nullable
    public VrPlayerState vrPlayerState;
    public float draw;
    public float worldScale = 1.0f;
    public float heightScale = 1.0f;
    public BodyPart activeBodyPart = BodyPart.MAIN_HAND;
    public boolean crawling;
    private boolean isVR = false;
    public Vec3 offset = Vec3.f_82478_;
    public ServerPlayer player;
    public int networkVersion = 2;

    public ServerVivePlayer(ServerPlayer player) {
        this.player = player;
    }

    public Vec3 getBodyPartVectorCustom(BodyPart bodyPart, Vector3fc direction) {
        if (this.vrPlayerState != null) {
            if (this.isSeated() || !bodyPart.isValid(this.vrPlayerState.fbtMode())) {
                bodyPart = BodyPart.MAIN_HAND;
            }
            return new Vec3(this.vrPlayerState.getBodyPartPose(bodyPart).orientation().transform(direction, new Vector3f()));
        }
        return this.player.m_20154_();
    }

    public Vec3 getBodyPartDir(BodyPart bodyPart) {
        return this.getBodyPartVectorCustom(bodyPart, MathUtils.BACK);
    }

    public Vec3 getAimDir() {
        if (!this.isSeated() && this.draw > 0.0f) {
            return this.getBodyPartPos(this.activeBodyPart.opposite()).m_82546_(this.getBodyPartPos(this.activeBodyPart)).m_82541_();
        }
        return this.getBodyPartDir(this.activeBodyPart);
    }

    public Vec3 getHMDDir() {
        if (this.vrPlayerState != null) {
            return new Vec3(this.vrPlayerState.hmd().orientation().transform(MathUtils.BACK, new Vector3f()));
        }
        return this.player.m_20154_();
    }

    public Vec3 getHMDPos() {
        if (this.vrPlayerState != null) {
            Vector3fc hmdPos = this.vrPlayerState.hmd().position();
            return this.player.m_20182_().m_82520_(this.offset.f_82479_ + (double)hmdPos.x(), this.offset.f_82480_ + (double)hmdPos.y(), this.offset.f_82481_ + (double)hmdPos.z());
        }
        return this.player.m_20182_().m_82520_(0.0, 1.62, 0.0);
    }

    public Vec3 getBodyPartPos(BodyPart bodyPart, boolean realPosition) {
        if (this.vrPlayerState != null) {
            if (!bodyPart.isValid(this.vrPlayerState.fbtMode())) {
                bodyPart = BodyPart.MAIN_HAND;
            }
            if (this.isSeated() && !realPosition) {
                Vec3 dir = this.getHMDDir();
                dir = dir.m_82524_((float)Math.PI / 180 * (bodyPart == BodyPart.MAIN_HAND ? -35.0f : 35.0f));
                dir = new Vec3(dir.f_82479_, 0.0, dir.f_82481_);
                dir = dir.m_82541_();
                return this.getHMDPos().m_82520_(dir.f_82479_ * (double)0.3f * (double)this.worldScale, (double)(-0.4f * this.worldScale), dir.f_82481_ * (double)0.3f * (double)this.worldScale);
            }
            Vector3fc conPos = this.vrPlayerState.getBodyPartPose(bodyPart).position();
            return this.player.m_20182_().m_82520_(this.offset.f_82479_ + (double)conPos.x(), this.offset.f_82480_ + (double)conPos.y(), this.offset.f_82481_ + (double)conPos.z());
        }
        return this.player.m_20182_().m_82520_(0.0, 1.62, 0.0);
    }

    public Vec3 getBodyPartPos(BodyPart bodyPart) {
        return this.getBodyPartPos(bodyPart, false);
    }

    public boolean isVR() {
        return this.isVR;
    }

    public void setVR(boolean vr) {
        this.isVR = vr;
    }

    public boolean isSeated() {
        return this.vrPlayerState != null && this.vrPlayerState.seated();
    }
}

