/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vivecraft.client.Xplat;
import org.vivecraft.common.CommonDataHolder;
import org.vivecraft.common.network.BodyPart;
import org.vivecraft.common.network.FBTMode;
import org.vivecraft.common.network.VrPlayerState;
import org.vivecraft.common.network.packet.PayloadIdentifier;
import org.vivecraft.common.network.packet.c2s.ActiveBodyPartPayloadC2S;
import org.vivecraft.common.network.packet.c2s.CrawlPayloadC2S;
import org.vivecraft.common.network.packet.c2s.DrawPayloadC2S;
import org.vivecraft.common.network.packet.c2s.HeightPayloadC2S;
import org.vivecraft.common.network.packet.c2s.LegacyController0DataPayloadC2S;
import org.vivecraft.common.network.packet.c2s.LegacyController1DataPayloadC2S;
import org.vivecraft.common.network.packet.c2s.LegacyHeadDataPayloadC2S;
import org.vivecraft.common.network.packet.c2s.TeleportPayloadC2S;
import org.vivecraft.common.network.packet.c2s.UnknownPayloadC2S;
import org.vivecraft.common.network.packet.c2s.VRActivePayloadC2S;
import org.vivecraft.common.network.packet.c2s.VRPlayerStatePayloadC2S;
import org.vivecraft.common.network.packet.c2s.VersionPayloadC2S;
import org.vivecraft.common.network.packet.c2s.VivecraftPayloadC2S;
import org.vivecraft.common.network.packet.c2s.WorldScalePayloadC2S;
import org.vivecraft.common.network.packet.s2c.ClimbingPayloadS2C;
import org.vivecraft.common.network.packet.s2c.CrawlPayloadS2C;
import org.vivecraft.common.network.packet.s2c.DualWieldingPayloadS2C;
import org.vivecraft.common.network.packet.s2c.NetworkVersionPayloadS2C;
import org.vivecraft.common.network.packet.s2c.RequestDataPayloadS2C;
import org.vivecraft.common.network.packet.s2c.SettingOverridePayloadS2C;
import org.vivecraft.common.network.packet.s2c.TeleportPayloadS2C;
import org.vivecraft.common.network.packet.s2c.UberPacketPayloadS2C;
import org.vivecraft.common.network.packet.s2c.VRActivePayloadS2C;
import org.vivecraft.common.network.packet.s2c.VRSwitchingPayloadS2C;
import org.vivecraft.common.network.packet.s2c.VersionPayloadS2C;
import org.vivecraft.common.network.packet.s2c.VivecraftPayloadS2C;
import org.vivecraft.mixin.server.ChunkMapAccessor;
import org.vivecraft.mixin.server.TrackedEntityAccessor;
import org.vivecraft.server.ServerVRPlayers;
import org.vivecraft.server.ServerVivePlayer;
import org.vivecraft.server.config.ClimbeyBlockmode;
import org.vivecraft.server.config.ServerConfig;

public class ServerNetworking {
    private static final Map<UUID, Map<PayloadIdentifier, VivecraftPayloadC2S>> LEGACY_DATA_MAP = new HashMap<UUID, Map<PayloadIdentifier, VivecraftPayloadC2S>>();
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"VivecraftServer");

    /*
     * Unable to fully structure code
     */
    public static void handlePacket(VivecraftPayloadC2S c2sPayload, ServerPlayer player, Consumer<VivecraftPayloadS2C> packetConsumer) {
        if (c2sPayload instanceof UnknownPayloadC2S) {
            return;
        }
        vivePlayer = ServerVRPlayers.getVivePlayer(player);
        if (vivePlayer == null && c2sPayload.payloadId() != PayloadIdentifier.VERSION) {
            return;
        }
        if (vivePlayer != null) {
            vivePlayer.player = player;
        }
        switch (1.$SwitchMap$org$vivecraft$common$network$packet$PayloadIdentifier[c2sPayload.payloadId().ordinal()]) {
            case 1: {
                vivePlayer = new ServerVivePlayer(player);
                payload = (VersionPayloadC2S)c2sPayload;
                if (((Boolean)ServerConfig.DEBUG.get()).booleanValue()) {
                    ServerNetworking.LOGGER.info("Vivecraft: player '{}' joined with {}", (Object)player.m_7755_().getString(), (Object)payload.version());
                }
                if (payload.legacy()) ** GOTO lbl24
                if (0 <= payload.maxVersion() && payload.minVersion() <= 2) {
                    vivePlayer.networkVersion = Math.min(payload.maxVersion(), 2);
                    if (((Boolean)ServerConfig.DEBUG.get()).booleanValue()) {
                        ServerNetworking.LOGGER.info("Vivecraft: {} networking supported, using version {}", (Object)player.m_7755_().getString(), (Object)vivePlayer.networkVersion);
                    }
                } else {
                    player.m_213846_((Component)Component.m_237113_((String)"Unsupported vivecraft version, VR features will not work"));
                    if (((Boolean)ServerConfig.DEBUG.get()).booleanValue()) {
                        ServerNetworking.LOGGER.info("Vivecraft: {} networking not supported. client range [{},{}], server range [{},{}]", new Object[]{player.m_6302_(), payload.minVersion(), payload.maxVersion(), 0, 2});
                    }
                    return;
lbl24:
                    // 1 sources

                    vivePlayer.networkVersion = -1;
                    if (((Boolean)ServerConfig.DEBUG.get()).booleanValue()) {
                        ServerNetworking.LOGGER.info("Vivecraft: {} using legacy networking", (Object)player.m_6302_());
                    }
                }
                vivePlayer.setVR(payload.vr());
                ServerVRPlayers.getPlayersWithVivecraft(player.f_8924_).put(player.m_20148_(), vivePlayer);
                packetConsumer.accept(new VersionPayloadS2C(CommonDataHolder.getInstance().versionIdentifier));
                packetConsumer.accept(new RequestDataPayloadS2C());
                if (((Boolean)ServerConfig.CLIMBEY_ENABLED.get()).booleanValue()) {
                    packetConsumer.accept(ServerNetworking.getClimbeyServerPayload());
                }
                if (((Boolean)ServerConfig.TELEPORT_ENABLED.get()).booleanValue()) {
                    packetConsumer.accept(new TeleportPayloadS2C());
                }
                if (((Boolean)ServerConfig.TELEPORT_LIMITED_SURVIVAL.get()).booleanValue()) {
                    packetConsumer.accept(new SettingOverridePayloadS2C(Map.of("limitedTeleport", "true", "teleportLimitUp", String.valueOf(ServerConfig.TELEPORT_UP_LIMIT.get()), "teleportLimitDown", String.valueOf(ServerConfig.TELEPORT_DOWN_LIMIT.get()), "teleportLimitHoriz", String.valueOf(ServerConfig.TELEPORT_HORIZONTAL_LIMIT.get()))));
                }
                if (((Boolean)ServerConfig.WORLDSCALE_LIMITED.get()).booleanValue()) {
                    packetConsumer.accept(new SettingOverridePayloadS2C(Map.of("worldScale.min", String.valueOf(ServerConfig.WORLDSCALE_MIN.get()), "worldScale.max", String.valueOf(ServerConfig.WORLDSCALE_MAX.get()))));
                }
                if (((Boolean)ServerConfig.FORCE_THIRD_PERSON_ITEMS.get()).booleanValue()) {
                    packetConsumer.accept(new SettingOverridePayloadS2C(Map.of("thirdPersonItems", "true")));
                }
                if (((Boolean)ServerConfig.FORCE_THIRD_PERSON_ITEMS_CUSTOM.get()).booleanValue()) {
                    packetConsumer.accept(new SettingOverridePayloadS2C(Map.of("thirdPersonItemsCustom", "true")));
                }
                if (((Boolean)ServerConfig.CRAWLING_ENABLED.get()).booleanValue()) {
                    packetConsumer.accept(new CrawlPayloadS2C());
                }
                packetConsumer.accept(new VRSwitchingPayloadS2C((Boolean)ServerConfig.VR_SWITCHING_ENABLED.get() != false && (Boolean)ServerConfig.VR_ONLY.get() == false));
                if (vivePlayer.networkVersion >= 2) {
                    packetConsumer.accept(new DualWieldingPayloadS2C((Boolean)ServerConfig.DUAL_WIELDING.get()));
                }
                packetConsumer.accept(new NetworkVersionPayloadS2C(vivePlayer.networkVersion));
                break;
            }
            case 2: {
                payload = (VRActivePayloadC2S)c2sPayload;
                if (vivePlayer.isVR() == payload.vr()) break;
                vivePlayer.setVR(vivePlayer.isVR() == false);
                if (vivePlayer.isVR()) break;
                ServerNetworking.sendPacketToTrackingPlayers(vivePlayer, new VRActivePayloadS2C(false, player.m_20148_()));
                break;
            }
            case 3: {
                vivePlayer.draw = ((DrawPayloadC2S)c2sPayload).draw();
                break;
            }
            case 4: {
                vivePlayer.vrPlayerState = ((VRPlayerStatePayloadC2S)c2sPayload).playerState();
                break;
            }
            case 5: {
                vivePlayer.worldScale = ((WorldScalePayloadC2S)c2sPayload).worldScale();
                break;
            }
            case 6: {
                vivePlayer.heightScale = ((HeightPayloadC2S)c2sPayload).heightScale();
                break;
            }
            case 7: {
                payload = (TeleportPayloadC2S)c2sPayload;
                player.m_19890_((double)payload.x(), (double)payload.y(), (double)payload.z(), player.m_146908_(), player.m_146909_());
                break;
            }
            case 8: {
                player.f_19789_ = 0.0f;
                player.f_8906_.f_9737_ = 0;
                break;
            }
            case 9: {
                v0 = newBodyPart = vivePlayer.isSeated() != false ? BodyPart.MAIN_HAND : ((ActiveBodyPartPayloadC2S)c2sPayload).bodyPart();
                if (vivePlayer.activeBodyPart == newBodyPart) break;
                oldItem = player.m_6844_(EquipmentSlot.MAINHAND);
                vivePlayer.activeBodyPart = newBodyPart;
                newItem = player.m_6844_(EquipmentSlot.MAINHAND);
                if (!player.m_246525_(oldItem, newItem)) break;
                if (!oldItem.m_41619_()) {
                    player.m_21204_().m_22161_(oldItem.m_41638_(EquipmentSlot.MAINHAND));
                }
                if (newItem.m_41619_()) break;
                player.m_21204_().m_22178_(newItem.m_41638_(EquipmentSlot.MAINHAND));
                break;
            }
            case 10: {
                vivePlayer.crawling = ((CrawlPayloadC2S)c2sPayload).crawling();
                if (!vivePlayer.crawling) break;
                player.m_20124_(Pose.SWIMMING);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                playerData = ServerNetworking.LEGACY_DATA_MAP.get(player.m_20148_());
                if (playerData == null) {
                    playerData = new HashMap<PayloadIdentifier, VivecraftPayloadC2S>();
                    ServerNetworking.LEGACY_DATA_MAP.put(player.m_20148_(), playerData);
                }
                playerData.put(c2sPayload.payloadId(), c2sPayload);
                if (playerData.size() != 3) break;
                controller0Data = (LegacyController0DataPayloadC2S)playerData.get((Object)PayloadIdentifier.CONTROLLER0DATA);
                controller1Data = (LegacyController1DataPayloadC2S)playerData.get((Object)PayloadIdentifier.CONTROLLER1DATA);
                headData = (LegacyHeadDataPayloadC2S)playerData.get((Object)PayloadIdentifier.HEADDATA);
                vivePlayer.vrPlayerState = new VrPlayerState(headData.seated(), headData.hmdPose(), controller0Data.leftHanded(), controller0Data.mainHand(), controller1Data.leftHanded(), controller1Data.offHand(), FBTMode.ARMS_ONLY, null, null, null, null, null, null, null);
                ServerNetworking.LEGACY_DATA_MAP.remove(player.m_20148_());
                break;
            }
            default: {
                throw new IllegalStateException("Vivecraft: got unexpected packet on server: " + c2sPayload.payloadId());
            }
        }
    }

    public static VivecraftPayloadS2C getClimbeyServerPayload() {
        ArrayList<String> blocks = null;
        if (ServerConfig.CLIMBEY_BLOCKMODE.get() != ClimbeyBlockmode.DISABLED) {
            blocks = new ArrayList<String>();
            for (String block : (List)ServerConfig.CLIMBEY_BLOCKLIST.get()) {
                try {
                    Block b = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(block));
                    if (b == Blocks.f_50016_) continue;
                    blocks.add(block);
                }
                catch (ResourceLocationException resourceLocationException) {}
            }
        }
        return new ClimbingPayloadS2C(true, (ClimbeyBlockmode)((Object)ServerConfig.CLIMBEY_BLOCKMODE.get()), blocks);
    }

    public static void sendVrPlayerStateToClients(ServerVivePlayer vivePlayer) {
        Packet<?> legacyPacket = Xplat.getS2CPacket(new UberPacketPayloadS2C(vivePlayer.player.m_20148_(), new VrPlayerState(vivePlayer.vrPlayerState, 0), vivePlayer.worldScale, vivePlayer.heightScale));
        Packet<?> newPacket = Xplat.getS2CPacket(new UberPacketPayloadS2C(vivePlayer.player.m_20148_(), vivePlayer.vrPlayerState, vivePlayer.worldScale, vivePlayer.heightScale));
        ServerNetworking.sendPacketToTrackingPlayers(vivePlayer, (Integer version) -> version < 1 ? legacyPacket : newPacket);
    }

    public static Set<ServerPlayerConnection> getTrackingPlayers(ServerPlayer player) {
        ChunkMap chunkMap = player.m_284548_().m_7726_().f_8325_;
        TrackedEntityAccessor playerTracker = (TrackedEntityAccessor)((ChunkMapAccessor)chunkMap).getTrackedEntities().get(player.m_19879_());
        return playerTracker != null ? Collections.unmodifiableSet(playerTracker.getPlayersTracking()) : Collections.emptySet();
    }

    private static void sendPacketToTrackingPlayers(ServerVivePlayer vivePlayer, VivecraftPayloadS2C payload) {
        Packet<?> packet = Xplat.getS2CPacket(payload);
        ServerNetworking.sendPacketToTrackingPlayers(vivePlayer, (Integer v) -> packet);
    }

    private static void sendPacketToTrackingPlayers(ServerVivePlayer vivePlayer, Function<Integer, Packet<?>> packetProvider) {
        Map<UUID, ServerVivePlayer> vivePlayers = ServerVRPlayers.getPlayersWithVivecraft(vivePlayer.player.f_8924_);
        for (ServerPlayerConnection trackedPlayer : ServerNetworking.getTrackingPlayers(vivePlayer.player)) {
            if (!vivePlayers.containsKey(trackedPlayer.m_142253_().m_20148_()) || trackedPlayer.m_142253_() == vivePlayer.player) continue;
            trackedPlayer.m_9829_(packetProvider.apply(vivePlayer.networkVersion));
        }
        if (((Boolean)ServerConfig.SEND_DATA_TO_OWNER.get()).booleanValue() || Xplat.isModLoaded("replaymod") || Xplat.isModLoaded("reforgedplaymod") || Xplat.isModLoaded("flashback")) {
            vivePlayer.player.f_8906_.m_9829_(packetProvider.apply(vivePlayer.networkVersion));
        }
    }
}

