/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.world.entity.projectile;

import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.vivecraft.server.ServerVRPlayers;
import org.vivecraft.server.ServerVivePlayer;

@Mixin(value={Projectile.class})
public class ProjectileMixin {
    @ModifyVariable(method={"shootFromRotation"}, at=@At(value="HEAD"), ordinal=3, argsOnly=true)
    private float vivecraft$modifyVelocity(float velocity, Entity shooter, @Share(value="dir") LocalRef<Vec3> direction) {
        ServerPlayer player;
        ServerVivePlayer serverVivePlayer;
        if (shooter instanceof ServerPlayer && (serverVivePlayer = ServerVRPlayers.getVivePlayer(player = (ServerPlayer)shooter)) != null && serverVivePlayer.isVR()) {
            Projectile projectile = (Projectile)this;
            direction.set((Object)serverVivePlayer.getAimDir());
            if (projectile instanceof AbstractArrow && !(projectile instanceof ThrownTrident) && !serverVivePlayer.isSeated() && serverVivePlayer.draw > 0.0f) {
                return velocity * serverVivePlayer.draw;
            }
        }
        return velocity;
    }

    @ModifyVariable(method={"shootFromRotation"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private float vivecraft$modifyXRot(float xRot, @Share(value="dir") LocalRef<Vec3> direction) {
        if (direction.get() != null) {
            return -((float)Math.toDegrees(Math.asin(((Vec3)direction.get()).f_82480_ / ((Vec3)direction.get()).m_82553_())));
        }
        return xRot;
    }

    @ModifyVariable(method={"shootFromRotation"}, at=@At(value="HEAD"), ordinal=1, argsOnly=true)
    private float vivecraft$modifyYRot(float yRot, @Share(value="dir") LocalRef<Vec3> direction) {
        if (direction.get() != null) {
            return (float)Math.toDegrees(Math.atan2(-((Vec3)direction.get()).f_82479_, ((Vec3)direction.get()).f_82481_));
        }
        return yRot;
    }
}

