/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.server;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.IllegalFormatException;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.vivecraft.client.Xplat;
import org.vivecraft.mixin.world.entity.PlayerMixin;
import org.vivecraft.server.ServerNetworking;
import org.vivecraft.server.ServerVRPlayers;
import org.vivecraft.server.ServerVivePlayer;
import org.vivecraft.server.config.ServerConfig;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends PlayerMixin {
    @Shadow
    @Final
    public MinecraftServer f_8924_;

    protected ServerPlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"initInventoryMenu"}, at={@At(value="TAIL")})
    private void vivecraft$addItemEasterEgg(CallbackInfo ci) {
        ServerVivePlayer serverVivePlayer = this.vivecraft$getVivePlayer();
        if (((Boolean)ServerConfig.VR_FUN.get()).booleanValue() && serverVivePlayer != null && serverVivePlayer.isVR() && this.f_19796_.m_188503_(40) == 3) {
            ItemStack easterEggItem;
            if (this.f_19796_.m_188503_(2) == 1) {
                easterEggItem = new ItemStack((ItemLike)Items.f_42687_);
                easterEggItem.m_41714_((Component)Component.m_237113_((String)"EAT ME"));
            } else {
                easterEggItem = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_);
                easterEggItem.m_41714_((Component)Component.m_237113_((String)"DRINK ME"));
            }
            easterEggItem.m_41784_().m_128405_("HideFlags", 32);
            if (this.m_150109_().m_36054_(easterEggItem)) {
                this.f_36095_.m_38946_();
            }
        }
    }

    @Inject(method={"doTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;tick()V", shift=At.Shift.AFTER)})
    private void vivecraft$overridePose(CallbackInfo ci) {
        ServerVRPlayers.overridePose((ServerPlayer)this);
    }

    @Override
    protected int vivecraft$modifySweepParticleSpawnPos(ServerLevel instance, ParticleOptions type, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed, Operation<Integer> original) {
        ServerVivePlayer serverVivePlayer = this.vivecraft$getVivePlayer();
        if (!Xplat.isFakePlayer((ServerPlayer)this) && serverVivePlayer != null && serverVivePlayer.isVR()) {
            Vec3 aim = serverVivePlayer.getBodyPartDir(serverVivePlayer.activeBodyPart);
            float yaw = (float)Math.atan2(-aim.f_82479_, aim.f_82481_);
            xOffset = -Mth.m_14031_((float)yaw);
            zOffset = Mth.m_14089_((float)yaw);
            Vec3 pos = serverVivePlayer.getBodyPartPos(serverVivePlayer.activeBodyPart);
            return (Integer)original.call(new Object[]{instance, type, pos.f_82479_ + xOffset, pos.f_82480_, pos.f_82481_ + zOffset, particleCount, xOffset, yOffset, zOffset, speed});
        }
        return (Integer)original.call(new Object[]{instance, type, posX, posY, posZ, particleCount, xOffset, yOffset, zOffset, speed});
    }

    @Override
    protected float vivecraft$damageModifier(float damage) {
        ServerVivePlayer vivePlayer;
        if (((Boolean)ServerConfig.DUAL_WIELDING.get()).booleanValue() && (Double)ServerConfig.BOOTS_ARMOR_DAMAGE.get() > 0.0 && (vivePlayer = this.vivecraft$getVivePlayer()).isVR() && vivePlayer.activeBodyPart.isFoot() && !this.m_6844_(EquipmentSlot.FEET).m_41619_()) {
            float addedDamage = 0.0f;
            for (AttributeModifier modifier : this.m_6844_(EquipmentSlot.FEET).m_41720_().m_7167_(EquipmentSlot.FEET).get((Object)Attributes.f_22284_)) {
                float amount = (float)modifier.m_22218_();
                switch (modifier.m_22217_()) {
                    case ADDITION: {
                        addedDamage += amount;
                        break;
                    }
                    case MULTIPLY_TOTAL: {
                        addedDamage += amount * addedDamage;
                    }
                }
            }
            return damage + addedDamage * ((Double)ServerConfig.BOOTS_ARMOR_DAMAGE.get()).floatValue();
        }
        return damage;
    }

    @Inject(method={"drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addFreshEntity(Lnet/minecraft/world/entity/Entity;)Z")})
    private void vivecraft$dropVive(ItemStack droppedItem, boolean dropAround, boolean includeThrowerName, CallbackInfoReturnable<ItemEntity> cir, @Local ItemEntity item) {
        ServerVivePlayer serverVivePlayer = this.vivecraft$getVivePlayer();
        if (!Xplat.isFakePlayer((ServerPlayer)this) && !dropAround && serverVivePlayer != null && serverVivePlayer.isVR()) {
            Vec3 pos = serverVivePlayer.getBodyPartPos(serverVivePlayer.activeBodyPart);
            Vec3 aim = serverVivePlayer.getBodyPartDir(serverVivePlayer.activeBodyPart);
            float speed = 0.3f;
            item.m_20334_(aim.f_82479_ * (double)0.3f, aim.f_82480_ * (double)0.3f, aim.f_82481_ * (double)0.3f);
            item.m_6034_(pos.f_82479_ + item.m_20184_().f_82479_, pos.f_82480_ + item.m_20184_().f_82480_, pos.f_82481_ + item.m_20184_().f_82481_);
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$checkCanGetHurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        Entity entity = source.m_7639_();
        ServerPlayer other = null;
        if (entity instanceof ServerPlayer) {
            other = (ServerPlayer)entity;
        } else if (entity instanceof AbstractArrow && ((AbstractArrow)entity).m_19749_() instanceof ServerPlayer) {
            other = (ServerPlayer)((AbstractArrow)entity).m_19749_();
        }
        if (other != null) {
            ServerVivePlayer otherVive = ServerVRPlayers.getVivePlayer(other);
            ServerVivePlayer thisVive = this.vivecraft$getVivePlayer();
            if (otherVive == null) {
                otherVive = new ServerVivePlayer(other);
            }
            if (thisVive == null) {
                thisVive = new ServerVivePlayer((ServerPlayer)this);
            }
            boolean blockedDamage = false;
            String blockedDamageCase = "";
            if (!otherVive.isVR() && thisVive.isVR() && thisVive.isSeated() || !thisVive.isVR() && otherVive.isVR() && otherVive.isSeated()) {
                if (!((Boolean)ServerConfig.PVP_SEATEDVR_VS_NONVR.get()).booleanValue()) {
                    blockedDamage = true;
                    blockedDamageCase = "canceled nonvr vs seated VR damage";
                }
            } else if (!otherVive.isVR() && thisVive.isVR() && !thisVive.isSeated() || !thisVive.isVR() && otherVive.isVR() && !otherVive.isSeated()) {
                if (!((Boolean)ServerConfig.PVP_VR_VS_NONVR.get()).booleanValue()) {
                    blockedDamage = true;
                    blockedDamageCase = "canceled nonvr vs standing VR damage";
                }
            } else if (otherVive.isVR() && otherVive.isSeated() && thisVive.isVR() && !thisVive.isSeated() || thisVive.isVR() && thisVive.isSeated() && otherVive.isVR() && !otherVive.isSeated()) {
                if (!((Boolean)ServerConfig.PVP_VR_VS_SEATEDVR.get()).booleanValue()) {
                    blockedDamage = true;
                    blockedDamageCase = "canceled seated VR vs standing VR damage";
                }
            } else if (otherVive.isVR() && !otherVive.isSeated() && thisVive.isVR() && !thisVive.isSeated()) {
                if (!((Boolean)ServerConfig.PVP_VR_VS_VR.get()).booleanValue()) {
                    blockedDamage = true;
                    blockedDamageCase = "canceled standing VR vs standing VR damage";
                }
            } else if (otherVive.isVR() && otherVive.isSeated() && thisVive.isVR() && thisVive.isSeated() && !((Boolean)ServerConfig.PVP_SEATEDVR_VS_SEATEDVR.get()).booleanValue()) {
                blockedDamage = true;
                blockedDamageCase = "canceled seated VR vs seated VR damage";
            }
            if (blockedDamage) {
                if (((Boolean)ServerConfig.PVP_NOTIFY_BLOCKED_DAMAGE.get()).booleanValue()) {
                    other.m_213846_((Component)Component.m_237113_((String)blockedDamageCase));
                }
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"die"}, at={@At(value="HEAD")})
    private void vivecraft$customDeathMessage(DamageSource damageSource, CallbackInfo ci) {
        if (((Boolean)ServerConfig.MESSAGES_ENABLED.get()).booleanValue()) {
            ServerVivePlayer vivePlayer = ServerVRPlayers.getVivePlayer((ServerPlayer)this);
            String message = "";
            String entity = "";
            if (damageSource.m_7639_() != null) {
                entity = damageSource.m_7639_().m_7755_().m_6879_().getString();
                message = vivePlayer == null ? (String)ServerConfig.MESSAGES_DEATH_BY_MOB_VANILLA.get() : (!vivePlayer.isVR() ? (String)ServerConfig.MESSAGES_DEATH_BY_MOB_NONVR.get() : (vivePlayer.isSeated() ? (String)ServerConfig.MESSAGES_DEATH_BY_MOB_SEATED.get() : (String)ServerConfig.MESSAGES_DEATH_BY_MOB_VR.get()));
            }
            if (message.isEmpty()) {
                message = vivePlayer == null ? (String)ServerConfig.MESSAGES_DEATH_VANILLA.get() : (!vivePlayer.isVR() ? (String)ServerConfig.MESSAGES_DEATH_NONVR.get() : (vivePlayer.isSeated() ? (String)ServerConfig.MESSAGES_DEATH_SEATED.get() : (String)ServerConfig.MESSAGES_DEATH_VR.get()));
            }
            if (!message.isEmpty()) {
                try {
                    this.f_8924_.m_6846_().m_240416_((Component)Component.m_237113_((String)message.formatted(this.m_7755_().getString(), entity)), false);
                }
                catch (IllegalFormatException e) {
                    ServerNetworking.LOGGER.error("Vivecraft: Death message '{}' has errors:", (Object)message, (Object)e);
                }
            }
        }
    }

    @Unique
    private ServerVivePlayer vivecraft$getVivePlayer() {
        return ServerVRPlayers.getVivePlayer((ServerPlayer)this);
    }
}

