/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client_vr.renderer;

import com.mojang.blaze3d.pipeline.RenderTarget;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.vivecraft.client.extensions.RenderTargetExtension;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.MultiPassRenderTarget;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.render.RenderPass;
import org.vivecraft.client_xr.render_pass.RenderPassManager;
import org.vivecraft.client_xr.render_pass.RenderPassType;
import org.vivecraft.client_xr.render_pass.WorldRenderPass;

@Mixin(value={PostChain.class})
public class PostChainVRMixin {
    @Shadow
    @Final
    private RenderTarget f_110006_;
    @Unique
    private final EnumMap<RenderPass, PostChain> vivecraft$VRPostChains = new EnumMap(RenderPass.class);

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void vivecraft$createVRChains(TextureManager textureManager, ResourceManager resourceManager, RenderTarget screenTarget, ResourceLocation name, CallbackInfo ci) throws IOException {
        if (VRState.VR_INITIALIZED && this.f_110006_ == RenderPassManager.INSTANCE.vanillaRenderTarget) {
            for (RenderPass pass : RenderPass.values()) {
                if (pass == RenderPass.GUI) {
                    this.vivecraft$VRPostChains.put(pass, new PostChain(textureManager, resourceManager, GuiHandler.GUI_FRAMEBUFFER, name));
                    continue;
                }
                if (WorldRenderPass.getByRenderPass(pass) == null) continue;
                this.vivecraft$VRPostChains.put(pass, new PostChain(textureManager, resourceManager, WorldRenderPass.getByRenderPass((RenderPass)pass).target, name));
            }
        }
    }

    @Inject(method={"getTempTarget"}, at={@At(value="RETURN")}, cancellable=true)
    private void vivecraft$getVRTempTarget(String attributeName, CallbackInfoReturnable<RenderTarget> cir) {
        if (VRState.VR_INITIALIZED && !this.vivecraft$VRPostChains.isEmpty()) {
            EnumMap<RenderPass, RenderTarget> vrTargets = new EnumMap<RenderPass, RenderTarget>(RenderPass.class);
            for (Map.Entry<RenderPass, PostChain> entry : this.vivecraft$VRPostChains.entrySet()) {
                vrTargets.put(entry.getKey(), entry.getValue().m_110036_(attributeName));
            }
            cir.setReturnValue((Object)new MultiPassRenderTarget((RenderTarget)cir.getReturnValue(), vrTargets));
        }
    }

    @ModifyVariable(method={"addTempTarget"}, at=@At(value="STORE"), ordinal=0)
    private RenderTarget vivecraft$vrTargetStencil(RenderTarget renderTarget) {
        if (((RenderTargetExtension)this.f_110006_).vivecraft$hasStencil()) {
            ((RenderTargetExtension)renderTarget).vivecraft$setStencil(true);
            renderTarget.m_83941_(renderTarget.f_83915_, renderTarget.f_83916_, Minecraft.f_91002_);
        }
        return renderTarget;
    }

    @Inject(method={"close"}, at={@At(value="TAIL")})
    private void vivecraft$closeVRChains(CallbackInfo ci) {
        for (PostChain postChain : this.vivecraft$VRPostChains.values()) {
            postChain.close();
        }
        this.vivecraft$VRPostChains.clear();
    }

    @Inject(method={"resize"}, at={@At(value="TAIL")})
    private void vivecraft$resizeVRChains(CallbackInfo ci) {
        for (Map.Entry<RenderPass, PostChain> entry : this.vivecraft$VRPostChains.entrySet()) {
            RenderTarget target = entry.getKey() == RenderPass.GUI ? GuiHandler.GUI_FRAMEBUFFER : WorldRenderPass.getByRenderPass((RenderPass)entry.getKey()).target;
            entry.getValue().m_110025_(target.f_83915_, target.f_83916_);
        }
    }

    @Inject(method={"process"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$renderVRChain(float partialTick, CallbackInfo ci) {
        if (!RenderPassType.isVanilla() && this.vivecraft$VRPostChains.containsKey((Object)ClientDataHolderVR.getInstance().currentPass)) {
            this.vivecraft$VRPostChains.get((Object)ClientDataHolderVR.getInstance().currentPass).m_110023_(partialTick);
            ci.cancel();
        }
    }
}

