/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client_vr.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.extensions.EntityRenderDispatcherVRExtension;
import org.vivecraft.client_vr.gameplay.trackers.BowTracker;
import org.vivecraft.client_vr.gameplay.trackers.ClimbTracker;
import org.vivecraft.client_vr.gameplay.trackers.TelescopeTracker;
import org.vivecraft.client_vr.render.RenderPass;
import org.vivecraft.client_vr.render.VRArmRenderer;
import org.vivecraft.client_vr.render.VivecraftItemRendering;
import org.vivecraft.client_vr.render.helpers.VREffectsHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.mod_compat_vr.optifine.OptifineHelper;

@Mixin(value={ItemInHandRenderer.class}, priority=999)
public abstract class ItemInHandRendererVRMixin {
    @Final
    @Shadow
    private Minecraft f_109299_;
    @Final
    @Shadow
    private EntityRenderDispatcher f_109306_;
    @Final
    @Shadow
    private ItemRenderer f_109307_;
    @Shadow
    private float f_109303_;
    @Shadow
    private float f_109302_;
    @Shadow
    private float f_109305_;
    @Shadow
    private float f_109304_;

    @Shadow
    public abstract void m_269530_(LivingEntity var1, ItemStack var2, ItemDisplayContext var3, boolean var4, PoseStack var5, MultiBufferSource var6, int var7);

    @Shadow
    protected abstract void m_109366_(PoseStack var1, MultiBufferSource var2, int var3, ItemStack var4);

    @Shadow
    protected abstract void m_109346_(PoseStack var1, MultiBufferSource var2, int var3, float var4, float var5, HumanoidArm var6);

    @Inject(method={"renderPlayerArm"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$overrideArm(PoseStack poseStack, MultiBufferSource buffer, int combinedLight, float equippedProgress, float swingProgress, HumanoidArm side, CallbackInfo ci) {
        if (VRState.VR_RUNNING) {
            this.vivecraft$vrPlayerArm(poseStack, buffer, combinedLight, swingProgress, side);
            ci.cancel();
        }
    }

    @Inject(method={"renderArmWithItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$overrideArmItem(AbstractClientPlayer player, float partialTick, float pitch, InteractionHand hand, float swingProgress, ItemStack itemStack, float equippedProgress, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, CallbackInfo ci) {
        if (VRState.VR_RUNNING) {
            this.vivecraft$vrRenderArmWithItem(player, partialTick, hand, swingProgress, itemStack, poseStack, buffer, combinedLight);
            ci.cancel();
        }
    }

    @Unique
    private void vivecraft$vrRenderArmWithItem(AbstractClientPlayer player, float partialTick, InteractionHand hand, float swingProgress, ItemStack itemStack, PoseStack poseStack, MultiBufferSource buffer, int combinedLight) {
        boolean renderArm;
        ClientDataHolderVR dh = ClientDataHolderVR.getInstance();
        boolean mainHand = hand == InteractionHand.MAIN_HAND;
        HumanoidArm side = mainHand ? player.m_5737_() : player.m_5737_().m_20828_();
        float equippedProgress = this.vivecraft$getEquipProgress(hand, partialTick);
        poseStack.m_85836_();
        boolean bl = renderArm = dh.currentPass != RenderPass.THIRD || dh.vrSettings.mixedRealityRenderHands;
        if (RenderPass.isFirstPerson(dh.currentPass)) {
            renderArm &= dh.vrSettings.showPlayerHands;
        }
        if (dh.currentPass == RenderPass.CAMERA) {
            renderArm = false;
        }
        if (BowTracker.isBow(itemStack) && dh.bowTracker.isActive((LocalPlayer)player)) {
            renderArm = false;
        }
        if (TelescopeTracker.isTelescope(itemStack) && (hand == InteractionHand.OFF_HAND && dh.currentPass == RenderPass.SCOPEL || hand == InteractionHand.MAIN_HAND && dh.currentPass == RenderPass.SCOPER)) {
            renderArm = false;
        }
        if (RenderPass.isFirstPerson(dh.currentPass) && ClientDataHolderVR.getInstance().vrSettings.shouldRenderSelf && ClientDataHolderVR.getInstance().vrSettings.modelArmsMode == VRSettings.ModelArmsMode.COMPLETE) {
            renderArm = false;
        }
        if (renderArm && !player.m_20145_()) {
            this.m_109346_(poseStack, buffer, combinedLight, equippedProgress, swingProgress, side);
        }
        if (!itemStack.m_41619_()) {
            ItemDisplayContext itemDisplayContext;
            boolean isBow;
            poseStack.m_85836_();
            if (player.f_20912_ == hand) {
                this.vivecraft$transformFirstPersonVR(poseStack, side, swingProgress);
            }
            VivecraftItemRendering.VivecraftItemTransformType transformType = VivecraftItemRendering.getTransformType(itemStack, player, this.f_109307_);
            boolean useLeftHandModelinLeftHand = false;
            if (ClimbTracker.isClaws(itemStack) && dh.vrSettings.reverseHands) {
                mainHand = !mainHand;
            }
            boolean hasCMD = itemStack.m_41782_() && itemStack.m_41783_().m_128451_("CustomModelData") != 0 && transformType != VivecraftItemRendering.VivecraftItemTransformType.Crossbow && transformType != VivecraftItemRendering.VivecraftItemTransformType.Spear && transformType != VivecraftItemRendering.VivecraftItemTransformType.Shield;
            boolean bl2 = isBow = BowTracker.isBow(itemStack) && dh.bowTracker.isActive((LocalPlayer)player);
            if (ClimbTracker.isClaws(itemStack) || !isBow && (ClientNetworking.isThirdPersonItems() || hasCMD && ClientNetworking.isThirdPersonItemsCustom())) {
                useLeftHandModelinLeftHand = true;
                VivecraftItemRendering.applyThirdPersonItemTransforms(poseStack, transformType, mainHand, player, equippedProgress, partialTick, itemStack, hand);
                itemDisplayContext = mainHand || !useLeftHandModelinLeftHand ? ItemDisplayContext.THIRD_PERSON_RIGHT_HAND : ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
            } else {
                VivecraftItemRendering.applyFirstPersonItemTransforms(poseStack, transformType, mainHand, player, equippedProgress, partialTick, itemStack, hand);
                ItemDisplayContext itemDisplayContext2 = itemDisplayContext = mainHand || !useLeftHandModelinLeftHand ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : ItemDisplayContext.FIRST_PERSON_LEFT_HAND;
            }
            if (transformType == VivecraftItemRendering.VivecraftItemTransformType.Map) {
                RenderSystem.disableCull();
                this.m_109366_(poseStack, buffer, combinedLight, itemStack);
            } else if (transformType == VivecraftItemRendering.VivecraftItemTransformType.Telescope) {
                if (dh.currentPass != RenderPass.SCOPEL && dh.currentPass != RenderPass.SCOPER) {
                    poseStack.m_85836_();
                    this.m_269530_((LivingEntity)player, itemStack, itemDisplayContext, !mainHand && useLeftHandModelinLeftHand, poseStack, buffer, combinedLight);
                    if (ClientNetworking.isThirdPersonItems()) {
                        poseStack.m_252880_(0.0f, 0.219f, 0.0f);
                    } else {
                        poseStack.m_252880_(0.0f, 0.344f, 0.0f);
                    }
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                    if (OptifineHelper.isOptifineLoaded() && OptifineHelper.isShaderActive()) {
                        OptifineHelper.endEntities();
                    }
                    VREffectsHelper.drawScopeFB(poseStack, hand == InteractionHand.MAIN_HAND ? 0 : 1);
                    if (OptifineHelper.isOptifineLoaded() && OptifineHelper.isShaderActive()) {
                        OptifineHelper.beginEntities();
                    }
                    poseStack.m_85849_();
                }
            } else {
                this.m_269530_((LivingEntity)player, itemStack, itemDisplayContext, !mainHand && useLeftHandModelinLeftHand, poseStack, buffer, combinedLight);
            }
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    @Unique
    private float vivecraft$getEquipProgress(InteractionHand hand, float partialTick) {
        return hand == InteractionHand.MAIN_HAND ? 1.0f - Mth.m_14179_((float)partialTick, (float)this.f_109303_, (float)this.f_109302_) : 1.0f - Mth.m_14179_((float)partialTick, (float)this.f_109305_, (float)this.f_109304_);
    }

    @Unique
    private void vivecraft$vrPlayerArm(PoseStack poseStack, MultiBufferSource buffer, int combinedLight, float swingProgress, HumanoidArm side) {
        LocalPlayer player = this.f_109299_.f_91074_;
        boolean rightHand = side == HumanoidArm.RIGHT;
        boolean mainHand = side == player.m_5737_();
        float offsetDirection = rightHand ? 1.0f : -1.0f;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)player.m_108560_());
        VRArmRenderer vrArmRenderer = ((EntityRenderDispatcherVRExtension)this.f_109306_).vivecraft$getArmSkinMap().get(player.m_108564_());
        poseStack.m_85836_();
        if (player.f_20912_ == InteractionHand.MAIN_HAND && mainHand) {
            this.vivecraft$transformFirstPersonVR(poseStack, side, swingProgress);
        }
        if (player.f_20912_ == InteractionHand.OFF_HAND && !mainHand) {
            this.vivecraft$transformFirstPersonVR(poseStack, side, swingProgress);
        }
        poseStack.m_85841_(0.4f, 0.4f, 0.4f);
        boolean slim = player.m_108564_().equals("slim");
        poseStack.m_252880_((slim ? -0.34375f : -0.375f) * offsetDirection, 0.0f, 0.75f);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        if (rightHand) {
            vrArmRenderer.m_117770_(poseStack, buffer, combinedLight, (AbstractClientPlayer)player);
        } else {
            vrArmRenderer.m_117813_(poseStack, buffer, combinedLight, (AbstractClientPlayer)player);
        }
        poseStack.m_85849_();
    }

    @Unique
    private void vivecraft$transformFirstPersonVR(PoseStack poseStack, HumanoidArm side, float swingProgress) {
        if (swingProgress == 0.0f) {
            return;
        }
        switch (ClientDataHolderVR.getInstance().swingType) {
            case Attack: {
                float forwardRotation = swingProgress > 0.5f ? Mth.m_14031_((float)(swingProgress * (float)Math.PI + (float)Math.PI)) : Mth.m_14031_((float)(swingProgress * 3.0f * (float)Math.PI));
                poseStack.m_252880_(0.0f, 0.0f, 0.2f);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(forwardRotation * 30.0f));
                poseStack.m_252880_(0.0f, 0.0f, -0.2f);
                break;
            }
            case Interact: {
                float sideRotation = swingProgress > 0.5f ? Mth.m_14031_((float)(swingProgress * (float)Math.PI + (float)Math.PI)) : Mth.m_14031_((float)(swingProgress * 3.0f * (float)Math.PI));
                poseStack.m_252781_(Axis.f_252403_.m_252977_((side == HumanoidArm.RIGHT ? -1.0f : 1.0f) * sideRotation * 45.0f));
                break;
            }
            case Use: {
                float forwardMovement = swingProgress > 0.25f ? Mth.m_14031_((float)(swingProgress / 2.0f * (float)Math.PI + (float)Math.PI)) : Mth.m_14031_((float)(swingProgress * 2.0f * (float)Math.PI));
                poseStack.m_252880_(0.0f, 0.0f, -(1.0f + forwardMovement) * 0.1f);
            }
        }
    }
}

