/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client_vr.multiplayer;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.settings.VRSettings;

@Mixin(value={ClientPacketListener.class})
public abstract class ClientPacketListenerVRMixin {
    @Unique
    private String vivecraft$lastMsg = null;
    @Final
    @Shadow
    private Minecraft f_104888_;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void vivecraft$init(CallbackInfo ci) {
        if (ClientNetworking.NEEDS_RESET) {
            ClientNetworking.resetServerSettings();
            ClientNetworking.DISPLAYED_CHAT_MESSAGE = false;
            ClientNetworking.DISPLAYED_CHAT_WARNING = false;
            ClientNetworking.NEEDS_RESET = false;
        }
    }

    @Inject(method={"handleLogin"}, at={@At(value="TAIL")})
    private void vivecraft$resetOnLogin(CallbackInfo ci) {
        ClientNetworking.resetServerSettings();
        ClientNetworking.sendVersionInfo();
        if (VRState.VR_INITIALIZED) {
            ClientDataHolderVR.getInstance().vrPlayer.chatWarningTimer = 200;
            ClientDataHolderVR.getInstance().vrPlayer.teleportWarning = true;
            ClientDataHolderVR.getInstance().vrPlayer.vrSwitchWarning = false;
        }
    }

    @Inject(method={"handleRespawn"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;setLevel(Lnet/minecraft/client/multiplayer/ClientLevel;)V", shift=At.Shift.AFTER)})
    private void vivecraft$resetOnDimensionChange(CallbackInfo ci) {
        ClientNetworking.resetServerSettings();
        ClientNetworking.sendVersionInfo();
        if (VRState.VR_INITIALIZED) {
            ClientDataHolderVR.getInstance().vrPlayer.chatWarningTimer = 200;
            ClientDataHolderVR.getInstance().vrPlayer.teleportWarning = true;
            ClientDataHolderVR.getInstance().vrPlayer.vrSwitchWarning = false;
        }
    }

    @Inject(method={"close"}, at={@At(value="TAIL")})
    private void vivecraft$cleanup(CallbackInfo ci) {
        ClientNetworking.resetServerSettings();
        ClientNetworking.DISPLAYED_CHAT_MESSAGE = false;
        ClientNetworking.DISPLAYED_CHAT_WARNING = false;
        ClientNetworking.NEEDS_RESET = true;
    }

    @Inject(method={"sendChat"}, at={@At(value="TAIL")})
    private void vivecraft$storeChatMsg(String message, CallbackInfo ci) {
        this.vivecraft$lastMsg = message;
    }

    @Inject(method={"sendCommand"}, at={@At(value="TAIL")})
    private void vivecraft$storeCommandMsg(String command, CallbackInfo ci) {
        this.vivecraft$lastMsg = command;
    }

    @Inject(method={"handlePlayerChat"}, at={@At(value="TAIL")})
    private void vivecraft$chatHapticsPlayer(ClientboundPlayerChatPacket packet, CallbackInfo ci) {
        if (VRState.VR_RUNNING && (this.f_104888_.f_91074_ == null || this.vivecraft$lastMsg == null || packet.f_243918_() == this.f_104888_.f_91074_.m_20148_())) {
            this.vivecraft$triggerHapticSound();
        }
        this.vivecraft$lastMsg = null;
    }

    @Inject(method={"handleSystemChat"}, at={@At(value="TAIL")})
    private void vivecraft$chatHapticsSystem(ClientboundSystemChatPacket packet, CallbackInfo ci) {
        if (VRState.VR_RUNNING && (this.f_104888_.f_91074_ == null || this.vivecraft$lastMsg == null || packet.f_237849_().getString().contains(this.vivecraft$lastMsg))) {
            this.vivecraft$triggerHapticSound();
        }
        this.vivecraft$lastMsg = null;
    }

    @Unique
    private void vivecraft$triggerHapticSound() {
        ClientDataHolderVR dataHolder = ClientDataHolderVR.getInstance();
        if (dataHolder.vrSettings.chatNotifications != VRSettings.ChatNotifications.NONE) {
            if (!(dataHolder.vrSettings.seated || dataHolder.vrSettings.chatNotifications != VRSettings.ChatNotifications.HAPTIC && dataHolder.vrSettings.chatNotifications != VRSettings.ChatNotifications.BOTH)) {
                dataHolder.vr.triggerHapticPulse(ControllerType.LEFT, 0.2f, 1000.0f, 1.0f);
            }
            if (dataHolder.vrSettings.chatNotifications == VRSettings.ChatNotifications.SOUND || dataHolder.vrSettings.chatNotifications == VRSettings.ChatNotifications.BOTH) {
                Vec3 controllerPos = dataHolder.vrPlayer.vrdata_world_pre.getController(1).getPosition();
                this.f_104888_.f_91073_.m_7785_(controllerPos.m_7096_(), controllerPos.m_7098_(), controllerPos.m_7094_(), (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(new ResourceLocation(dataHolder.vrSettings.chatNotificationSound)), SoundSource.NEUTRAL, 0.3f, 0.1f, false);
            }
        }
    }

    @Inject(method={"handleOpenScreen"}, at={@At(value="HEAD")})
    private void vivecraft$markScreenActive(CallbackInfo ci) {
        GuiHandler.GUI_APPEAR_OVER_BLOCK_ACTIVE = true;
    }
}

