/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.common.network.packet.c2s;

import net.minecraft.network.FriendlyByteBuf;
import org.vivecraft.common.network.packet.PayloadIdentifier;
import org.vivecraft.common.network.packet.VivecraftPayload;
import org.vivecraft.common.network.packet.c2s.ActiveBodyPartPayloadC2S;
import org.vivecraft.common.network.packet.c2s.ClimbingPayloadC2S;
import org.vivecraft.common.network.packet.c2s.CrawlPayloadC2S;
import org.vivecraft.common.network.packet.c2s.DrawPayloadC2S;
import org.vivecraft.common.network.packet.c2s.HeightPayloadC2S;
import org.vivecraft.common.network.packet.c2s.LegacyController0DataPayloadC2S;
import org.vivecraft.common.network.packet.c2s.LegacyController1DataPayloadC2S;
import org.vivecraft.common.network.packet.c2s.LegacyHeadDataPayloadC2S;
import org.vivecraft.common.network.packet.c2s.TeleportPayloadC2S;
import org.vivecraft.common.network.packet.c2s.UnknownPayloadC2S;
import org.vivecraft.common.network.packet.c2s.VRActivePayloadC2S;
import org.vivecraft.common.network.packet.c2s.VRPlayerStatePayloadC2S;
import org.vivecraft.common.network.packet.c2s.VersionPayloadC2S;
import org.vivecraft.common.network.packet.c2s.WorldScalePayloadC2S;
import org.vivecraft.server.ServerNetworking;

public interface VivecraftPayloadC2S
extends VivecraftPayload {
    public static VivecraftPayloadC2S readPacket(FriendlyByteBuf buffer) {
        byte index = buffer.readByte();
        if (index < PayloadIdentifier.values().length) {
            PayloadIdentifier id = PayloadIdentifier.values()[index];
            return switch (id) {
                case PayloadIdentifier.VERSION -> VersionPayloadC2S.read(buffer);
                case PayloadIdentifier.HEADDATA -> LegacyHeadDataPayloadC2S.read(buffer);
                case PayloadIdentifier.CONTROLLER0DATA -> LegacyController0DataPayloadC2S.read(buffer);
                case PayloadIdentifier.CONTROLLER1DATA -> LegacyController1DataPayloadC2S.read(buffer);
                case PayloadIdentifier.WORLDSCALE -> WorldScalePayloadC2S.read(buffer);
                case PayloadIdentifier.DRAW -> DrawPayloadC2S.read(buffer);
                case PayloadIdentifier.TELEPORT -> TeleportPayloadC2S.read(buffer);
                case PayloadIdentifier.CLIMBING -> new ClimbingPayloadC2S();
                case PayloadIdentifier.HEIGHT -> HeightPayloadC2S.read(buffer);
                case PayloadIdentifier.ACTIVEHAND -> ActiveBodyPartPayloadC2S.read(buffer);
                case PayloadIdentifier.CRAWL -> CrawlPayloadC2S.read(buffer);
                case PayloadIdentifier.IS_VR_ACTIVE -> VRActivePayloadC2S.read(buffer);
                case PayloadIdentifier.VR_PLAYER_STATE -> VRPlayerStatePayloadC2S.read(buffer);
                default -> {
                    ServerNetworking.LOGGER.error("Vivecraft: Got unexpected payload identifier on server: {}", (Object)id);
                    yield UnknownPayloadC2S.read(buffer);
                }
            };
        }
        ServerNetworking.LOGGER.error("Vivecraft: Got unknown payload identifier on server: {}", (Object)index);
        return UnknownPayloadC2S.read(buffer);
    }
}

