/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.common.network.packet.c2s;

import net.minecraft.network.FriendlyByteBuf;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.common.network.BodyPart;
import org.vivecraft.common.network.FBTMode;
import org.vivecraft.common.network.packet.PayloadIdentifier;
import org.vivecraft.common.network.packet.c2s.VivecraftPayloadC2S;

public record ActiveBodyPartPayloadC2S(BodyPart bodyPart) implements VivecraftPayloadC2S
{
    @Override
    public PayloadIdentifier payloadId() {
        return PayloadIdentifier.ACTIVEHAND;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeByte(this.payloadId().ordinal());
        if (ClientNetworking.USED_NETWORK_VERSION < 2 && !this.bodyPart.isValid(FBTMode.ARMS_ONLY)) {
            buffer.writeByte(BodyPart.MAIN_HAND.ordinal());
        } else {
            buffer.writeByte(this.bodyPart.ordinal());
        }
    }

    public static ActiveBodyPartPayloadC2S read(FriendlyByteBuf buffer) {
        return new ActiveBodyPartPayloadC2S(BodyPart.values()[buffer.readByte()]);
    }
}

