/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render.helpers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.extensions.GameRendererExtension;
import org.vivecraft.client_vr.gameplay.trackers.CameraTracker;
import org.vivecraft.client_vr.render.RenderPass;
import org.vivecraft.client_vr.render.helpers.DebugRenderHelper;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.render.helpers.VREffectsHelper;
import org.vivecraft.client_vr.settings.VRHotkeys;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.MathUtils;

public class VRWidgetHelper {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static final ClientDataHolderVR DATA_HOLDER = ClientDataHolderVR.getInstance();
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    private static final ResourceLocation TRANSPARENT_TEXTURE = new ResourceLocation("vivecraft:transparent");
    public static boolean DEBUG = false;

    public static void renderVRThirdPersonCamWidget(PoseStack poseStack) {
        if (!VRWidgetHelper.DATA_HOLDER.vrSettings.mixedRealityRenderCameraModel) {
            return;
        }
        if (!(VRWidgetHelper.DATA_HOLDER.currentPass != RenderPass.LEFT && VRWidgetHelper.DATA_HOLDER.currentPass != RenderPass.RIGHT || VRWidgetHelper.DATA_HOLDER.vrSettings.displayMirrorMode != VRSettings.MirrorMode.MIXED_REALITY && VRWidgetHelper.DATA_HOLDER.vrSettings.displayMirrorMode != VRSettings.MirrorMode.THIRD_PERSON || VRWidgetHelper.DATA_HOLDER.vrSettings.displayMirrorUseScreenshotCamera && VRWidgetHelper.DATA_HOLDER.cameraTracker.isVisible())) {
            float scale = 0.35f;
            if (VRWidgetHelper.DATA_HOLDER.interactTracker.isInCamera() && !VRHotkeys.isMovingThirdPersonCam()) {
                scale *= 1.03f;
            }
            VRWidgetHelper.renderVRCameraWidget(poseStack, -0.748f, -0.438f, -0.06f, scale, RenderPass.THIRD, ClientDataHolderVR.THIRD_PERSON_CAMERA_MODEL, ClientDataHolderVR.THIRD_PERSON_CAMERA_DISPLAY_MODEL, () -> {
                VRWidgetHelper.DATA_HOLDER.vrRenderer.framebufferMR.m_83956_();
                RenderSystem.setShaderTexture((int)0, (int)VRWidgetHelper.DATA_HOLDER.vrRenderer.framebufferMR.m_83975_());
            }, face -> {
                if (face == Direction.NORTH) {
                    return DisplayFace.MIRROR;
                }
                return face == Direction.SOUTH ? DisplayFace.NORMAL : DisplayFace.NONE;
            });
        }
    }

    public static void renderVRHandheldCameraWidget(PoseStack poseStack) {
        if (VRWidgetHelper.DATA_HOLDER.currentPass != RenderPass.CAMERA && VRWidgetHelper.DATA_HOLDER.cameraTracker.isVisible()) {
            float scale = 0.25f;
            if (VRWidgetHelper.DATA_HOLDER.interactTracker.isInHandheldCamera() && !VRWidgetHelper.DATA_HOLDER.cameraTracker.isMoving()) {
                scale *= 1.03f;
            }
            VRWidgetHelper.renderVRCameraWidget(poseStack, -0.5f, -0.25f, -0.22f, scale, RenderPass.CAMERA, CameraTracker.CAMERA_MODEL, CameraTracker.CAMERA_DISPLAY_MODEL, () -> {
                if (VREffectsHelper.getNearOpaqueBlock(VRWidgetHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getEye(RenderPass.CAMERA).getPosition(), ((GameRendererExtension)VRWidgetHelper.MC.f_91063_).vivecraft$getMinClipDistance()) == null) {
                    VRWidgetHelper.DATA_HOLDER.vrRenderer.cameraFramebuffer.m_83956_();
                    RenderSystem.setShaderTexture((int)0, (int)VRWidgetHelper.DATA_HOLDER.vrRenderer.cameraFramebuffer.m_83975_());
                } else {
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)RenderHelper.BLACK_TEXTURE);
                }
            }, face -> face == Direction.SOUTH ? DisplayFace.NORMAL : DisplayFace.NONE);
        }
    }

    public static void renderVRCameraWidget(PoseStack poseStack, float offsetX, float offsetY, float offsetZ, float scale, RenderPass renderPass, ModelResourceLocation model, ModelResourceLocation displayModel, Runnable displayBindFunc, Function<Direction, DisplayFace> displayFaceFunc) {
        poseStack.m_85836_();
        Vec3 widgetPosition = VRWidgetHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getEye(renderPass).getPosition();
        Vec3 eye = RenderHelper.getSmoothCameraPosition(VRWidgetHelper.DATA_HOLDER.currentPass, VRWidgetHelper.DATA_HOLDER.vrPlayer.vrdata_world_render);
        Vector3f widgetOffset = MathUtils.subtractToVector3f(widgetPosition, eye);
        poseStack.m_252880_(widgetOffset.x, widgetOffset.y, widgetOffset.z);
        Matrix4f rotation = VRWidgetHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getEye(renderPass).getMatrix();
        poseStack.m_252931_(rotation);
        poseStack.m_85850_().m_252943_().mul((Matrix3fc)new Matrix3f((Matrix4fc)rotation));
        poseStack.m_85841_(scale *= VRWidgetHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.worldScale, scale, scale);
        if (DEBUG) {
            DebugRenderHelper.renderLocalAxes(poseStack);
        }
        poseStack.m_252880_(offsetX, offsetY, offsetZ);
        BlockPos blockpos = BlockPos.m_274446_((Position)VRWidgetHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getEye(renderPass).getPosition());
        int combinedLight = ClientUtils.getCombinedLightWithMin((BlockAndTintGetter)VRWidgetHelper.MC.f_91073_, blockpos, 0);
        RenderSystem.enableDepthTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        if (VRWidgetHelper.MC.f_91073_ != null) {
            RenderSystem.setShader(GameRenderer::m_172667_);
        } else {
            RenderSystem.setShader(GameRenderer::m_172820_);
        }
        VRWidgetHelper.MC.f_91063_.m_109154_().m_109896_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85812_);
        MC.m_91289_().m_110937_().m_111067_(poseStack.m_85850_(), (VertexConsumer)bufferBuilder, null, MC.m_91304_().m_119422_(model), 1.0f, 1.0f, 1.0f, combinedLight, OverlayTexture.f_118083_);
        tesselator.m_85914_();
        RenderSystem.disableBlend();
        displayBindFunc.run();
        RenderSystem.setShader(GameRenderer::m_172661_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85812_);
        for (BakedQuad bakedquad : MC.m_91304_().m_119422_(displayModel).m_213637_(null, null, RANDOM)) {
            if (displayFaceFunc.apply(bakedquad.m_111306_()) == DisplayFace.NONE || !bakedquad.m_173410_().m_245424_().m_246162_().equals((Object)TRANSPARENT_TEXTURE)) continue;
            int[] vertexList = bakedquad.m_111303_();
            boolean mirrored = displayFaceFunc.apply(bakedquad.m_111306_()) == DisplayFace.MIRROR;
            int step = vertexList.length / 4;
            bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), Float.intBitsToFloat(vertexList[0]), Float.intBitsToFloat(vertexList[1]), Float.intBitsToFloat(vertexList[2])).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(mirrored ? 1.0f : 0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), Float.intBitsToFloat(vertexList[step]), Float.intBitsToFloat(vertexList[step + 1]), Float.intBitsToFloat(vertexList[step + 2])).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(mirrored ? 1.0f : 0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), Float.intBitsToFloat(vertexList[step * 2]), Float.intBitsToFloat(vertexList[step * 2 + 1]), Float.intBitsToFloat(vertexList[step * 2 + 2])).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(mirrored ? 0.0f : 1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), Float.intBitsToFloat(vertexList[step * 3]), Float.intBitsToFloat(vertexList[step * 3 + 1]), Float.intBitsToFloat(vertexList[step * 3 + 2])).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(mirrored ? 0.0f : 1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        }
        tesselator.m_85914_();
        VRWidgetHelper.MC.f_91063_.m_109154_().m_109891_();
        RenderSystem.enableBlend();
        poseStack.m_85849_();
    }

    public static enum DisplayFace {
        NONE,
        NORMAL,
        MIRROR;

    }
}

