/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render.helpers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client.ClientVRPlayers;
import org.vivecraft.client.gui.screens.FBTCalibrationScreen;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.extensions.GameRendererExtension;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.gameplay.trackers.TelescopeTracker;
import org.vivecraft.client_vr.provider.DeviceSource;
import org.vivecraft.client_vr.provider.MCVR;
import org.vivecraft.client_vr.render.RenderPass;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.common.network.FBTMode;
import org.vivecraft.common.utils.MathUtils;

public class DebugRenderHelper {
    private static final ClientDataHolderVR DATA_HOLDER = ClientDataHolderVR.getInstance();
    private static final Minecraft MC = Minecraft.m_91087_();
    private static final Vector3fc RED = new Vector3f(1.0f, 0.0f, 0.0f);
    private static final Vector3fc GREEN = new Vector3f(0.0f, 1.0f, 0.0f);
    private static final Vector3fc BLUE = new Vector3f(0.0f, 0.0f, 1.0f);
    private static final Vector3fc DARK_GRAY = new Vector3f(0.25f);

    public static void renderDebug(PoseStack poseStack, float partialTick) {
        if (DebugRenderHelper.DATA_HOLDER.vrSettings.renderDeviceAxes) {
            DebugRenderHelper.renderDeviceAxes(poseStack, DebugRenderHelper.DATA_HOLDER.vrPlayer.getVRDataWorld());
        }
        if (DebugRenderHelper.DATA_HOLDER.vrSettings.renderVrPlayerAxes) {
            DebugRenderHelper.renderPlayerAxes(poseStack, partialTick);
        }
        if (DebugRenderHelper.DATA_HOLDER.vrSettings.renderTrackerPositions || DebugRenderHelper.MC.f_91080_ instanceof FBTCalibrationScreen) {
            boolean showNames = true;
            Screen screen = DebugRenderHelper.MC.f_91080_;
            if (screen instanceof FBTCalibrationScreen) {
                FBTCalibrationScreen fbtScreen = (FBTCalibrationScreen)screen;
                showNames = fbtScreen.isCalibrated();
            }
            DebugRenderHelper.renderTackerPositions(poseStack, showNames);
        }
    }

    public static void renderPlayerAxes(PoseStack poseStack, float partialTick) {
        if (DebugRenderHelper.MC.f_91074_ != null) {
            BufferBuilder bufferbuilder = null;
            Vec3 camPos = RenderHelper.getSmoothCameraPosition(DebugRenderHelper.DATA_HOLDER.currentPass, DebugRenderHelper.DATA_HOLDER.vrPlayer.getVRDataWorld());
            for (Player p : DebugRenderHelper.MC.f_91074_.m_9236_().m_6907_()) {
                if (!ClientVRPlayers.getInstance().isVRPlayer((Entity)p)) continue;
                ClientVRPlayers.RotInfo info = ClientVRPlayers.getInstance().getRotationsForPlayer(p.m_20148_());
                if (bufferbuilder == null) {
                    RenderSystem.setShader(GameRenderer::m_172811_);
                    bufferbuilder = Tesselator.m_85913_().m_85915_();
                    bufferbuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
                }
                Vector3f playerPos = p.m_20318_(partialTick).m_82546_(camPos).m_252839_();
                if (p == DebugRenderHelper.MC.f_91074_) {
                    playerPos = ((GameRendererExtension)DebugRenderHelper.MC.f_91063_).vivecraft$getRvePos(partialTick).m_82546_(camPos).m_252839_();
                }
                if (p != DebugRenderHelper.MC.f_91074_ || DebugRenderHelper.DATA_HOLDER.currentPass == RenderPass.THIRD) {
                    DebugRenderHelper.addAxes(poseStack, bufferbuilder, (Vector3fc)playerPos, info.headPos, info.headRot, info.headQuat);
                }
                if (!info.seated) {
                    DebugRenderHelper.addAxes(poseStack, bufferbuilder, (Vector3fc)playerPos, info.mainHandPos, info.mainHandRot, info.mainHandQuat);
                    DebugRenderHelper.addAxes(poseStack, bufferbuilder, (Vector3fc)playerPos, info.offHandPos, info.offHandRot, info.offHandQuat);
                }
                if (info.fbtMode != FBTMode.ARMS_ONLY) {
                    DebugRenderHelper.addAxes(poseStack, bufferbuilder, (Vector3fc)playerPos, info.waistPos, info.waistQuat);
                    DebugRenderHelper.addAxes(poseStack, bufferbuilder, (Vector3fc)playerPos, info.rightFootPos, info.rightFootQuat);
                    DebugRenderHelper.addAxes(poseStack, bufferbuilder, (Vector3fc)playerPos, info.leftFootPos, info.leftFootQuat);
                }
                if (info.fbtMode != FBTMode.WITH_JOINTS) continue;
                DebugRenderHelper.addAxes(poseStack, bufferbuilder, (Vector3fc)playerPos, info.rightElbowPos, info.rightElbowQuat);
                DebugRenderHelper.addAxes(poseStack, bufferbuilder, (Vector3fc)playerPos, info.leftElbowPos, info.leftElbowQuat);
                DebugRenderHelper.addAxes(poseStack, bufferbuilder, (Vector3fc)playerPos, info.rightKneePos, info.rightKneeQuat);
                DebugRenderHelper.addAxes(poseStack, bufferbuilder, (Vector3fc)playerPos, info.leftKneePos, info.leftKneeQuat);
            }
            if (bufferbuilder != null) {
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            }
        }
    }

    public static void renderDeviceAxes(PoseStack poseStack, VRData data) {
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        bufferbuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        ArrayList<VRData.VRDevicePose> list = new ArrayList<VRData.VRDevicePose>();
        list.add(data.c2);
        if (DebugRenderHelper.DATA_HOLDER.currentPass == RenderPass.THIRD) {
            list.add(data.hmd);
        }
        if (DebugRenderHelper.DATA_HOLDER.cameraTracker.isVisible()) {
            list.add(data.cam);
        }
        if (DebugRenderHelper.MC.f_91074_ != null && TelescopeTracker.isTelescope(DebugRenderHelper.MC.f_91074_.m_21205_()) && TelescopeTracker.isViewing(0)) {
            list.add(data.t0);
        } else {
            list.add(DebugRenderHelper.MC.f_91074_ != null && DebugRenderHelper.MC.f_91074_.m_6144_() ? data.h0 : data.c0);
        }
        if (DebugRenderHelper.MC.f_91074_ != null && TelescopeTracker.isTelescope(DebugRenderHelper.MC.f_91074_.m_21206_()) && TelescopeTracker.isViewing(0)) {
            list.add(data.t1);
        } else {
            list.add(DebugRenderHelper.MC.f_91074_ != null && DebugRenderHelper.MC.f_91074_.m_6144_() ? data.h1 : data.c1);
        }
        if (data.fbtMode != FBTMode.ARMS_ONLY) {
            list.add(data.waist);
            list.add(data.foot_left);
            list.add(data.foot_right);
        }
        if (data.fbtMode == FBTMode.WITH_JOINTS) {
            list.add(data.elbow_left);
            list.add(data.knee_left);
            list.add(data.elbow_right);
            list.add(data.knee_right);
        }
        list.forEach(p -> DebugRenderHelper.addAxes(poseStack, bufferbuilder, data, p));
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    private static void renderTackerPositions(PoseStack poseStack, boolean showNames) {
        VRData data = DebugRenderHelper.DATA_HOLDER.vrPlayer.getVRDataWorld();
        Vec3 camPos = RenderHelper.getSmoothCameraPosition(DebugRenderHelper.DATA_HOLDER.currentPass, data);
        Quaternionf orientation = data.getEye(DebugRenderHelper.DATA_HOLDER.currentPass).getMatrix().getNormalizedRotation(new Quaternionf()).rotateY((float)Math.PI);
        Component[] labels = new Component[]{Component.m_237115_((String)"vivecraft.toasts.point_controller.right"), Component.m_237115_((String)"vivecraft.toasts.point_controller.left"), Component.m_237115_((String)"vivecraft.messages.tracker.camera"), Component.m_237115_((String)"vivecraft.messages.tracker.waist"), Component.m_237115_((String)"vivecraft.messages.tracker.rightFoot"), Component.m_237115_((String)"vivecraft.messages.tracker.leftFoot"), Component.m_237115_((String)"vivecraft.messages.tracker.rightElbow"), Component.m_237115_((String)"vivecraft.messages.tracker.leftElbow"), Component.m_237115_((String)"vivecraft.messages.tracker.rightKnee"), Component.m_237115_((String)"vivecraft.messages.tracker.leftKnee")};
        for (Triple<DeviceSource, Integer, Matrix4fc> tracker : MCVR.get().getTrackers()) {
            Vector3f pos = ((Matrix4fc)tracker.getRight()).getTranslation(new Vector3f());
            Vec3 trackerPos = VRPlayer.roomToWorldPos((Vector3fc)pos, data).m_82546_(camPos);
            pos.set((float)trackerPos.f_82479_, (float)trackerPos.f_82480_, (float)trackerPos.f_82481_);
            if (showNames) {
                if ((Integer)tracker.getMiddle() >= 0) {
                    DebugRenderHelper.addNamedCube(poseStack, (Vector3fc)pos, orientation, (Component)Component.m_237110_((String)"vivecraft.formatting.name_value", (Object[])new Object[]{Component.m_237113_((String)((DeviceSource)tracker.getLeft()).source.toString()), labels[(Integer)tracker.getMiddle()]}), 0.05f, DARK_GRAY);
                    continue;
                }
                DebugRenderHelper.addNamedCube(poseStack, (Vector3fc)pos, orientation, (Component)Component.m_237110_((String)"vivecraft.formatting.name_value", (Object[])new Object[]{Component.m_237113_((String)(((DeviceSource)tracker.getLeft()).source.toString() + ((DeviceSource)tracker.getLeft()).deviceIndex)), Component.m_237115_((String)"vivecraft.messages.tracker.unknown")}), 0.05f, DARK_GRAY);
                continue;
            }
            DebugRenderHelper.addCube(poseStack, (Vector3fc)pos, 0.05f, DARK_GRAY);
        }
        MC.m_91269_().m_110104_().m_173043_();
    }

    public static void renderLocalAxes(PoseStack poseStack) {
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        bufferbuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        Vector3f position = new Vector3f();
        DebugRenderHelper.addLine(poseStack, bufferbuilder, (Vector3fc)position, MathUtils.BACK, BLUE);
        DebugRenderHelper.addLine(poseStack, bufferbuilder, (Vector3fc)position, MathUtils.UP, GREEN);
        DebugRenderHelper.addLine(poseStack, bufferbuilder, (Vector3fc)position, MathUtils.RIGHT, RED);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    private static void addAxes(PoseStack poseStack, BufferBuilder bufferBuilder, VRData data, VRData.VRDevicePose pose) {
        Vector3f position = pose.getPosition().m_82546_(RenderHelper.getSmoothCameraPosition(DebugRenderHelper.DATA_HOLDER.currentPass, data)).m_252839_();
        float scale = 0.25f * DebugRenderHelper.DATA_HOLDER.vrPlayer.worldScale;
        Vector3f forward = pose.getDirection().mul(scale);
        Vector3f up = pose.getCustomVector(MathUtils.UP).mul(scale);
        Vector3f right = pose.getCustomVector(MathUtils.RIGHT).mul(scale);
        DebugRenderHelper.addLine(poseStack, bufferBuilder, (Vector3fc)position, (Vector3fc)forward, BLUE);
        DebugRenderHelper.addLine(poseStack, bufferBuilder, (Vector3fc)position, (Vector3fc)up, GREEN);
        DebugRenderHelper.addLine(poseStack, bufferBuilder, (Vector3fc)position, (Vector3fc)right, RED);
    }

    private static void addAxes(PoseStack poseStack, BufferBuilder bufferBuilder, Vector3fc playerPos, Vector3fc devicePos, Quaternionfc rot) {
        DebugRenderHelper.addAxes(poseStack, bufferBuilder, playerPos, devicePos, (Vector3fc)rot.transform(MathUtils.BACK, new Vector3f()), rot);
    }

    private static void addAxes(PoseStack poseStack, BufferBuilder bufferBuilder, Vector3fc playerPos, Vector3fc devicePos, Vector3fc dir, Quaternionfc rot) {
        Vector3f position = playerPos.add(devicePos, new Vector3f());
        float scale = 0.25f * DebugRenderHelper.DATA_HOLDER.vrPlayer.worldScale;
        Vector3f forward = dir.mul(scale, new Vector3f());
        Vector3f up = rot.transform(MathUtils.UP, new Vector3f()).mul(scale);
        Vector3f right = rot.transform(MathUtils.RIGHT, new Vector3f()).mul(scale);
        DebugRenderHelper.addLine(poseStack, bufferBuilder, (Vector3fc)position, (Vector3fc)forward, BLUE);
        DebugRenderHelper.addLine(poseStack, bufferBuilder, (Vector3fc)position, (Vector3fc)up, GREEN);
        DebugRenderHelper.addLine(poseStack, bufferBuilder, (Vector3fc)position, (Vector3fc)right, RED);
    }

    private static void addLine(PoseStack poseStack, BufferBuilder bufferBuilder, Vector3fc position, Vector3fc dir, Vector3fc color) {
        bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), position.x(), position.y(), position.z()).m_85950_(color.x(), color.y(), color.z(), 0.0f).m_5752_();
        bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), position.x(), position.y(), position.z()).m_85950_(color.x(), color.y(), color.z(), 1.0f).m_5752_();
        bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), position.x() + dir.x(), position.y() + dir.y(), position.z() + dir.z()).m_85950_(color.x(), color.y(), color.z(), 1.0f).m_5752_();
        bufferBuilder.m_252986_(poseStack.m_85850_().m_252922_(), position.x() + dir.x(), position.y() + dir.y(), position.z() + dir.z()).m_85950_(color.x(), color.y(), color.z(), 0.0f).m_5752_();
    }

    private static void addNamedCube(PoseStack poseStack, Vector3fc cubePos, Quaternionf rot, Component label, float size, Vector3fc color) {
        DebugRenderHelper.addCube(poseStack, cubePos, size, color);
        if (label != null) {
            DebugRenderHelper.renderTextAtRelativePosition(poseStack, cubePos.x(), cubePos.y(), cubePos.z(), rot, label);
        }
    }

    public static void renderTextAtDevice(PoseStack poseStack, int device, String text) {
        DebugRenderHelper.renderTextAtPosition(poseStack, DebugRenderHelper.DATA_HOLDER.vrPlayer.getVRDataWorld().getDevice(device).getPosition(), text);
    }

    public static void renderTextAtPosition(PoseStack poseStack, Vec3 position, String text) {
        VRData data = DebugRenderHelper.DATA_HOLDER.vrPlayer.getVRDataWorld();
        Vec3 camPos = RenderHelper.getSmoothCameraPosition(DebugRenderHelper.DATA_HOLDER.currentPass, data);
        Quaternionf rot = data.getEye(DebugRenderHelper.DATA_HOLDER.currentPass).getMatrix().getNormalizedRotation(new Quaternionf()).rotateY((float)Math.PI);
        Vector3f pos = MathUtils.subtractToVector3f(position, camPos);
        DebugRenderHelper.renderTextAtRelativePosition(poseStack, pos.x, pos.y, pos.z, rot, text);
    }

    public static void renderTextAtRelativePosition(PoseStack poseStack, float x, float y, float z, Quaternionf rot, String text) {
        DebugRenderHelper.renderTextAtRelativePosition(poseStack, x, y, z, rot, (Component)Component.m_237113_((String)text));
    }

    public static void renderTextAtRelativePosition(PoseStack poseStack, float x, float y, float z, Quaternionf rot, Component text) {
        poseStack.m_85836_();
        poseStack.m_252880_(x, y + 0.05f, z);
        poseStack.m_252781_(rot);
        poseStack.m_85841_(-0.005f, -0.005f, 0.005f);
        Font font = DebugRenderHelper.MC.f_91062_;
        float f = (float)DebugRenderHelper.MC.f_91062_.m_92852_((FormattedText)text) * -0.5f;
        Objects.requireNonNull(DebugRenderHelper.MC.f_91062_);
        font.m_272077_(text, f, (float)(-9), -1, false, poseStack.m_85850_().m_252922_(), (MultiBufferSource)MC.m_91269_().m_110104_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        poseStack.m_85849_();
    }

    private static void addCube(PoseStack poseStack, Vector3fc position, float size, Vector3fc color) {
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)RenderHelper.WHITE_TEXTURE);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Vec3i iColor = new Vec3i((int)(color.x() * 255.0f), (int)(color.y() * 255.0f), (int)(color.z() * 255.0f));
        Vec3 start = new Vec3((double)position.x(), (double)position.y(), (double)position.z()).m_82549_(MathUtils.FORWARD_D.m_82490_((double)(size * 0.5f)));
        Vec3 end = new Vec3((double)position.x(), (double)position.y(), (double)position.z()).m_82549_(MathUtils.BACK_D.m_82490_((double)(size * 0.5f)));
        RenderHelper.renderBox((VertexConsumer)bufferbuilder, start, end, size, size, iColor, (byte)-1, poseStack);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }
}

