/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.Util;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.FoodOnAStickItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TorchBlock;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.trackers.ClimbTracker;
import org.vivecraft.client_vr.gameplay.trackers.SwingTracker;
import org.vivecraft.client_vr.gameplay.trackers.TelescopeTracker;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.data.ItemTags;

public class VivecraftItemRendering {
    private static final ClientDataHolderVR DH = ClientDataHolderVR.getInstance();

    public static VivecraftItemTransformType getTransformType(ItemStack itemStack, AbstractClientPlayer player, ItemRenderer itemRenderer) {
        VivecraftItemTransformType itemTransformType = VivecraftItemTransformType.Item;
        Item item = itemStack.m_41720_();
        if (itemStack.m_41780_() == UseAnim.EAT || itemStack.m_41780_() == UseAnim.DRINK) {
            itemTransformType = VivecraftItemTransformType.Noms;
        } else if (item instanceof BlockItem) {
            BakedModel bakedmodel;
            Block block = ((BlockItem)item).m_40614_();
            itemTransformType = block instanceof TorchBlock ? VivecraftItemTransformType.Block_Stick : ((bakedmodel = itemRenderer.m_174264_(itemStack, player.m_9236_(), (LivingEntity)player, 0)).m_7539_() ? VivecraftItemTransformType.Block_3D : VivecraftItemTransformType.Block_Item);
        } else if (item instanceof MapItem || itemStack.m_204117_(ItemTags.VIVECRAFT_MAPS)) {
            itemTransformType = VivecraftItemTransformType.Map;
        } else if (itemStack.m_41780_() == UseAnim.BOW && !itemStack.m_204117_(ItemTags.VIVECRAFT_BOW_EXCLUSION)) {
            itemTransformType = VivecraftItemTransformType.Bow_Seated;
            if (VivecraftItemRendering.DH.bowTracker.isActive((LocalPlayer)player)) {
                itemTransformType = VivecraftItemRendering.DH.bowTracker.isDrawing ? VivecraftItemTransformType.Bow_Roomscale_Drawing : VivecraftItemTransformType.Bow_Roomscale;
            }
        } else if (itemStack.m_41780_() == UseAnim.TOOT_HORN) {
            itemTransformType = VivecraftItemTransformType.Horn;
        } else if (item instanceof SwordItem || itemStack.m_204117_(ItemTags.VIVECRAFT_SWORDS)) {
            itemTransformType = VivecraftItemTransformType.Sword;
        } else if (item instanceof ShieldItem || itemStack.m_204117_(ItemTags.VIVECRAFT_SHIELDS)) {
            itemTransformType = VivecraftItemTransformType.Shield;
        } else if (item instanceof TridentItem || itemStack.m_204117_(ItemTags.VIVECRAFT_SPEARS)) {
            itemTransformType = VivecraftItemTransformType.Spear;
        } else if (item instanceof CrossbowItem || itemStack.m_204117_(ItemTags.VIVECRAFT_CROSSBOWS)) {
            itemTransformType = VivecraftItemTransformType.Crossbow;
        } else if (item instanceof CompassItem || item == Items.f_42524_ || itemStack.m_204117_(ItemTags.VIVECRAFT_COMPASSES)) {
            itemTransformType = VivecraftItemTransformType.Compass;
        } else if (SwingTracker.isTool(item)) {
            itemTransformType = VivecraftItemTransformType.Tool;
            if (item instanceof FoodOnAStickItem || item instanceof FishingRodItem || itemStack.m_204117_(ItemTags.VIVECRAFT_FISHING_RODS)) {
                itemTransformType = VivecraftItemTransformType.Tool_Rod;
            }
        } else if (TelescopeTracker.isTelescope(itemStack)) {
            itemTransformType = VivecraftItemTransformType.Telescope;
        }
        return itemTransformType;
    }

    public static void applyThirdPersonItemTransforms(PoseStack poseStack, VivecraftItemTransformType itemTransformType, boolean mainHand, AbstractClientPlayer player, float equippedProgress, float partialTick, ItemStack itemStack, InteractionHand hand) {
        int k = mainHand ? 1 : -1;
        float scale = 0.525f;
        float translateX = 0.0f;
        float translateY = 0.05f;
        float translateZ = 0.0f;
        boolean useLeftHandModelinLeftHand = false;
        if (ClimbTracker.isClaws(itemStack)) {
            scale = 0.4f;
        }
        poseStack.m_252880_(translateX, translateY, translateZ);
        poseStack.m_85841_(scale, scale, scale);
    }

    public static void applyFirstPersonItemTransforms(PoseStack poseStack, VivecraftItemTransformType itemTransformType, boolean mainHand, AbstractClientPlayer player, float equippedProgress, float partialTick, ItemStack itemStack, InteractionHand hand) {
        float gunAngle = VivecraftItemRendering.DH.vr.getGunAngle();
        float scale = 0.7f;
        float translateX = -0.05f;
        float translateY = 0.005f;
        float translateZ = 0.0f;
        Quaternionf rotation = new Quaternionf();
        Quaternionf preRotation = new Quaternionf();
        rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_(-110.0f + gunAngle));
        switch (itemTransformType) {
            case Bow_Seated: {
                rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_(90.0f - gunAngle));
                translateY += -0.1f;
                translateZ += 0.1f;
                break;
            }
            case Bow_Roomscale: {
                preRotation.set((Quaternionfc)rotation);
                rotation.identity();
                translateX -= 0.0225f;
                translateY -= 0.25f;
                translateZ += 0.025f + 0.03f * gunAngle / 40.0f;
                scale = 1.0f;
                break;
            }
            case Bow_Roomscale_Drawing: {
                rotation.identity();
                scale = 1.0f;
                int bowHand = 1;
                if (VivecraftItemRendering.DH.vrSettings.reverseShootingEye && ClientNetworking.supportsReversedBow()) {
                    bowHand = 0;
                }
                Vector3fc aim = VivecraftItemRendering.DH.bowTracker.getAimVector();
                Vector3f localBack = VivecraftItemRendering.DH.vrPlayer.vrdata_world_render.getHand(bowHand).getCustomVector(MathUtils.BACK);
                float aimPitch = (float)Math.toDegrees(Math.asin(aim.y() / aim.length()));
                float yaw = (float)Math.toDegrees(Math.atan2(aim.x(), aim.z()));
                Vector3f aimHorizontal = new Vector3f(aim.x(), 0.0f, aim.z());
                Vector3f pAim2 = new Vector3f();
                float aimProj = localBack.dot((Vector3fc)aimHorizontal);
                if (aimProj != 0.0f) {
                    aimHorizontal.mul(aimProj, pAim2);
                }
                Vector3f proj = localBack.sub((Vector3fc)pAim2, new Vector3f()).normalize();
                float dot = proj.dot(MathUtils.UP);
                float dot2 = aimHorizontal.dot((Vector3fc)proj.cross(MathUtils.UP, new Vector3f()));
                float angle = dot2 < 0.0f ? (float)(-Math.acos(dot)) : (float)Math.acos(dot);
                float roll = 57.295776f * angle;
                if (VivecraftItemRendering.DH.bowTracker.isCharged()) {
                    long j = Util.m_137550_() - VivecraftItemRendering.DH.bowTracker.startDrawTime;
                    translateX += 0.003f * Mth.m_14031_((float)j);
                }
                poseStack.m_252880_(0.0f, 0.0f, 0.1f);
                poseStack.m_85850_().m_252922_().mul((Matrix4fc)VivecraftItemRendering.DH.vrPlayer.vrdata_world_render.getController(bowHand).getMatrix().transpose());
                rotation.mul((Quaternionfc)Axis.f_252436_.m_252977_(yaw));
                rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_(-aimPitch));
                rotation.mul((Quaternionfc)Axis.f_252403_.m_252977_(-roll));
                rotation.mul((Quaternionfc)Axis.f_252403_.m_252977_(180.0f));
                poseStack.m_85850_().m_252922_().rotate((Quaternionfc)rotation);
                rotation = Axis.f_252436_.m_252977_(180.0f);
                rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_(160.0f));
                translateX += 0.125f;
                translateY += 0.1225f;
                translateZ += 0.16f;
                break;
            }
            case Crossbow: {
                rotation = Axis.f_252436_.m_252977_(10.0f);
                translateX += 0.01f;
                translateZ -= 0.02f;
                translateY -= 0.02f;
                scale = 0.5f;
                break;
            }
            case Map: {
                rotation = Axis.f_252529_.m_252977_(-45.0f);
                translateX = 0.0f;
                translateY = 0.16f;
                translateZ = -0.075f;
                scale = 0.75f;
                break;
            }
            case Noms: {
                rotation = Axis.f_252403_.m_252977_(180.0f);
                rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_(-135.0f));
                translateX += 0.08f;
                translateZ += 0.02f + 0.006f * Mth.m_14031_((float)player.m_21212_());
                scale = 0.4f;
                break;
            }
            case Item: 
            case Block_Item: {
                rotation = Axis.f_252403_.m_252977_(180.0f);
                rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_(-135.0f));
                translateX += 0.08f;
                translateZ += -0.08f;
                scale = 0.4f;
                break;
            }
            case Compass: {
                rotation = Axis.f_252436_.m_252977_(90.0f);
                rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_(25.0f));
                scale = 0.4f;
                break;
            }
            case Block_3D: {
                translateX += 0.05f;
                translateZ -= 0.1f;
                scale = 0.3f;
                break;
            }
            case Block_Stick: {
                rotation = Axis.f_252529_.m_252977_(-45.0f + gunAngle);
                translateY += -0.105f + 0.06f * gunAngle / 40.0f;
                translateZ -= 0.1f;
                break;
            }
            case Horn: {
                rotation = Axis.f_252529_.m_252977_(-45.0f + gunAngle);
                translateY += -0.105f + 0.06f * gunAngle / 40.0f;
                translateZ -= 0.1f;
                scale = 0.3f;
                break;
            }
            case Shield: {
                int side;
                int n = side = mainHand ? 1 : -1;
                if (VivecraftItemRendering.DH.vrSettings.reverseHands) {
                    side *= -1;
                }
                scale = 0.4f;
                translateY += 0.18f;
                if (side == 1) {
                    rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_(105.0f - gunAngle));
                    translateX += 0.11f;
                } else {
                    rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_(115.0f - gunAngle));
                    translateX -= 0.015f;
                }
                translateZ += 0.1f;
                if (player.m_6117_() && player.m_21212_() > 0 && player.m_7655_() == hand) {
                    rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_((float)side * 5.0f));
                    rotation.mul((Quaternionfc)Axis.f_252403_.m_252977_(-5.0f));
                    if (side == 1) {
                        translateX += 0.04f;
                        translateY -= 0.12f;
                        translateZ -= 0.1f;
                    } else {
                        translateX += 0.19f;
                        translateY -= 0.12f;
                        translateZ -= 0.11f;
                    }
                    if (player.m_21254_()) {
                        rotation.mul((Quaternionfc)Axis.f_252436_.m_252977_((float)side * 90.0f));
                    } else {
                        rotation.mul((Quaternionfc)Axis.f_252436_.m_252977_((1.0f - equippedProgress) * (float)side * 90.0f));
                    }
                }
                rotation.mul((Quaternionfc)Axis.f_252436_.m_252977_((float)side * -90.0f));
                break;
            }
            case Spear: {
                rotation.identity();
                translateX -= 0.135f;
                translateZ += 0.575f;
                scale = 0.6f;
                float progress = 0.0f;
                boolean charging = false;
                int riptideLevel = 0;
                if (player.m_6117_() && player.m_21212_() > 0 && player.m_7655_() == hand) {
                    charging = true;
                    riptideLevel = EnchantmentHelper.m_44932_((ItemStack)itemStack);
                    if ((riptideLevel <= 0 || player.m_20070_()) && (progress = (float)itemStack.m_41779_() - ((float)player.m_21212_() - partialTick + 1.0f)) > 10.0f) {
                        float rotationProgress = progress - 10.0f;
                        progress = 10.0f;
                        if (riptideLevel > 0 && player.m_20070_()) {
                            poseStack.m_252781_(Axis.f_252403_.m_252977_(-rotationProgress * 10.0f * (float)riptideLevel));
                        }
                        if (VivecraftItemRendering.DH.frameIndex % 4L == 0L) {
                            VivecraftItemRendering.DH.vr.triggerHapticPulse(mainHand ? 0 : 1, 200);
                        }
                        translateX += 0.003f * (float)Math.sin(Util.m_137550_());
                    }
                }
                if (player.m_21209_()) {
                    riptideLevel = 5;
                    translateZ -= 0.15f;
                    poseStack.m_252781_(Axis.f_252403_.m_252977_((float)(-VivecraftItemRendering.DH.tickCounter * 10 * riptideLevel % 360) - partialTick * 10.0f * (float)riptideLevel));
                    charging = true;
                }
                if (!charging) {
                    translateY += 0.2f * gunAngle / 40.0f;
                    rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_(gunAngle));
                }
                rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_(-65.0f));
                translateZ += -0.75f + progress / 10.0f * 0.25f;
                break;
            }
            case Tool_Rod: {
                rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_(40.0f));
                translateY += -0.02f + gunAngle / 40.0f * 0.1f;
                translateX += 0.05f;
                translateZ -= 0.15f;
                scale = 0.8f;
                break;
            }
            case Tool: {
                if (!(itemStack.m_41720_() instanceof ArrowItem) && !itemStack.m_204117_(ItemTags.VIVECRAFT_ARROWS)) break;
                preRotation = Axis.f_252403_.m_252977_(-180.0f);
                rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_(-gunAngle));
                break;
            }
            case Telescope: {
                preRotation.identity();
                rotation.identity();
                translateX = (mainHand ? -0.03f : 0.03f) * (scale *= 0.625f);
                translateY = 0.0f;
                translateZ = -0.1f * scale;
                break;
            }
        }
        poseStack.m_252781_(preRotation);
        poseStack.m_252880_(translateX, translateY, translateZ);
        poseStack.m_252781_(rotation);
        poseStack.m_85841_(scale, scale, scale);
    }

    public static enum VivecraftItemTransformType {
        Item,
        Block_3D,
        Block_Stick,
        Block_Item,
        Shield,
        Sword,
        Tool,
        Tool_Rod,
        Bow_Seated,
        Bow_Roomscale,
        Bow_Roomscale_Drawing,
        Spear,
        Map,
        Noms,
        Crossbow,
        Telescope,
        Compass,
        Horn;

    }
}

