/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.provider;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.GlUtil;
import com.mojang.blaze3d.shaders.ProgramManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;
import org.vivecraft.client.Xplat;
import org.vivecraft.client.extensions.RenderTargetExtension;
import org.vivecraft.client.utils.StencilHelper;
import org.vivecraft.client.utils.TextUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRTextureTarget;
import org.vivecraft.client_vr.extensions.WindowExtension;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.RadialHandler;
import org.vivecraft.client_vr.gameplay.trackers.TelescopeTracker;
import org.vivecraft.client_vr.provider.MCVR;
import org.vivecraft.client_vr.render.RenderConfigException;
import org.vivecraft.client_vr.render.RenderPass;
import org.vivecraft.client_vr.render.VRShaders;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.client_xr.render_pass.WorldRenderPass;
import org.vivecraft.mod_compat_vr.resolutioncontrol.ResolutionControlHelper;
import org.vivecraft.mod_compat_vr.shaders.ShadersHelper;
import oshi.SystemInfo;
import oshi.hardware.GraphicsCard;

public abstract class VRRenderer {
    public Matrix4f[] eyeProj = new Matrix4f[2];
    private float lastFarClip = 0.0f;
    public RenderTarget framebufferEye0;
    public RenderTarget framebufferEye1;
    protected int LeftEyeTextureId = -1;
    protected int RightEyeTextureId = -1;
    public RenderTarget framebufferMR;
    public RenderTarget framebufferUndistorted;
    public RenderTarget framebufferVrRender;
    public RenderTarget fsaaFirstPassResultFBO;
    public RenderTarget fsaaLastPassResultFBO;
    public RenderTarget cameraFramebuffer;
    public RenderTarget cameraRenderFramebuffer;
    public RenderTarget telescopeFramebufferL;
    public RenderTarget telescopeFramebufferR;
    protected float[][] hiddenMeshVertices = new float[2][];
    private GraphicsStatus previousGraphics = null;
    protected VRSettings.MirrorMode lastMirror;
    public long lastWindow = 0L;
    public int mirrorFBHeight;
    public int mirrorFBWidth;
    protected boolean reinitFrameBuffers = true;
    protected boolean resizeFrameBuffers = false;
    public float renderScale;
    protected Tuple<Integer, Integer> resolution;
    public float ss = -1.0f;
    protected MCVR vr;
    protected String lastError = "";

    public VRRenderer(MCVR vr) {
        this.vr = vr;
    }

    public abstract void createRenderTexture(int var1, int var2);

    public Matrix4f getCachedProjectionMatrix(int eyeType, float nearClip, float farClip) {
        if (farClip != this.lastFarClip) {
            this.lastFarClip = farClip;
            this.eyeProj[0] = this.getProjectionMatrix(0, nearClip, farClip);
            this.eyeProj[1] = this.getProjectionMatrix(1, nearClip, farClip);
        }
        return this.eyeProj[eyeType];
    }

    protected abstract Matrix4f getProjectionMatrix(int var1, float var2, float var3);

    public abstract void endFrame() throws RenderConfigException;

    public abstract boolean providesStencilMask();

    public float[] getStencilMask(RenderPass eye) {
        if (eye == RenderPass.LEFT || eye == RenderPass.RIGHT) {
            return eye == RenderPass.LEFT ? this.hiddenMeshVertices[0] : this.hiddenMeshVertices[1];
        }
        return null;
    }

    public void doStencil(boolean inverse) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientDataHolderVR dataholder = ClientDataHolderVR.getInstance();
        if (StencilHelper.stencilBufferSupported()) {
            GL11.glEnable((int)2960);
            RenderSystem.stencilOp((int)7680, (int)7680, (int)7681);
            RenderSystem.stencilMask((int)255);
        }
        if (inverse) {
            RenderSystem.clearStencil((int)255);
            RenderSystem.clearDepth((double)0.0);
            RenderSystem.stencilFunc((int)519, (int)0, (int)255);
            RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
        } else {
            RenderSystem.clearStencil((int)0);
            RenderSystem.clearDepth((double)1.0);
            RenderSystem.stencilFunc((int)519, (int)255, (int)255);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
        if (StencilHelper.stencilBufferSupported()) {
            RenderSystem.clear((int)1280, (boolean)false);
        } else {
            RenderSystem.clear((int)256, (boolean)false);
        }
        RenderSystem.clearStencil((int)0);
        RenderSystem.clearDepth((double)1.0);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)519);
        RenderSystem.disableCull();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderTarget fb = minecraft.m_91385_();
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().setOrtho(0.0f, (float)fb.f_83917_, 0.0f, (float)fb.f_83918_, 0.0f, 20.0f), (VertexSorting)VertexSorting.f_276633_);
        RenderSystem.getModelViewStack().m_85836_();
        RenderSystem.getModelViewStack().m_166856_();
        if (inverse) {
            RenderSystem.getModelViewStack().m_252880_(0.0f, 0.0f, -20.0f);
        }
        RenderSystem.applyModelViewMatrix();
        int program = GlStateManager._getInteger((int)35725);
        if (dataholder.currentPass == RenderPass.SCOPEL || dataholder.currentPass == RenderPass.SCOPER) {
            this.drawCircle(fb.f_83917_, fb.f_83918_);
        } else if (this.providesStencilMask() && (dataholder.currentPass == RenderPass.LEFT || dataholder.currentPass == RenderPass.RIGHT)) {
            this.drawMask();
        }
        RenderSystem.restoreProjectionMatrix();
        RenderSystem.getModelViewStack().m_85849_();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableCull();
        ProgramManager.m_85578_((int)program);
        if (StencilHelper.stencilBufferSupported()) {
            RenderSystem.stencilFunc((int)517, (int)255, (int)1);
            RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
            RenderSystem.stencilMask((int)0);
        }
        RenderSystem.depthFunc((int)515);
    }

    private void drawCircle(float width, float height) {
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85814_);
        float edges = 32.0f;
        float radius = width / 2.0f;
        builder.m_5483_((double)radius, (double)radius, 0.0).m_5752_();
        int i = 0;
        while ((float)i < 33.0f) {
            float startAngle = (float)i / 32.0f * ((float)Math.PI * 2);
            builder.m_5483_((double)(radius + Mth.m_14089_((float)startAngle) * radius), (double)(radius + Mth.m_14031_((float)startAngle) * radius), 0.0).m_5752_();
            ++i;
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
    }

    private void drawMask() {
        Minecraft mc = Minecraft.m_91087_();
        ClientDataHolderVR dh = ClientDataHolderVR.getInstance();
        float[] verts = this.getStencilMask(dh.currentPass);
        if (verts == null) {
            return;
        }
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85814_);
        mc.m_91097_().m_174784_(RenderHelper.BLACK_TEXTURE);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)RenderHelper.BLACK_TEXTURE);
        for (int i = 0; i < verts.length; i += 2) {
            builder.m_5483_((double)(verts[i] * this.renderScale + 0.5f), (double)(verts[i + 1] * this.renderScale + 0.5f), 0.0).m_5752_();
        }
        RenderSystem.setShader(GameRenderer::m_172808_);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
    }

    public String getInitError() {
        return this.vr.initStatus;
    }

    public String getLastError() {
        return this.lastError;
    }

    public abstract String getName();

    public List<RenderPass> getRenderPasses() {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientDataHolderVR dataholder = ClientDataHolderVR.getInstance();
        ArrayList<RenderPass> passes = new ArrayList<RenderPass>();
        passes.add(RenderPass.LEFT);
        passes.add(RenderPass.RIGHT);
        if (((WindowExtension)minecraft.m_91268_()).vivecraft$getActualScreenWidth() > 0 && ((WindowExtension)minecraft.m_91268_()).vivecraft$getActualScreenHeight() > 0) {
            if (dataholder.vrSettings.displayMirrorMode == VRSettings.MirrorMode.FIRST_PERSON) {
                passes.add(RenderPass.CENTER);
            } else if (dataholder.vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY) {
                if (dataholder.vrSettings.mixedRealityUndistorted && dataholder.vrSettings.mixedRealityUnityLike) {
                    passes.add(RenderPass.CENTER);
                }
                passes.add(RenderPass.THIRD);
            } else if (dataholder.vrSettings.displayMirrorMode == VRSettings.MirrorMode.THIRD_PERSON) {
                passes.add(RenderPass.THIRD);
            }
        }
        if (minecraft.f_91074_ != null) {
            if (TelescopeTracker.isTelescope(minecraft.f_91074_.m_21205_()) && TelescopeTracker.isViewing(0)) {
                passes.add(RenderPass.SCOPER);
            }
            if (TelescopeTracker.isTelescope(minecraft.f_91074_.m_21206_()) && TelescopeTracker.isViewing(1)) {
                passes.add(RenderPass.SCOPEL);
            }
            if (dataholder.cameraTracker.isVisible()) {
                passes.add(RenderPass.CAMERA);
            }
        }
        return passes;
    }

    public abstract Tuple<Integer, Integer> getRenderTextureSizes();

    public Tuple<Integer, Integer> getMirrorTextureSize(int eyeFBWidth, int eyeFBHeight, float resolutionScale) {
        this.mirrorFBWidth = (int)Math.ceil((float)((WindowExtension)Minecraft.m_91087_().m_91268_()).vivecraft$getActualScreenWidth() * resolutionScale);
        this.mirrorFBHeight = (int)Math.ceil((float)((WindowExtension)Minecraft.m_91087_().m_91268_()).vivecraft$getActualScreenHeight() * resolutionScale);
        if (ClientDataHolderVR.getInstance().vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY) {
            this.mirrorFBWidth /= 2;
            if (ClientDataHolderVR.getInstance().vrSettings.mixedRealityUnityLike) {
                this.mirrorFBHeight /= 2;
            }
        }
        if (ShadersHelper.needsSameSizeBuffers()) {
            this.mirrorFBWidth = eyeFBWidth;
            this.mirrorFBHeight = eyeFBHeight;
        }
        return new Tuple((Object)this.mirrorFBWidth, (Object)this.mirrorFBHeight);
    }

    public Tuple<Integer, Integer> getTelescopeTextureSize(int eyeFBWidth, int eyeFBHeight) {
        int telescopeFBwidth = 720;
        int telescopeFBheight = 720;
        if (ShadersHelper.needsSameSizeBuffers()) {
            telescopeFBwidth = eyeFBWidth;
            telescopeFBheight = eyeFBHeight;
        }
        return new Tuple((Object)telescopeFBwidth, (Object)telescopeFBheight);
    }

    public Tuple<Integer, Integer> getCameraTextureSize(int eyeFBWidth, int eyeFBHeight) {
        int cameraFBwidth = Math.round(1920.0f * ClientDataHolderVR.getInstance().vrSettings.handCameraResScale);
        int cameraFBheight = Math.round(1080.0f * ClientDataHolderVR.getInstance().vrSettings.handCameraResScale);
        if (ShadersHelper.needsSameSizeBuffers()) {
            float aspect = (float)cameraFBwidth / (float)cameraFBheight;
            if (aspect > (float)(eyeFBWidth / eyeFBHeight)) {
                cameraFBwidth = eyeFBWidth;
                cameraFBheight = Math.round((float)eyeFBWidth / aspect);
            } else {
                cameraFBwidth = Math.round((float)eyeFBHeight * aspect);
                cameraFBheight = eyeFBHeight;
            }
        }
        return new Tuple((Object)cameraFBwidth, (Object)cameraFBheight);
    }

    public boolean isInitialized() {
        return this.vr.initSuccess;
    }

    public void reinitWithoutShaders(String cause) {
        if (ShadersHelper.isShaderActive()) {
            this.resizeFrameBuffers(cause);
        } else {
            this.reinitFrameBuffers(cause);
        }
    }

    public void reinitFrameBuffers(String cause) {
        if (!this.reinitFrameBuffers) {
            VRSettings.LOGGER.info("Vivecraft: Reinit Render: {}", (Object)cause);
        }
        this.reinitFrameBuffers = true;
    }

    public void resizeFrameBuffers(String cause) {
        if (!cause.isEmpty() && !this.resizeFrameBuffers) {
            VRSettings.LOGGER.info("Vivecraft: Resizing Buffers: {}", (Object)cause);
        }
        this.resizeFrameBuffers = true;
    }

    public void setupRenderConfiguration() throws RenderConfigException, IOException {
        Tuple<Integer, Integer> cameraSize;
        Tuple<Integer, Integer> telescopeSize;
        int eyeFBHeight;
        int eyeFBWidth;
        float resolutionScale;
        int eyeh;
        int eyew;
        Tuple<Integer, Integer> tuple;
        Minecraft minecraft = Minecraft.m_91087_();
        ClientDataHolderVR dataholder = ClientDataHolderVR.getInstance();
        if (minecraft.m_91268_().m_85439_() != this.lastWindow) {
            this.lastWindow = minecraft.m_91268_().m_85439_();
            this.reinitFrameBuffers("Window Handle Changed");
        }
        if (this.lastMirror != dataholder.vrSettings.displayMirrorMode) {
            this.reinitWithoutShaders("Mirror Changed");
            this.lastMirror = dataholder.vrSettings.displayMirrorMode;
        }
        if ((this.framebufferMR == null || this.framebufferUndistorted == null) && ShadersHelper.isShaderActive()) {
            this.reinitFrameBuffers("Shaders on, but some buffers not initialized");
        }
        if (Minecraft.m_91087_().f_91066_.m_232060_().m_231551_() != this.previousGraphics) {
            this.previousGraphics = (GraphicsStatus)Minecraft.m_91087_().f_91066_.m_232060_().m_231551_();
            this.reinitFrameBuffers("gfx setting changed to: " + this.previousGraphics);
        }
        if (this.resizeFrameBuffers && !this.reinitFrameBuffers) {
            boolean mipmapChanged;
            tuple = this.getRenderTextureSizes();
            eyew = (Integer)tuple.m_14418_();
            eyeh = (Integer)tuple.m_14419_();
            resolutionScale = ResolutionControlHelper.isLoaded() ? ResolutionControlHelper.getCurrentScaleFactor() : 1.0f;
            this.renderScale = (float)Math.sqrt(dataholder.vrSettings.renderScaleFactor) * resolutionScale;
            eyeFBWidth = (int)Math.ceil((float)eyew * this.renderScale);
            eyeFBHeight = (int)Math.ceil((float)eyeh * this.renderScale);
            Tuple<Integer, Integer> mirrorSize = this.getMirrorTextureSize(eyeFBWidth, eyeFBHeight, resolutionScale);
            telescopeSize = this.getTelescopeTextureSize(eyeFBWidth, eyeFBHeight);
            cameraSize = this.getCameraTextureSize(eyeFBWidth, eyeFBHeight);
            if (dataholder.vrSettings.vrUseStencil && StencilHelper.stencilBufferSupported()) {
                ((RenderTargetExtension)WorldRenderPass.STEREO_XR.target).vivecraft$setStencil(!Xplat.enableRenderTargetStencil(WorldRenderPass.STEREO_XR.target));
            } else {
                ((RenderTargetExtension)WorldRenderPass.STEREO_XR.target).vivecraft$setStencil(false);
            }
            WorldRenderPass.STEREO_XR.resize(eyeFBWidth, eyeFBHeight);
            if (dataholder.vrSettings.useFsaa) {
                this.fsaaFirstPassResultFBO.m_83941_(eyew, eyeFBHeight, Minecraft.f_91002_);
            }
            if ((Integer)mirrorSize.m_14418_() > 0 && (Integer)mirrorSize.m_14419_() > 0) {
                if (WorldRenderPass.CENTER != null) {
                    WorldRenderPass.CENTER.resize((Integer)mirrorSize.m_14418_(), (Integer)mirrorSize.m_14419_());
                }
                if (WorldRenderPass.MIXED_REALITY != null) {
                    WorldRenderPass.MIXED_REALITY.resize((Integer)mirrorSize.m_14418_(), (Integer)mirrorSize.m_14419_());
                }
            }
            WorldRenderPass.LEFT_TELESCOPE.resize((Integer)telescopeSize.m_14418_(), (Integer)telescopeSize.m_14419_());
            WorldRenderPass.RIGHT_TELESCOPE.resize((Integer)telescopeSize.m_14418_(), (Integer)telescopeSize.m_14419_());
            this.cameraFramebuffer.m_83941_(((Integer)cameraSize.m_14418_()).intValue(), ((Integer)cameraSize.m_14419_()).intValue(), Minecraft.f_91002_);
            if (ShadersHelper.needsSameSizeBuffers()) {
                WorldRenderPass.CAMERA.resize(eyeFBWidth, eyeFBHeight);
            } else {
                WorldRenderPass.CAMERA.resize((Integer)cameraSize.m_14418_(), (Integer)cameraSize.m_14419_());
            }
            boolean bl = mipmapChanged = dataholder.vrSettings.guiMipmaps != ((RenderTargetExtension)GuiHandler.GUI_FRAMEBUFFER).vivecraft$hasMipmaps();
            if (GuiHandler.updateResolution() || mipmapChanged) {
                boolean mipmaps = dataholder.vrSettings.guiMipmaps;
                ((RenderTargetExtension)GuiHandler.GUI_FRAMEBUFFER).vivecraft$setMipmaps(mipmaps);
                GuiHandler.GUI_FRAMEBUFFER.m_83941_(GuiHandler.GUI_WIDTH, GuiHandler.GUI_HEIGHT, Minecraft.f_91002_);
                ((RenderTargetExtension)RadialHandler.FRAMEBUFFER).vivecraft$setMipmaps(mipmaps);
                RadialHandler.FRAMEBUFFER.m_83941_(GuiHandler.GUI_WIDTH, GuiHandler.GUI_HEIGHT, Minecraft.f_91002_);
                ((RenderTargetExtension)KeyboardHandler.FRAMEBUFFER).vivecraft$setMipmaps(mipmaps);
                KeyboardHandler.FRAMEBUFFER.m_83941_(GuiHandler.GUI_WIDTH, GuiHandler.GUI_HEIGHT, Minecraft.f_91002_);
                if (minecraft.f_91080_ != null) {
                    int guiWidth = minecraft.m_91268_().m_85445_();
                    int guiHeight = minecraft.m_91268_().m_85446_();
                    minecraft.f_91080_.m_6575_(minecraft, guiWidth, guiHeight);
                }
            }
            Minecraft.m_91087_().m_5741_();
            this.resizeFrameBuffers = false;
        }
        if (this.reinitFrameBuffers) {
            RenderHelper.checkGLError("Start Init");
            if (Util.m_137581_() == Util.OS.WINDOWS && GlUtil.m_84820_().toLowerCase().contains("intel")) {
                StringBuilder gpus = new StringBuilder();
                boolean onlyIntel = true;
                for (GraphicsCard gpu : new SystemInfo().getHardware().getGraphicsCards()) {
                    gpus.append("\n");
                    if (gpu.getVendor().toLowerCase().contains("intel") || gpu.getName().toLowerCase().contains("intel")) {
                        gpus.append("\u00a7c\u274c\u00a7r ");
                    } else {
                        onlyIntel = false;
                        gpus.append("\u00a7a\u2714\u00a7r ");
                    }
                    gpus.append(gpu.getVendor()).append(": ").append(gpu.getName());
                }
                throw new RenderConfigException((Component)Component.m_237115_((String)"vivecraft.messages.incompatiblegpu"), (Component)Component.m_237110_((String)"vivecraft.messages.intelgraphics1", (Object[])new Object[]{Component.m_237113_((String)GlUtil.m_84820_()).m_130940_(ChatFormatting.GOLD), gpus.toString(), onlyIntel ? Component.m_237119_() : Component.m_237110_((String)"vivecraft.messages.intelgraphics2", (Object[])new Object[]{Component.m_237113_((String)"https://www.vivecraft.org/faq/#gpu").m_130938_(style -> style.m_131162_(Boolean.valueOf(true)).m_131140_(ChatFormatting.GREEN).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)CommonComponents.f_289829_)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.vivecraft.org/faq/#gpu")))})}));
            }
            if (!this.isInitialized()) {
                throw new RenderConfigException((Component)Component.m_237110_((String)"vivecraft.messages.renderiniterror", (Object[])new Object[]{this.getName()}), (Component)Component.m_237113_((String)this.getInitError()));
            }
            tuple = this.getRenderTextureSizes();
            eyew = (Integer)tuple.m_14418_();
            eyeh = (Integer)tuple.m_14419_();
            this.destroyBuffers();
            if (this.LeftEyeTextureId == -1) {
                this.createRenderTexture(eyew, eyeh);
                if (this.LeftEyeTextureId == -1) {
                    throw new RenderConfigException((Component)Component.m_237110_((String)"vivecraft.messages.renderiniterror", (Object[])new Object[]{this.getName()}), (Component)Component.m_237113_((String)this.getLastError()));
                }
                VRSettings.LOGGER.info("Vivecraft: VR Provider supplied render texture IDs: {}, {}", (Object)this.LeftEyeTextureId, (Object)this.RightEyeTextureId);
                VRSettings.LOGGER.info("Vivecraft: VR Provider supplied texture resolution: {} x {}", (Object)eyew, (Object)eyeh);
            }
            RenderHelper.checkGLError("Render Texture setup");
            if (this.framebufferEye0 == null) {
                this.framebufferEye0 = new VRTextureTarget("L Eye", eyew, eyeh, false, this.LeftEyeTextureId, true, false, false);
                VRSettings.LOGGER.info("Vivecraft: {}", (Object)this.framebufferEye0);
                RenderHelper.checkGLError("Left Eye framebuffer setup");
            }
            if (this.framebufferEye1 == null) {
                this.framebufferEye1 = new VRTextureTarget("R Eye", eyew, eyeh, false, this.RightEyeTextureId, true, false, false);
                VRSettings.LOGGER.info("Vivecraft: {}", (Object)this.framebufferEye1);
                RenderHelper.checkGLError("Right Eye framebuffer setup");
            }
            resolutionScale = ResolutionControlHelper.isLoaded() ? ResolutionControlHelper.getCurrentScaleFactor() : 1.0f;
            this.renderScale = (float)Math.sqrt(dataholder.vrSettings.renderScaleFactor) * resolutionScale;
            eyeFBWidth = (int)Math.ceil((float)eyew * this.renderScale);
            eyeFBHeight = (int)Math.ceil((float)eyeh * this.renderScale);
            this.framebufferVrRender = new VRTextureTarget("3D Render", eyeFBWidth, eyeFBHeight, true, -1, true, false, dataholder.vrSettings.vrUseStencil && StencilHelper.stencilBufferSupported());
            WorldRenderPass.STEREO_XR = new WorldRenderPass(this.framebufferVrRender);
            VRSettings.LOGGER.info("Vivecraft: {}", (Object)this.framebufferVrRender);
            RenderHelper.checkGLError("3D framebuffer setup");
            this.getMirrorTextureSize(eyeFBWidth, eyeFBHeight, resolutionScale);
            List<RenderPass> list = this.getRenderPasses();
            VRSettings.LOGGER.info("Vivecraft: Active RenderPasses: {}", (Object)list.stream().map(Enum::toString).collect(Collectors.joining(", ")));
            if (this.mirrorFBWidth > 0 && this.mirrorFBHeight > 0) {
                if (list.contains((Object)RenderPass.THIRD) || ShadersHelper.isShaderActive()) {
                    this.framebufferMR = new VRTextureTarget("Mixed Reality Render", this.mirrorFBWidth, this.mirrorFBHeight, true, -1, true, false, false);
                    WorldRenderPass.MIXED_REALITY = new WorldRenderPass(this.framebufferMR);
                    VRSettings.LOGGER.info("Vivecraft: {}", (Object)this.framebufferMR);
                    RenderHelper.checkGLError("Mixed reality framebuffer setup");
                }
                if (list.contains((Object)RenderPass.CENTER) || ShadersHelper.isShaderActive()) {
                    this.framebufferUndistorted = new VRTextureTarget("Undistorted View Render", this.mirrorFBWidth, this.mirrorFBHeight, true, -1, true, false, false);
                    WorldRenderPass.CENTER = new WorldRenderPass(this.framebufferUndistorted);
                    VRSettings.LOGGER.info("Vivecraft: {}", (Object)this.framebufferUndistorted);
                    RenderHelper.checkGLError("Undistorted view framebuffer setup");
                }
            }
            GuiHandler.updateResolution();
            GuiHandler.GUI_FRAMEBUFFER = new VRTextureTarget("GUI", GuiHandler.GUI_WIDTH, GuiHandler.GUI_HEIGHT, true, -1, true, dataholder.vrSettings.guiMipmaps, false);
            VRSettings.LOGGER.info("Vivecraft: {}", (Object)GuiHandler.GUI_FRAMEBUFFER);
            RenderHelper.checkGLError("GUI framebuffer setup");
            KeyboardHandler.FRAMEBUFFER = new VRTextureTarget("Keyboard", GuiHandler.GUI_WIDTH, GuiHandler.GUI_HEIGHT, true, -1, true, dataholder.vrSettings.guiMipmaps, false);
            VRSettings.LOGGER.info("Vivecraft: {}", (Object)KeyboardHandler.FRAMEBUFFER);
            RenderHelper.checkGLError("Keyboard framebuffer setup");
            RadialHandler.FRAMEBUFFER = new VRTextureTarget("Radial Menu", GuiHandler.GUI_WIDTH, GuiHandler.GUI_HEIGHT, true, -1, true, dataholder.vrSettings.guiMipmaps, false);
            VRSettings.LOGGER.info("Vivecraft: {}", (Object)RadialHandler.FRAMEBUFFER);
            RenderHelper.checkGLError("Radial framebuffer setup");
            telescopeSize = this.getTelescopeTextureSize(eyeFBWidth, eyeFBHeight);
            this.telescopeFramebufferR = new VRTextureTarget("TelescopeR", (Integer)telescopeSize.m_14418_(), (Integer)telescopeSize.m_14419_(), true, -1, false, false, false);
            WorldRenderPass.RIGHT_TELESCOPE = new WorldRenderPass(this.telescopeFramebufferR);
            VRSettings.LOGGER.info("Vivecraft: {}", (Object)this.telescopeFramebufferR);
            this.telescopeFramebufferR.m_83931_(0.0f, 0.0f, 0.0f, 1.0f);
            this.telescopeFramebufferR.m_83954_(Minecraft.f_91002_);
            RenderHelper.checkGLError("TelescopeR framebuffer setup");
            this.telescopeFramebufferL = new VRTextureTarget("TelescopeL", (Integer)telescopeSize.m_14418_(), (Integer)telescopeSize.m_14419_(), true, -1, false, false, false);
            WorldRenderPass.LEFT_TELESCOPE = new WorldRenderPass(this.telescopeFramebufferL);
            VRSettings.LOGGER.info("Vivecraft: {}", (Object)this.telescopeFramebufferL);
            this.telescopeFramebufferL.m_83931_(0.0f, 0.0f, 0.0f, 1.0f);
            this.telescopeFramebufferL.m_83954_(Minecraft.f_91002_);
            RenderHelper.checkGLError("TelescopeL framebuffer setup");
            cameraSize = this.getCameraTextureSize(eyeFBWidth, eyeFBHeight);
            int cameraRenderFBwidth = (Integer)cameraSize.m_14418_();
            int cameraRenderFBheight = (Integer)cameraSize.m_14419_();
            if (ShadersHelper.needsSameSizeBuffers()) {
                cameraRenderFBwidth = eyeFBWidth;
                cameraRenderFBheight = eyeFBHeight;
            }
            this.cameraFramebuffer = new VRTextureTarget("Handheld Camera", (Integer)cameraSize.m_14418_(), (Integer)cameraSize.m_14419_(), true, -1, false, false, false);
            VRSettings.LOGGER.info("Vivecraft: {}", (Object)this.cameraFramebuffer);
            RenderHelper.checkGLError("Camera framebuffer setup");
            this.cameraRenderFramebuffer = new VRTextureTarget("Handheld Camera Render", cameraRenderFBwidth, cameraRenderFBheight, true, -1, true, false, false);
            WorldRenderPass.CAMERA = new WorldRenderPass(this.cameraRenderFramebuffer);
            VRSettings.LOGGER.info("Vivecraft: {}", (Object)this.cameraRenderFramebuffer);
            RenderHelper.checkGLError("Camera render framebuffer setup");
            if (dataholder.vrSettings.useFsaa) {
                try {
                    RenderHelper.checkGLError("pre FSAA FBO creation");
                    this.fsaaFirstPassResultFBO = new VRTextureTarget("FSAA Pass1 FBO", eyew, eyeFBHeight, true, -1, false, false, false);
                    this.fsaaLastPassResultFBO = new VRTextureTarget("FSAA Pass2 FBO", eyew, eyeh, true, -1, false, false, false);
                    VRSettings.LOGGER.info("Vivecraft: {}", (Object)this.fsaaFirstPassResultFBO);
                    VRSettings.LOGGER.info("Vivecraft: {}", (Object)this.fsaaLastPassResultFBO);
                    RenderHelper.checkGLError("FSAA FBO creation");
                    VRShaders.setupFSAA();
                    RenderHelper.checkGLError("FBO init fsaa shader");
                }
                catch (Exception exception) {
                    dataholder.vrSettings.useFsaa = false;
                    dataholder.vrSettings.saveOptions();
                    VRSettings.LOGGER.error("Vivecraft: FSAA init failed: ", (Throwable)exception);
                    this.reinitFrameBuffers = true;
                    return;
                }
            }
            try {
                minecraft.f_91042_ = this.framebufferVrRender;
                VRShaders.setupBlitAspect();
                RenderHelper.checkGLError("init blit aspect shader");
                VRShaders.setupDepthMask();
                RenderHelper.checkGLError("init depth shader");
                VRShaders.setupFOVReduction();
                RenderHelper.checkGLError("init FOV shader");
                VRShaders.setupPortalShaders();
                RenderHelper.checkGLError("init portal shader");
                minecraft.f_91063_.m_109106_(minecraft.m_91288_());
            }
            catch (Exception exception) {
                VRSettings.LOGGER.error("Vivecraft: Shader creation failed:", (Throwable)exception);
                throw new RenderConfigException((Component)Component.m_237110_((String)"vivecraft.messages.renderiniterror", (Object[])new Object[]{this.getName()}), TextUtils.throwableToComponent(exception));
            }
            if (minecraft.f_91080_ != null) {
                int w = minecraft.m_91268_().m_85445_();
                int h = minecraft.m_91268_().m_85446_();
                minecraft.f_91080_.m_6575_(minecraft, w, h);
            }
            long windowPixels = (long)((WindowExtension)minecraft.m_91268_()).vivecraft$getActualScreenWidth() * (long)((WindowExtension)minecraft.m_91268_()).vivecraft$getActualScreenHeight();
            long mirrorPixels = (long)this.mirrorFBWidth * (long)this.mirrorFBHeight;
            long vrPixels = (long)eyeFBWidth * (long)eyeFBHeight;
            long pixelsPerFrame = vrPixels * 2L;
            if (list.contains((Object)RenderPass.CENTER)) {
                pixelsPerFrame += mirrorPixels;
            }
            if (list.contains((Object)RenderPass.THIRD)) {
                pixelsPerFrame += mirrorPixels;
            }
            VRSettings.LOGGER.info("Vivecraft:\nNew VR render config:\nVR target: {}x{} [{}MP]\nRender target: {}x{} [Render scale: {}%, {}MP]\nMain window: {}x{} [{}MP]\nTotal shaded pixels per frame: {}MP (eye stencil not accounted for)", new Object[]{eyew, eyeh, String.format("%.1f", Float.valueOf((float)(eyew * eyeh) / 1000000.0f)), eyeFBWidth, eyeFBHeight, Float.valueOf(dataholder.vrSettings.renderScaleFactor * 100.0f), String.format("%.1f", Float.valueOf((float)vrPixels / 1000000.0f)), ((WindowExtension)minecraft.m_91268_()).vivecraft$getActualScreenWidth(), ((WindowExtension)minecraft.m_91268_()).vivecraft$getActualScreenHeight(), String.format("%.1f", Float.valueOf((float)windowPixels / 1000000.0f)), String.format("%.1f", Float.valueOf((float)pixelsPerFrame / 1000000.0f))});
            minecraft.f_91060_.m_6213_(minecraft.m_91098_());
            ShadersHelper.maybeReloadShaders();
            this.reinitFrameBuffers = false;
            this.resizeFrameBuffers = false;
        }
    }

    protected void destroyBuffers() {
        if (this.framebufferVrRender != null) {
            WorldRenderPass.STEREO_XR.close();
            WorldRenderPass.STEREO_XR = null;
            this.framebufferVrRender.m_83930_();
            this.framebufferVrRender = null;
        }
        if (this.framebufferMR != null) {
            WorldRenderPass.MIXED_REALITY.close();
            WorldRenderPass.MIXED_REALITY = null;
            this.framebufferMR.m_83930_();
            this.framebufferMR = null;
        }
        if (this.framebufferUndistorted != null) {
            WorldRenderPass.CENTER.close();
            WorldRenderPass.CENTER = null;
            this.framebufferUndistorted.m_83930_();
            this.framebufferUndistorted = null;
        }
        if (GuiHandler.GUI_FRAMEBUFFER != null) {
            GuiHandler.GUI_FRAMEBUFFER.m_83930_();
            GuiHandler.GUI_FRAMEBUFFER = null;
        }
        if (KeyboardHandler.FRAMEBUFFER != null) {
            KeyboardHandler.FRAMEBUFFER.m_83930_();
            KeyboardHandler.FRAMEBUFFER = null;
        }
        if (RadialHandler.FRAMEBUFFER != null) {
            RadialHandler.FRAMEBUFFER.m_83930_();
            RadialHandler.FRAMEBUFFER = null;
        }
        if (this.telescopeFramebufferL != null) {
            WorldRenderPass.LEFT_TELESCOPE.close();
            WorldRenderPass.LEFT_TELESCOPE = null;
            this.telescopeFramebufferL.m_83930_();
            this.telescopeFramebufferL = null;
        }
        if (this.telescopeFramebufferR != null) {
            WorldRenderPass.RIGHT_TELESCOPE.close();
            WorldRenderPass.RIGHT_TELESCOPE = null;
            this.telescopeFramebufferR.m_83930_();
            this.telescopeFramebufferR = null;
        }
        if (this.cameraFramebuffer != null) {
            this.cameraFramebuffer.m_83930_();
            this.cameraFramebuffer = null;
        }
        if (this.cameraRenderFramebuffer != null) {
            WorldRenderPass.CAMERA.close();
            WorldRenderPass.CAMERA = null;
            this.cameraRenderFramebuffer.m_83930_();
            this.cameraRenderFramebuffer = null;
        }
        if (this.fsaaFirstPassResultFBO != null) {
            this.fsaaFirstPassResultFBO.m_83930_();
            this.fsaaFirstPassResultFBO = null;
        }
        if (this.fsaaLastPassResultFBO != null) {
            this.fsaaLastPassResultFBO.m_83930_();
            this.fsaaLastPassResultFBO = null;
        }
        if (this.framebufferEye0 != null) {
            this.framebufferEye0.m_83930_();
            this.framebufferEye0 = null;
            this.LeftEyeTextureId = -1;
        }
        if (this.framebufferEye1 != null) {
            this.framebufferEye1.m_83930_();
            this.framebufferEye1 = null;
            this.RightEyeTextureId = -1;
        }
    }

    public void destroy() {
        this.destroyBuffers();
    }
}

