/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.provider.InputSimulator;
import org.vivecraft.client_vr.provider.MCVR;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.settings.OptionEnum;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.client_vr.utils.RGBAColor;

public class PhysicalKeyboard {
    private static final int ROWS = 4;
    private static final int COLUMNS = 13;
    private static final float SPACING = 0.0064f;
    private static final float KEY_WIDTH = 0.04f;
    private static final float KEY_HEIGHT = 0.04f;
    private static final float KEY_WIDTH_SPECIAL = 0.086399995f;
    private final Minecraft mc = Minecraft.m_91087_();
    private final ClientDataHolderVR dh = ClientDataHolderVR.getInstance();
    private boolean reinit;
    private boolean shift;
    private boolean shiftSticky;
    private final List<KeyButton> keys;
    private int rows;
    private int columns;
    private float spacing;
    private float keyWidth;
    private float keyHeight;
    private float keyWidthSpecial;
    private float scale = 1.0f;
    private final KeyButton[] pressedKey = new KeyButton[2];
    private final long[] pressTime = new long[2];
    private final long[] pressRepeatTime = new long[2];
    private long shiftPressTime;
    private boolean lastPressedShift;
    private Supplier<String> easterEggText = () -> {
        int[] data = new int[]{188, 161, 183, 175, 162, 238, 188, 175, 167, 160, 172, 161, 185};
        byte[] bytes = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            bytes[i] = (byte)(data[i] ^ 0xCE);
        }
        String str = new String(bytes, StandardCharsets.UTF_8);
        this.easterEggText = () -> str;
        return str;
    };
    private int easterEggIndex = 0;
    private boolean easterEggActive;
    private final Map<Integer, RGBAColor> customTheme = new HashMap<Integer, RGBAColor>();

    public PhysicalKeyboard() {
        this.keys = new ArrayList<KeyButton>();
    }

    public void init() {
        float calcRows;
        this.unpressAllKeys();
        this.keys.clear();
        this.rows = 4;
        this.columns = 13;
        this.spacing = 0.0064f * this.scale;
        this.keyWidth = 0.04f * this.scale;
        this.keyHeight = 0.04f * this.scale;
        this.keyWidthSpecial = 0.086399995f * this.scale;
        String chars = this.dh.vrSettings.keyboardKeys;
        if (this.shift) {
            chars = this.dh.vrSettings.keyboardKeysShift;
        }
        if (Math.abs((float)this.rows - (calcRows = (float)chars.length() / (float)this.columns)) > 0.01f) {
            this.rows = Mth.m_14167_((float)calcRows);
        }
        for (int row = 0; row < this.rows; ++row) {
            for (int column = 0; column < this.columns; ++column) {
                int index = row * this.columns + column;
                char ch = ' ';
                if (index < chars.length()) {
                    ch = chars.charAt(index);
                }
                final char buttonChar = ch;
                final int code = index < this.dh.vrSettings.keyboardCodes.length ? this.dh.vrSettings.keyboardCodes[index] : -1;
                this.addKey(new KeyButton(index, String.valueOf(ch), this.keyWidthSpecial + this.spacing + (float)column * (this.keyWidth + this.spacing), (float)row * (this.keyHeight + this.spacing), this.keyWidth, this.keyHeight){

                    @Override
                    public void onPressed() {
                        InputSimulator.pressKeyForBind(code);
                        InputSimulator.typeChar(buttonChar);
                        if (!PhysicalKeyboard.this.shiftSticky) {
                            PhysicalKeyboard.this.setShift(false, false);
                        }
                        if (buttonChar == '/' && PhysicalKeyboard.this.mc.f_91080_ == null) {
                            InputSimulator.pressKey(47);
                            InputSimulator.releaseKey(47);
                        }
                    }

                    @Override
                    public void onReleased() {
                        InputSimulator.releaseKeyForBind(code);
                    }
                });
            }
        }
        for (int i = 0; i < 2; ++i) {
            this.addKey(new KeyButton(1000 + i, "Shift", i == 1 ? this.keyWidthSpecial + this.spacing + (float)this.columns * (this.keyWidth + this.spacing) : 0.0f, 3.0f * (this.keyHeight + this.spacing), this.keyWidthSpecial, this.keyHeight){

                @Override
                public void onPressed() {
                    if (PhysicalKeyboard.this.shift && !PhysicalKeyboard.this.shiftSticky && ClientUtils.milliTime() - PhysicalKeyboard.this.shiftPressTime < 400L) {
                        PhysicalKeyboard.this.setShift(true, true);
                    } else {
                        PhysicalKeyboard.this.setShift(!PhysicalKeyboard.this.shift, false);
                    }
                    PhysicalKeyboard.this.shiftPressTime = ClientUtils.milliTime();
                }

                @Override
                public RGBAColor getRenderColor() {
                    if (PhysicalKeyboard.this.shift) {
                        RGBAColor color = new RGBAColor(this.pressed ? 1.0f : 0.5f, this.pressed ? 1.0f : 0.5f, 0.0f, 0.5f);
                        if (!PhysicalKeyboard.this.shiftSticky) {
                            color.r = 0.0f;
                        }
                        return color;
                    }
                    return super.getRenderColor();
                }
            });
        }
        this.addKey(new KeyButton(1002, " ", this.keyWidthSpecial + this.spacing + (float)(this.columns - 5) / 2.0f * (this.keyWidth + this.spacing), (float)this.rows * (this.keyHeight + this.spacing), 5.0f * (this.keyWidth + this.spacing) - this.spacing, this.keyHeight){

            @Override
            public void onPressed() {
                InputSimulator.pressKeyForBind(32);
                InputSimulator.typeChar(' ');
            }

            @Override
            public void onReleased() {
                InputSimulator.releaseKeyForBind(32);
            }
        });
        this.addKey(new KeyPressButton(1003, "Tab", 0.0f, this.keyHeight + this.spacing, this.keyWidthSpecial, this.keyHeight, 258));
        this.addKey(new KeyPressButton(1004, "Esc", 0.0f, 0.0f, this.keyWidthSpecial, this.keyHeight, 256));
        this.addKey(new KeyPressButton(1005, "Bksp", this.keyWidthSpecial + this.spacing + (float)this.columns * (this.keyWidth + this.spacing), 0.0f, this.keyWidthSpecial, this.keyHeight, 259));
        this.addKey(new KeyPressButton(1006, "Enter", this.keyWidthSpecial + this.spacing + (float)this.columns * (this.keyWidth + this.spacing), 2.0f * (this.keyHeight + this.spacing), this.keyWidthSpecial, this.keyHeight, 257));
        this.addKey(new KeyPressButton(1007, "\u2191", this.keyWidthSpecial + this.spacing + (float)(this.columns + 1) * (this.keyWidth + this.spacing), 4.0f * (this.keyHeight + this.spacing), this.keyWidth, this.keyHeight, 265));
        this.addKey(new KeyPressButton(1008, "\u2193", this.keyWidthSpecial + this.spacing + (float)(this.columns + 1) * (this.keyWidth + this.spacing), 5.0f * (this.keyHeight + this.spacing), this.keyWidth, this.keyHeight, 264));
        this.addKey(new KeyPressButton(1009, "\u2190", this.keyWidthSpecial + this.spacing + (float)this.columns * (this.keyWidth + this.spacing), 5.0f * (this.keyHeight + this.spacing), this.keyWidth, this.keyHeight, 263));
        this.addKey(new KeyPressButton(1010, "\u2192", this.keyWidthSpecial + this.spacing + (float)(this.columns + 2) * (this.keyWidth + this.spacing), 5.0f * (this.keyHeight + this.spacing), this.keyWidth, this.keyHeight, 262));
        this.addKey(new KeyButton(1011, "Cut", this.keyWidthSpecial + this.spacing, -1.0f * (this.keyHeight + this.spacing), this.keyWidthSpecial, this.keyHeight){

            @Override
            public void onPressed() {
                InputSimulator.pressKey(341);
                InputSimulator.pressKey(88);
                InputSimulator.releaseKey(88);
                InputSimulator.releaseKey(341);
            }
        });
        this.addKey(new KeyButton(1012, "Copy", 2.0f * (this.keyWidthSpecial + this.spacing), -1.0f * (this.keyHeight + this.spacing), this.keyWidthSpecial, this.keyHeight){

            @Override
            public void onPressed() {
                InputSimulator.pressKey(341);
                InputSimulator.pressKey(67);
                InputSimulator.releaseKey(67);
                InputSimulator.releaseKey(341);
            }
        });
        this.addKey(new KeyButton(1013, "Paste", 3.0f * (this.keyWidthSpecial + this.spacing), -1.0f * (this.keyHeight + this.spacing), this.keyWidthSpecial, this.keyHeight){

            @Override
            public void onPressed() {
                InputSimulator.pressKey(341);
                InputSimulator.pressKey(86);
                InputSimulator.releaseKey(86);
                InputSimulator.releaseKey(341);
            }
        });
        block17: for (int c = 0; c < 2; ++c) {
            if (this.pressedKey[c] == null) continue;
            for (KeyButton key : this.keys) {
                if (key.id != this.pressedKey[c].id) continue;
                this.pressedKey[c] = key;
                key.pressed = true;
                continue block17;
            }
        }
        if (this.dh.vrSettings.physicalKeyboardTheme == KeyboardTheme.CUSTOM) {
            this.customTheme.clear();
            File themeFile = new File(this.mc.f_91069_, "keyboardtheme.txt");
            if (!themeFile.exists()) {
                try (PrintWriter pw = new PrintWriter(new FileWriter(themeFile, StandardCharsets.UTF_8));){
                    char[] normalChars = this.dh.vrSettings.keyboardKeys.toCharArray();
                    for (int i = 0; i < normalChars.length; ++i) {
                        pw.println("# " + normalChars[i] + " (Normal)");
                        pw.println(i + "=255,255,255");
                    }
                    char[] shiftChars = this.dh.vrSettings.keyboardKeysShift.toCharArray();
                    for (int i = 0; i < shiftChars.length; ++i) {
                        pw.println("# " + shiftChars[i] + " (Shifted)");
                        pw.println(i + 500 + "=255,255,255");
                    }
                    this.keys.forEach(button -> {
                        if (button.id >= 1000) {
                            pw.println("# " + button.label);
                            pw.println(button.id + "=255,255,255");
                        }
                    });
                }
                catch (IOException ex) {
                    VRSettings.LOGGER.error("Vivecraft: error creating keyboard template: ", (Throwable)ex);
                }
            } else {
                try (Stream<String> lines = Files.lines(Paths.get(themeFile.toURI()), StandardCharsets.UTF_8);){
                    lines.forEach(line -> {
                        if (line.isEmpty() || line.charAt(0) == '#') {
                            return;
                        }
                        try {
                            String[] split = line.split("=", 2);
                            int id = Integer.parseInt(split[0]);
                            String[] colorSplit = split[1].split(",");
                            RGBAColor color = new RGBAColor(Integer.parseInt(colorSplit[0]), Integer.parseInt(colorSplit[1]), Integer.parseInt(colorSplit[2]), 255);
                            this.customTheme.put(id, color);
                        }
                        catch (Exception ex) {
                            VRSettings.LOGGER.error("Vivecraft: error reading keyboard theme line: {}:", line, (Object)ex);
                        }
                    });
                }
                catch (IOException ex) {
                    VRSettings.LOGGER.error("Vivecraft: error reading keyboard theme:", (Throwable)ex);
                }
            }
        }
        this.reinit = false;
    }

    public void process() {
        if (this.reinit) {
            this.init();
        }
        for (int c = 0; c < 2; ++c) {
            ControllerType controller = ControllerType.values()[c];
            KeyButton key = this.findTouchedKey(controller);
            long milliTime = ClientUtils.milliTime();
            if (key != null) {
                if (key != this.pressedKey[c] && milliTime - this.pressTime[c] >= 150L) {
                    if (this.pressedKey[c] != null) {
                        this.pressedKey[c].unpress();
                        this.pressedKey[c] = null;
                    }
                    key.press(controller, false);
                    this.pressedKey[c] = key;
                    this.pressTime[c] = milliTime;
                    this.pressRepeatTime[c] = milliTime;
                    continue;
                }
                if (key != this.pressedKey[c] || milliTime - this.pressTime[c] < 500L || milliTime - this.pressRepeatTime[c] < 100L) continue;
                key.press(controller, true);
                this.pressRepeatTime[c] = milliTime;
                continue;
            }
            if (this.pressedKey[c] == null) continue;
            this.pressedKey[c].unpress();
            this.pressedKey[c] = null;
            this.pressTime[c] = milliTime;
        }
    }

    public void processBindings() {
        if (GuiHandler.KEY_KEYBOARD_SHIFT.m_90859_()) {
            this.setShift(true, true);
            this.lastPressedShift = true;
        }
        if (!GuiHandler.KEY_KEYBOARD_SHIFT.m_90857_() && this.lastPressedShift) {
            this.setShift(false, false);
            this.lastPressedShift = false;
        }
    }

    private Vector3f getCenterPos() {
        return new Vector3f(((this.keyWidth + this.spacing) * ((float)this.columns + (float)this.columns % 2.0f / 2.0f) + (this.keyWidthSpecial + this.spacing) * 2.0f) / 2.0f, (this.keyHeight + this.spacing) * (float)(this.rows + 1), 0.0f);
    }

    private KeyButton findTouchedKey(ControllerType controller) {
        Matrix4f matrix = new Matrix4f();
        matrix.translate((Vector3fc)this.getCenterPos());
        matrix.mul((Matrix4fc)new Matrix4f((Matrix4fc)KeyboardHandler.ROTATION_ROOM).invert());
        matrix.translate(-KeyboardHandler.POS_ROOM.x, -KeyboardHandler.POS_ROOM.y, -KeyboardHandler.POS_ROOM.z);
        Vector3f pos = matrix.transformPosition(this.dh.vrPlayer.vrdata_room_pre.getController(controller.ordinal()).getPositionF());
        for (KeyButton key : this.keys) {
            if (!key.getCollisionBoundingBox().m_82393_((double)pos.x, (double)pos.y, (double)pos.z)) continue;
            return key;
        }
        return null;
    }

    private void updateEasterEgg(String label) {
        String text = this.easterEggText.get();
        if (this.easterEggIndex < text.length()) {
            this.easterEggIndex = label.toLowerCase().equals(String.valueOf(text.charAt(this.easterEggIndex))) ? ++this.easterEggIndex : 0;
        } else if (label.equals("Enter")) {
            this.easterEggActive = !this.easterEggActive;
        } else {
            this.easterEggIndex = 0;
        }
    }

    private void drawBox(BufferBuilder buf, AABB box, RGBAColor color, PoseStack poseStack) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float minX = (float)box.f_82288_;
        float minY = (float)box.f_82289_;
        float minZ = (float)box.f_82290_;
        float maxX = (float)box.f_82291_;
        float maxY = (float)box.f_82292_;
        float maxZ = (float)box.f_82293_;
        buf.m_252986_(matrix, minX, minY, minZ).m_7421_(0.0f, 0.0f).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buf.m_252986_(matrix, minX, maxY, minZ).m_7421_(0.0f, 0.0f).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buf.m_252986_(matrix, maxX, maxY, minZ).m_7421_(0.0f, 0.0f).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buf.m_252986_(matrix, maxX, minY, minZ).m_7421_(0.0f, 0.0f).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buf.m_252986_(matrix, minX, minY, minZ).m_7421_(0.0f, 0.0f).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buf.m_252986_(matrix, maxX, minY, minZ).m_7421_(0.0f, 0.0f).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buf.m_252986_(matrix, maxX, minY, maxZ).m_7421_(0.0f, 0.0f).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buf.m_252986_(matrix, minX, minY, maxZ).m_7421_(0.0f, 0.0f).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buf.m_252986_(matrix, minX, minY, minZ).m_7421_(0.0f, 0.0f).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buf.m_252986_(matrix, minX, minY, maxZ).m_7421_(0.0f, 0.0f).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buf.m_252986_(matrix, minX, maxY, maxZ).m_7421_(0.0f, 0.0f).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buf.m_252986_(matrix, minX, maxY, minZ).m_7421_(0.0f, 0.0f).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buf.m_252986_(matrix, maxX, maxY, maxZ).m_7421_(0.0f, 0.0f).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buf.m_252986_(matrix, minX, maxY, maxZ).m_7421_(0.0f, 0.0f).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buf.m_252986_(matrix, minX, minY, maxZ).m_7421_(0.0f, 0.0f).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buf.m_252986_(matrix, maxX, minY, maxZ).m_7421_(0.0f, 0.0f).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buf.m_252986_(matrix, maxX, maxY, maxZ).m_7421_(0.0f, 0.0f).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buf.m_252986_(matrix, maxX, maxY, minZ).m_7421_(0.0f, 0.0f).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buf.m_252986_(matrix, minX, maxY, minZ).m_7421_(0.0f, 0.0f).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buf.m_252986_(matrix, minX, maxY, maxZ).m_7421_(0.0f, 0.0f).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buf.m_252986_(matrix, maxX, maxY, maxZ).m_7421_(0.0f, 0.0f).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buf.m_252986_(matrix, maxX, minY, maxZ).m_7421_(0.0f, 0.0f).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buf.m_252986_(matrix, maxX, minY, minZ).m_7421_(0.0f, 0.0f).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buf.m_252986_(matrix, maxX, maxY, minZ).m_7421_(0.0f, 0.0f).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
    }

    public void render(PoseStack poseStack) {
        if (this.keys.isEmpty()) {
            return;
        }
        poseStack.m_85836_();
        Vector3f center = this.getCenterPos();
        poseStack.m_252880_(-center.x, -center.y, -center.z);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        if (this.easterEggActive) {
            for (KeyButton key : this.keys) {
                RGBAColor color = RGBAColor.fromHSB(((float)this.dh.tickCounter + ClientUtils.getCurrentPartialTick()) / 100.0f + (float)(key.boundingBox.f_82288_ + (key.boundingBox.f_82291_ - key.boundingBox.f_82288_) / 2.0) / 2.0f, 1.0f, 1.0f);
                key.color.r = color.r;
                key.color.g = color.g;
                key.color.b = color.b;
            }
        } else {
            this.keys.forEach(button -> {
                if (this.dh.vrSettings.physicalKeyboardTheme == KeyboardTheme.CUSTOM) {
                    RGBAColor color = this.customTheme.get(this.shift && button.id < 1000 ? button.id + 500 : button.id);
                    if (color != null) {
                        button.color.r = color.r;
                        button.color.g = color.g;
                        button.color.b = color.b;
                    }
                } else {
                    this.dh.vrSettings.physicalKeyboardTheme.assignColor((KeyButton)button);
                }
            });
        }
        RenderSystem.depthFunc((int)519);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Font font = this.mc.f_91062_;
        ArrayList<Tuple> labels = new ArrayList<Tuple>();
        float textScale = 0.002f * this.scale;
        RenderSystem.setShader(GameRenderer::m_172820_);
        this.mc.m_91097_().m_174784_(RenderHelper.WHITE_TEXTURE);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)RenderHelper.WHITE_TEXTURE);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buf = tesselator.m_85915_();
        buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        for (KeyButton key : this.keys) {
            AABB box = key.getRenderBoundingBox();
            RGBAColor color = key.getRenderColor();
            this.drawBox(buf, box, color, poseStack);
            float stringWidth = (float)font.m_92895_(key.label) * textScale;
            Objects.requireNonNull(font);
            float stringHeight = 9.0f * textScale;
            float textX = (float)box.f_82288_ + ((float)box.f_82291_ - (float)box.f_82288_) / 2.0f - stringWidth / 2.0f;
            float textY = (float)box.f_82289_ + ((float)box.f_82292_ - (float)box.f_82289_) / 2.0f - stringHeight / 2.0f;
            float textZ = (float)box.f_82290_ + ((float)box.f_82293_ - (float)box.f_82290_) / 2.0f;
            labels.add(new Tuple((Object)key.label, (Object)new Vector3f(textX, textY, textZ)));
        }
        tesselator.m_85914_();
        RenderSystem.depthFunc((int)515);
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)tesselator.m_85915_());
        for (Tuple label : labels) {
            poseStack.m_85836_();
            poseStack.m_252880_(((Vector3f)label.m_14419_()).x, ((Vector3f)label.m_14419_()).y, ((Vector3f)label.m_14419_()).z);
            poseStack.m_85841_(textScale, textScale, 1.0f);
            font.m_272078_((String)label.m_14418_(), 0.0f, 0.0f, -1, false, poseStack.m_85850_().m_252922_(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.m_92718_());
            poseStack.m_85849_();
        }
        bufferSource.m_109911_();
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.defaultBlendFunc();
        poseStack.m_85849_();
    }

    public void show() {
        if (!this.shiftSticky) {
            this.shift = false;
        }
        this.scale = this.dh.vrSettings.physicalKeyboardScale;
        this.reinit = true;
    }

    public void unpressAllKeys() {
        for (KeyButton key : this.keys) {
            if (!key.pressed) continue;
            key.unpress();
        }
    }

    private KeyButton addKey(KeyButton key) {
        this.keys.add(key);
        return key;
    }

    public boolean isShift() {
        return this.shift;
    }

    public boolean isShiftSticky() {
        return this.shiftSticky;
    }

    public void setShift(boolean shift, boolean sticky) {
        if (shift != this.shift || sticky != this.shiftSticky) {
            this.shift = shift;
            this.shiftSticky = shift && sticky;
            this.reinit = true;
        }
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.reinit = true;
    }

    private abstract class KeyButton {
        public final int id;
        public final String label;
        public final AABB boundingBox;
        public RGBAColor color = new RGBAColor(1.0f, 1.0f, 1.0f, 0.5f);
        public boolean pressed;

        public KeyButton(int id, String label, float x, float y, float width, float height) {
            this.id = id;
            this.label = label;
            this.boundingBox = new AABB((double)x, (double)y, 0.0, (double)(x + width), (double)(y + height), 0.028 * (double)PhysicalKeyboard.this.scale);
        }

        public AABB getRenderBoundingBox() {
            return this.pressed ? this.boundingBox.m_82386_(0.0, 0.0, 0.012 * (double)PhysicalKeyboard.this.scale) : this.boundingBox;
        }

        public AABB getCollisionBoundingBox() {
            return this.pressed ? this.boundingBox.m_82363_(0.0, 0.0, 0.08) : this.boundingBox;
        }

        public RGBAColor getRenderColor() {
            RGBAColor color = this.color.copy();
            if (!this.pressed) {
                color.r *= 0.5f;
                color.g *= 0.5f;
                color.b *= 0.5f;
            }
            return color;
        }

        public final void press(ControllerType controller, boolean isRepeat) {
            if (!isRepeat) {
                PhysicalKeyboard.this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            }
            MCVR.get().triggerHapticPulse(controller, isRepeat ? 300 : 600);
            this.pressed = true;
            this.onPressed();
            PhysicalKeyboard.this.updateEasterEgg(this.label);
        }

        public final void unpress() {
            this.pressed = false;
            this.onReleased();
        }

        public abstract void onPressed();

        public void onReleased() {
        }
    }

    private class KeyPressButton
    extends KeyButton {
        private final int keyCode;

        public KeyPressButton(int id, String label, float x, float y, float width, float height, int keyCode) {
            super(id, label, x, y, width, height);
            this.keyCode = keyCode;
        }

        @Override
        public void onPressed() {
            InputSimulator.pressKey(this.keyCode);
        }

        @Override
        public void onReleased() {
            InputSimulator.releaseKey(this.keyCode);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum KeyboardTheme implements OptionEnum<KeyboardTheme>
    {
        DEFAULT{

            @Override
            public void assignColor(KeyButton button) {
                button.color.r = 1.0f;
                button.color.g = 1.0f;
                button.color.b = 1.0f;
            }
        }
        ,
        RED{

            @Override
            public void assignColor(KeyButton button) {
                button.color.r = 1.0f;
                button.color.g = 0.0f;
                button.color.b = 0.0f;
            }
        }
        ,
        GREEN{

            @Override
            public void assignColor(KeyButton button) {
                button.color.r = 0.0f;
                button.color.g = 1.0f;
                button.color.b = 0.0f;
            }
        }
        ,
        BLUE{

            @Override
            public void assignColor(KeyButton button) {
                button.color.r = 0.0f;
                button.color.g = 0.0f;
                button.color.b = 1.0f;
            }
        }
        ,
        BLACK{

            @Override
            public void assignColor(KeyButton button) {
                button.color.r = 0.0f;
                button.color.g = 0.0f;
                button.color.b = 0.0f;
            }
        }
        ,
        GRASS{

            @Override
            public void assignColor(KeyButton button) {
                if (button.boundingBox.f_82292_ < 0.07) {
                    button.color.r = 0.321f;
                    button.color.g = 0.584f;
                    button.color.b = 0.184f;
                } else {
                    button.color.r = 0.607f;
                    button.color.g = 0.462f;
                    button.color.b = 0.325f;
                }
            }
        }
        ,
        BEES{

            @Override
            public void assignColor(KeyButton button) {
                float val;
                button.color.r = val = button.boundingBox.f_82291_ % 0.2 < 0.1 ? 1.0f : 0.0f;
                button.color.g = val;
                button.color.b = 0.0f;
            }
        }
        ,
        AESTHETIC{

            @Override
            public void assignColor(KeyButton button) {
                if (button.id >= 1000) {
                    button.color.r = 0.0f;
                    button.color.g = 1.0f;
                    button.color.b = 1.0f;
                } else {
                    button.color.r = 1.0f;
                    button.color.g = 0.0f;
                    button.color.b = 1.0f;
                }
            }
        }
        ,
        DOSE{

            @Override
            public void assignColor(KeyButton button) {
                button.color.r = button.id % 2 == 0 ? 0.5f : 0.0f;
                button.color.g = button.id % 2 == 0 ? 0.0f : 1.0f;
                button.color.b = button.id % 2 == 0 ? 1.0f : 0.0f;
            }
        }
        ,
        CUSTOM{

            @Override
            public void assignColor(KeyButton button) {
            }
        };


        public abstract void assignColor(KeyButton var1);
    }
}

