/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.item.FoodOnAStickItem;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.gameplay.trackers.Tracker;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.data.ItemTags;

public class VehicleTracker
extends Tracker {
    private float PreMount_World_Rotation;
    public Vec3 Premount_Pos_Room = Vec3.f_82478_;
    public float vehicleInitialRotation = 0.0f;
    public int rotationCooldown = 0;
    public int dismountCooldown = 0;
    private double rotationTarget = 0.0;
    private int minecartStupidityCounter;
    private boolean isRiding = false;

    public VehicleTracker(Minecraft mc, ClientDataHolderVR dh) {
        super(mc, dh);
    }

    @Override
    public boolean isActive(LocalPlayer player) {
        if (player == null) {
            return false;
        }
        if (this.mc.f_91072_ == null) {
            return false;
        }
        return player.m_6084_();
    }

    @Override
    public void reset(LocalPlayer player) {
        this.minecartStupidityCounter = 2;
        this.isRiding = false;
    }

    public double getVehicleFloor(Entity vehicle, double original) {
        return original;
    }

    public static Vector3f getSteeringDirection(LocalPlayer player) {
        Mob mob;
        Entity entity = player.m_20202_();
        ClientDataHolderVR dataHolder = ClientDataHolderVR.getInstance();
        if (entity instanceof AbstractHorse || entity instanceof Boat) {
            if (player.f_20902_ > 0.0f) {
                if (dataHolder.vrSettings.vrFreeMoveMode == VRSettings.FreeMove.HMD) {
                    return dataHolder.vrPlayer.vrdata_world_pre.hmd.getDirection();
                }
                return dataHolder.vrPlayer.vrdata_world_pre.getController(0).getDirection();
            }
        } else if (entity instanceof Mob && (mob = (Mob)entity).m_6109_()) {
            int c = player.m_21205_().m_41720_() instanceof FoodOnAStickItem || player.m_21205_().m_204117_(ItemTags.VIVECRAFT_FOOD_STICKS) ? 0 : 1;
            VRData.VRDevicePose con = dataHolder.vrPlayer.vrdata_world_pre.getController(c);
            return MathUtils.subtractToVector3f(con.getPosition(), entity.m_20182_()).add((Vector3fc)con.getDirection().mul(0.3f)).normalize();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void doProcess(LocalPlayer player) {
        block21: {
            block23: {
                block22: {
                    if (this.mc.m_91104_()) break block21;
                    if (this.dismountCooldown > 0) {
                        --this.dismountCooldown;
                    }
                    if (this.rotationCooldown > 0) {
                        --this.rotationCooldown;
                    }
                    if (!this.dh.vrSettings.vehicleRotation || this.rotationCooldown != 0 || !this.mc.f_91074_.m_20159_() && (this.mc.m_91288_() == null || this.mc.m_91288_() == this.mc.f_91074_)) break block22;
                    entity = this.mc.f_91074_.m_20202_();
                    if (this.mc.m_91288_() != null && this.mc.m_91288_() != this.mc.f_91074_) {
                        entity = this.mc.m_91288_();
                    }
                    this.rotationTarget = entity.m_146908_();
                    if (!(entity instanceof AbstractHorse)) ** GOTO lbl-1000
                    abstracthorse = (AbstractHorse)entity;
                    if (!this.dh.horseTracker.isActive(this.mc.f_91074_)) {
                        if (abstracthorse.m_6109_() && abstracthorse.m_6254_()) {
                            return;
                        }
                        this.rotationTarget = abstracthorse.f_20883_;
                    } else if (entity instanceof Mob) {
                        mob = (Mob)entity;
                        if (mob.m_6109_()) {
                            return;
                        }
                        this.rotationTarget = mob.f_20883_;
                    }
                    smooth = true;
                    smoothIncrement = 10.0f;
                    if (entity instanceof Minecart) {
                        minecart = (Minecart)entity;
                        if (this.shouldMinecartTurnView(minecart)) {
                            if (this.minecartStupidityCounter > 0) {
                                --this.minecartStupidityCounter;
                            }
                        } else {
                            this.minecartStupidityCounter = 3;
                        }
                        this.rotationTarget = this.getMinecartRenderYaw(minecart);
                        if (this.minecartStupidityCounter > 0) {
                            this.vehicleInitialRotation = (float)this.rotationTarget;
                        }
                        if ((smoothIncrement = 200.0f * (float)((speed = this.mineCartSpeed(minecart)) * speed)) < 10.0f) {
                            smoothIncrement = 10.0f;
                        }
                    }
                    difference = this.dh.vrPlayer.rotDiff_Degrees((float)this.rotationTarget, this.vehicleInitialRotation);
                    if (smooth) {
                        if (difference > smoothIncrement) {
                            difference = smoothIncrement;
                        }
                        if (difference < -smoothIncrement) {
                            difference = -smoothIncrement;
                        }
                    }
                    this.dh.vrSettings.worldRotation += difference;
                    this.dh.vrSettings.worldRotation %= 360.0f;
                    this.dh.vr.seatedRot = this.dh.vrSettings.worldRotation;
                    this.vehicleInitialRotation -= difference;
                    this.vehicleInitialRotation %= 360.0f;
                    break block23;
                }
                this.minecartStupidityCounter = 3;
                if (this.mc.m_91288_() != null && this.mc.m_91288_() != this.mc.f_91074_) {
                    this.vehicleInitialRotation = this.mc.m_91288_().m_146908_();
                } else if (this.mc.f_91074_.m_20159_()) {
                    this.vehicleInitialRotation = this.mc.f_91074_.m_20202_().m_146908_();
                }
            }
            if (this.isRiding && this.mc.m_91288_() != null && this.mc.m_91288_() != this.mc.f_91074_) {
                ridingPos = this.mc.m_91288_().m_146892_().m_82492_(0.0, (double)this.mc.f_91074_.f_19816_, 0.0);
                this.updateRiderPos(ridingPos.f_82479_, ridingPos.f_82480_, ridingPos.f_82481_, this.mc.m_91288_());
            }
        }
    }

    public void onStartRiding(Entity vehicle) {
        this.isRiding = true;
        this.PreMount_World_Rotation = this.dh.vrPlayer.vrdata_world_pre.rotation_radians;
        Vec3 camPos = this.dh.vrPlayer.vrdata_room_pre.getHeadPivot();
        this.Premount_Pos_Room = new Vec3(camPos.f_82479_, 0.0, camPos.f_82481_);
        this.dismountCooldown = 5;
        if (this.dh.vrSettings.vehicleRotation) {
            float end = this.dh.vrPlayer.vrdata_world_pre.hmd.getYaw();
            float start = vehicle.m_146908_() % 360.0f;
            this.vehicleInitialRotation = this.dh.vrSettings.worldRotation;
            this.rotationCooldown = 2;
            if (vehicle instanceof Minecart) {
                return;
            }
            float difference = this.dh.vrPlayer.rotDiff_Degrees(start, end);
            this.dh.vrSettings.worldRotation = (float)(Math.toDegrees(this.dh.vrPlayer.vrdata_world_pre.rotation_radians) + (double)difference);
            this.dh.vrSettings.worldRotation %= 360.0f;
            this.dh.vr.seatedRot = this.dh.vrSettings.worldRotation;
        }
    }

    public void onStopRiding() {
        this.isRiding = false;
        this.dh.swingTracker.disableSwing = 10;
        this.dh.sneakTracker.sneakCounter = 0;
    }

    public boolean isRiding() {
        return this.isRiding;
    }

    public void updateRiderPos(double x, double y, double z, Entity entity) {
        Vec3 offset = this.Premount_Pos_Room.m_82524_(this.dh.vrPlayer.vrdata_world_pre.rotation_radians);
        y = this.getVehicleFloor(entity, y);
        this.dh.vrPlayer.setRoomOrigin(x, y, z, (x -= offset.f_82479_) + y + (z -= offset.f_82481_) == 0.0);
    }

    private float getMinecartRenderYaw(Minecart entity) {
        Vec3 speed = new Vec3(entity.m_20185_() - entity.f_19790_, entity.m_20186_() - entity.f_19791_, entity.m_20189_() - entity.f_19792_);
        float speedYaw = (float)Math.toDegrees(Math.atan2(-speed.f_82479_, speed.f_82481_));
        return this.shouldMinecartTurnView(entity) ? -180.0f + speedYaw : this.vehicleInitialRotation;
    }

    private double mineCartSpeed(Minecart entity) {
        Vec3 speed = new Vec3(entity.m_20184_().f_82479_, 0.0, entity.m_20184_().f_82481_);
        return speed.m_82553_();
    }

    private boolean shouldMinecartTurnView(Minecart entity) {
        Vec3 speed = new Vec3(entity.m_20185_() - entity.f_19790_, entity.m_20186_() - entity.f_19791_, entity.m_20189_() - entity.f_19792_);
        return speed.m_82553_() > 0.001;
    }

    public boolean canRoomscaleDismount(LocalPlayer player) {
        return player.f_20902_ == 0.0f && player.f_20900_ == 0.0f && player.m_20159_() && player.m_20202_().m_20096_() && this.dismountCooldown == 0;
    }
}

