/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.gameplay.trackers.Tracker;
import org.vivecraft.client_vr.render.RenderPass;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.data.ItemTags;

public class TelescopeTracker
extends Tracker {
    public static final ModelResourceLocation SCOPE_MODEL = new ModelResourceLocation("vivecraft", "spyglass_in_hand", "inventory");
    private static final float LENS_DIST_MAX = 0.05f;
    private static final float LENS_DIST_MIN = 0.185f;
    private static final float LENS_DOT_MAX = 0.9f;
    private static final float LENS_DOT_MIN = 0.75f;
    private final boolean[] viewing = new boolean[2];

    public TelescopeTracker(Minecraft mc, ClientDataHolderVR dh) {
        super(mc, dh);
    }

    @Override
    public boolean isActive(LocalPlayer player) {
        return player != null && !this.dh.bowTracker.isActive(player) && (TelescopeTracker.isTelescope(player.m_21205_()) || TelescopeTracker.isTelescope(player.m_21206_()));
    }

    @Override
    public boolean itemInUse(LocalPlayer player) {
        return this.viewing[0] || this.viewing[1];
    }

    @Override
    public void reset(LocalPlayer player) {
        this.viewing[0] = false;
        this.viewing[1] = false;
    }

    @Override
    public void doProcess(LocalPlayer player) {
        for (int c = 0; c < 2; ++c) {
            if (TelescopeTracker.isTelescope(player.m_21120_(InteractionHand.values()[c]))) {
                if (TelescopeTracker.isViewing(c)) {
                    if (!this.viewing[c]) {
                        this.mc.f_91072_.m_233721_((Player)player, InteractionHand.values()[c]);
                    }
                    this.viewing[c] = true;
                    continue;
                }
                this.viewing[c] = false;
                continue;
            }
            this.viewing[c] = false;
        }
    }

    public static boolean isTelescope(ItemStack itemStack) {
        return itemStack != null && (itemStack.m_150930_(Items.f_151059_) || TelescopeTracker.isLegacyTelescope(itemStack) || itemStack.m_204117_(ItemTags.VIVECRAFT_TELESCOPE));
    }

    public static boolean isLegacyTelescope(ItemStack itemStack) {
        TranslatableContents translatableContents;
        ComponentContents componentContents;
        if (itemStack.m_41619_()) {
            return false;
        }
        if (!itemStack.m_41788_()) {
            return false;
        }
        if (itemStack.m_41720_() != Items.f_42545_) {
            return false;
        }
        if (!itemStack.m_41782_() || !itemStack.m_41783_().m_128471_("Unbreakable")) {
            return false;
        }
        return itemStack.m_41786_().getString().equals("Eye of the Farseer") || (componentContents = itemStack.m_41786_().m_214077_()) instanceof TranslatableContents && (translatableContents = (TranslatableContents)componentContents).m_237508_().equals("vivecraft.item.telescope");
    }

    private static Vector3f getLensOrigin(int controller) {
        VRData.VRDevicePose con = ClientDataHolderVR.getInstance().vrPlayer.vrdata_room_pre.getController(controller);
        return con.getPositionF().add((Vector3fc)TelescopeTracker.getViewVector(controller).mul(-0.2f).add((Vector3fc)con.getDirection().mul(0.05f)));
    }

    private static Vector3f getViewVector(int controller) {
        return ClientDataHolderVR.getInstance().vrPlayer.vrdata_room_pre.getController(controller).getCustomVector(MathUtils.DOWN);
    }

    public static boolean isViewing(int controller) {
        return TelescopeTracker.viewPercent(controller) > 0.0f;
    }

    public static float viewPercent(int controller) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && ClientDataHolderVR.getInstance().vrSettings.seated) {
            if (TelescopeTracker.isTelescope(player.m_21211_())) {
                return 1.0f;
            }
            return 0.0f;
        }
        float out = 0.0f;
        out = Math.max(out, TelescopeTracker.viewPercent(controller, RenderPass.LEFT));
        out = Math.max(out, TelescopeTracker.viewPercent(controller, RenderPass.RIGHT));
        return out;
    }

    private static float viewPercent(int controller, RenderPass renderPass) {
        if (ClientDataHolderVR.getInstance().vrPlayer == null) {
            return 0.0f;
        }
        VRData.VRDevicePose eyeRoom = ClientDataHolderVR.getInstance().vrPlayer.vrdata_room_pre.getEye(renderPass);
        float dist = eyeRoom.getPositionF().sub((Vector3fc)TelescopeTracker.getLensOrigin(controller)).length();
        Vector3f look = eyeRoom.getDirection();
        float dot = Math.abs(look.dot((Vector3fc)TelescopeTracker.getViewVector(controller)));
        float dfact = 0.0f;
        float distfact = 0.0f;
        if (dot > 0.75f) {
            dfact = dot > 0.9f ? 1.0f : (dot - 0.75f) / 0.14999998f;
        }
        if (dist < 0.185f) {
            distfact = dist < 0.05f ? 1.0f : 1.0f - (dist - 0.05f) / 0.135f;
        }
        return Math.min(dfact, distfact);
    }
}

