/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.FoodOnAStickItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.Xplat;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.Vector3fHistory;
import org.vivecraft.client_vr.gameplay.trackers.Tracker;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.network.BodyPart;
import org.vivecraft.common.network.FBTMode;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.data.BlockTags;
import org.vivecraft.data.ItemTags;
import org.vivecraft.mod_compat_vr.bettercombat.BetterCombatHelper;
import org.vivecraft.mod_compat_vr.epicfight.EpicFightHelper;

public class SwingTracker
extends Tracker {
    private static final int[] CONTROLLER_AND_FEET = new int[]{0, 1, 4, 5};
    private static final float SPEED_THRESH = 3.0f;
    private final Vec3[] lastWeaponEndAir = new Vec3[]{Vec3.f_82478_, Vec3.f_82478_, Vec3.f_82478_, Vec3.f_82478_};
    private final boolean[] lastWeaponSolid = new boolean[4];
    private final List<Entity>[] lastHitEntities = new List[]{Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList()};
    public final Vec3[] miningPoint = new Vec3[4];
    public final Vec3[] attackingPoint = new Vec3[4];
    public final Vector3fHistory[] tipHistory = new Vector3fHistory[]{new Vector3fHistory(), new Vector3fHistory(), new Vector3fHistory(), new Vector3fHistory()};
    public boolean[] canAct = new boolean[4];
    public int disableSwing = 3;

    public SwingTracker(Minecraft mc, ClientDataHolderVR dh) {
        super(mc, dh);
    }

    @Override
    public boolean isActive(LocalPlayer player) {
        if (this.disableSwing > 0) {
            --this.disableSwing;
            return false;
        }
        if (this.mc.f_91072_ == null) {
            return false;
        }
        if (player == null) {
            return false;
        }
        if (!player.m_6084_()) {
            return false;
        }
        if (player.m_5803_()) {
            return false;
        }
        if (this.mc.f_91080_ != null) {
            return false;
        }
        if (this.dh.vrSettings.weaponCollision == VRSettings.WeaponCollision.OFF) {
            return false;
        }
        if (this.dh.vrSettings.weaponCollision == VRSettings.WeaponCollision.AUTO) {
            return !player.m_7500_();
        }
        if (this.dh.vrSettings.seated) {
            return false;
        }
        if (this.dh.vrSettings.vrFreeMoveMode == VRSettings.FreeMove.RUN_IN_PLACE && player.f_20902_ > 0.0f) {
            return false;
        }
        if (player.m_21254_()) {
            return false;
        }
        return !this.dh.jumpTracker.isjumping();
    }

    public static boolean isTool(Item item) {
        return item instanceof DiggerItem || item instanceof ArrowItem || item instanceof FishingRodItem || item instanceof FoodOnAStickItem || item instanceof ShearsItem || item == Items.f_42500_ || item == Items.f_42585_ || item == Items.f_41911_ || item == Items.f_42000_ || item == Items.f_41978_ || item == Items.f_42398_ || item == Items.f_42751_ || item instanceof FlintAndSteelItem || item instanceof BrushItem || item.m_7968_().m_204117_(ItemTags.VIVECRAFT_TOOLS);
    }

    @Override
    public void doProcess(LocalPlayer player) {
        float speedTreshhold = 3.0f;
        if (player.m_7500_()) {
            speedTreshhold *= 1.5f;
        }
        this.mc.m_91307_().m_6180_("updateSwingAttack");
        int trackers = 2;
        if (this.dh.vrSettings.feetCollision && this.dh.vrPlayer.vrdata_world_pre.fbtMode != FBTMode.ARMS_ONLY) {
            trackers = 4;
        }
        for (int i = 0; i < trackers; ++i) {
            BlockHitResult blockhitresult;
            boolean isHand;
            int c = CONTROLLER_AND_FEET[i];
            boolean bl = isHand = i < 2;
            if (isHand && this.dh.climbTracker.isGrabbingLadder(c)) continue;
            Vec3 handPos = this.dh.vrPlayer.vrdata_world_pre.getDevice(c).getPosition();
            Vector3f handDirection = this.dh.vrPlayer.vrdata_world_pre.getHand(c).getCustomVector(MathUtils.BACK);
            ItemStack itemstack = player.m_21120_(c == 1 ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
            Item item = itemstack.m_41720_();
            boolean isTool = false;
            boolean isSword = false;
            if (this.dh.vrSettings.onlySwordCollision && !(item instanceof SwordItem) && !itemstack.m_204117_(ItemTags.VIVECRAFT_SWORDS)) continue;
            if (!(item instanceof SwordItem || itemstack.m_204117_(ItemTags.VIVECRAFT_SWORDS) || item instanceof TridentItem || itemstack.m_204117_(ItemTags.VIVECRAFT_SPEARS))) {
                if (SwingTracker.isTool(item)) {
                    isTool = true;
                }
            } else {
                isSword = true;
                isTool = true;
            }
            float weaponLength = 0.0f;
            float entityReachAdd = 0.3f;
            if (isHand) {
                double playerEntityReach = Xplat.getItemEntityReach(3.0, itemstack, c == 0 ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                if (BetterCombatHelper.isLoaded()) {
                    playerEntityReach = BetterCombatHelper.getItemRange(playerEntityReach, itemstack);
                }
                playerEntityReach = Math.min(playerEntityReach, 6.0) - 0.5;
                if (isSword) {
                    weaponLength = 0.6f;
                    entityReachAdd = (float)playerEntityReach - weaponLength;
                } else if (isTool) {
                    weaponLength = 0.35f;
                    entityReachAdd = (float)playerEntityReach * 0.62f - weaponLength;
                } else if (!itemstack.m_41619_()) {
                    weaponLength = 0.1f;
                    entityReachAdd = (float)playerEntityReach * 0.16f - weaponLength;
                }
            }
            Vector3f weaponEnd = handDirection.mul(weaponLength *= this.dh.vrPlayer.vrdata_world_pre.worldScale, new Vector3f());
            this.miningPoint[i] = handPos.m_82520_((double)weaponEnd.x, (double)weaponEnd.y, (double)weaponEnd.z);
            Vector3f tip = this.dh.vrPlayer.vrdata_room_pre.getDevice(c).getPositionF().add((Vector3fc)this.dh.vrPlayer.vrdata_room_pre.getHand(c).getCustomVector(MathUtils.BACK).mul(0.3f));
            this.tipHistory[i].add((Vector3fc)tip);
            float speed = this.tipHistory[i].averageSpeed(0.33);
            boolean inAnEntity = false;
            this.canAct[i] = speed > speedTreshhold && !this.lastWeaponSolid[i];
            boolean entityAct = this.canAct[i];
            if (entityAct && (blockhitresult = this.mc.f_91073_.m_45547_(new ClipContext(this.dh.vrPlayer.vrdata_world_pre.hmd.getPosition(), handPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this.mc.f_91074_))).m_6662_() != HitResult.Type.MISS) {
                entityAct = false;
            }
            this.attackingPoint[i] = this.constrain(handPos, this.miningPoint[i]);
            Vector3f weaponEntityEnd = handDirection.mul(weaponLength + entityReachAdd, new Vector3f());
            Vec3 weaponTip = handPos.m_82520_((double)weaponEntityEnd.x, (double)weaponEntityEnd.y, (double)weaponEntityEnd.z);
            weaponTip = this.constrain(handPos, weaponTip);
            AABB weaponBB = new AABB(handPos, this.attackingPoint[i]);
            AABB weaponTipBB = new AABB(handPos, weaponTip);
            List<Object> mobs = this.mc.f_91073_.m_45933_((Entity)this.mc.f_91074_, weaponTipBB);
            if (this.dh.vrSettings.reducedPlayerReach) {
                mobs.removeIf(e -> e instanceof Player);
                List players = this.mc.f_91073_.m_45933_((Entity)this.mc.f_91074_, weaponBB);
                players.removeIf(e -> !(e instanceof Player));
                mobs.addAll(players);
            }
            for (Entity entity : mobs) {
                if (!entity.m_6087_() || entity == this.mc.m_91288_().m_20202_() || this.lastHitEntities[i].contains(entity)) continue;
                if (entityAct) {
                    if (!EpicFightHelper.isLoaded() || !EpicFightHelper.attack()) {
                        ClientNetworking.sendActiveBodyPart(BodyPart.values()[i]);
                        this.mc.f_91072_.m_105223_((Player)player, entity);
                    } else {
                        entityAct = false;
                    }
                    this.dh.vr.triggerHapticPulse(c, 1000);
                    this.lastWeaponSolid[i] = true;
                }
                inAnEntity = true;
            }
            this.lastHitEntities[i] = speed > speedTreshhold ? mobs : Collections.emptyList();
            if (isHand && this.dh.climbTracker.isClimbeyClimb() && (!isTool || c == 0 && VivecraftVRMod.INSTANCE.keyClimbeyGrab.isDown(ControllerType.RIGHT) || c == 1 && VivecraftVRMod.INSTANCE.keyClimbeyGrab.isDown(ControllerType.LEFT))) continue;
            BlockPos blockpos = BlockPos.m_274446_((Position)this.miningPoint[i]);
            BlockState blockState = this.mc.f_91073_.m_8055_(blockpos);
            boolean mineableByItem = this.dh.vrSettings.swordBlockCollision && (itemstack.m_41735_(blockState) || blockState.m_60625_((Player)player, (BlockGetter)player.m_9236_(), blockpos) == 1.0f);
            this.canAct[i] = this.canAct[i] && (!isSword || mineableByItem) && !inAnEntity;
            BlockHitResult blockHit = this.mc.f_91073_.m_45547_(new ClipContext(this.lastWeaponEndAir[i], this.miningPoint[i], ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this.mc.f_91074_));
            if (!blockState.m_60795_() && blockHit.m_6662_() == HitResult.Type.BLOCK && this.lastWeaponEndAir[i].m_82553_() != 0.0) {
                boolean protectedBlock;
                this.lastWeaponSolid[i] = true;
                boolean sameBlock = blockHit.m_82425_().equals((Object)blockpos);
                boolean bl2 = protectedBlock = this.dh.vrSettings.realisticClimbEnabled && (blockState.m_60734_() instanceof LadderBlock || blockState.m_60734_() instanceof VineBlock || blockState.m_204336_(BlockTags.VIVECRAFT_CLIMBABLE));
                if (blockHit.m_6662_() != HitResult.Type.BLOCK || !sameBlock || !this.canAct[i] || protectedBlock) continue;
                int totalHits = 3;
                if (!this.dh.vrSettings.doorHitting || !this.isOpenable(blockState, this.tipHistory[i].netMovement(0.3)) || this.mc.f_91072_.m_233732_(player, c == 1 ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND, blockHit) == InteractionResult.PASS) {
                    if (isHand && (item instanceof HoeItem || itemstack.m_204117_(ItemTags.VIVECRAFT_HOES) || itemstack.m_204117_(ItemTags.VIVECRAFT_SCYTHES)) && (blockState.m_60734_() instanceof CropBlock || blockState.m_60734_() instanceof StemBlock || blockState.m_60734_() instanceof AttachedStemBlock || blockState.m_204336_(BlockTags.VIVECRAFT_CROPS) || item.m_6225_(new UseOnContext((Player)player, c == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, blockHit)).m_19080_())) {
                        boolean useSuccessful = this.mc.f_91072_.m_233732_(player, i == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, blockHit).m_19080_();
                        if (itemstack.m_204117_(ItemTags.VIVECRAFT_SCYTHES) && !useSuccessful) {
                            this.mc.f_91072_.m_233721_((Player)player, c == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
                        }
                    } else if (isHand && item instanceof BrushItem) {
                        ((BrushItem)item).m_278154_(player.m_9236_(), blockHit, blockState, player.m_20252_(0.0f), c == 0 ? player.m_5737_() : player.m_5737_().m_20828_());
                        player.m_9236_().m_247517_((Player)player, blockHit.m_82425_(), blockState.m_60734_() instanceof BrushableBlock ? ((BrushableBlock)blockState.m_60734_()).m_276856_() : SoundEvents.f_276624_, SoundSource.BLOCKS);
                        this.mc.f_91072_.m_233732_(player, c == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, blockHit);
                    } else if (blockState.m_60734_() instanceof NoteBlock || blockState.m_204336_(BlockTags.VIVECRAFT_MUSIC_BLOCKS)) {
                        this.mc.f_91072_.m_105283_(blockHit.m_82425_(), blockHit.m_82434_());
                    } else {
                        totalHits = (int)((float)totalHits + Math.min(speed - speedTreshhold, 4.0f));
                        ClientNetworking.sendActiveBodyPart(BodyPart.values()[i]);
                        this.mc.f_91072_.m_105269_(blockHit.m_82425_(), blockHit.m_82434_());
                        if (this.getIsHittingBlock()) {
                            for (int hit = 0; hit < totalHits; ++hit) {
                                if (this.mc.f_91072_.m_105283_(blockHit.m_82425_(), blockHit.m_82434_())) {
                                    this.mc.f_91061_.m_107367_(blockHit.m_82425_(), blockHit.m_82434_());
                                }
                                this.clearBlockHitDelay();
                                if (!this.getIsHittingBlock()) break;
                            }
                            this.mc.f_91072_.f_105195_ = 0;
                        }
                        this.dh.vrPlayer.blockDust(blockHit.m_82450_().f_82479_, blockHit.m_82450_().f_82480_, blockHit.m_82450_().f_82481_, 3 * totalHits, blockpos, blockState, 0.6f, 1.0f);
                    }
                }
                this.dh.vr.triggerHapticPulse(c, 250 * totalHits);
                continue;
            }
            this.lastWeaponEndAir[i] = this.miningPoint[i];
            this.lastWeaponSolid[i] = false;
        }
        ClientNetworking.sendActiveBodyPart(BodyPart.MAIN_HAND);
        this.mc.m_91307_().m_7238_();
    }

    private boolean getIsHittingBlock() {
        return this.mc.f_91072_.m_105296_();
    }

    private void clearBlockHitDelay() {
    }

    private Vec3 constrain(Vec3 start, Vec3 end) {
        BlockHitResult blockhitresult = this.mc.f_91073_.m_45547_(new ClipContext(start, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this.mc.f_91074_));
        return blockhitresult.m_6662_() == HitResult.Type.BLOCK ? blockhitresult.m_82450_() : end;
    }

    private boolean isOpenable(BlockState state, Vector3f roomDirection) {
        float t = 0.25f;
        Vector3f direction = roomDirection.normalize().rotateY(this.dh.vrPlayer.vrdata_world_pre.rotation_radians);
        if (state.m_204336_(net.minecraft.tags.BlockTags.f_13103_) || state.m_60734_() instanceof DoorBlock) {
            Direction d = (Direction)state.m_61143_((Property)DoorBlock.f_52726_);
            boolean open = (Boolean)state.m_61143_((Property)DoorBlock.f_52727_);
            DoorHingeSide hinge = (DoorHingeSide)state.m_61143_((Property)DoorBlock.f_52728_);
            if (direction.z < -0.25f && (d == Direction.NORTH && !open || d == Direction.WEST && open && hinge == DoorHingeSide.LEFT || d == Direction.EAST && open && hinge == DoorHingeSide.RIGHT)) {
                return true;
            }
            if (direction.x > 0.25f && (d == Direction.EAST && !open || d == Direction.NORTH && open && hinge == DoorHingeSide.LEFT || d == Direction.SOUTH && open && hinge == DoorHingeSide.RIGHT)) {
                return true;
            }
            if (direction.z > 0.25f && (d == Direction.SOUTH && !open || d == Direction.EAST && open && hinge == DoorHingeSide.LEFT || d == Direction.WEST && open && hinge == DoorHingeSide.RIGHT)) {
                return true;
            }
            return direction.x < -0.25f && (d == Direction.WEST && !open || d == Direction.SOUTH && open && hinge == DoorHingeSide.LEFT || d == Direction.NORTH && open && hinge == DoorHingeSide.RIGHT);
        }
        if (state.m_204336_(net.minecraft.tags.BlockTags.f_13036_) || state.m_60734_() instanceof TrapDoorBlock) {
            Direction d = (Direction)state.m_61143_((Property)TrapDoorBlock.f_54117_);
            boolean open = (Boolean)state.m_61143_((Property)TrapDoorBlock.f_57514_);
            return direction.y > 0.25f && !open || direction.x < -0.25f && open && d == Direction.WEST || direction.x > 0.25f && open && d == Direction.EAST || direction.z < -0.25f && open && d == Direction.NORTH || direction.z > 0.25f && open && d == Direction.SOUTH;
        }
        if (state.m_204336_(net.minecraft.tags.BlockTags.f_13055_) || state.m_60734_() instanceof FenceGateBlock) {
            Direction d = (Direction)state.m_61143_((Property)FenceGateBlock.f_54117_);
            boolean open = (Boolean)state.m_61143_((Property)FenceGateBlock.f_53341_);
            return !open && (direction.x > 0.25f || direction.x < 0.25f) && (d == Direction.WEST || d == Direction.EAST) || !open && (direction.z > 0.25f || direction.z < 0.25f) && (d == Direction.NORTH || d == Direction.SOUTH);
        }
        return false;
    }

    public static float getItemFade(LocalPlayer player, ItemStack itemStack) {
        float fade = player.m_36403_(0.0f) * 0.75f + 0.25f;
        if (player.m_6144_()) {
            fade = 0.75f;
        }
        if (ClientDataHolderVR.getInstance().swingTracker.lastWeaponSolid[ClientDataHolderVR.IS_MAIN_HAND ? 0 : 1]) {
            fade -= 0.25f;
        }
        if (itemStack != ItemStack.f_41583_) {
            if (player.m_21254_() && player.m_21211_() != itemStack) {
                fade -= 0.25f;
            }
            if (itemStack.m_41720_() == Items.f_42740_ && !player.m_21254_()) {
                fade -= 0.25f;
            }
        }
        if ((double)fade < 0.1) {
            fade = 0.1f;
        }
        if (fade > 1.0f) {
            fade = 1.0f;
        }
        return fade;
    }
}

