/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.Xplat;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.gameplay.trackers.Tracker;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.render.RenderPass;
import org.vivecraft.client_vr.render.VRFirstPersonArmSwing;
import org.vivecraft.client_vr.settings.VRHotkeys;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.MathUtils;

public class InteractTracker
extends Tracker {
    public boolean[] bukkit = new boolean[2];
    public int hotbar = -1;
    private final boolean[] inBow = new boolean[2];
    public BlockHitResult[] inBlockHit = new BlockHitResult[2];
    private final BlockPos[] inBlockPos = new BlockPos[2];
    private final Entity[] inEntity = new Entity[2];
    private final EntityHitResult[] inEntityHit = new EntityHitResult[2];
    private final boolean[] inCamera = new boolean[2];
    private final boolean[] inHandheldCamera = new boolean[2];
    private final boolean[] active = new boolean[2];
    private final boolean[] wasactive = new boolean[2];
    private HashSet<Class<?>> rightClickable = null;

    public InteractTracker(Minecraft mc, ClientDataHolderVR dh) {
        super(mc, dh);
    }

    @Override
    public boolean isActive(LocalPlayer player) {
        if (this.mc.f_91072_ == null) {
            return false;
        }
        if (player == null) {
            return false;
        }
        if (!player.m_6084_()) {
            return false;
        }
        if (player.m_5803_()) {
            return false;
        }
        if (this.dh.vrSettings.seated) {
            return false;
        }
        return !player.m_21254_() || this.hotbar >= 0;
    }

    @Override
    public void reset(LocalPlayer player) {
        for (int c = 0; c < 2; ++c) {
            this.reset(player, c);
        }
    }

    private void reset(LocalPlayer player, int c) {
        if (this.inCamera[c] && VRHotkeys.isMovingThirdPersonCam() && VRHotkeys.getMovingThirdPersonCamTriggerer() == VRHotkeys.Triggerer.INTERACTION && VRHotkeys.getMovingThirdPersonCamController() == c) {
            VRHotkeys.stopMovingThirdPersonCam();
        }
        if (this.inHandheldCamera[c] && this.dh.cameraTracker.isMoving() && this.dh.cameraTracker.getMovingController() == c && !this.dh.cameraTracker.isQuickMode()) {
            this.dh.cameraTracker.stopMoving();
        }
        this.inBow[c] = false;
        this.inBlockPos[c] = null;
        this.inBlockHit[c] = null;
        this.inEntity[c] = null;
        this.inEntityHit[c] = null;
        this.inCamera[c] = false;
        this.inHandheldCamera[c] = false;
        this.active[c] = false;
        this.dh.vr.getInputAction(VivecraftVRMod.INSTANCE.keyVRInteract).setEnabled(ControllerType.values()[c], false);
    }

    @Override
    public void doProcess(LocalPlayer player) {
        if (this.rightClickable == null) {
            this.rightClickable = new HashSet();
            String name = Xplat.getUseMethodName();
            for (Object object : BuiltInRegistries.f_256975_) {
                Class<?> oclass = object.getClass();
                this.addIfClassHasMethod(name, oclass);
                this.addIfClassHasMethod(name, oclass.getSuperclass());
            }
            this.rightClickable.remove(Block.class);
            this.rightClickable.remove(BlockBehaviour.class);
            this.rightClickable.remove(BlockBehaviour.BlockStateBase.class);
        }
        for (int c = 0; c < 2; ++c) {
            Vector3f offset;
            Vec3 camPos;
            VRData.VRDevicePose camData;
            if ((this.inCamera[c] || this.inHandheldCamera[c] || this.inBow[c]) && VivecraftVRMod.INSTANCE.keyVRInteract.isDown(ControllerType.values()[c])) continue;
            this.reset(player, c);
            if (c == 0 && this.hotbar >= 0) {
                this.active[c] = true;
            }
            if (!this.active[c] && this.dh.bowTracker.isNotched() && c == (this.dh.vrSettings.reverseShootingEye && ClientNetworking.supportsReversedBow() ? 1 : 0)) {
                this.inBow[c] = true;
                this.active[c] = true;
            }
            Vec3 hmdPos = this.dh.vrPlayer.vrdata_world_pre.getHeadPivot();
            Vec3 handPos = this.dh.vrPlayer.vrdata_world_pre.getController(c).getPosition();
            Vector3f handDirection = this.dh.vrPlayer.vrdata_world_pre.getHand(c).getCustomVector(MathUtils.BACK);
            ItemStack handItem = player.m_21120_(c == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
            if (!this.active[c] && this.dh.vrSettings.mixedRealityRenderCameraModel && (this.dh.vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY || this.dh.vrSettings.displayMirrorMode == VRSettings.MirrorMode.THIRD_PERSON)) {
                camData = this.dh.vrPlayer.vrdata_world_pre.getEye(RenderPass.THIRD);
                camPos = camData.getPosition();
                offset = camData.getCustomVector(MathUtils.BACK).mul(0.15f * this.dh.vrPlayer.vrdata_world_pre.worldScale);
                offset.add((Vector3fc)camData.getCustomVector(MathUtils.DOWN).mul(0.05f * this.dh.vrPlayer.vrdata_world_pre.worldScale));
                camPos = camPos.m_82492_((double)offset.x, (double)offset.y, (double)offset.z);
                if (handPos.m_82554_(camPos) < (double)0.15f * (double)this.dh.vrPlayer.vrdata_world_pre.worldScale) {
                    this.inCamera[c] = true;
                    this.active[c] = true;
                }
            }
            if (!this.active[c] && this.dh.cameraTracker.isVisible() && !this.dh.cameraTracker.isQuickMode()) {
                camData = this.dh.vrPlayer.vrdata_world_pre.getEye(RenderPass.CAMERA);
                camPos = camData.getPosition();
                offset = camData.getCustomVector(MathUtils.BACK).mul(0.08f * this.dh.vrPlayer.vrdata_world_pre.worldScale);
                if (handPos.m_82554_(camPos = camPos.m_82492_((double)offset.x, (double)offset.y, (double)offset.z)) < (double)0.11f * (double)this.dh.vrPlayer.vrdata_world_pre.worldScale) {
                    this.inHandheldCamera[c] = true;
                    this.active[c] = true;
                }
            }
            if (this.dh.vrSettings.realisticEntityInteractEnabled && !this.active[c]) {
                Vec3 extWeapon = new Vec3(handPos.f_82479_ + (double)(handDirection.x * -0.1f), handPos.f_82480_ + (double)(handDirection.y * -0.1f), handPos.f_82481_ + (double)(handDirection.z * -0.1f));
                AABB weaponBB = new AABB(handPos, extWeapon);
                this.inEntityHit[c] = ProjectileUtil.m_37287_((Entity)this.mc.m_91288_(), (Vec3)hmdPos, (Vec3)handPos, (AABB)weaponBB, e -> !e.m_5833_() && e.m_6087_() && e != this.mc.m_91288_().m_20202_(), (double)0.0);
                if (this.inEntityHit[c] != null) {
                    Entity entity;
                    this.inEntity[c] = entity = this.inEntityHit[c].m_82443_();
                    this.active[c] = true;
                }
            }
            if (this.dh.vrSettings.realisticBlockInteractEnabled && !this.active[c]) {
                BlockPos blockpos = BlockPos.m_274446_((Position)handPos);
                BlockState blockstate = this.mc.f_91073_.m_8055_(blockpos);
                BlockHitResult hit = blockstate.m_60808_((BlockGetter)this.mc.f_91073_, blockpos).m_83220_(hmdPos, handPos, blockpos);
                this.inBlockPos[c] = blockpos;
                this.inBlockHit[c] = hit;
                this.active[c] = hit != null && (this.rightClickable.contains(blockstate.m_60734_().getClass()) || this.rightClickable.contains(blockstate.m_60734_().getClass().getSuperclass()));
                this.bukkit[c] = false;
                if (!this.active[c] && handItem.m_41720_() == Items.f_42446_ && blockstate.m_278721_()) {
                    this.active[c] = true;
                    this.bukkit[c] = true;
                }
            }
            if (!this.wasactive[c] && this.active[c]) {
                this.dh.vr.triggerHapticPulse(c, 250);
            }
            this.dh.vr.getInputAction(VivecraftVRMod.INSTANCE.keyVRInteract).setEnabled(ControllerType.values()[c], this.active[c]);
            this.wasactive[c] = this.active[c];
        }
    }

    private void addIfClassHasMethod(String name, Class<?> oclass) {
        try {
            oclass.getDeclaredMethod(name, BlockState.class, Level.class, BlockPos.class, Player.class, InteractionHand.class, BlockHitResult.class);
            this.rightClickable.add(oclass);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isInteractActive(int controller) {
        return this.active[controller];
    }

    public boolean isInCamera() {
        return this.inCamera[0] || this.inCamera[1];
    }

    public boolean isInHandheldCamera() {
        return this.inHandheldCamera[0] || this.inHandheldCamera[1];
    }

    public void processBindings() {
        for (int c = 0; c < 2; ++c) {
            if (!VivecraftVRMod.INSTANCE.keyVRInteract.consumeClick(ControllerType.values()[c]) || !this.active[c]) continue;
            InteractionHand hand = InteractionHand.values()[c];
            boolean success = false;
            if (this.hotbar >= 0 && this.hotbar < 9 && this.mc.f_91074_.m_150109_().f_35977_ != this.hotbar && hand == InteractionHand.MAIN_HAND) {
                this.mc.f_91074_.m_150109_().f_35977_ = this.hotbar;
                success = true;
            } else if (this.hotbar == 9 && hand == InteractionHand.MAIN_HAND) {
                this.mc.f_91074_.f_108617_.m_104955_((Packet)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.SWAP_ITEM_WITH_OFFHAND, BlockPos.f_121853_, Direction.DOWN));
                success = true;
            } else if (this.inCamera[c]) {
                VRHotkeys.startMovingThirdPersonCam(c, VRHotkeys.Triggerer.INTERACTION);
                success = true;
            } else if (this.inHandheldCamera[c]) {
                this.dh.cameraTracker.startMoving(c);
                success = true;
            } else if (this.inEntityHit[c] != null) {
                success = this.mc.f_91072_.m_105230_((Player)this.mc.f_91074_, this.inEntity[c], this.inEntityHit[c], hand).m_19077_() || this.mc.f_91072_.m_105226_((Player)this.mc.f_91074_, this.inEntity[c], hand).m_19077_();
            } else if (this.inBlockHit[c] != null) {
                success = this.mc.f_91072_.m_233732_(this.mc.f_91074_, hand, this.inBlockHit[c]).m_19077_();
            } else if (this.bukkit[c]) {
                success = this.mc.f_91072_.m_233721_((Player)this.mc.f_91074_, hand).m_19077_();
            }
            if (!success) continue;
            this.dh.swingType = VRFirstPersonArmSwing.Interact;
            this.mc.f_91074_.m_6674_(hand);
            this.dh.vr.triggerHapticPulse(c, 750);
        }
    }
}

