/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.gameplay.trackers.Tracker;
import org.vivecraft.common.utils.MathUtils;

public class EatingTracker
extends Tracker {
    private static final float MOUTH_TO_EYE_DISTANCE = 0.0f;
    private static final float THRESHOLD = 0.25f;
    private static final long EAT_TIME = 2100L;
    private final boolean[] eating = new boolean[2];
    private long eatStart;

    public EatingTracker(Minecraft mc, ClientDataHolderVR dh) {
        super(mc, dh);
    }

    @Override
    public boolean isActive(LocalPlayer player) {
        UseAnim anim;
        if (ClientDataHolderVR.getInstance().vrSettings.seated) {
            return false;
        }
        if (player == null) {
            return false;
        }
        if (this.mc.f_91072_ == null) {
            return false;
        }
        if (!player.m_6084_()) {
            return false;
        }
        if (player.m_5803_()) {
            return false;
        }
        if (player.m_21205_() != null && ((anim = player.m_21205_().m_41780_()) == UseAnim.EAT || anim == UseAnim.DRINK || anim == UseAnim.TOOT_HORN)) {
            return true;
        }
        if (player.m_21206_() != null) {
            anim = player.m_21206_().m_41780_();
            return anim == UseAnim.EAT || anim == UseAnim.DRINK || anim == UseAnim.TOOT_HORN;
        }
        return false;
    }

    @Override
    public boolean itemInUse(LocalPlayer player) {
        return this.eating[0] || this.eating[1];
    }

    @Override
    public void reset(LocalPlayer player) {
        this.eating[0] = false;
        this.eating[1] = false;
    }

    @Override
    public void doProcess(LocalPlayer player) {
        VRData room_pre = this.dh.vrPlayer.vrdata_room_pre;
        Vector3f hmdPos = room_pre.hmd.getPositionF();
        Vector3f mouthPos = room_pre.hmd.getCustomVector((Vector3fc)new Vector3f(0.0f, -0.0f, 0.0f)).add((Vector3fc)hmdPos);
        for (int c = 0; c < 2; ++c) {
            Vector3f controllerPos = this.dh.vr.controllerHistory[c].averagePosition(0.333).add((Vector3fc)room_pre.getController(c).getDirection().mul(0.2f));
            if (mouthPos.distance((Vector3fc)controllerPos) < 0.25f) {
                long k;
                ItemStack itemstack;
                ItemStack itemStack = itemstack = c == 0 ? player.m_21205_() : player.m_21206_();
                if (itemstack == ItemStack.f_41583_) continue;
                int crunchiness = 0;
                if (itemstack.m_41780_() == UseAnim.DRINK) {
                    if (room_pre.getController((int)c).getCustomVector((Vector3fc)MathUtils.UP).y > 0.0f) {
                        continue;
                    }
                } else if (itemstack.m_41780_() == UseAnim.EAT) {
                    crunchiness = 2;
                } else {
                    if (itemstack.m_41780_() != UseAnim.TOOT_HORN) continue;
                    crunchiness = 1;
                }
                if (!this.eating[c] && this.mc.f_91072_.m_233721_((Player)player, c == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND).m_19077_()) {
                    this.mc.f_91063_.f_109055_.m_109320_(c == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
                    this.eating[c] = true;
                    this.eatStart = Util.m_137550_();
                }
                if (this.eating[c] && (k = (long)player.m_21212_()) > 0L && k % 5L <= (long)crunchiness) {
                    this.dh.vr.triggerHapticPulse(c, 700);
                }
                if (Util.m_137550_() - this.eatStart <= 2100L) continue;
                this.eating[c] = false;
                continue;
            }
            this.eating[c] = false;
        }
    }
}

