/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.extensions.PlayerExtension;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.gameplay.trackers.JumpTracker;
import org.vivecraft.client_vr.gameplay.trackers.Tracker;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.common.network.packet.c2s.ClimbingPayloadC2S;
import org.vivecraft.data.BlockTags;
import org.vivecraft.server.config.ClimbeyBlockmode;

public class ClimbTracker
extends Tracker {
    public static final ModelResourceLocation CLAWS_MODEL = new ModelResourceLocation("vivecraft", "climb_claws", "inventory");
    public Set<Block> blocklist = new HashSet<Block>();
    public ClimbeyBlockmode serverBlockmode = ClimbeyBlockmode.DISABLED;
    public boolean forceActivate = false;
    public int latchStartController = -1;
    public Vec3[] latchStart = new Vec3[]{Vec3.f_82478_, Vec3.f_82478_};
    public Vector3f[] latchStart_room = new Vector3f[]{new Vector3f(), new Vector3f()};
    public Vec3[] latchStartBody = new Vec3[]{Vec3.f_82478_, Vec3.f_82478_};
    private boolean gravityOverride = false;
    private boolean wantJump = false;
    private final boolean[] latched = new boolean[2];
    private final boolean[] wasInBlock = new boolean[2];
    private final boolean[] wasButton = new boolean[2];
    private final boolean[] wasLatched = new boolean[2];
    private final AABB[] box = new AABB[2];
    private final AABB[] latchBox = new AABB[2];
    private final boolean[] inBlock = new boolean[2];
    private final Direction[] grabDirection = new Direction[2];
    private final AABB northBB = new AABB(0.1, 0.0, 0.9, 0.9, 1.0, 1.1);
    private final AABB southBB = new AABB(0.1, 0.0, -0.1, 0.9, 1.0, 0.1);
    private final AABB westBB = new AABB(0.9, 0.0, 0.1, 1.1, 1.0, 0.9);
    private final AABB eastBB = new AABB(-0.1, 0.0, 0.1, 0.1, 1.0, 0.9);
    private final AABB upBB = new AABB(0.0, 0.9, 0.0, 1.0, 1.1, 1.0);
    private final AABB fullBB = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private final Random rand = new Random();
    private boolean unsetFlag;

    public ClimbTracker(Minecraft mc, ClientDataHolderVR dh) {
        super(mc, dh);
    }

    public boolean isGrabbingLadder() {
        return this.latched[0] || this.latched[1];
    }

    public boolean wasGrabbingLadder() {
        return this.wasLatched[0] || this.latched[1];
    }

    public boolean isGrabbingLadder(int controller) {
        return this.latched[controller];
    }

    public boolean wasGrabbingLadder(int controller) {
        return this.wasLatched[controller];
    }

    public boolean isClimbeyClimb() {
        return this.isActive(this.mc.f_91074_) && ClimbTracker.hasClimbeyClimbEquipped((Player)this.mc.f_91074_);
    }

    public static boolean hasClimbeyClimbEquipped(Player player) {
        return ClientNetworking.SERVER_ALLOWS_CLIMBEY && (ClimbTracker.isClaws(player.m_21205_()) || ClimbTracker.isClaws(player.m_21206_()));
    }

    public static boolean isClaws(ItemStack itemStack) {
        TranslatableContents translatableContent;
        ComponentContents componentContents;
        if (itemStack == null || itemStack.m_41619_()) {
            return false;
        }
        if (!itemStack.m_41788_()) {
            return false;
        }
        if (itemStack.m_41720_() != Items.f_42574_) {
            return false;
        }
        if (!itemStack.m_41782_() || !itemStack.m_41783_().m_128471_("Unbreakable")) {
            return false;
        }
        return itemStack.m_41786_().getString().equals("Climb Claws") || (componentContents = itemStack.m_41786_().m_214077_()) instanceof TranslatableContents && (translatableContent = (TranslatableContents)componentContents).m_237508_().equals("vivecraft.item.climbclaws");
    }

    private static boolean canStand(BlockPos blockPos, LocalPlayer player) {
        VoxelShape blockShape = player.m_9236_().m_8055_(blockPos).m_60812_((BlockGetter)player.m_9236_(), blockPos);
        if (blockShape.m_83281_() || blockShape.m_83215_().f_82292_ != 0.0) {
            BlockPos above = blockPos.m_7494_();
            VoxelShape aboveBlockShape = player.m_9236_().m_8055_(above).m_60812_((BlockGetter)player.m_9236_(), above);
            if (aboveBlockShape.m_83281_() || aboveBlockShape.m_83215_().f_82292_ > 0.0) {
                return false;
            }
            BlockPos above2 = above.m_7494_();
            VoxelShape above2BlockShape = player.m_9236_().m_8055_(above2).m_60812_((BlockGetter)player.m_9236_(), above2);
            return above2BlockShape.m_83281_() || above2BlockShape.m_83215_().f_82292_ <= 0.0;
        }
        return false;
    }

    @Override
    public boolean isActive(LocalPlayer player) {
        if (this.dh.vrSettings.seated) {
            return false;
        }
        if (!this.dh.vrPlayer.getFreeMove() && !this.dh.vrSettings.simulateFalling) {
            return false;
        }
        if (!this.dh.vrSettings.realisticClimbEnabled) {
            return false;
        }
        if (player == null && !player.m_6084_()) {
            return false;
        }
        if (this.mc.f_91072_ == null) {
            return false;
        }
        if (player.m_20159_()) {
            return false;
        }
        return ClimbTracker.hasClimbeyClimbEquipped((Player)player) || player.f_20902_ == 0.0f && player.f_20900_ == 0.0f;
    }

    @Override
    public void idleTick(LocalPlayer player) {
        if (!this.isActive(player)) {
            this.wasLatched[0] = false;
            this.wasLatched[1] = false;
        }
        if (this.wasGrabbingLadder() && !this.isGrabbingLadder()) {
            this.forceActivate = true;
        } else if (player.m_20096_() || player.m_150110_().f_35935_) {
            this.forceActivate = false;
        }
        this.dh.vr.getInputAction(VivecraftVRMod.INSTANCE.keyClimbeyGrab).setEnabled(ControllerType.RIGHT, this.isClimbeyClimb() && (this.isGrabbingLadder() || this.inBlock[0] || this.forceActivate));
        this.dh.vr.getInputAction(VivecraftVRMod.INSTANCE.keyClimbeyGrab).setEnabled(ControllerType.LEFT, this.isClimbeyClimb() && (this.isGrabbingLadder() || this.inBlock[1] || this.forceActivate));
    }

    @Override
    public void reset(LocalPlayer player) {
        this.latchStartController = -1;
        this.latched[0] = false;
        this.latched[1] = false;
        player.m_20242_(false);
    }

    @Override
    public void doProcess(LocalPlayer player) {
        int c;
        boolean[] button = new boolean[2];
        boolean[] allowed = new boolean[2];
        Vec3[] controllerPos = new Vec3[2];
        boolean nope = false;
        boolean grabbed = false;
        boolean jump = false;
        boolean ladder = false;
        for (c = 0; c < 2; ++c) {
            controllerPos[c] = this.dh.vrPlayer.vrdata_world_pre.getController(c).getPosition();
            Vector3f controllerDir = this.dh.vrPlayer.vrdata_world_pre.getController(c).getDirection();
            this.inBlock[c] = false;
            BlockPos blockPos = BlockPos.m_274446_((Position)controllerPos[c]);
            BlockState blockState = this.mc.f_91073_.m_8055_(blockPos);
            Block block = blockState.m_60734_();
            VoxelShape voxelShape = blockState.m_60812_((BlockGetter)this.mc.f_91073_, blockPos);
            this.box[c] = voxelShape.m_83281_() ? null : voxelShape.m_83215_();
            if (!this.dh.climbTracker.isClimbeyClimb()) {
                BlockPos blockPos2;
                Object blockState2;
                Block block2;
                boolean ok;
                Vec3 controllerPosNear = this.dh.vrPlayer.vrdata_world_pre.getController(c).getPosition().m_82492_((double)(controllerDir.x * 0.2f), (double)(controllerDir.y * 0.2f), (double)(controllerDir.z * 0.2f));
                AABB controllerBB = new AABB(controllerPos[c], controllerPosNear);
                ladder = true;
                boolean bl = ok = block instanceof LadderBlock || this.isClimbableTrapdoor((Level)this.mc.f_91073_, blockPos, blockState) || block instanceof VineBlock || blockState.m_204336_(BlockTags.VIVECRAFT_CLIMBABLE);
                if (!ok && ((block2 = (blockState2 = this.mc.f_91073_.m_8055_(blockPos2 = BlockPos.m_274446_((Position)controllerPosNear))).m_60734_()) instanceof LadderBlock || this.isClimbableTrapdoor((Level)this.mc.f_91073_, blockPos2, (BlockState)blockState2) || block2 instanceof VineBlock || blockState2.m_204336_(BlockTags.VIVECRAFT_CLIMBABLE))) {
                    blockPos = blockPos2;
                    blockState = blockState2;
                    block = block2;
                    controllerPos[c] = controllerPosNear;
                    VoxelShape voxelShape2 = blockState2.m_60812_((BlockGetter)this.mc.f_91073_, blockPos2);
                    if (voxelShape2.m_83281_()) {
                        this.box[c] = null;
                    } else {
                        ok = true;
                        this.box[c] = voxelShape2.m_83215_();
                    }
                }
                if (ok) {
                    ArrayList<AABB> BBs = new ArrayList<AABB>();
                    if (block instanceof LadderBlock || block instanceof HorizontalDirectionalBlock) {
                        switch ((Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)) {
                            case EAST: {
                                BBs.add(this.eastBB);
                                break;
                            }
                            case NORTH: {
                                BBs.add(this.northBB);
                                break;
                            }
                            case SOUTH: {
                                BBs.add(this.southBB);
                                break;
                            }
                            case WEST: {
                                BBs.add(this.westBB);
                                break;
                            }
                            default: {
                                ok = false;
                            }
                        }
                    }
                    if (block instanceof VineBlock) {
                        this.box[c] = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                        if (((Boolean)blockState.m_61143_((Property)VineBlock.f_57834_)).booleanValue() && this.mc.f_91073_.m_8055_(blockPos.m_122012_()).m_60815_()) {
                            BBs.add(this.southBB);
                        }
                        if (((Boolean)blockState.m_61143_((Property)VineBlock.f_57835_)).booleanValue() && this.mc.f_91073_.m_8055_(blockPos.m_122029_()).m_60815_()) {
                            BBs.add(this.westBB);
                        }
                        if (((Boolean)blockState.m_61143_((Property)VineBlock.f_57836_)).booleanValue() && this.mc.f_91073_.m_8055_(blockPos.m_122019_()).m_60815_()) {
                            BBs.add(this.northBB);
                        }
                        if (((Boolean)blockState.m_61143_((Property)VineBlock.f_57837_)).booleanValue() && this.mc.f_91073_.m_8055_(blockPos.m_122024_()).m_60815_()) {
                            BBs.add(this.eastBB);
                        }
                    }
                    this.inBlock[c] = false;
                    if (ok) {
                        blockState2 = BBs.iterator();
                        while (blockState2.hasNext()) {
                            AABB aabb2 = (AABB)blockState2.next();
                            if (!controllerBB.m_82381_(aabb2.m_82338_(blockPos))) continue;
                            this.inBlock[c] = true;
                            if (aabb2 == this.northBB) {
                                this.grabDirection[c] = Direction.NORTH;
                            } else if (aabb2 == this.southBB) {
                                this.grabDirection[c] = Direction.SOUTH;
                            } else if (aabb2 == this.eastBB) {
                                this.grabDirection[c] = Direction.EAST;
                            } else if (aabb2 == this.westBB) {
                                this.grabDirection[c] = Direction.WEST;
                            }
                            break;
                        }
                    }
                } else {
                    Vec3 handToLatch = this.latchStart[c].m_82546_(controllerPos[c]);
                    if (handToLatch.m_82553_() > 0.5) {
                        this.inBlock[c] = false;
                    } else {
                        BlockPos latchBlockPos = BlockPos.m_274446_((Position)this.latchStart[c]);
                        BlockState latchBlockState = this.mc.f_91073_.m_8055_(latchBlockPos);
                        this.inBlock[c] = this.wasInBlock[c] && latchBlockState.m_60734_() instanceof LadderBlock || latchBlockState.m_60734_() instanceof VineBlock || latchBlockState.m_204336_(BlockTags.VIVECRAFT_CLIMBABLE);
                    }
                }
                button[c] = this.inBlock[c];
                allowed[c] = this.inBlock[c];
            } else {
                Vec3 handToLatch;
                if (this.mc.f_91074_.m_20096_()) {
                    this.mc.f_91074_.m_6853_(!this.latched[0] && !this.latched[1]);
                }
                button[c] = c == 0 ? VivecraftVRMod.INSTANCE.keyClimbeyGrab.isDown(ControllerType.RIGHT) : VivecraftVRMod.INSTANCE.keyClimbeyGrab.isDown(ControllerType.LEFT);
                boolean bl = this.inBlock[c] = this.box[c] != null && this.box[c].m_82338_(blockPos).m_82390_(controllerPos[c]);
                if (!this.inBlock[c] && (handToLatch = this.latchStart[c].m_82546_(controllerPos[c])).m_82553_() > 0.5) {
                    button[c] = false;
                }
                allowed[c] = this.allowed(blockState);
            }
            this.wasLatched[c] = this.latched[c];
            if (!button[c] && this.latched[c]) {
                this.latched[c] = false;
                if (c == 0) {
                    VivecraftVRMod.INSTANCE.keyClimbeyGrab.unpressKey(ControllerType.RIGHT);
                } else {
                    VivecraftVRMod.INSTANCE.keyClimbeyGrab.unpressKey(ControllerType.LEFT);
                }
                jump = true;
            }
            if (!this.latched[c] && !nope && allowed[c]) {
                if (!this.wasInBlock[c] && this.inBlock[c]) {
                    this.dh.vr.triggerHapticPulse(c, 750);
                }
                if (!this.wasInBlock[c] && this.inBlock[c] && button[c] || !this.wasButton[c] && button[c] && this.inBlock[c]) {
                    grabbed = true;
                    this.wantJump = false;
                    this.latchStart[c] = controllerPos[c];
                    this.latchStart_room[c] = this.dh.vrPlayer.vrdata_room_pre.getController(c).getPositionF();
                    this.latchStartBody[c] = player.m_20182_();
                    this.latchStartController = c;
                    this.latchBox[c] = this.box[c];
                    this.latched[c] = true;
                    if (c == 0) {
                        this.latched[1] = false;
                        nope = true;
                    } else {
                        this.latched[0] = false;
                    }
                    this.dh.vr.triggerHapticPulse(c, 2000);
                    ((PlayerExtension)this.mc.f_91074_).vivecraft$stepSound(blockPos, this.latchStart[c]);
                    if (!ladder) {
                        this.dh.vrPlayer.blockDust(this.latchStart[c].f_82479_, this.latchStart[c].f_82480_, this.latchStart[c].f_82481_, 5, blockPos, blockState, 0.1f, 0.2f);
                    }
                }
            }
            this.wasButton[c] = button[c];
            this.wasInBlock[c] = this.inBlock[c];
        }
        if (!this.latched[0] && !this.latched[1]) {
            for (c = 0; c < 2; ++c) {
                if (!this.inBlock[c] || !button[c] || !allowed[c]) continue;
                grabbed = true;
                this.latchStart[c] = controllerPos[c];
                this.latchStart_room[c] = this.dh.vrPlayer.vrdata_room_pre.getController(c).getPositionF();
                this.latchStartBody[c] = player.m_20182_();
                this.latchStartController = c;
                this.latched[c] = true;
                this.latchBox[c] = this.box[c];
                this.wantJump = false;
                this.dh.vr.triggerHapticPulse(c, 2000);
                if (ladder) continue;
                BlockPos blockPos = BlockPos.m_274446_((Position)this.latchStart[c]);
                BlockState blockState = this.mc.f_91073_.m_8055_(blockPos);
                this.dh.vrPlayer.blockDust(this.latchStart[c].f_82479_, this.latchStart[c].f_82480_, this.latchStart[c].f_82481_, 5, blockPos, blockState, 0.1f, 0.2f);
            }
        }
        if (!this.wantJump && !ladder) {
            this.wantJump = VivecraftVRMod.INSTANCE.keyClimbeyJump.m_90857_() && JumpTracker.hasClimbeyJumpEquipped((Player)player);
        }
        jump &= this.wantJump;
        if ((this.latched[0] || this.latched[1]) && !this.gravityOverride) {
            this.unsetFlag = true;
            player.m_20242_(true);
            this.gravityOverride = true;
        }
        if (!this.latched[0] && !this.latched[1] && this.gravityOverride) {
            player.m_20242_(false);
            this.gravityOverride = false;
        }
        if (!(this.latched[0] || this.latched[1] || jump)) {
            if (player.m_20096_() && this.unsetFlag) {
                this.unsetFlag = false;
                VivecraftVRMod.INSTANCE.keyClimbeyGrab.unpressKey(ControllerType.RIGHT);
                VivecraftVRMod.INSTANCE.keyClimbeyGrab.unpressKey(ControllerType.LEFT);
            }
            this.latchStartController = -1;
            return;
        }
        if ((this.latched[0] || this.latched[1]) && this.rand.nextInt(20) == 10) {
            this.mc.f_91074_.m_36399_(0.1f);
            if (!ladder) {
                BlockPos blockPos = BlockPos.m_274446_((Position)this.latchStart[this.latchStartController]);
                BlockState blockState = this.mc.f_91073_.m_8055_(blockPos);
                this.dh.vrPlayer.blockDust(this.latchStart[this.latchStartController].f_82479_, this.latchStart[this.latchStartController].f_82480_, this.latchStart[this.latchStartController].f_82481_, 1, blockPos, blockState, 0.1f, 0.2f);
            }
        }
        Vec3 now = this.dh.vrPlayer.vrdata_world_pre.getController(this.latchStartController).getPosition();
        Vec3 start = VRPlayer.roomToWorldPos((Vector3fc)this.latchStart_room[this.latchStartController], this.dh.vrPlayer.vrdata_world_pre);
        Vec3 delta = now.m_82546_(start);
        this.latchStart_room[this.latchStartController] = this.dh.vrPlayer.vrdata_room_pre.getController(this.latchStartController).getPositionF();
        if (this.wantJump) {
            this.dh.vr.triggerHapticPulse(this.latchStartController, 200);
        }
        if (!jump) {
            if (grabbed) {
                player.m_20334_(0.0, 0.0, 0.0);
            } else {
                player.m_20334_(player.m_20184_().f_82479_, 0.0, player.m_20184_().f_82481_);
            }
            player.f_19789_ = 0.0f;
            double x = player.m_20185_();
            double y = player.m_20186_();
            double z = player.m_20189_();
            double newX = x;
            double newY = y - delta.f_82480_;
            double newZ = z;
            BlockPos blockPos = BlockPos.m_274446_((Position)this.latchStart[this.latchStartController]);
            if (!ladder) {
                newX = x - delta.f_82479_;
                newZ = z - delta.f_82481_;
            } else {
                Direction dir = this.grabDirection[this.latchStartController];
                if (dir == Direction.NORTH || dir == Direction.SOUTH) {
                    newX = x - delta.f_82479_;
                    newZ = (float)blockPos.m_123343_() + 0.5f;
                    newZ += (1.0 - Math.min((double)this.dh.vrPlayer.worldScale, 1.0)) * (dir == Direction.NORTH ? 0.5 : -0.5);
                } else if (dir == Direction.EAST || dir == Direction.WEST) {
                    newZ = z - delta.f_82481_;
                    newX = (float)blockPos.m_123341_() + 0.5f;
                    newX += (1.0 - Math.min((double)this.dh.vrPlayer.worldScale, 1.0)) * (dir == Direction.WEST ? 0.5 : -0.5);
                }
            }
            double hmd = this.dh.vrPlayer.vrdata_room_pre.getHeadPivot().f_82480_;
            double controller = this.dh.vrPlayer.vrdata_room_pre.getController((int)this.latchStartController).getPosition().f_82480_;
            if (!this.wantJump && this.latchBox[this.latchStartController] != null && controller <= hmd / 2.0 && this.latchStart[this.latchStartController].f_82480_ > this.latchBox[this.latchStartController].f_82292_ * 0.8 + (double)blockPos.m_123342_()) {
                Vector3f horizontalDir = this.dh.vrPlayer.vrdata_world_pre.hmd.getDirection();
                horizontalDir.y = 0.0f;
                horizontalDir.normalize().mul(0.1f);
                boolean ok = this.mc.f_91073_.m_45756_((Entity)player, player.m_20191_().m_82386_((double)horizontalDir.x, this.latchBox[this.latchStartController].f_82292_ + (double)blockPos.m_123342_() - player.m_20186_(), (double)horizontalDir.z));
                if (ok) {
                    newX = player.m_20185_() + (double)horizontalDir.x;
                    newY = this.latchBox[this.latchStartController].f_82292_ + (double)blockPos.m_123342_();
                    newZ = player.m_20189_() + (double)horizontalDir.z;
                    this.latchStartController = -1;
                    this.latched[0] = false;
                    this.latched[1] = false;
                    this.wasInBlock[0] = false;
                    this.wasInBlock[1] = false;
                    player.m_20242_(false);
                }
            }
            boolean free = false;
            for (int i = 0; i < 8; ++i) {
                double ax = newX;
                double ay = newY;
                double az = newZ;
                switch (i) {
                    case 2: {
                        ay = y;
                        break;
                    }
                    case 3: {
                        az = z;
                        break;
                    }
                    case 4: {
                        ax = x;
                        break;
                    }
                    case 5: {
                        ax = x;
                        az = z;
                        break;
                    }
                    case 6: {
                        ax = x;
                        ay = y;
                        break;
                    }
                    case 7: {
                        ay = y;
                        az = z;
                        break;
                    }
                }
                player.m_6034_(ax, ay, az);
                AABB bb = player.m_20191_();
                free = this.mc.f_91073_.m_45756_((Entity)player, bb);
                if (!free) continue;
                if (i <= 1) break;
                this.dh.vr.triggerHapticPulse(0, 100);
                this.dh.vr.triggerHapticPulse(1, 100);
                break;
            }
            if (!free) {
                player.m_6034_(x, y, z);
                this.dh.vr.triggerHapticPulse(0, 100);
                this.dh.vr.triggerHapticPulse(1, 100);
            }
            ClientNetworking.sendServerPacket(new ClimbingPayloadC2S());
        } else {
            this.wantJump = false;
            Vec3 p1 = player.m_20182_().m_82546_(delta);
            Vector3f movement = this.dh.vr.controllerHistory[this.latchStartController].netMovement(0.3);
            float speed = this.dh.vr.controllerHistory[this.latchStartController].averageSpeed(0.3f);
            movement.mul(0.66f * speed);
            float limit = 0.66f;
            if (movement.length() > 0.66f) {
                movement.mul(0.66f / movement.length());
            }
            if (player.m_21023_(MobEffects.f_19603_)) {
                movement.mul((float)player.m_21124_(MobEffects.f_19603_).m_19564_() + 1.5f);
            }
            movement.rotateY(this.dh.vrPlayer.vrdata_world_pre.rotation_radians);
            player.m_20334_((double)(-movement.x), (double)(-movement.y), (double)(-movement.z));
            player.f_19790_ = p1.f_82479_;
            player.f_19791_ = p1.f_82480_;
            player.f_19792_ = p1.f_82481_;
            p1 = p1.m_82520_(player.m_20184_().f_82479_, player.m_20184_().f_82480_, player.m_20184_().f_82481_);
            player.m_6034_(p1.f_82479_, p1.f_82480_, p1.f_82481_);
            this.dh.vrPlayer.snapRoomOriginToPlayerEntity((Entity)player, false, false);
            this.mc.f_91074_.m_36399_(0.3f);
        }
    }

    private boolean isClimbableTrapdoor(Level level, BlockPos blockPos, BlockState blockState) {
        if (blockState.m_60734_() instanceof TrapDoorBlock && ((Boolean)blockState.m_61143_((Property)TrapDoorBlock.f_57514_)).booleanValue()) {
            BlockState blockStateBelow = level.m_8055_(blockPos.m_7495_());
            return blockStateBelow.m_60713_(Blocks.f_50155_) && blockStateBelow.m_61143_((Property)LadderBlock.f_54337_) == blockState.m_61143_((Property)TrapDoorBlock.f_54117_);
        }
        return false;
    }

    private boolean allowed(BlockState bs) {
        return switch (this.serverBlockmode) {
            default -> throw new IncompatibleClassChangeError();
            case ClimbeyBlockmode.DISABLED -> true;
            case ClimbeyBlockmode.WHITELIST -> this.blocklist.contains(bs.m_60734_());
            case ClimbeyBlockmode.BLACKLIST -> !this.blocklist.contains(bs.m_60734_());
        };
    }
}

