/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.gameplay.trackers.Tracker;
import org.vivecraft.client_vr.render.RenderPass;
import org.vivecraft.common.utils.MathUtils;

public class CameraTracker
extends Tracker {
    public static final ModelResourceLocation CAMERA_MODEL = new ModelResourceLocation("vivecraft", "camera", "");
    public static final ModelResourceLocation CAMERA_DISPLAY_MODEL = new ModelResourceLocation("vivecraft", "camera_display", "");
    private boolean visible = false;
    private Vec3 position = Vec3.f_82478_;
    private Quaternionf rotation = new Quaternionf();
    private int startController;
    private VRData.VRDevicePose startControllerPose;
    private Vec3 startPosition;
    private Quaternionf startRotation;
    private boolean quickMode;

    public CameraTracker(Minecraft mc, ClientDataHolderVR dh) {
        super(mc, dh);
    }

    @Override
    public boolean isActive(LocalPlayer player) {
        if (this.mc.f_91072_ == null) {
            return false;
        }
        if (this.dh.vrSettings.seated) {
            return false;
        }
        return this.isVisible();
    }

    @Override
    public void doProcess(LocalPlayer player) {
        if (this.startControllerPose != null) {
            VRData.VRDevicePose controllerPose = this.dh.vrPlayer.vrdata_world_render.getController(this.startController);
            Vec3 startPos = this.startControllerPose.getPosition();
            Vector3f deltaPos = MathUtils.subtractToVector3f(controllerPose.getPosition(), startPos);
            Matrix4f deltaMatrix = controllerPose.getMatrix().mul((Matrix4fc)this.startControllerPose.getMatrix().invert());
            Vector3f offset = MathUtils.subtractToVector3f(this.startPosition, startPos);
            Vector3f offsetRotated = deltaMatrix.transformPosition((Vector3fc)offset, new Vector3f());
            this.position = new Vec3(this.startPosition.f_82479_ + (double)deltaPos.x + (double)offsetRotated.x() - (double)offset.x(), this.startPosition.f_82480_ + (double)deltaPos.y + (double)offsetRotated.y() - (double)offset.y(), this.startPosition.f_82481_ + (double)deltaPos.z + (double)offsetRotated.z() - (double)offset.z());
            Quaternionf tempQuat = deltaMatrix.getNormalizedRotation(new Quaternionf());
            this.rotation = tempQuat.mul((Quaternionfc)this.startRotation, tempQuat);
        }
        if (this.quickMode && !this.isMoving() && !this.dh.grabScreenShot) {
            this.visible = false;
        }
        if (this.dh.vrPlayer.vrdata_world_render.getEye(RenderPass.CENTER).getPosition().m_82554_(this.position) > (double)(this.mc.f_91066_.m_193772_() * 12)) {
            this.visible = false;
        }
    }

    @Override
    public void reset(LocalPlayer player) {
        this.visible = false;
        this.quickMode = false;
        this.stopMoving();
    }

    @Override
    public Tracker.EntryPoint getEntryPoint() {
        return Tracker.EntryPoint.SPECIAL_ITEMS;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void toggleVisibility() {
        this.visible = !this.visible;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public Vector3f getRoomPosition(Vec3 roomOrigin) {
        if (roomOrigin == Vec3.f_82478_ && this.dh.vrPlayer != null) {
            return MathUtils.subtractToVector3f(this.position, this.dh.vrPlayer.roomOrigin);
        }
        return MathUtils.subtractToVector3f(this.position, roomOrigin);
    }

    public void setPosition(Vec3 position) {
        this.position = position;
    }

    public Quaternionf getRotation() {
        return this.rotation;
    }

    public void setRotation(Quaternionf rotation) {
        this.rotation = rotation;
    }

    public void setRotation(Matrix4fc rotationMat) {
        rotationMat.getNormalizedRotation(this.rotation);
    }

    public boolean isMoving() {
        return this.startControllerPose != null;
    }

    public int getMovingController() {
        return this.startController;
    }

    public boolean isQuickMode() {
        return this.quickMode;
    }

    public void startMoving(int controller, boolean quickMode) {
        this.startController = controller;
        this.startControllerPose = this.dh.vrPlayer.vrdata_world_pre.getController(controller);
        this.startPosition = this.position;
        this.startRotation = new Quaternionf((Quaternionfc)this.rotation);
        this.quickMode = quickMode;
    }

    public void startMoving(int controller) {
        this.startMoving(controller, false);
    }

    public void stopMoving() {
        this.startControllerPose = null;
    }
}

