/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client.utils.ScaleHelper;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.extensions.PlayerExtension;
import org.vivecraft.client_vr.gameplay.trackers.Tracker;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.network.packet.c2s.DrawPayloadC2S;
import org.vivecraft.common.utils.MathUtils;

public class BowTracker
extends Tracker {
    private static final long MAX_DRAW_MILLIS = 1100L;
    private static final double NOTCH_DOT_THRESHOLD = 20.0;
    public long startDrawTime;
    public boolean isDrawing;
    private boolean pressed;
    private boolean canDraw;
    private float currentDraw;
    private float maxDraw;
    private Vector3f aim;
    private float tsNotch = 0.0f;
    private int hapCounter = 0;
    private int lastHapStep = 0;

    public BowTracker(Minecraft mc, ClientDataHolderVR dh) {
        super(mc, dh);
    }

    public Vector3fc getAimVector() {
        return this.aim;
    }

    public float getDrawPercent() {
        return this.currentDraw / this.maxDraw;
    }

    public boolean isNotched() {
        return this.canDraw || this.isDrawing;
    }

    public boolean isCharged() {
        return Util.m_137550_() - this.startDrawTime >= 1100L;
    }

    public static boolean isBow(ItemStack itemStack) {
        if (itemStack == ItemStack.f_41583_) {
            return false;
        }
        if (ClientDataHolderVR.getInstance().vrSettings.bowMode == VRSettings.BowMode.OFF) {
            return false;
        }
        if (ClientDataHolderVR.getInstance().vrSettings.bowMode == VRSettings.BowMode.VANILLA) {
            return itemStack.m_41720_() == Items.f_42411_;
        }
        return itemStack.m_41720_().m_6164_(itemStack) == UseAnim.BOW && !itemStack.m_204117_(org.vivecraft.data.ItemTags.VIVECRAFT_BOW_EXCLUSION);
    }

    public static boolean isHoldingBow(LivingEntity entity, InteractionHand hand) {
        return !ClientDataHolderVR.getInstance().vrSettings.seated && BowTracker.isBow(entity.m_21120_(hand));
    }

    public static boolean isHoldingBowEither(LivingEntity entity) {
        return BowTracker.isHoldingBow(entity, InteractionHand.MAIN_HAND) || BowTracker.isHoldingBow(entity, InteractionHand.OFF_HAND);
    }

    @Override
    public boolean itemInUse(LocalPlayer player) {
        return this.isDrawing;
    }

    @Override
    public boolean isActive(LocalPlayer player) {
        if (player == null) {
            return false;
        }
        if (this.mc.f_91072_ == null) {
            return false;
        }
        if (!player.m_6084_()) {
            return false;
        }
        if (player.m_5803_()) {
            return false;
        }
        return BowTracker.isHoldingBow((LivingEntity)player, InteractionHand.MAIN_HAND) || BowTracker.isHoldingBow((LivingEntity)player, InteractionHand.OFF_HAND);
    }

    @Override
    public void reset(LocalPlayer player) {
        this.isDrawing = false;
        this.canDraw = false;
    }

    @Override
    public Tracker.EntryPoint getEntryPoint() {
        return Tracker.EntryPoint.SPECIAL_ITEMS;
    }

    @Override
    public void doProcess(LocalPlayer player) {
        VRData vrData = this.dh.vrPlayer.getVRDataWorld();
        if (this.dh.vrSettings.seated) {
            this.aim = vrData.getController(0).getCustomVector(MathUtils.FORWARD);
        } else {
            boolean lastPressed = this.pressed;
            boolean lastCanDraw = this.canDraw;
            this.maxDraw = this.mc.f_91074_.m_20206_() * 0.22f;
            this.maxDraw /= ScaleHelper.getEntityBbScale((LivingEntity)player, ClientUtils.getCurrentPartialTick());
            int bowHand = 1;
            int arrowHand = 0;
            if (this.dh.vrSettings.reverseShootingEye && ClientNetworking.supportsReversedBow()) {
                bowHand = 0;
                arrowHand = 1;
            }
            Vec3 arrowPos = vrData.getController(arrowHand).getPosition();
            Vec3 bowPos = vrData.getController(bowHand).getPosition();
            float controllersDist = (float)bowPos.m_82554_(arrowPos);
            Vector3f up = new Vector3f(0.0f, vrData.worldScale, 0.0f);
            Vec3 stringPos = new Vec3(vrData.getHand(bowHand).getCustomVector((Vector3fc)up).mul(this.maxDraw * 0.5f)).m_82549_(bowPos);
            double notchDist = arrowPos.m_82554_(stringPos);
            this.aim = MathUtils.subtractToVector3f(arrowPos, bowPos).normalize();
            Vector3f arrowAim = vrData.getController(arrowHand).getCustomVector(MathUtils.BACK);
            Vector3f bowAim = vrData.getHand(bowHand).getCustomVector(MathUtils.DOWN);
            double controllersDot = Math.toDegrees(Math.acos(bowAim.dot((Vector3fc)arrowAim)));
            this.pressed = VivecraftVRMod.INSTANCE.keyVRInteract.isDown(ControllerType.values()[arrowHand]);
            float notchDistThreshold = 0.15f * vrData.worldScale;
            boolean main = BowTracker.isHoldingBow((LivingEntity)player, InteractionHand.MAIN_HAND);
            InteractionHand hand = main ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
            ItemStack ammo = ItemStack.f_41583_;
            ItemStack bow = ItemStack.f_41583_;
            if (main) {
                bow = player.m_21205_();
                ammo = player.m_6298_(bow);
            } else {
                if (player.m_21205_().m_204117_(ItemTags.f_13161_)) {
                    ammo = player.m_21205_();
                }
                bow = player.m_21206_();
            }
            int stage0 = bow.m_41779_();
            int stage1 = bow.m_41779_() - 15;
            int stage2 = 0;
            if (ammo != ItemStack.f_41583_ && notchDist <= (double)notchDistThreshold && controllersDot <= 20.0) {
                if (!this.canDraw) {
                    this.startDrawTime = Util.m_137550_();
                }
                this.canDraw = true;
                this.tsNotch = Util.m_137550_();
                if (!this.isDrawing) {
                    ((PlayerExtension)player).vivecraft$setItemInUseClient(bow, hand);
                    ((PlayerExtension)player).vivecraft$setItemInUseRemainingClient(stage0);
                }
            } else if (!this.isDrawing && (float)Util.m_137550_() - this.tsNotch > 500.0f) {
                this.canDraw = false;
                ((PlayerExtension)player).vivecraft$setItemInUseClient(ItemStack.f_41583_, hand);
            }
            if (!this.isDrawing && this.canDraw && this.pressed && !lastPressed) {
                this.isDrawing = true;
                this.mc.f_91072_.m_233721_((Player)player, hand);
            }
            if (this.isDrawing && !this.pressed && lastPressed && this.getDrawPercent() > 0.0f) {
                this.dh.vr.triggerHapticPulse(arrowHand, 500);
                this.dh.vr.triggerHapticPulse(bowHand, 3000);
                ClientNetworking.sendServerPacket(new DrawPayloadC2S(this.getDrawPercent()));
                ClientNetworking.sendActiveHand(InteractionHand.values()[arrowHand]);
                this.mc.f_91072_.m_105277_((Player)player);
                ClientNetworking.sendServerPacket(new DrawPayloadC2S(0.0f));
                ClientNetworking.sendActiveHand(InteractionHand.MAIN_HAND);
                this.isDrawing = false;
            }
            if (!this.pressed) {
                this.isDrawing = false;
            }
            if (!this.isDrawing && this.canDraw && !lastCanDraw) {
                this.dh.vr.triggerHapticPulse(arrowHand, 800);
                this.dh.vr.triggerHapticPulse(bowHand, 800);
            }
            if (this.isDrawing) {
                this.currentDraw = (controllersDist - notchDistThreshold) / vrData.worldScale;
                if (this.currentDraw > this.maxDraw) {
                    this.currentDraw = this.maxDraw;
                }
                int hapStrength = 0;
                if (this.getDrawPercent() > 0.0f) {
                    hapStrength = (int)(this.getDrawPercent() * 500.0f) + 700;
                }
                ((PlayerExtension)player).vivecraft$setItemInUseClient(bow, hand);
                double drawPercent = this.getDrawPercent();
                if (drawPercent >= 1.0) {
                    ((PlayerExtension)player).vivecraft$setItemInUseRemainingClient(stage2);
                } else if (drawPercent > 0.4) {
                    ((PlayerExtension)player).vivecraft$setItemInUseRemainingClient(stage1);
                } else {
                    ((PlayerExtension)player).vivecraft$setItemInUseRemainingClient(stage0);
                }
                int hapStep = (int)(drawPercent * 4.0 * 4.0 * 3.0);
                if (hapStep % 2 == 0 && this.lastHapStep != hapStep) {
                    this.dh.vr.triggerHapticPulse(arrowHand, hapStrength);
                    if (drawPercent == 1.0) {
                        this.dh.vr.triggerHapticPulse(bowHand, hapStrength);
                    }
                }
                if (this.isCharged() && this.hapCounter % 4 == 0) {
                    this.dh.vr.triggerHapticPulse(bowHand, 200);
                }
                this.lastHapStep = hapStep;
                ++this.hapCounter;
            } else {
                this.hapCounter = 0;
                this.lastHapStep = 0;
            }
        }
    }
}

