/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.gameplay.trackers.BackpackTracker;
import org.vivecraft.client_vr.gameplay.trackers.BowTracker;
import org.vivecraft.client_vr.gameplay.trackers.CameraTracker;
import org.vivecraft.client_vr.gameplay.trackers.ClimbTracker;
import org.vivecraft.client_vr.gameplay.trackers.CrawlTracker;
import org.vivecraft.client_vr.gameplay.trackers.EatingTracker;
import org.vivecraft.client_vr.gameplay.trackers.HorseTracker;
import org.vivecraft.client_vr.gameplay.trackers.InteractTracker;
import org.vivecraft.client_vr.gameplay.trackers.JumpTracker;
import org.vivecraft.client_vr.gameplay.trackers.RowTracker;
import org.vivecraft.client_vr.gameplay.trackers.RunTracker;
import org.vivecraft.client_vr.gameplay.trackers.SneakTracker;
import org.vivecraft.client_vr.gameplay.trackers.SwimTracker;
import org.vivecraft.client_vr.gameplay.trackers.SwingTracker;
import org.vivecraft.client_vr.gameplay.trackers.TeleportTracker;
import org.vivecraft.client_vr.gameplay.trackers.TelescopeTracker;
import org.vivecraft.client_vr.gameplay.trackers.Tracker;
import org.vivecraft.client_vr.gameplay.trackers.VehicleTracker;
import org.vivecraft.client_vr.menuworlds.MenuWorldRenderer;
import org.vivecraft.client_vr.provider.MCVR;
import org.vivecraft.client_vr.provider.VRRenderer;
import org.vivecraft.client_vr.render.RenderPass;
import org.vivecraft.client_vr.render.VRFirstPersonArmSwing;
import org.vivecraft.client_vr.settings.VRSettings;

public class ClientDataHolderVR {
    public static final ModelResourceLocation THIRD_PERSON_CAMERA_MODEL = new ModelResourceLocation("vivecraft", "camcorder", "");
    public static final ModelResourceLocation THIRD_PERSON_CAMERA_DISPLAY_MODEL = new ModelResourceLocation("vivecraft", "camcorder_display", "");
    public static boolean KAT_VR;
    public static boolean INFINADECK;
    public static boolean KIOSK;
    public static boolean VIEW_ONLY;
    public static boolean IS_MAIN_HAND;
    public static boolean IS_FP_HAND;
    private static ClientDataHolderVR INSTANCE;
    public VRPlayer vrPlayer;
    public MCVR vr;
    public VRRenderer vrRenderer;
    public MenuWorldRenderer menuWorldRenderer;
    private final List<Tracker> trackers = new ArrayList<Tracker>();
    public final BackpackTracker backpackTracker = this.createTracker(BackpackTracker::new);
    public final BowTracker bowTracker = this.createTracker(BowTracker::new);
    public final CameraTracker cameraTracker = this.createTracker(CameraTracker::new);
    public final ClimbTracker climbTracker = this.createTracker(ClimbTracker::new);
    public final CrawlTracker crawlTracker = this.createTracker(CrawlTracker::new);
    public final EatingTracker eatingTracker = this.createTracker(EatingTracker::new);
    public final HorseTracker horseTracker = this.createTracker(HorseTracker::new);
    public final InteractTracker interactTracker = this.createTracker(InteractTracker::new);
    public final JumpTracker jumpTracker = this.createTracker(JumpTracker::new);
    public final RowTracker rowTracker = this.createTracker(RowTracker::new);
    public final RunTracker runTracker = this.createTracker(RunTracker::new);
    public final SneakTracker sneakTracker = this.createTracker(SneakTracker::new);
    public final SwimTracker swimTracker = this.createTracker(SwimTracker::new);
    public final SwingTracker swingTracker = this.createTracker(SwingTracker::new);
    public final TeleportTracker teleportTracker = this.createTracker(TeleportTracker::new);
    public final TelescopeTracker telescopeTracker = this.createTracker(TelescopeTracker::new);
    public final VehicleTracker vehicleTracker = this.createTracker(VehicleTracker::new);
    public VRSettings vrSettings;
    public boolean grabScreenShot = false;
    public Screen cachedScreen = null;
    public long frameIndex = 0L;
    public RenderPass currentPass;
    public boolean isFirstPass;
    public boolean menuHandOff;
    public boolean menuHandMain;
    public boolean completelyDisabled;
    public int tickCounter;
    public VRFirstPersonArmSwing swingType = VRFirstPersonArmSwing.Attack;
    public boolean showedUpdateNotification;
    public boolean showedStencilMessage;
    public boolean showedFbtCalibrationNotification;

    public static ClientDataHolderVR getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ClientDataHolderVR();
        }
        return INSTANCE;
    }

    public boolean isMenuHand(HumanoidArm arm) {
        if (arm == HumanoidArm.LEFT) {
            return this.vrSettings.reverseHands ? this.menuHandMain : this.menuHandOff;
        }
        return this.vrSettings.reverseHands ? this.menuHandOff : this.menuHandMain;
    }

    public <T extends Tracker> T createTracker(BiFunction<Minecraft, ClientDataHolderVR, T> constructor) {
        Tracker tracker = (Tracker)constructor.apply(Minecraft.m_91087_(), this);
        this.registerTracker(tracker);
        return (T)tracker;
    }

    public void registerTracker(Tracker tracker) throws IllegalArgumentException {
        if (this.trackers.contains(tracker)) {
            throw new IllegalArgumentException("Tracker is already added and should not be added again!");
        }
        this.trackers.add(tracker);
    }

    public List<Tracker> getTrackers() {
        return Collections.unmodifiableList(this.trackers);
    }
}

