/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.utils;

import com.mojang.blaze3d.pipeline.RenderTarget;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import org.vivecraft.client_vr.extensions.MinecraftExtension;
import org.vivecraft.client_vr.settings.VRSettings;

public class ClientUtils {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static final Random AV_RANDOMIZER = new Random();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readWinRegistry(String key) {
        try {
            Process process = Runtime.getRuntime().exec("reg query \"" + key.substring(0, key.lastIndexOf(92)) + "\" /v \"" + key.substring(key.lastIndexOf(92) + 1) + "\"");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line = reader.readLine();
                while (line != null) {
                    String[] split = line.split("REG_SZ|REG_DWORD");
                    if (split.length > 1) {
                        String string = split[1].trim();
                        return string;
                    }
                    line = reader.readLine();
                }
                return null;
            }
        }
        catch (Exception e) {
            VRSettings.LOGGER.error("Vivecraft: error reading registry key: ", (Throwable)e);
        }
        return null;
    }

    public static void spawnParticles(ParticleOptions type, int count, Vec3 position, Vec3 size, double speed) {
        Minecraft minecraft = Minecraft.m_91087_();
        for (int k = 0; k < count; ++k) {
            double offX = AV_RANDOMIZER.nextGaussian() * size.f_82479_;
            double offY = AV_RANDOMIZER.nextGaussian() * size.f_82480_;
            double offZ = AV_RANDOMIZER.nextGaussian() * size.f_82481_;
            double dirX = AV_RANDOMIZER.nextGaussian() * speed;
            double dirY = AV_RANDOMIZER.nextGaussian() * speed;
            double dirZ = AV_RANDOMIZER.nextGaussian() * speed;
            try {
                minecraft.f_91073_.m_7106_(type, position.f_82479_ + offX, position.f_82480_ + offY, position.f_82481_ + offZ, dirX, dirY, dirZ);
                continue;
            }
            catch (Throwable throwable) {
                VRSettings.LOGGER.warn("Vivecraft: Could not spawn particle effect {}", (Object)type);
                return;
            }
        }
    }

    public static int getCombinedLightWithMin(BlockAndTintGetter lightReader, BlockPos pos, int minLight) {
        int light = LevelRenderer.m_109541_((BlockAndTintGetter)lightReader, (BlockPos)pos);
        int blockLight = light >> 4 & 0xF;
        if (blockLight < minLight) {
            light &= 0xFFFFFF00;
            light |= minLight << 4;
        }
        return light;
    }

    public static void takeScreenshot(RenderTarget fb) {
        Minecraft minecraft = Minecraft.m_91087_();
        Screenshot.m_92289_((File)minecraft.f_91069_, (RenderTarget)fb, text -> minecraft.execute(() -> minecraft.f_91065_.m_93076_().m_93785_(text)));
    }

    public static float getCurrentPartialTick() {
        return ((MinecraftExtension)MC).vivecraft$getPartialTick();
    }

    public static <T extends Enum<T>> T getNextEnum(T current, int offset) {
        Enum[] values = (Enum[])current.getClass().getEnumConstants();
        int index = (current.ordinal() + offset + values.length) % values.length;
        return (T)values[index];
    }

    public static long microTime() {
        return System.nanoTime() / 1000L;
    }

    public static long milliTime() {
        return System.nanoTime() / 1000000L;
    }
}

