/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client.ClientVRPlayers;
import org.vivecraft.client.render.VRPlayerModel_WithArms;
import org.vivecraft.client.render.VRPlayerModel_WithArmsLegs;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client.utils.ModelUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.render.RenderPass;
import org.vivecraft.client_vr.render.helpers.VREffectsHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.network.FBTMode;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.mod_compat_vr.immersiveportals.ImmersivePortalsHelper;
import org.vivecraft.mod_compat_vr.mca.MCAHelper;
import org.vivecraft.mod_compat_vr.shaders.ShadersHelper;

public class VRPlayerModel<T extends LivingEntity>
extends PlayerModel<T> {
    public ModelPart vrHMD;
    protected ClientVRPlayers.RotInfo rotInfo;
    protected float bodyYaw;
    protected boolean laying;
    protected float xRot;
    protected float layAmount;
    protected HumanoidArm attackArm = null;
    protected HumanoidArm mainArm = HumanoidArm.RIGHT;
    protected boolean isMainPlayer;
    protected float bodyScale;
    protected float armScale;
    protected float legScale;
    protected final Vector3f tempV = new Vector3f();
    protected final Vector3f tempV2 = new Vector3f();
    protected final Matrix3f tempM = new Matrix3f();

    public VRPlayerModel(ModelPart root, boolean isSlim) {
        super(root, isSlim);
        this.vrHMD = root.m_171324_("vrHMD");
    }

    public static MeshDefinition createMesh(CubeDeformation cubeDeformation, boolean slim) {
        MeshDefinition meshDefinition = PlayerModel.m_170825_((CubeDeformation)cubeDeformation, (boolean)slim);
        PartDefinition root = meshDefinition.m_171576_();
        root.m_171599_("vrHMD", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.5f, -6.0f, -7.5f, 7.0f, 4.0f, 5.0f, cubeDeformation), PartPose.f_171404_);
        return meshDefinition;
    }

    public void m_6973_(T player, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_(player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.vrHMD.f_104207_ = true;
        this.vrHMD.m_104315_(this.f_102808_);
    }

    public static void animateVRModel(PlayerModel<LivingEntity> model, LivingEntity player, float limbSwing, float limbSwingAmount, Vector3f tempV, Vector3f tempV2, Matrix3f tempM) {
        ClientVRPlayers.RotInfo rotInfo = null;
        if (player.getClass() == LocalPlayer.class || player.getClass() == RemotePlayer.class) {
            rotInfo = ClientVRPlayers.getInstance().getRotationsForPlayer(player.m_20148_());
        }
        if (rotInfo == null) {
            if (model instanceof VRPlayerModel) {
                VRPlayerModel vrModel = (VRPlayerModel)model;
                vrModel.rotInfo = null;
            }
            return;
        }
        float partialTick = ClientUtils.getCurrentPartialTick();
        boolean isMainPlayer = VREffectsHelper.isFirstPersonPlayer((Entity)player);
        HumanoidArm mainArm = rotInfo.leftHanded ? HumanoidArm.LEFT : HumanoidArm.RIGHT;
        HumanoidArm attackArm = null;
        if (model.f_102608_ > 0.0f) {
            HumanoidArm humanoidArm = attackArm = player.f_20912_ == InteractionHand.MAIN_HAND ? HumanoidArm.RIGHT : HumanoidArm.LEFT;
            if (rotInfo.leftHanded) {
                attackArm = attackArm.m_20828_();
            }
        }
        float bodyYaw = isMainPlayer ? ClientDataHolderVR.getInstance().vrPlayer.getVRDataWorld().getBodyYawRad() : rotInfo.getBodyYawRad();
        boolean laying = model.f_102818_ > 0.0f || player.m_21255_();
        float layAmount = player.m_21255_() ? 1.0f : model.f_102818_;
        boolean swimming = laying && player.m_20069_() || player.m_21255_();
        boolean noLowerBodyAnimation = swimming || rotInfo.fbtMode == FBTMode.ARMS_ONLY;
        float bodyScale = 1.0f;
        float armScale = 1.0f;
        float legScale = 1.0f;
        if (isMainPlayer && ClientDataHolderVR.getInstance().vrSettings.shouldRenderSelf && (!ImmersivePortalsHelper.isLoaded() || !ImmersivePortalsHelper.isRenderingPortal()) && !ShadersHelper.isRenderingShadows() && RenderPass.isFirstPerson(ClientDataHolderVR.getInstance().currentPass) || ShadersHelper.isRenderingShadows() && ClientDataHolderVR.getInstance().vrSettings.shaderFullSizeShadowLimbs) {
            bodyScale = ClientDataHolderVR.getInstance().vrSettings.playerModelBodyScale;
            armScale = ClientDataHolderVR.getInstance().vrSettings.playerModelArmsScale;
            legScale = ClientDataHolderVR.getInstance().vrSettings.playerModelLegScale;
        }
        float sideOffset = 4.0f * bodyScale + armScale;
        float xRot = swimming ? layAmount * (-1.5707964f - (float)Math.PI / 180 * player.m_5686_(partialTick)) : layAmount * -1.5707964f;
        if (!swimming) {
            rotInfo.headQuat.transform(0.0f, -0.2f, 0.1f, tempV2);
            if (isMainPlayer) {
                tempV2.mul(rotInfo.worldScale);
            }
            tempV2.mul(rotInfo.heightScale);
        } else {
            tempV2.zero();
        }
        tempV2.add(rotInfo.headPos);
        float progress = ModelUtils.getBendProgress(player, rotInfo, (Vector3fc)tempV2);
        float heightOffset = 22.0f * progress;
        tempM.set(rotInfo.headQuat).rotateLocalY(bodyYaw + (float)Math.PI).rotateLocalX(-xRot);
        ModelUtils.setRotation(model.f_102808_, (Matrix3fc)tempM, tempV);
        ModelUtils.worldToModel(player, (Vector3fc)tempV2, rotInfo, bodyYaw, isMainPlayer, tempV);
        if (swimming) {
            tempV.z += 3.0f;
        }
        model.f_102808_.m_104227_(tempV.x, tempV.y, tempV.z);
        model.f_102810_.m_104227_(model.f_102808_.f_104200_, model.f_102808_.f_104201_, model.f_102808_.f_104202_);
        if (model.f_102609_) {
            ModelUtils.pointModelAtModelForward(model.f_102810_, 0.0f, 14.0f, 2.0f + heightOffset, tempV, tempV2, tempM);
            tempM.rotateLocalX(-xRot);
            ModelUtils.setRotation(model.f_102810_, (Matrix3fc)tempM, tempV);
        } else if (noLowerBodyAnimation) {
            model.f_102810_.m_171327_((float)Math.PI * Math.max(0.0f, model.f_102810_.f_104201_ / 22.0f) * (model instanceof VRPlayerModel_WithArmsLegs ? 0.5f : 1.0f), 0.0f, 0.0f);
            if (laying) {
                float bodyXRot;
                if (swimming) {
                    bodyXRot = -xRot;
                } else {
                    float aboveGround = (heightOffset - 11.0f) / 11.0f;
                    bodyXRot = progress * ((float)Math.PI - 1.5707964f * (1.0f + 0.3f * (1.0f - aboveGround)));
                }
                model.f_102810_.f_104203_ = Mth.m_14179_((float)layAmount, (float)model.f_102810_.f_104203_, (float)bodyXRot);
                model.f_102808_.f_104201_ -= 2.0f * layAmount;
                model.f_102810_.f_104201_ -= 2.0f * layAmount;
            }
        } else {
            ModelUtils.pointModelAtLocal(player, model.f_102810_, rotInfo.waistPos, rotInfo.waistQuat, rotInfo, bodyYaw, isMainPlayer, tempV, tempV2, tempM);
            tempM.transform(sideOffset, 2.0f, 0.0f, tempV2);
            model.f_102812_.f_104200_ = model.f_102810_.f_104200_ + tempV2.x;
            model.f_102812_.f_104201_ = model.f_102810_.f_104201_ + tempV2.y;
            model.f_102812_.f_104202_ = model.f_102810_.f_104202_ - tempV2.z;
            tempM.transform(-sideOffset, 2.0f, 0.0f, tempV2);
            model.f_102811_.f_104200_ = model.f_102810_.f_104200_ + tempV2.x;
            model.f_102811_.f_104201_ = model.f_102810_.f_104201_ + tempV2.y;
            model.f_102811_.f_104202_ = model.f_102810_.f_104202_ - tempV2.z;
            tempM.rotateLocalX(-xRot);
            ModelUtils.setRotation(model.f_102810_, (Matrix3fc)tempM, tempV);
        }
        float cosBodyRot = Mth.m_14089_((float)model.f_102810_.f_104203_);
        if (model.f_102609_ || noLowerBodyAnimation) {
            model.f_102812_.f_104200_ = model.f_102810_.f_104200_ + sideOffset;
            model.f_102811_.f_104200_ = model.f_102810_.f_104200_ - sideOffset;
            model.f_102812_.f_104201_ = 2.0f * cosBodyRot + model.f_102810_.f_104201_;
            model.f_102812_.f_104202_ = model.f_102810_.f_104202_;
            model.f_102811_.f_104201_ = model.f_102812_.f_104201_;
            model.f_102811_.f_104202_ = model.f_102812_.f_104202_;
        }
        model.f_102814_.f_104200_ = 1.9f;
        model.f_102813_.f_104200_ = -1.9f;
        if (model.f_102609_) {
            model.f_102813_.f_104202_ = model.f_102814_.f_104202_ = heightOffset;
        } else if (laying && noLowerBodyAnimation) {
            if (swimming) {
                tempV.set(0.0f, 12.0f, 0.0f);
                tempV.rotateX(-xRot);
                model.f_102814_.f_104201_ = model.f_102810_.f_104201_ + tempV.y;
                model.f_102814_.f_104202_ = model.f_102810_.f_104202_ + tempV.z;
            } else {
                float cosBodyRot2 = cosBodyRot * cosBodyRot;
                model.f_102814_.f_104201_ += 10.25f - 2.0f * cosBodyRot2;
                model.f_102814_.f_104202_ = model.f_102810_.f_104202_ + 13.0f - cosBodyRot2 * 8.0f;
            }
            model.f_102814_.f_104200_ += model.f_102810_.f_104200_;
            model.f_102813_.f_104200_ += model.f_102810_.f_104200_;
            model.f_102813_.f_104201_ = model.f_102814_.f_104201_;
            model.f_102813_.f_104202_ = model.f_102814_.f_104202_;
        } else if (rotInfo.fbtMode != FBTMode.ARMS_ONLY) {
            ModelUtils.worldToModel(player, rotInfo.waistPos, rotInfo, bodyYaw, isMainPlayer, tempV);
            tempV2.set(-1.9f, -2.0f, 0.0f);
            rotInfo.waistQuat.transform(tempV2);
            ModelUtils.worldToModelDirection((Vector3fc)tempV2, bodyYaw, tempV2);
            model.f_102814_.m_104227_(tempV.x + tempV2.x, tempV.y + tempV2.y, tempV.z + tempV2.z);
            tempV2.set(1.9f, -2.0f, 0.0f);
            rotInfo.waistQuat.transform(tempV2);
            ModelUtils.worldToModelDirection((Vector3fc)tempV2, bodyYaw, tempV2);
            model.f_102813_.m_104227_(tempV.x + tempV2.x, tempV.y + tempV2.y, tempV.z + tempV2.z);
        } else {
            model.f_102814_.f_104200_ += model.f_102810_.f_104200_;
            model.f_102813_.f_104200_ += model.f_102810_.f_104200_;
        }
        if (!model.f_102609_ && layAmount < 1.0f && rotInfo.fbtMode == FBTMode.ARMS_ONLY) {
            float newLegY = 12.0f + Math.min(model.f_102810_.f_104201_, 0.0f);
            float newLegZ = model.f_102810_.f_104202_ + 10.0f * Mth.m_14031_((float)model.f_102810_.f_104203_);
            if (model instanceof VRPlayerModel_WithArmsLegs) {
                newLegY += 10.0f * Mth.m_14031_((float)model.f_102810_.f_104203_);
            }
            model.f_102814_.f_104201_ = Mth.m_14179_((float)layAmount, (float)newLegY, (float)model.f_102814_.f_104201_);
            model.f_102814_.f_104202_ = Mth.m_14179_((float)layAmount, (float)newLegZ, (float)model.f_102814_.f_104202_);
            model.f_102813_.f_104201_ = model.f_102814_.f_104201_;
            model.f_102813_.f_104202_ = model.f_102814_.f_104202_;
        }
        if (!rotInfo.seated || isMainPlayer) {
            if (!(model instanceof VRPlayerModel_WithArms) && rotInfo.offHandPos.distanceSquared(rotInfo.mainHandPos) > 0.0f) {
                ModelPart offHand = rotInfo.leftHanded ? model.f_102811_ : model.f_102812_;
                ModelPart mainHand = rotInfo.leftHanded ? model.f_102812_ : model.f_102811_;
                float offset = (rotInfo.leftHanded ? -1.0f : 1.0f) * (model.f_103380_ ? 0.016f : 0.032f) * (float)Math.PI * armScale;
                ModelUtils.pointModelAtLocal(player, mainHand, rotInfo.mainHandPos, rotInfo.mainHandQuat, rotInfo, bodyYaw, isMainPlayer, tempV, tempV2, tempM);
                float controllerDist = tempV.length();
                if (!ClientDataHolderVR.getInstance().vrSettings.playerLimbsLimit && controllerDist > 10.0f) {
                    tempV.normalize().mul(controllerDist - 10.0f);
                    mainHand.f_104200_ += tempV.x;
                    mainHand.f_104201_ += tempV.y;
                    mainHand.f_104202_ += tempV.z;
                    tempM.rotateZ(-offset);
                } else {
                    tempM.rotateZ(-offset * Math.min(10.0f / controllerDist, 1.0f));
                }
                if (ClientDataHolderVR.getInstance().vrSettings.playerArmAnim && attackArm == mainArm) {
                    ModelUtils.swingAnimation(attackArm, model.f_102608_, isMainPlayer, tempM, tempV);
                    mainHand.f_104200_ -= tempV.x;
                    mainHand.f_104201_ -= tempV.y;
                    mainHand.f_104202_ += tempV.z;
                }
                tempM.rotateLocalX(-xRot);
                ModelUtils.setRotation(mainHand, (Matrix3fc)tempM, tempV);
                ModelUtils.pointModelAtLocal(player, offHand, rotInfo.offHandPos, rotInfo.offHandQuat, rotInfo, bodyYaw, isMainPlayer, tempV, tempV2, tempM);
                controllerDist = tempV.length();
                if (!ClientDataHolderVR.getInstance().vrSettings.playerLimbsLimit && controllerDist > 10.0f) {
                    tempV.normalize().mul(controllerDist - 10.0f);
                    offHand.f_104200_ += tempV.x;
                    offHand.f_104201_ += tempV.y;
                    offHand.f_104202_ += tempV.z;
                    tempM.rotateZ(offset);
                } else {
                    tempM.rotateZ(offset * Math.min(10.0f / controllerDist, 1.0f));
                }
                if (ClientDataHolderVR.getInstance().vrSettings.playerArmAnim && attackArm != mainArm) {
                    ModelUtils.swingAnimation(attackArm, model.f_102608_, isMainPlayer, tempM, tempV);
                    offHand.f_104200_ -= tempV.x;
                    offHand.f_104201_ -= tempV.y;
                    offHand.f_104202_ += tempV.z;
                }
                if (isMainPlayer && ClientDataHolderVR.getInstance().vrSettings.shouldRenderSelf && ClientDataHolderVR.getInstance().vrSettings.modelArmsMode != VRSettings.ModelArmsMode.OFF) {
                    GuiHandler.GUI_ROTATION_PLAYER_MODEL.set3x3((Matrix3fc)tempM);
                    GuiHandler.GUI_ROTATION_PLAYER_MODEL.rotateX(-1.5707964f);
                    GuiHandler.GUI_ROTATION_PLAYER_MODEL.rotateLocalY(-bodyYaw - (float)Math.PI);
                    GuiHandler.GUI_ROTATION_PLAYER_MODEL.transformDirection(MathUtils.BACK, tempV).mul(0.584f * rotInfo.worldScale);
                    ModelUtils.modelToWorld(player, offHand.f_104200_, offHand.f_104201_, offHand.f_104202_, rotInfo, bodyYaw, true, isMainPlayer, tempV2);
                    if (MCAHelper.isLoaded()) {
                        MCAHelper.applyPlayerScale(player, tempV);
                    }
                    tempV2.add((Vector3fc)tempV);
                    GuiHandler.GUI_POS_PLAYER_MODEL = player.m_20318_(ClientUtils.getCurrentPartialTick()).m_82520_((double)tempV2.x, (double)tempV2.y, (double)tempV2.z);
                }
                tempM.rotateLocalX(-xRot);
                ModelUtils.setRotation(offHand, (Matrix3fc)tempM, tempV);
            }
            if (!(model.f_102609_ || noLowerBodyAnimation || model instanceof VRPlayerModel_WithArmsLegs)) {
                float limbRotation = 0.0f;
                if (ClientDataHolderVR.getInstance().vrSettings.playerWalkAnim) {
                    limbRotation = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
                }
                ModelUtils.pointModelAtLocal(player, model.f_102813_, rotInfo.rightFootPos, rotInfo.rightFootQuat, rotInfo, bodyYaw, isMainPlayer, tempV, tempV2, tempM);
                tempM.rotateLocalX(limbRotation - xRot);
                ModelUtils.setRotation(model.f_102813_, (Matrix3fc)tempM, tempV);
                ModelUtils.pointModelAtLocal(player, model.f_102814_, rotInfo.leftFootPos, rotInfo.leftFootQuat, rotInfo, bodyYaw, isMainPlayer, tempV, tempV2, tempM);
                tempM.rotateLocalX(-limbRotation - xRot);
                ModelUtils.setRotation(model.f_102814_, (Matrix3fc)tempM, tempV);
            }
        }
        if (layAmount > 0.0f) {
            if (noLowerBodyAnimation) {
                model.f_102810_.f_104203_ += xRot;
            }
            if (model instanceof VRPlayerModel_WithArmsLegs) {
                ModelUtils.applySwimRotationOffset(player, xRot, tempV, tempV2, model.f_102808_, model.f_102810_);
            } else if (model instanceof VRPlayerModel_WithArms) {
                ModelUtils.applySwimRotationOffset(player, xRot, tempV, tempV2, model.f_102808_, model.f_102810_, model.f_102814_, model.f_102813_);
            } else {
                ModelUtils.applySwimRotationOffset(player, xRot, tempV, tempV2, model.f_102808_, model.f_102810_, model.f_102812_, model.f_102811_, model.f_102814_, model.f_102813_);
            }
        }
        model.f_102811_.f_233553_ = model.f_102811_.f_233555_ = armScale;
        model.f_102812_.f_233555_ = model.f_102811_.f_233555_;
        model.f_102812_.f_233553_ = model.f_102811_.f_233555_;
        model.f_102810_.f_233553_ = model.f_102810_.f_233555_ = bodyScale;
        model.f_102813_.f_233553_ = model.f_102813_.f_233555_ = legScale;
        model.f_102814_.f_233555_ = model.f_102813_.f_233555_;
        model.f_102814_.f_233553_ = model.f_102813_.f_233555_;
        if (player.m_21209_()) {
            VRPlayerModel.spinOffset(model.f_102808_, model.f_102810_);
            if (!(model instanceof VRPlayerModel_WithArms)) {
                VRPlayerModel.spinOffset(model.f_102812_, model.f_102811_);
            }
            if (!(model instanceof VRPlayerModel_WithArmsLegs)) {
                VRPlayerModel.spinOffset(model.f_102814_, model.f_102813_);
            }
        }
        model.f_103374_.m_104315_(model.f_102812_);
        model.f_103375_.m_104315_(model.f_102811_);
        model.f_103376_.m_104315_(model.f_102814_);
        model.f_103377_.m_104315_(model.f_102813_);
        model.f_102809_.m_104315_(model.f_102808_);
        model.f_103378_.m_104315_(model.f_102810_);
        if (model instanceof VRPlayerModel) {
            VRPlayerModel vrModel = (VRPlayerModel)model;
            vrModel.isMainPlayer = isMainPlayer;
            vrModel.rotInfo = rotInfo;
            vrModel.mainArm = mainArm;
            vrModel.attackArm = attackArm;
            vrModel.bodyYaw = bodyYaw;
            vrModel.laying = laying;
            vrModel.layAmount = layAmount;
            vrModel.bodyScale = bodyScale;
            vrModel.armScale = armScale;
            vrModel.legScale = legScale;
            vrModel.xRot = xRot;
        }
    }

    public void renderHMD(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay) {
        this.vrHMD.m_104301_(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public void hideLeftArm(boolean completeArm) {
        this.f_102812_.f_104207_ = false;
        this.f_103374_.f_104207_ = false;
    }

    public void hideRightArm(boolean onlyHand) {
        this.f_102811_.f_104207_ = false;
        this.f_103375_.f_104207_ = false;
    }

    protected static void spinOffset(ModelPart ... parts) {
        for (ModelPart part : parts) {
            part.f_104201_ += 24.0f;
        }
    }

    public void m_6002_(HumanoidArm side, PoseStack poseStack) {
        this.m_102851_(side).m_104299_(poseStack);
        if (this.f_103380_) {
            poseStack.m_252880_(side == HumanoidArm.RIGHT ? 0.03125f : -0.03125f, 0.0f, 0.0f);
        }
        if (side == this.attackArm) {
            poseStack.m_252880_(0.0f, 0.5f, 0.0f);
            poseStack.m_252781_(Axis.f_252529_.m_252961_(Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI))));
            poseStack.m_252880_(0.0f, -0.5f, 0.0f);
        }
    }
}

