/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.network;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.vivecraft.client.ClientVRPlayers;
import org.vivecraft.client.Xplat;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.settings.AutoCalibration;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.CommonDataHolder;
import org.vivecraft.common.VRServerPerms;
import org.vivecraft.common.network.BodyPart;
import org.vivecraft.common.network.VrPlayerState;
import org.vivecraft.common.network.packet.c2s.ActiveBodyPartPayloadC2S;
import org.vivecraft.common.network.packet.c2s.HeightPayloadC2S;
import org.vivecraft.common.network.packet.c2s.LegacyController0DataPayloadC2S;
import org.vivecraft.common.network.packet.c2s.LegacyController1DataPayloadC2S;
import org.vivecraft.common.network.packet.c2s.LegacyHeadDataPayloadC2S;
import org.vivecraft.common.network.packet.c2s.VRPlayerStatePayloadC2S;
import org.vivecraft.common.network.packet.c2s.VersionPayloadC2S;
import org.vivecraft.common.network.packet.c2s.VivecraftPayloadC2S;
import org.vivecraft.common.network.packet.c2s.WorldScalePayloadC2S;
import org.vivecraft.common.network.packet.s2c.ClimbingPayloadS2C;
import org.vivecraft.common.network.packet.s2c.DualWieldingPayloadS2C;
import org.vivecraft.common.network.packet.s2c.NetworkVersionPayloadS2C;
import org.vivecraft.common.network.packet.s2c.SettingOverridePayloadS2C;
import org.vivecraft.common.network.packet.s2c.UberPacketPayloadS2C;
import org.vivecraft.common.network.packet.s2c.UnknownPayloadS2C;
import org.vivecraft.common.network.packet.s2c.VRActivePayloadS2C;
import org.vivecraft.common.network.packet.s2c.VRSwitchingPayloadS2C;
import org.vivecraft.common.network.packet.s2c.VersionPayloadS2C;
import org.vivecraft.common.network.packet.s2c.VivecraftPayloadS2C;

public class ClientNetworking {
    public static boolean DISPLAYED_CHAT_MESSAGE = false;
    public static boolean DISPLAYED_CHAT_WARNING = false;
    public static boolean SERVER_HAS_VIVECRAFT = false;
    public static boolean SERVER_WANTS_DATA = false;
    public static boolean SERVER_SUPPORTS_DIRECT_TELEPORT = false;
    public static boolean SERVER_ALLOWS_CLIMBEY = false;
    public static boolean SERVER_ALLOWS_CRAWLING = false;
    public static boolean SERVER_ALLOWS_VR_SWITCHING = false;
    public static boolean SERVER_ALLOWS_DUAL_WIELDING = false;
    public static int USED_NETWORK_VERSION = -1;
    private static float WORLDSCALE_LAST = 0.0f;
    private static float HEIGHT_LAST = 0.0f;
    private static float CAPTURED_YAW;
    private static float CAPTURED_PITCH;
    private static boolean OVERRIDE_ACTIVE;
    public static BodyPart LAST_SENT_BODY_PART;
    public static boolean NEEDS_RESET;

    public static void resetServerSettings() {
        WORLDSCALE_LAST = 0.0f;
        HEIGHT_LAST = 0.0f;
        SERVER_HAS_VIVECRAFT = false;
        SERVER_WANTS_DATA = false;
        SERVER_SUPPORTS_DIRECT_TELEPORT = false;
        SERVER_ALLOWS_CLIMBEY = false;
        SERVER_ALLOWS_CRAWLING = false;
        SERVER_ALLOWS_VR_SWITCHING = false;
        SERVER_ALLOWS_DUAL_WIELDING = false;
        USED_NETWORK_VERSION = -1;
        ClientVRPlayers.clear();
        VRServerPerms.INSTANCE.setTeleportSupported(false);
        if (VRState.VR_INITIALIZED) {
            ClientDataHolderVR.getInstance().vrPlayer.setTeleportOverride(false);
        }
        ClientDataHolderVR.getInstance().vrSettings.overrides.resetAll();
    }

    public static void sendVersionInfo() {
        if (!ClientDataHolderVR.getInstance().completelyDisabled) {
            Minecraft.m_91087_().m_91403_().m_104955_(ClientNetworking.createServerPacket(new VersionPayloadC2S(CommonDataHolder.getInstance().versionIdentifier, VRState.VR_RUNNING, 2, 0)));
        }
    }

    public static void sendVRPlayerPositions(VRPlayer vrPlayer) {
        float userHeight;
        if (!SERVER_WANTS_DATA || Minecraft.m_91087_().m_91403_() == null || Minecraft.m_91087_().m_91288_() != Minecraft.m_91087_().f_91074_) {
            return;
        }
        float worldScale = ClientDataHolderVR.getInstance().vrPlayer.vrdata_world_post.worldScale;
        if (worldScale != WORLDSCALE_LAST) {
            ClientNetworking.sendServerPacket(new WorldScalePayloadC2S(worldScale));
            WORLDSCALE_LAST = worldScale;
        }
        if ((userHeight = AutoCalibration.getPlayerHeight()) != HEIGHT_LAST) {
            ClientNetworking.sendServerPacket(new HeightPayloadC2S(userHeight / 1.52f));
            HEIGHT_LAST = userHeight;
        }
        VrPlayerState vrPlayerState = VrPlayerState.create(vrPlayer);
        if (USED_NETWORK_VERSION != -1) {
            ClientNetworking.sendServerPacket(new VRPlayerStatePayloadC2S(vrPlayerState));
        } else {
            ClientNetworking.sendLegacyPackets(vrPlayerState);
        }
        if (ClientDataHolderVR.getInstance().vrSettings.mainPlayerDataSource != VRSettings.DataSource.SERVER) {
            ClientVRPlayers.getInstance().update(Minecraft.m_91087_().f_91074_.m_36316_().getId(), vrPlayerState, worldScale, userHeight / 1.52f, true);
        }
    }

    public static void sendServerPacket(VivecraftPayloadC2S payload) {
        if (Minecraft.m_91087_().m_91403_() != null && SERVER_HAS_VIVECRAFT) {
            Minecraft.m_91087_().m_91403_().m_104955_(ClientNetworking.createServerPacket(payload));
        }
    }

    public static Packet<?> createServerPacket(VivecraftPayloadC2S payload) {
        return Xplat.getC2SPacket(payload);
    }

    public static void sendLegacyPackets(VrPlayerState vrPlayerState) {
        ClientNetworking.sendServerPacket(new LegacyController0DataPayloadC2S(ClientDataHolderVR.getInstance().vrSettings.reverseHands, vrPlayerState.mainHand()));
        ClientNetworking.sendServerPacket(new LegacyController1DataPayloadC2S(ClientDataHolderVR.getInstance().vrSettings.reverseHands, vrPlayerState.offHand()));
        ClientNetworking.sendServerPacket(new LegacyHeadDataPayloadC2S(ClientDataHolderVR.getInstance().vrSettings.seated, vrPlayerState.hmd()));
    }

    public static boolean isThirdPersonItems() {
        return ClientDataHolderVR.getInstance().vrSettings.overrides.getSetting(VRSettings.VrOptions.THIRDPERSON_ITEMTRANSFORMS).getBoolean();
    }

    public static boolean isThirdPersonItemsCustom() {
        return ClientDataHolderVR.getInstance().vrSettings.overrides.getSetting(VRSettings.VrOptions.THIRDPERSON_ITEMTRANSFORMS_CUSTOM).getBoolean();
    }

    public static boolean isLimitedSurvivalTeleport() {
        return ClientDataHolderVR.getInstance().vrSettings.overrides.getSetting(VRSettings.VrOptions.LIMIT_TELEPORT).getBoolean();
    }

    public static boolean supportsReversedBow() {
        return USED_NETWORK_VERSION >= 2 || !SERVER_HAS_VIVECRAFT;
    }

    public static int getTeleportUpLimit() {
        return ClientDataHolderVR.getInstance().vrSettings.overrides.getSetting(VRSettings.VrOptions.TELEPORT_UP_LIMIT).getInt();
    }

    public static int getTeleportDownLimit() {
        return ClientDataHolderVR.getInstance().vrSettings.overrides.getSetting(VRSettings.VrOptions.TELEPORT_DOWN_LIMIT).getInt();
    }

    public static int getTeleportHorizLimit() {
        return ClientDataHolderVR.getInstance().vrSettings.overrides.getSetting(VRSettings.VrOptions.TELEPORT_HORIZ_LIMIT).getInt();
    }

    public static void sendActiveHand(InteractionHand hand) {
        if (SERVER_WANTS_DATA) {
            ClientNetworking.sendActiveBodyPart(hand == InteractionHand.MAIN_HAND ? BodyPart.MAIN_HAND : BodyPart.OFF_HAND);
        }
    }

    public static void sendActiveBodyPart(BodyPart bodyPart) {
        if (SERVER_WANTS_DATA && bodyPart != LAST_SENT_BODY_PART) {
            ClientNetworking.sendServerPacket(new ActiveBodyPartPayloadC2S(bodyPart));
            LAST_SENT_BODY_PART = bodyPart;
        }
    }

    public static void overridePose(LocalPlayer player) {
        if (ClientDataHolderVR.getInstance().crawlTracker.crawling) {
            player.m_20124_(Pose.SWIMMING);
        }
    }

    public static void overrideLook(Player player, Vec3 view) {
        if (SERVER_WANTS_DATA) {
            return;
        }
        CAPTURED_PITCH = player.m_146909_();
        CAPTURED_YAW = player.m_146908_();
        float pitch = (float)Math.toDegrees(Math.asin(-view.f_82480_ / view.m_82553_()));
        float yaw = (float)Math.toDegrees(Math.atan2(-view.f_82479_, view.f_82481_));
        ((LocalPlayer)player).f_108617_.m_104955_((Packet)new ServerboundMovePlayerPacket.Rot(yaw, pitch, player.m_20096_()));
        OVERRIDE_ACTIVE = true;
    }

    public static void restoreLook(Player player) {
        if (!SERVER_WANTS_DATA && OVERRIDE_ACTIVE) {
            ((LocalPlayer)player).f_108617_.m_104955_((Packet)new ServerboundMovePlayerPacket.Rot(CAPTURED_YAW, CAPTURED_PITCH, player.m_20096_()));
            OVERRIDE_ACTIVE = false;
        }
    }

    public static void handlePacket(VivecraftPayloadS2C s2cPayload) {
        if (s2cPayload instanceof UnknownPayloadS2C) {
            return;
        }
        ClientDataHolderVR dataholder = ClientDataHolderVR.getInstance();
        Minecraft mc = Minecraft.m_91087_();
        switch (s2cPayload.payloadId()) {
            case VERSION: {
                SERVER_HAS_VIVECRAFT = true;
                VRServerPerms.INSTANCE.setTeleportSupported(true);
                if (VRState.VR_INITIALIZED) {
                    dataholder.vrPlayer.teleportWarning = false;
                    dataholder.vrPlayer.vrSwitchWarning = true;
                }
                if (!DISPLAYED_CHAT_MESSAGE && (dataholder.vrSettings.showServerPluginMessage == VRSettings.ChatServerPluginMessage.ALWAYS || dataholder.vrSettings.showServerPluginMessage == VRSettings.ChatServerPluginMessage.SERVER_ONLY && !Minecraft.m_91087_().m_91090_())) {
                    DISPLAYED_CHAT_MESSAGE = true;
                    mc.f_91065_.m_93076_().m_93785_((Component)Component.m_237110_((String)"vivecraft.messages.serverplugin", (Object[])new Object[]{((VersionPayloadS2C)s2cPayload).version()}));
                }
                if (!VRState.VR_ENABLED || dataholder.vrSettings.manualCalibration != -1.0f || dataholder.vrSettings.seated) break;
                mc.f_91065_.m_93076_().m_93785_((Component)Component.m_237115_((String)"vivecraft.messages.calibrateheight"));
                break;
            }
            case IS_VR_ACTIVE: {
                VRActivePayloadS2C packet = (VRActivePayloadS2C)s2cPayload;
                if (packet.vr()) break;
                ClientVRPlayers.getInstance().disableVR(packet.playerID());
                break;
            }
            case REQUESTDATA: {
                SERVER_WANTS_DATA = true;
                break;
            }
            case CLIMBING: {
                ClimbingPayloadS2C packet = (ClimbingPayloadS2C)s2cPayload;
                SERVER_ALLOWS_CLIMBEY = packet.allowed();
                dataholder.climbTracker.serverBlockmode = packet.blockmode();
                dataholder.climbTracker.blocklist.clear();
                if (packet.blocks() == null) break;
                for (String blockId : packet.blocks()) {
                    Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(blockId));
                    if (block == Blocks.f_50016_) continue;
                    dataholder.climbTracker.blocklist.add(block);
                }
                break;
            }
            case TELEPORT: {
                SERVER_SUPPORTS_DIRECT_TELEPORT = true;
                break;
            }
            case UBERPACKET: {
                UberPacketPayloadS2C packet = (UberPacketPayloadS2C)s2cPayload;
                ClientVRPlayers.getInstance().update(packet.playerID(), packet.state(), packet.worldScale(), packet.heightScale());
                break;
            }
            case SETTING_OVERRIDE: {
                for (Map.Entry<String, String> override : ((SettingOverridePayloadS2C)s2cPayload).overrides().entrySet()) {
                    String[] split = override.getKey().split("\\.", 2);
                    if (!dataholder.vrSettings.overrides.hasSetting(split[0])) continue;
                    VRSettings.ServerOverrides.Setting setting = dataholder.vrSettings.overrides.getSetting(split[0]);
                    try {
                        if (split.length > 1) {
                            switch (split[1]) {
                                case "min": {
                                    setting.setValueMin(Float.parseFloat(override.getValue()));
                                    break;
                                }
                                case "max": {
                                    setting.setValueMax(Float.parseFloat(override.getValue()));
                                }
                            }
                        } else {
                            Object origValue = setting.getOriginalValue();
                            if (origValue instanceof Boolean) {
                                setting.setValue(override.getValue().equals("true"));
                            } else if (origValue instanceof Integer || origValue instanceof Byte || origValue instanceof Short) {
                                setting.setValue(Integer.parseInt(override.getValue()));
                            } else if (origValue instanceof Float || origValue instanceof Double) {
                                setting.setValue(Float.valueOf(Float.parseFloat(override.getValue())));
                            } else {
                                setting.setValue(override.getValue());
                            }
                        }
                        VRSettings.LOGGER.info("Vivecraft: Server setting override: {}={}", (Object)override.getKey(), (Object)override.getValue());
                    }
                    catch (Exception exception) {
                        VRSettings.LOGGER.error("Vivecraft: error parsing server setting override: ", (Throwable)exception);
                    }
                }
                break;
            }
            case CRAWL: {
                SERVER_ALLOWS_CRAWLING = true;
                break;
            }
            case NETWORK_VERSION: {
                USED_NETWORK_VERSION = ((NetworkVersionPayloadS2C)s2cPayload).version();
                break;
            }
            case VR_SWITCHING: {
                SERVER_ALLOWS_VR_SWITCHING = ((VRSwitchingPayloadS2C)s2cPayload).allowed();
                if (!VRState.VR_INITIALIZED) break;
                if (!SERVER_ALLOWS_VR_SWITCHING) {
                    Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)Component.m_237115_((String)"vivecraft.messages.novrhotswitching"));
                }
                dataholder.vrPlayer.vrSwitchWarning = false;
                break;
            }
            case DUAL_WIELDING: {
                SERVER_ALLOWS_DUAL_WIELDING = ((DualWieldingPayloadS2C)s2cPayload).allowed();
            }
        }
    }

    static {
        LAST_SENT_BODY_PART = BodyPart.MAIN_HAND;
        NEEDS_RESET = true;
    }
}

