/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.settings;

import java.util.Arrays;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.ArrayUtils;
import org.vivecraft.client.gui.settings.GuiRadialConfiguration;

public class GuiRadialItemsList
extends ObjectSelectionList<BaseEntry> {
    private static final int MAX_LIST_LABEL_WIDTH = 300;
    private final GuiRadialConfiguration parent;

    public GuiRadialItemsList(GuiRadialConfiguration parent, Minecraft mc) {
        super(mc, parent.f_96543_, parent.f_96544_, 49, parent.f_96544_ - 28, 20);
        this.parent = parent;
        this.buildList();
    }

    public void buildList() {
        Object[] mappings = (KeyMapping[])ArrayUtils.clone((Object[])this.f_93386_.f_91066_.f_92059_);
        Arrays.sort(mappings);
        String currentCategory = null;
        for (Object keymapping : mappings) {
            String category;
            String string = category = keymapping != null ? keymapping.m_90858_() : null;
            if (category == null) continue;
            if (!category.equals(currentCategory)) {
                currentCategory = category;
                this.m_7085_((AbstractSelectionList.Entry)new CategoryEntry(category));
            }
            this.m_7085_((AbstractSelectionList.Entry)new MappingEntry((KeyMapping)keymapping, this.parent));
        }
    }

    public static class CategoryEntry
    extends BaseEntry {
        private final String labelText;
        private final int labelWidth;

        public CategoryEntry(String name) {
            this.labelText = I18n.m_118938_((String)name, (Object[])new Object[0]);
            this.labelWidth = Minecraft.m_91087_().f_91062_.m_92895_(this.labelText);
        }

        public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, this.labelText, Minecraft.m_91087_().f_91080_.f_96543_ / 2 - this.labelWidth / 2, top + height - 9 - 1, 6777215);
        }
    }

    public static class MappingEntry
    extends BaseEntry {
        private final KeyMapping myKey;
        private final GuiRadialConfiguration parentScreen;

        private MappingEntry(KeyMapping key, GuiRadialConfiguration parent) {
            this.myKey = key;
            this.parentScreen = parent;
        }

        public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            ChatFormatting chatformatting = ChatFormatting.WHITE;
            if (hovering) {
                chatformatting = ChatFormatting.GREEN;
            }
            guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, chatformatting + I18n.m_118938_((String)this.myKey.m_90860_(), (Object[])new Object[0]), Minecraft.m_91087_().f_91080_.f_96543_ / 2 - 150, top + height / 2 - 4, 0xFFFFFF);
        }

        public boolean m_6375_(double pMouseX, double p_94738_, int pMouseY) {
            this.parentScreen.setKey(this.myKey);
            return true;
        }
    }

    public static abstract class BaseEntry
    extends ObjectSelectionList.Entry<BaseEntry> {
        public Component m_142172_() {
            return null;
        }
    }
}

